/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Request for the `ValidateMessage` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ValidateMessageRequest extends com.google.api.client.json.GenericJson {

  /**
   * The encoding expected for messages
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encoding;

  /**
   * Message to validate against the provided `schema_spec`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String message;

  /**
   * Name of the schema against which to validate. Format is `projects/{project}/schemas/{schema}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Ad-hoc schema against which to validate
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Schema schema;

  /**
   * The encoding expected for messages
   * @return value or {@code null} for none
   */
  public java.lang.String getEncoding() {
    return encoding;
  }

  /**
   * The encoding expected for messages
   * @param encoding encoding or {@code null} for none
   */
  public ValidateMessageRequest setEncoding(java.lang.String encoding) {
    this.encoding = encoding;
    return this;
  }

  /**
   * Message to validate against the provided `schema_spec`.
   * @see #decodeMessage()
   * @return value or {@code null} for none
   */
  public java.lang.String getMessage() {
    return message;
  }

  /**
   * Message to validate against the provided `schema_spec`.
   * @see #getMessage()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeMessage() {
    return com.google.api.client.util.Base64.decodeBase64(message);
  }

  /**
   * Message to validate against the provided `schema_spec`.
   * @see #encodeMessage()
   * @param message message or {@code null} for none
   */
  public ValidateMessageRequest setMessage(java.lang.String message) {
    this.message = message;
    return this;
  }

  /**
   * Message to validate against the provided `schema_spec`.
   * @see #setMessage()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public ValidateMessageRequest encodeMessage(byte[] message) {
    this.message = com.google.api.client.util.Base64.encodeBase64URLSafeString(message);
    return this;
  }

  /**
   * Name of the schema against which to validate. Format is `projects/{project}/schemas/{schema}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the schema against which to validate. Format is `projects/{project}/schemas/{schema}`.
   * @param name name or {@code null} for none
   */
  public ValidateMessageRequest setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Ad-hoc schema against which to validate
   * @return value or {@code null} for none
   */
  public Schema getSchema() {
    return schema;
  }

  /**
   * Ad-hoc schema against which to validate
   * @param schema schema or {@code null} for none
   */
  public ValidateMessageRequest setSchema(Schema schema) {
    this.schema = schema;
    return this;
  }

  @Override
  public ValidateMessageRequest set(String fieldName, Object value) {
    return (ValidateMessageRequest) super.set(fieldName, value);
  }

  @Override
  public ValidateMessageRequest clone() {
    return (ValidateMessageRequest) super.clone();
  }

}
