/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Request for the UpdateTopic method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateTopicRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The updated topic object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Topic topic;

  /**
   * Required. Indicates which fields in the provided topic to update. Must be specified and non-
   * empty. Note that if `update_mask` contains "message_storage_policy" but the
   * `message_storage_policy` is not set in the `topic` provided above, then the updated value is
   * determined by the policy configured at the project or organization level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateMask;

  /**
   * Required. The updated topic object.
   * @return value or {@code null} for none
   */
  public Topic getTopic() {
    return topic;
  }

  /**
   * Required. The updated topic object.
   * @param topic topic or {@code null} for none
   */
  public UpdateTopicRequest setTopic(Topic topic) {
    this.topic = topic;
    return this;
  }

  /**
   * Required. Indicates which fields in the provided topic to update. Must be specified and non-
   * empty. Note that if `update_mask` contains "message_storage_policy" but the
   * `message_storage_policy` is not set in the `topic` provided above, then the updated value is
   * determined by the policy configured at the project or organization level.
   * @return value or {@code null} for none
   */
  public String getUpdateMask() {
    return updateMask;
  }

  /**
   * Required. Indicates which fields in the provided topic to update. Must be specified and non-
   * empty. Note that if `update_mask` contains "message_storage_policy" but the
   * `message_storage_policy` is not set in the `topic` provided above, then the updated value is
   * determined by the policy configured at the project or organization level.
   * @param updateMask updateMask or {@code null} for none
   */
  public UpdateTopicRequest setUpdateMask(String updateMask) {
    this.updateMask = updateMask;
    return this;
  }

  @Override
  public UpdateTopicRequest set(String fieldName, Object value) {
    return (UpdateTopicRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateTopicRequest clone() {
    return (UpdateTopicRequest) super.clone();
  }

}
