/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Request for the UpdateSubscription method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateSubscriptionRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The updated subscription object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Subscription subscription;

  /**
   * Required. Indicates which fields in the provided subscription to update. Must be specified and
   * non-empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateMask;

  /**
   * Required. The updated subscription object.
   * @return value or {@code null} for none
   */
  public Subscription getSubscription() {
    return subscription;
  }

  /**
   * Required. The updated subscription object.
   * @param subscription subscription or {@code null} for none
   */
  public UpdateSubscriptionRequest setSubscription(Subscription subscription) {
    this.subscription = subscription;
    return this;
  }

  /**
   * Required. Indicates which fields in the provided subscription to update. Must be specified and
   * non-empty.
   * @return value or {@code null} for none
   */
  public String getUpdateMask() {
    return updateMask;
  }

  /**
   * Required. Indicates which fields in the provided subscription to update. Must be specified and
   * non-empty.
   * @param updateMask updateMask or {@code null} for none
   */
  public UpdateSubscriptionRequest setUpdateMask(String updateMask) {
    this.updateMask = updateMask;
    return this;
  }

  @Override
  public UpdateSubscriptionRequest set(String fieldName, Object value) {
    return (UpdateSubscriptionRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateSubscriptionRequest clone() {
    return (UpdateSubscriptionRequest) super.clone();
  }

}
