/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * A snapshot resource. Snapshots are used in Seek operations, which allow you to manage message
 * acknowledgments in bulk. That is, you can set the acknowledgment state of messages in an existing
 * subscription to the state captured by a snapshot.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Snapshot extends com.google.api.client.json.GenericJson {

  /**
   * The snapshot is guaranteed to exist up until this time. A newly-created snapshot expires no
   * later than 7 days from the time of its creation. Its exact lifetime is determined at creation
   * by the existing backlog in the source subscription. Specifically, the lifetime of the snapshot
   * is `7 days - (age of oldest unacked message in the subscription)`. For example, consider a
   * subscription whose oldest unacked message is 3 days old. If a snapshot is created from this
   * subscription, the snapshot -- which will always capture this 3-day-old backlog as long as the
   * snapshot exists -- will expire in 4 days. The service will refuse to create a snapshot that
   * would expire in less than 1 hour after creation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * See  Creating and managing labels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * The name of the snapshot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The name of the topic from which this snapshot is retaining messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topic;

  /**
   * The snapshot is guaranteed to exist up until this time. A newly-created snapshot expires no
   * later than 7 days from the time of its creation. Its exact lifetime is determined at creation
   * by the existing backlog in the source subscription. Specifically, the lifetime of the snapshot
   * is `7 days - (age of oldest unacked message in the subscription)`. For example, consider a
   * subscription whose oldest unacked message is 3 days old. If a snapshot is created from this
   * subscription, the snapshot -- which will always capture this 3-day-old backlog as long as the
   * snapshot exists -- will expire in 4 days. The service will refuse to create a snapshot that
   * would expire in less than 1 hour after creation.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * The snapshot is guaranteed to exist up until this time. A newly-created snapshot expires no
   * later than 7 days from the time of its creation. Its exact lifetime is determined at creation
   * by the existing backlog in the source subscription. Specifically, the lifetime of the snapshot
   * is `7 days - (age of oldest unacked message in the subscription)`. For example, consider a
   * subscription whose oldest unacked message is 3 days old. If a snapshot is created from this
   * subscription, the snapshot -- which will always capture this 3-day-old backlog as long as the
   * snapshot exists -- will expire in 4 days. The service will refuse to create a snapshot that
   * would expire in less than 1 hour after creation.
   * @param expireTime expireTime or {@code null} for none
   */
  public Snapshot setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * See  Creating and managing labels.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * See  Creating and managing labels.
   * @param labels labels or {@code null} for none
   */
  public Snapshot setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The name of the snapshot.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the snapshot.
   * @param name name or {@code null} for none
   */
  public Snapshot setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the topic from which this snapshot is retaining messages.
   * @return value or {@code null} for none
   */
  public java.lang.String getTopic() {
    return topic;
  }

  /**
   * The name of the topic from which this snapshot is retaining messages.
   * @param topic topic or {@code null} for none
   */
  public Snapshot setTopic(java.lang.String topic) {
    this.topic = topic;
    return this;
  }

  @Override
  public Snapshot set(String fieldName, Object value) {
    return (Snapshot) super.set(fieldName, value);
  }

  @Override
  public Snapshot clone() {
    return (Snapshot) super.clone();
  }

}
