/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * A message and its corresponding acknowledgment ID.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReceivedMessage extends com.google.api.client.json.GenericJson {

  /**
   * This ID can be used to acknowledge the received message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ackId;

  /**
   * Delivery attempt counter is 1 + (the sum of number of NACKs and number of ack_deadline exceeds)
   * for this message.
   *
   * A NACK is any call to ModifyAckDeadline with a 0 deadline. An ack_deadline exceeds event is
   * whenever a message is not acknowledged within ack_deadline. Note that ack_deadline is initially
   * Subscription.ackDeadlineSeconds, but may get extended automatically by the client library.
   *
   * The first delivery of a given message will have this value as 1. The value is calculated at
   * best effort and is approximate.
   *
   * If a DeadLetterPolicy is not set on the subscription, this will be 0. EXPERIMENTAL: This
   * feature is part of a closed alpha release. This API might be changed in backward-incompatible
   * ways and is not recommended for production use. It is not subject to any SLA or deprecation
   * policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer deliveryAttempt;

  /**
   * The message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PubsubMessage message;

  /**
   * This ID can be used to acknowledge the received message.
   * @return value or {@code null} for none
   */
  public java.lang.String getAckId() {
    return ackId;
  }

  /**
   * This ID can be used to acknowledge the received message.
   * @param ackId ackId or {@code null} for none
   */
  public ReceivedMessage setAckId(java.lang.String ackId) {
    this.ackId = ackId;
    return this;
  }

  /**
   * Delivery attempt counter is 1 + (the sum of number of NACKs and number of ack_deadline exceeds)
   * for this message.
   *
   * A NACK is any call to ModifyAckDeadline with a 0 deadline. An ack_deadline exceeds event is
   * whenever a message is not acknowledged within ack_deadline. Note that ack_deadline is initially
   * Subscription.ackDeadlineSeconds, but may get extended automatically by the client library.
   *
   * The first delivery of a given message will have this value as 1. The value is calculated at
   * best effort and is approximate.
   *
   * If a DeadLetterPolicy is not set on the subscription, this will be 0. EXPERIMENTAL: This
   * feature is part of a closed alpha release. This API might be changed in backward-incompatible
   * ways and is not recommended for production use. It is not subject to any SLA or deprecation
   * policy.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDeliveryAttempt() {
    return deliveryAttempt;
  }

  /**
   * Delivery attempt counter is 1 + (the sum of number of NACKs and number of ack_deadline exceeds)
   * for this message.
   *
   * A NACK is any call to ModifyAckDeadline with a 0 deadline. An ack_deadline exceeds event is
   * whenever a message is not acknowledged within ack_deadline. Note that ack_deadline is initially
   * Subscription.ackDeadlineSeconds, but may get extended automatically by the client library.
   *
   * The first delivery of a given message will have this value as 1. The value is calculated at
   * best effort and is approximate.
   *
   * If a DeadLetterPolicy is not set on the subscription, this will be 0. EXPERIMENTAL: This
   * feature is part of a closed alpha release. This API might be changed in backward-incompatible
   * ways and is not recommended for production use. It is not subject to any SLA or deprecation
   * policy.
   * @param deliveryAttempt deliveryAttempt or {@code null} for none
   */
  public ReceivedMessage setDeliveryAttempt(java.lang.Integer deliveryAttempt) {
    this.deliveryAttempt = deliveryAttempt;
    return this;
  }

  /**
   * The message.
   * @return value or {@code null} for none
   */
  public PubsubMessage getMessage() {
    return message;
  }

  /**
   * The message.
   * @param message message or {@code null} for none
   */
  public ReceivedMessage setMessage(PubsubMessage message) {
    this.message = message;
    return this;
  }

  @Override
  public ReceivedMessage set(String fieldName, Object value) {
    return (ReceivedMessage) super.set(fieldName, value);
  }

  @Override
  public ReceivedMessage clone() {
    return (ReceivedMessage) super.clone();
  }

}
