/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Contains information needed for generating an [OpenID Connect
 * token](https://developers.google.com/identity/protocols/OpenIDConnect).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OidcToken extends com.google.api.client.json.GenericJson {

  /**
   * Audience to be used when generating OIDC token. The audience claim identifies the recipients
   * that the JWT is intended for. The audience value is a single case-sensitive string. Having
   * multiple values (array) for the audience field is not supported. More info about the OIDC JWT
   * token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
   * the Push endpoint URL will be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String audience;

  /**
   * [Service account email](https://cloud.google.com/iam/docs/service-accounts) to be used for
   * generating the OIDC token. The caller (for CreateSubscription, UpdateSubscription, and
   * ModifyPushConfig RPCs) must have the iam.serviceAccounts.actAs permission for the service
   * account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serviceAccountEmail;

  /**
   * Audience to be used when generating OIDC token. The audience claim identifies the recipients
   * that the JWT is intended for. The audience value is a single case-sensitive string. Having
   * multiple values (array) for the audience field is not supported. More info about the OIDC JWT
   * token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
   * the Push endpoint URL will be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getAudience() {
    return audience;
  }

  /**
   * Audience to be used when generating OIDC token. The audience claim identifies the recipients
   * that the JWT is intended for. The audience value is a single case-sensitive string. Having
   * multiple values (array) for the audience field is not supported. More info about the OIDC JWT
   * token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
   * the Push endpoint URL will be used.
   * @param audience audience or {@code null} for none
   */
  public OidcToken setAudience(java.lang.String audience) {
    this.audience = audience;
    return this;
  }

  /**
   * [Service account email](https://cloud.google.com/iam/docs/service-accounts) to be used for
   * generating the OIDC token. The caller (for CreateSubscription, UpdateSubscription, and
   * ModifyPushConfig RPCs) must have the iam.serviceAccounts.actAs permission for the service
   * account.
   * @return value or {@code null} for none
   */
  public java.lang.String getServiceAccountEmail() {
    return serviceAccountEmail;
  }

  /**
   * [Service account email](https://cloud.google.com/iam/docs/service-accounts) to be used for
   * generating the OIDC token. The caller (for CreateSubscription, UpdateSubscription, and
   * ModifyPushConfig RPCs) must have the iam.serviceAccounts.actAs permission for the service
   * account.
   * @param serviceAccountEmail serviceAccountEmail or {@code null} for none
   */
  public OidcToken setServiceAccountEmail(java.lang.String serviceAccountEmail) {
    this.serviceAccountEmail = serviceAccountEmail;
    return this;
  }

  @Override
  public OidcToken set(String fieldName, Object value) {
    return (OidcToken) super.set(fieldName, value);
  }

  @Override
  public OidcToken clone() {
    return (OidcToken) super.clone();
  }

}
