/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Dead lettering is done on a best effort basis. The same message might be dead lettered multiple
 * times.
 *
 * If validation on any of the fields fails at subscription creation/updation, the create/update
 * subscription request will fail.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeadLetterPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The name of the topic to which dead letter messages should be published. Format is
   * `projects/{project}/topics/{topic}`.The Cloud Pub/Sub service account associated with the
   * enclosing subscription's parent project (i.e., service-{project_number}@gcp-sa-
   * pubsub.iam.gserviceaccount.com) must have permission to Publish() to this topic.
   *
   * The operation will fail if the topic does not exist. Users should ensure that there is a
   * subscription attached to this topic since messages published to a topic with no subscriptions
   * are lost.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deadLetterTopic;

  /**
   * The maximum number of delivery attempts for any message. The value must be between 5 and 100.
   *
   * The number of delivery attempts is defined as 1 + (the sum of number of NACKs and number of
   * times the acknowledgement deadline has been exceeded for the message).
   *
   * A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that client libraries may
   * automatically extend ack_deadlines.
   *
   * This field will be honored on a best effort basis.
   *
   * If this parameter is 0, a default value of 5 is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxDeliveryAttempts;

  /**
   * The name of the topic to which dead letter messages should be published. Format is
   * `projects/{project}/topics/{topic}`.The Cloud Pub/Sub service account associated with the
   * enclosing subscription's parent project (i.e., service-{project_number}@gcp-sa-
   * pubsub.iam.gserviceaccount.com) must have permission to Publish() to this topic.
   *
   * The operation will fail if the topic does not exist. Users should ensure that there is a
   * subscription attached to this topic since messages published to a topic with no subscriptions
   * are lost.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeadLetterTopic() {
    return deadLetterTopic;
  }

  /**
   * The name of the topic to which dead letter messages should be published. Format is
   * `projects/{project}/topics/{topic}`.The Cloud Pub/Sub service account associated with the
   * enclosing subscription's parent project (i.e., service-{project_number}@gcp-sa-
   * pubsub.iam.gserviceaccount.com) must have permission to Publish() to this topic.
   *
   * The operation will fail if the topic does not exist. Users should ensure that there is a
   * subscription attached to this topic since messages published to a topic with no subscriptions
   * are lost.
   * @param deadLetterTopic deadLetterTopic or {@code null} for none
   */
  public DeadLetterPolicy setDeadLetterTopic(java.lang.String deadLetterTopic) {
    this.deadLetterTopic = deadLetterTopic;
    return this;
  }

  /**
   * The maximum number of delivery attempts for any message. The value must be between 5 and 100.
   *
   * The number of delivery attempts is defined as 1 + (the sum of number of NACKs and number of
   * times the acknowledgement deadline has been exceeded for the message).
   *
   * A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that client libraries may
   * automatically extend ack_deadlines.
   *
   * This field will be honored on a best effort basis.
   *
   * If this parameter is 0, a default value of 5 is used.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxDeliveryAttempts() {
    return maxDeliveryAttempts;
  }

  /**
   * The maximum number of delivery attempts for any message. The value must be between 5 and 100.
   *
   * The number of delivery attempts is defined as 1 + (the sum of number of NACKs and number of
   * times the acknowledgement deadline has been exceeded for the message).
   *
   * A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that client libraries may
   * automatically extend ack_deadlines.
   *
   * This field will be honored on a best effort basis.
   *
   * If this parameter is 0, a default value of 5 is used.
   * @param maxDeliveryAttempts maxDeliveryAttempts or {@code null} for none
   */
  public DeadLetterPolicy setMaxDeliveryAttempts(java.lang.Integer maxDeliveryAttempts) {
    this.maxDeliveryAttempts = maxDeliveryAttempts;
    return this;
  }

  @Override
  public DeadLetterPolicy set(String fieldName, Object value) {
    return (DeadLetterPolicy) super.set(fieldName, value);
  }

  @Override
  public DeadLetterPolicy clone() {
    return (DeadLetterPolicy) super.clone();
  }

}
