/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.plus.model;

import com.google.api.client.json.GenericJson;

/**
 * Model definition for Place.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Place extends GenericJson {

  /**
   * The physical address of the place.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Address address;

  /**
   * The display name of the place.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String displayName;

  /**
   * Identifies this resource as a place. Value: "plus#place".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The position of the place.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Position position;

  /**
   * The physical address of the place.
   * The value returned may be {@code null}.
   */
  public Address getAddress() {
    return address;
  }

  /**
   * The physical address of the place.
   * The value set may be {@code null}.
   */
  public Place setAddress(Address address) {
    this.address = address;
    return this;
  }

  /**
   * The display name of the place.
   * The value returned may be {@code null}.
   */
  public String getDisplayName() {
    return displayName;
  }

  /**
   * The display name of the place.
   * The value set may be {@code null}.
   */
  public Place setDisplayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Identifies this resource as a place. Value: "plus#place".
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as a place. Value: "plus#place".
   * The value set may be {@code null}.
   */
  public Place setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The position of the place.
   * The value returned may be {@code null}.
   */
  public Position getPosition() {
    return position;
  }

  /**
   * The position of the place.
   * The value set may be {@code null}.
   */
  public Place setPosition(Position position) {
    this.position = position;
    return this;
  }

  /**
   * The physical address of the place.
   */
  public static final class Address extends GenericJson {

    /**
     * The formatted address for display.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String formatted;

    /**
     * The formatted address for display.
     * The value returned may be {@code null}.
     */
    public String getFormatted() {
      return formatted;
    }

    /**
     * The formatted address for display.
     * The value set may be {@code null}.
     */
    public Address setFormatted(String formatted) {
      this.formatted = formatted;
      return this;
    }

  }

  /**
   * The position of the place.
   */
  public static final class Position extends GenericJson {

    /**
     * The latitude of this position.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Double latitude;

    /**
     * The longitude of this position.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Double longitude;

    /**
     * The latitude of this position.
     * The value returned may be {@code null}.
     */
    public Double getLatitude() {
      return latitude;
    }

    /**
     * The latitude of this position.
     * The value set may be {@code null}.
     */
    public Position setLatitude(Double latitude) {
      this.latitude = latitude;
      return this;
    }

    /**
     * The longitude of this position.
     * The value returned may be {@code null}.
     */
    public Double getLongitude() {
      return longitude;
    }

    /**
     * The longitude of this position.
     * The value set may be {@code null}.
     */
    public Position setLongitude(Double longitude) {
      this.longitude = longitude;
      return this;
    }

  }
}
