/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.plus.model;

import com.google.api.client.json.GenericJson;

/**
 * Model definition for PeopleFeed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PeopleFeed extends GenericJson {

  /**
   * ETag of this response for caching purposes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;

  /**
   * The people in this page of results. Each item includes the id, displayName, image, and url for
   * the person. To retrieve additional profile data, see the people.get method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Person> items;

  static {
    // hack to force ProGuard to consider Person used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Person.class);
  }

  /**
   * Identifies this resource as a collection of people. Value: "plus#peopleFeed".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextPageToken;

  /**
   * Link to this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The title of this collection of people.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String title;

  /**
   * The total number of people available in this list. The number of people in a response might be
   * smaller due to paging. This might not be set for all collections.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer totalItems;

  /**
   * ETag of this response for caching purposes.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * ETag of this response for caching purposes.
   * The value set may be {@code null}.
   */
  public PeopleFeed setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The people in this page of results. Each item includes the id, displayName, image, and url for
   * the person. To retrieve additional profile data, see the people.get method.
   * The value returned may be {@code null}.
   */
  public java.util.List<Person> getItems() {
    return items;
  }

  /**
   * The people in this page of results. Each item includes the id, displayName, image, and url for
   * the person. To retrieve additional profile data, see the people.get method.
   * The value set may be {@code null}.
   */
  public PeopleFeed setItems(java.util.List<Person> items) {
    this.items = items;
    return this;
  }

  /**
   * Identifies this resource as a collection of people. Value: "plus#peopleFeed".
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as a collection of people. Value: "plus#peopleFeed".
   * The value set may be {@code null}.
   */
  public PeopleFeed setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * The value returned may be {@code null}.
   */
  public String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * The value set may be {@code null}.
   */
  public PeopleFeed setNextPageToken(String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Link to this resource.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link to this resource.
   * The value set may be {@code null}.
   */
  public PeopleFeed setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The title of this collection of people.
   * The value returned may be {@code null}.
   */
  public String getTitle() {
    return title;
  }

  /**
   * The title of this collection of people.
   * The value set may be {@code null}.
   */
  public PeopleFeed setTitle(String title) {
    this.title = title;
    return this;
  }

  /**
   * The total number of people available in this list. The number of people in a response might be
   * smaller due to paging. This might not be set for all collections.
   * The value returned may be {@code null}.
   */
  public Integer getTotalItems() {
    return totalItems;
  }

  /**
   * The total number of people available in this list. The number of people in a response might be
   * smaller due to paging. This might not be set for all collections.
   * The value set may be {@code null}.
   */
  public PeopleFeed setTotalItems(Integer totalItems) {
    this.totalItems = totalItems;
    return this;
  }

}
