/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.plus.model;

import com.google.api.client.json.GenericJson;

/**
 * Model definition for ItemScope.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ItemScope extends GenericJson {

  /**
   * The subject matter of the content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope about;

  /**
   * An additional name for a Person, can be used for a middle name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> additionalName;

  /**
   * Postal address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope address;

  /**
   * Address country.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String addressCountry;

  /**
   * Address locality.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String addressLocality;

  /**
   * Address region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String addressRegion;

  /**
   * The encoding.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("associated_media")
  private java.util.List<ItemScope> associatedMedia;

  static {
    // hack to force ProGuard to consider ItemScope used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ItemScope.class);
  }

  /**
   * Number of attendees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer attendeeCount;

  /**
   * A person attending the event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ItemScope> attendees;

  static {
    // hack to force ProGuard to consider ItemScope used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ItemScope.class);
  }

  /**
   * From http://schema.org/MusicRecording, the audio file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope audio;

  /**
   * The person or persons who created this result. In the example of restaurant reviews, this might
   * be the reviewer's name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ItemScope> author;

  static {
    // hack to force ProGuard to consider ItemScope used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ItemScope.class);
  }

  /**
   * Best possible rating value that a result might obtain. This property defines the upper bound
   * for the ratingValue. For example, you might have a 5 star rating scale, you would provide 5 as
   * the value for this property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String bestRating;

  /**
   * Date of birth.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String birthDate;

  /**
   * From http://schema.org/MusicRecording, the artist that performed this recording.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope byArtist;

  /**
   * The caption for this object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String caption;

  /**
   * File size in (mega/kilo) bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String contentSize;

  /**
   * Actual bytes of the media object, for example the image file or video file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String contentUrl;

  /**
   * A list of contributors to this result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ItemScope> contributor;

  static {
    // hack to force ProGuard to consider ItemScope used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ItemScope.class);
  }

  /**
   * The date the result was created such as the date that a review was first created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String dateCreated;

  /**
   * The date the result was last modified such as the date that a review was last edited.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String dateModified;

  /**
   * The initial date that the result was published. For example, a user writes a comment on a blog,
   * which has a result.dateCreated of when they submit it. If the blog users comment moderation,
   * the result.datePublished value would match the date when the owner approved the message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String datePublished;

  /**
   * The string that describes the content of the result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * The duration of the item (movie, audio recording, event, etc.) in ISO 8601 date format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String duration;

  /**
   * A URL pointing to a player for a specific video. In general, this is the information in the src
   * element of an embed tag and should not be the same as the content of the loc tag.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String embedUrl;

  /**
   * The end date and time of the event (in ISO 8601 date format).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endDate;

  /**
   * Family name. This property can be used with givenName instead of the name property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String familyName;

  /**
   * Gender of the person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String gender;

  /**
   * Geo coordinates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope geo;

  /**
   * Given name. This property can be used with familyName instead of the name property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String givenName;

  /**
   * The height of the media object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String height;

  /**
   * An identifier for the target. Your app can choose how to identify targets. The target.id is
   * required if you are writing an activity that does not have a corresponding web page or
   * target.url property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * A URL to the image that represents this result. For example, if a user writes a review of a
   * restaurant and attaches a photo of their meal, you might use that photo as the result.image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String image;

  /**
   * From http://schema.org/MusicRecording, which album a song is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope inAlbum;

  /**
   * Identifies this resource as an itemScope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Latitude.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Double latitude;

  /**
   * The location of the event or organization.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope location;

  /**
   * Longitude.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Double longitude;

  /**
   * The name of the result. In the example of a restaurant review, this might be the summary the
   * user gave their review such as "Great ambiance, but overpriced."
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Property of http://schema.org/TVEpisode indicating which series the episode belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope partOfTVSeries;

  /**
   * The main performer or performers of the event-for example, a presenter, musician, or actor.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ItemScope> performers;

  static {
    // hack to force ProGuard to consider ItemScope used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ItemScope.class);
  }

  /**
   * Player type that is required. For example: Flash or Silverlight.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String playerType;

  /**
   * Post office box number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String postOfficeBoxNumber;

  /**
   * Postal code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String postalCode;

  /**
   * Rating value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String ratingValue;

  /**
   * Review rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope reviewRating;

  /**
   * The start date and time of the event (in ISO 8601 date format).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startDate;

  /**
   * Street address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String streetAddress;

  /**
   * The text that is the result of the app activity. For example, if a user leaves a review of a
   * restaurant, this might be the text of the review.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String text;

  /**
   * Thumbnail image for an image or video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope thumbnail;

  /**
   * A URL to a thumbnail image that represents this result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String thumbnailUrl;

  /**
   * The exchange traded instrument associated with a Corporation object. The tickerSymbol is
   * expressed as an exchange and an instrument name separated by a space character. For the
   * exchange component of the tickerSymbol attribute, we reccommend using the controlled vocaulary
   * of Market Identifier Codes (MIC) specified in ISO15022.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String tickerSymbol;

  /**
   * The schema.org URL that best describes the referenced target and matches the type of moment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String type;

  /**
   * The URL that points to the result object. For example, a permalink directly to a restaurant
   * reviewer's comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String url;

  /**
   * The width of the media object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String width;

  /**
   * Worst possible rating value that a result might obtain. This property defines the lower bound
   * for the ratingValue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String worstRating;

  /**
   * The subject matter of the content.
   * The value returned may be {@code null}.
   */
  public ItemScope getAbout() {
    return about;
  }

  /**
   * The subject matter of the content.
   * The value set may be {@code null}.
   */
  public ItemScope setAbout(ItemScope about) {
    this.about = about;
    return this;
  }

  /**
   * An additional name for a Person, can be used for a middle name.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getAdditionalName() {
    return additionalName;
  }

  /**
   * An additional name for a Person, can be used for a middle name.
   * The value set may be {@code null}.
   */
  public ItemScope setAdditionalName(java.util.List<String> additionalName) {
    this.additionalName = additionalName;
    return this;
  }

  /**
   * Postal address.
   * The value returned may be {@code null}.
   */
  public ItemScope getAddress() {
    return address;
  }

  /**
   * Postal address.
   * The value set may be {@code null}.
   */
  public ItemScope setAddress(ItemScope address) {
    this.address = address;
    return this;
  }

  /**
   * Address country.
   * The value returned may be {@code null}.
   */
  public String getAddressCountry() {
    return addressCountry;
  }

  /**
   * Address country.
   * The value set may be {@code null}.
   */
  public ItemScope setAddressCountry(String addressCountry) {
    this.addressCountry = addressCountry;
    return this;
  }

  /**
   * Address locality.
   * The value returned may be {@code null}.
   */
  public String getAddressLocality() {
    return addressLocality;
  }

  /**
   * Address locality.
   * The value set may be {@code null}.
   */
  public ItemScope setAddressLocality(String addressLocality) {
    this.addressLocality = addressLocality;
    return this;
  }

  /**
   * Address region.
   * The value returned may be {@code null}.
   */
  public String getAddressRegion() {
    return addressRegion;
  }

  /**
   * Address region.
   * The value set may be {@code null}.
   */
  public ItemScope setAddressRegion(String addressRegion) {
    this.addressRegion = addressRegion;
    return this;
  }

  /**
   * The encoding.
   * The value returned may be {@code null}.
   */
  public java.util.List<ItemScope> getAssociatedMedia() {
    return associatedMedia;
  }

  /**
   * The encoding.
   * The value set may be {@code null}.
   */
  public ItemScope setAssociatedMedia(java.util.List<ItemScope> associatedMedia) {
    this.associatedMedia = associatedMedia;
    return this;
  }

  /**
   * Number of attendees.
   * The value returned may be {@code null}.
   */
  public Integer getAttendeeCount() {
    return attendeeCount;
  }

  /**
   * Number of attendees.
   * The value set may be {@code null}.
   */
  public ItemScope setAttendeeCount(Integer attendeeCount) {
    this.attendeeCount = attendeeCount;
    return this;
  }

  /**
   * A person attending the event.
   * The value returned may be {@code null}.
   */
  public java.util.List<ItemScope> getAttendees() {
    return attendees;
  }

  /**
   * A person attending the event.
   * The value set may be {@code null}.
   */
  public ItemScope setAttendees(java.util.List<ItemScope> attendees) {
    this.attendees = attendees;
    return this;
  }

  /**
   * From http://schema.org/MusicRecording, the audio file.
   * The value returned may be {@code null}.
   */
  public ItemScope getAudio() {
    return audio;
  }

  /**
   * From http://schema.org/MusicRecording, the audio file.
   * The value set may be {@code null}.
   */
  public ItemScope setAudio(ItemScope audio) {
    this.audio = audio;
    return this;
  }

  /**
   * The person or persons who created this result. In the example of restaurant reviews, this might
   * be the reviewer's name.
   * The value returned may be {@code null}.
   */
  public java.util.List<ItemScope> getAuthor() {
    return author;
  }

  /**
   * The person or persons who created this result. In the example of restaurant reviews, this might
   * be the reviewer's name.
   * The value set may be {@code null}.
   */
  public ItemScope setAuthor(java.util.List<ItemScope> author) {
    this.author = author;
    return this;
  }

  /**
   * Best possible rating value that a result might obtain. This property defines the upper bound
   * for the ratingValue. For example, you might have a 5 star rating scale, you would provide 5 as
   * the value for this property.
   * The value returned may be {@code null}.
   */
  public String getBestRating() {
    return bestRating;
  }

  /**
   * Best possible rating value that a result might obtain. This property defines the upper bound
   * for the ratingValue. For example, you might have a 5 star rating scale, you would provide 5 as
   * the value for this property.
   * The value set may be {@code null}.
   */
  public ItemScope setBestRating(String bestRating) {
    this.bestRating = bestRating;
    return this;
  }

  /**
   * Date of birth.
   * The value returned may be {@code null}.
   */
  public String getBirthDate() {
    return birthDate;
  }

  /**
   * Date of birth.
   * The value set may be {@code null}.
   */
  public ItemScope setBirthDate(String birthDate) {
    this.birthDate = birthDate;
    return this;
  }

  /**
   * From http://schema.org/MusicRecording, the artist that performed this recording.
   * The value returned may be {@code null}.
   */
  public ItemScope getByArtist() {
    return byArtist;
  }

  /**
   * From http://schema.org/MusicRecording, the artist that performed this recording.
   * The value set may be {@code null}.
   */
  public ItemScope setByArtist(ItemScope byArtist) {
    this.byArtist = byArtist;
    return this;
  }

  /**
   * The caption for this object.
   * The value returned may be {@code null}.
   */
  public String getCaption() {
    return caption;
  }

  /**
   * The caption for this object.
   * The value set may be {@code null}.
   */
  public ItemScope setCaption(String caption) {
    this.caption = caption;
    return this;
  }

  /**
   * File size in (mega/kilo) bytes.
   * The value returned may be {@code null}.
   */
  public String getContentSize() {
    return contentSize;
  }

  /**
   * File size in (mega/kilo) bytes.
   * The value set may be {@code null}.
   */
  public ItemScope setContentSize(String contentSize) {
    this.contentSize = contentSize;
    return this;
  }

  /**
   * Actual bytes of the media object, for example the image file or video file.
   * The value returned may be {@code null}.
   */
  public String getContentUrl() {
    return contentUrl;
  }

  /**
   * Actual bytes of the media object, for example the image file or video file.
   * The value set may be {@code null}.
   */
  public ItemScope setContentUrl(String contentUrl) {
    this.contentUrl = contentUrl;
    return this;
  }

  /**
   * A list of contributors to this result.
   * The value returned may be {@code null}.
   */
  public java.util.List<ItemScope> getContributor() {
    return contributor;
  }

  /**
   * A list of contributors to this result.
   * The value set may be {@code null}.
   */
  public ItemScope setContributor(java.util.List<ItemScope> contributor) {
    this.contributor = contributor;
    return this;
  }

  /**
   * The date the result was created such as the date that a review was first created.
   * The value returned may be {@code null}.
   */
  public String getDateCreated() {
    return dateCreated;
  }

  /**
   * The date the result was created such as the date that a review was first created.
   * The value set may be {@code null}.
   */
  public ItemScope setDateCreated(String dateCreated) {
    this.dateCreated = dateCreated;
    return this;
  }

  /**
   * The date the result was last modified such as the date that a review was last edited.
   * The value returned may be {@code null}.
   */
  public String getDateModified() {
    return dateModified;
  }

  /**
   * The date the result was last modified such as the date that a review was last edited.
   * The value set may be {@code null}.
   */
  public ItemScope setDateModified(String dateModified) {
    this.dateModified = dateModified;
    return this;
  }

  /**
   * The initial date that the result was published. For example, a user writes a comment on a blog,
   * which has a result.dateCreated of when they submit it. If the blog users comment moderation,
   * the result.datePublished value would match the date when the owner approved the message.
   * The value returned may be {@code null}.
   */
  public String getDatePublished() {
    return datePublished;
  }

  /**
   * The initial date that the result was published. For example, a user writes a comment on a blog,
   * which has a result.dateCreated of when they submit it. If the blog users comment moderation,
   * the result.datePublished value would match the date when the owner approved the message.
   * The value set may be {@code null}.
   */
  public ItemScope setDatePublished(String datePublished) {
    this.datePublished = datePublished;
    return this;
  }

  /**
   * The string that describes the content of the result.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * The string that describes the content of the result.
   * The value set may be {@code null}.
   */
  public ItemScope setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * The duration of the item (movie, audio recording, event, etc.) in ISO 8601 date format.
   * The value returned may be {@code null}.
   */
  public String getDuration() {
    return duration;
  }

  /**
   * The duration of the item (movie, audio recording, event, etc.) in ISO 8601 date format.
   * The value set may be {@code null}.
   */
  public ItemScope setDuration(String duration) {
    this.duration = duration;
    return this;
  }

  /**
   * A URL pointing to a player for a specific video. In general, this is the information in the src
   * element of an embed tag and should not be the same as the content of the loc tag.
   * The value returned may be {@code null}.
   */
  public String getEmbedUrl() {
    return embedUrl;
  }

  /**
   * A URL pointing to a player for a specific video. In general, this is the information in the src
   * element of an embed tag and should not be the same as the content of the loc tag.
   * The value set may be {@code null}.
   */
  public ItemScope setEmbedUrl(String embedUrl) {
    this.embedUrl = embedUrl;
    return this;
  }

  /**
   * The end date and time of the event (in ISO 8601 date format).
   * The value returned may be {@code null}.
   */
  public String getEndDate() {
    return endDate;
  }

  /**
   * The end date and time of the event (in ISO 8601 date format).
   * The value set may be {@code null}.
   */
  public ItemScope setEndDate(String endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * Family name. This property can be used with givenName instead of the name property.
   * The value returned may be {@code null}.
   */
  public String getFamilyName() {
    return familyName;
  }

  /**
   * Family name. This property can be used with givenName instead of the name property.
   * The value set may be {@code null}.
   */
  public ItemScope setFamilyName(String familyName) {
    this.familyName = familyName;
    return this;
  }

  /**
   * Gender of the person.
   * The value returned may be {@code null}.
   */
  public String getGender() {
    return gender;
  }

  /**
   * Gender of the person.
   * The value set may be {@code null}.
   */
  public ItemScope setGender(String gender) {
    this.gender = gender;
    return this;
  }

  /**
   * Geo coordinates.
   * The value returned may be {@code null}.
   */
  public ItemScope getGeo() {
    return geo;
  }

  /**
   * Geo coordinates.
   * The value set may be {@code null}.
   */
  public ItemScope setGeo(ItemScope geo) {
    this.geo = geo;
    return this;
  }

  /**
   * Given name. This property can be used with familyName instead of the name property.
   * The value returned may be {@code null}.
   */
  public String getGivenName() {
    return givenName;
  }

  /**
   * Given name. This property can be used with familyName instead of the name property.
   * The value set may be {@code null}.
   */
  public ItemScope setGivenName(String givenName) {
    this.givenName = givenName;
    return this;
  }

  /**
   * The height of the media object.
   * The value returned may be {@code null}.
   */
  public String getHeight() {
    return height;
  }

  /**
   * The height of the media object.
   * The value set may be {@code null}.
   */
  public ItemScope setHeight(String height) {
    this.height = height;
    return this;
  }

  /**
   * An identifier for the target. Your app can choose how to identify targets. The target.id is
   * required if you are writing an activity that does not have a corresponding web page or
   * target.url property.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * An identifier for the target. Your app can choose how to identify targets. The target.id is
   * required if you are writing an activity that does not have a corresponding web page or
   * target.url property.
   * The value set may be {@code null}.
   */
  public ItemScope setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * A URL to the image that represents this result. For example, if a user writes a review of a
   * restaurant and attaches a photo of their meal, you might use that photo as the result.image.
   * The value returned may be {@code null}.
   */
  public String getImage() {
    return image;
  }

  /**
   * A URL to the image that represents this result. For example, if a user writes a review of a
   * restaurant and attaches a photo of their meal, you might use that photo as the result.image.
   * The value set may be {@code null}.
   */
  public ItemScope setImage(String image) {
    this.image = image;
    return this;
  }

  /**
   * From http://schema.org/MusicRecording, which album a song is in.
   * The value returned may be {@code null}.
   */
  public ItemScope getInAlbum() {
    return inAlbum;
  }

  /**
   * From http://schema.org/MusicRecording, which album a song is in.
   * The value set may be {@code null}.
   */
  public ItemScope setInAlbum(ItemScope inAlbum) {
    this.inAlbum = inAlbum;
    return this;
  }

  /**
   * Identifies this resource as an itemScope.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as an itemScope.
   * The value set may be {@code null}.
   */
  public ItemScope setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Latitude.
   * The value returned may be {@code null}.
   */
  public Double getLatitude() {
    return latitude;
  }

  /**
   * Latitude.
   * The value set may be {@code null}.
   */
  public ItemScope setLatitude(Double latitude) {
    this.latitude = latitude;
    return this;
  }

  /**
   * The location of the event or organization.
   * The value returned may be {@code null}.
   */
  public ItemScope getLocation() {
    return location;
  }

  /**
   * The location of the event or organization.
   * The value set may be {@code null}.
   */
  public ItemScope setLocation(ItemScope location) {
    this.location = location;
    return this;
  }

  /**
   * Longitude.
   * The value returned may be {@code null}.
   */
  public Double getLongitude() {
    return longitude;
  }

  /**
   * Longitude.
   * The value set may be {@code null}.
   */
  public ItemScope setLongitude(Double longitude) {
    this.longitude = longitude;
    return this;
  }

  /**
   * The name of the result. In the example of a restaurant review, this might be the summary the
   * user gave their review such as "Great ambiance, but overpriced."
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * The name of the result. In the example of a restaurant review, this might be the summary the
   * user gave their review such as "Great ambiance, but overpriced."
   * The value set may be {@code null}.
   */
  public ItemScope setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Property of http://schema.org/TVEpisode indicating which series the episode belongs to.
   * The value returned may be {@code null}.
   */
  public ItemScope getPartOfTVSeries() {
    return partOfTVSeries;
  }

  /**
   * Property of http://schema.org/TVEpisode indicating which series the episode belongs to.
   * The value set may be {@code null}.
   */
  public ItemScope setPartOfTVSeries(ItemScope partOfTVSeries) {
    this.partOfTVSeries = partOfTVSeries;
    return this;
  }

  /**
   * The main performer or performers of the event-for example, a presenter, musician, or actor.
   * The value returned may be {@code null}.
   */
  public java.util.List<ItemScope> getPerformers() {
    return performers;
  }

  /**
   * The main performer or performers of the event-for example, a presenter, musician, or actor.
   * The value set may be {@code null}.
   */
  public ItemScope setPerformers(java.util.List<ItemScope> performers) {
    this.performers = performers;
    return this;
  }

  /**
   * Player type that is required. For example: Flash or Silverlight.
   * The value returned may be {@code null}.
   */
  public String getPlayerType() {
    return playerType;
  }

  /**
   * Player type that is required. For example: Flash or Silverlight.
   * The value set may be {@code null}.
   */
  public ItemScope setPlayerType(String playerType) {
    this.playerType = playerType;
    return this;
  }

  /**
   * Post office box number.
   * The value returned may be {@code null}.
   */
  public String getPostOfficeBoxNumber() {
    return postOfficeBoxNumber;
  }

  /**
   * Post office box number.
   * The value set may be {@code null}.
   */
  public ItemScope setPostOfficeBoxNumber(String postOfficeBoxNumber) {
    this.postOfficeBoxNumber = postOfficeBoxNumber;
    return this;
  }

  /**
   * Postal code.
   * The value returned may be {@code null}.
   */
  public String getPostalCode() {
    return postalCode;
  }

  /**
   * Postal code.
   * The value set may be {@code null}.
   */
  public ItemScope setPostalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

  /**
   * Rating value.
   * The value returned may be {@code null}.
   */
  public String getRatingValue() {
    return ratingValue;
  }

  /**
   * Rating value.
   * The value set may be {@code null}.
   */
  public ItemScope setRatingValue(String ratingValue) {
    this.ratingValue = ratingValue;
    return this;
  }

  /**
   * Review rating.
   * The value returned may be {@code null}.
   */
  public ItemScope getReviewRating() {
    return reviewRating;
  }

  /**
   * Review rating.
   * The value set may be {@code null}.
   */
  public ItemScope setReviewRating(ItemScope reviewRating) {
    this.reviewRating = reviewRating;
    return this;
  }

  /**
   * The start date and time of the event (in ISO 8601 date format).
   * The value returned may be {@code null}.
   */
  public String getStartDate() {
    return startDate;
  }

  /**
   * The start date and time of the event (in ISO 8601 date format).
   * The value set may be {@code null}.
   */
  public ItemScope setStartDate(String startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Street address.
   * The value returned may be {@code null}.
   */
  public String getStreetAddress() {
    return streetAddress;
  }

  /**
   * Street address.
   * The value set may be {@code null}.
   */
  public ItemScope setStreetAddress(String streetAddress) {
    this.streetAddress = streetAddress;
    return this;
  }

  /**
   * The text that is the result of the app activity. For example, if a user leaves a review of a
   * restaurant, this might be the text of the review.
   * The value returned may be {@code null}.
   */
  public String getText() {
    return text;
  }

  /**
   * The text that is the result of the app activity. For example, if a user leaves a review of a
   * restaurant, this might be the text of the review.
   * The value set may be {@code null}.
   */
  public ItemScope setText(String text) {
    this.text = text;
    return this;
  }

  /**
   * Thumbnail image for an image or video.
   * The value returned may be {@code null}.
   */
  public ItemScope getThumbnail() {
    return thumbnail;
  }

  /**
   * Thumbnail image for an image or video.
   * The value set may be {@code null}.
   */
  public ItemScope setThumbnail(ItemScope thumbnail) {
    this.thumbnail = thumbnail;
    return this;
  }

  /**
   * A URL to a thumbnail image that represents this result.
   * The value returned may be {@code null}.
   */
  public String getThumbnailUrl() {
    return thumbnailUrl;
  }

  /**
   * A URL to a thumbnail image that represents this result.
   * The value set may be {@code null}.
   */
  public ItemScope setThumbnailUrl(String thumbnailUrl) {
    this.thumbnailUrl = thumbnailUrl;
    return this;
  }

  /**
   * The exchange traded instrument associated with a Corporation object. The tickerSymbol is
   * expressed as an exchange and an instrument name separated by a space character. For the
   * exchange component of the tickerSymbol attribute, we reccommend using the controlled vocaulary
   * of Market Identifier Codes (MIC) specified in ISO15022.
   * The value returned may be {@code null}.
   */
  public String getTickerSymbol() {
    return tickerSymbol;
  }

  /**
   * The exchange traded instrument associated with a Corporation object. The tickerSymbol is
   * expressed as an exchange and an instrument name separated by a space character. For the
   * exchange component of the tickerSymbol attribute, we reccommend using the controlled vocaulary
   * of Market Identifier Codes (MIC) specified in ISO15022.
   * The value set may be {@code null}.
   */
  public ItemScope setTickerSymbol(String tickerSymbol) {
    this.tickerSymbol = tickerSymbol;
    return this;
  }

  /**
   * The schema.org URL that best describes the referenced target and matches the type of moment.
   * The value returned may be {@code null}.
   */
  public String getType() {
    return type;
  }

  /**
   * The schema.org URL that best describes the referenced target and matches the type of moment.
   * The value set may be {@code null}.
   */
  public ItemScope setType(String type) {
    this.type = type;
    return this;
  }

  /**
   * The URL that points to the result object. For example, a permalink directly to a restaurant
   * reviewer's comment.
   * The value returned may be {@code null}.
   */
  public String getUrl() {
    return url;
  }

  /**
   * The URL that points to the result object. For example, a permalink directly to a restaurant
   * reviewer's comment.
   * The value set may be {@code null}.
   */
  public ItemScope setUrl(String url) {
    this.url = url;
    return this;
  }

  /**
   * The width of the media object.
   * The value returned may be {@code null}.
   */
  public String getWidth() {
    return width;
  }

  /**
   * The width of the media object.
   * The value set may be {@code null}.
   */
  public ItemScope setWidth(String width) {
    this.width = width;
    return this;
  }

  /**
   * Worst possible rating value that a result might obtain. This property defines the lower bound
   * for the ratingValue.
   * The value returned may be {@code null}.
   */
  public String getWorstRating() {
    return worstRating;
  }

  /**
   * Worst possible rating value that a result might obtain. This property defines the lower bound
   * for the ratingValue.
   * The value set may be {@code null}.
   */
  public ItemScope setWorstRating(String worstRating) {
    this.worstRating = worstRating;
    return this;
  }

}
