/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.plus.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * Model definition for ActivityFeed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ActivityFeed extends GenericJson {

  /**
   * ETag of this response for caching purposes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;

  /**
   * The ID of this collection of activities. Deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * The activities in this page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Activity> items;

  static {
    // hack to force ProGuard to consider Activity used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Activity.class);
  }

  /**
   * Identifies this resource as a collection of activities. Value: "plus#activityFeed".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Link to the next page of activities.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextLink;

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextPageToken;

  /**
   * Link to this activity resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The title of this collection of activities.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String title;

  /**
   * The time at which this collection of activities was last updated. Formatted as an RFC 3339
   * timestamp.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime updated;

  /**
   * ETag of this response for caching purposes.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * ETag of this response for caching purposes.
   * The value set may be {@code null}.
   */
  public ActivityFeed setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID of this collection of activities. Deprecated.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The ID of this collection of activities. Deprecated.
   * The value set may be {@code null}.
   */
  public ActivityFeed setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The activities in this page of results.
   * The value returned may be {@code null}.
   */
  public java.util.List<Activity> getItems() {
    return items;
  }

  /**
   * The activities in this page of results.
   * The value set may be {@code null}.
   */
  public ActivityFeed setItems(java.util.List<Activity> items) {
    this.items = items;
    return this;
  }

  /**
   * Identifies this resource as a collection of activities. Value: "plus#activityFeed".
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as a collection of activities. Value: "plus#activityFeed".
   * The value set may be {@code null}.
   */
  public ActivityFeed setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Link to the next page of activities.
   * The value returned may be {@code null}.
   */
  public String getNextLink() {
    return nextLink;
  }

  /**
   * Link to the next page of activities.
   * The value set may be {@code null}.
   */
  public ActivityFeed setNextLink(String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * The value returned may be {@code null}.
   */
  public String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * The value set may be {@code null}.
   */
  public ActivityFeed setNextPageToken(String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Link to this activity resource.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link to this activity resource.
   * The value set may be {@code null}.
   */
  public ActivityFeed setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The title of this collection of activities.
   * The value returned may be {@code null}.
   */
  public String getTitle() {
    return title;
  }

  /**
   * The title of this collection of activities.
   * The value set may be {@code null}.
   */
  public ActivityFeed setTitle(String title) {
    this.title = title;
    return this;
  }

  /**
   * The time at which this collection of activities was last updated. Formatted as an RFC 3339
   * timestamp.
   * The value returned may be {@code null}.
   */
  public DateTime getUpdated() {
    return updated;
  }

  /**
   * The time at which this collection of activities was last updated. Formatted as an RFC 3339
   * timestamp.
   * The value set may be {@code null}.
   */
  public ActivityFeed setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }

}
