/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.oauth2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.oauth2.Oauth2Request;
import com.google.api.services.oauth2.Oauth2RequestInitializer;
import com.google.api.services.oauth2.model.Jwk;
import com.google.api.services.oauth2.model.Raw;
import com.google.api.services.oauth2.model.Userinfoplus;
import com.google.api.services.oauth2.model.X509;
import java.io.IOException;

public class Oauth2
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch/oauth2/v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/";

    public Oauth2(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Oauth2(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Userinfo userinfo() {
        return new Userinfo();
    }

    public GetCertForOpenIdConnect getCertForOpenIdConnect() throws IOException {
        GetCertForOpenIdConnect result = new GetCertForOpenIdConnect();
        this.initialize((AbstractGoogleClientRequest<?>)result);
        return result;
    }

    public GetCertForOpenIdConnectRaw getCertForOpenIdConnectRaw() throws IOException {
        GetCertForOpenIdConnectRaw result = new GetCertForOpenIdConnectRaw();
        this.initialize((AbstractGoogleClientRequest<?>)result);
        return result;
    }

    public GetRobotJwk getRobotJwk(String robotEmail) throws IOException {
        GetRobotJwk result = new GetRobotJwk(robotEmail);
        this.initialize((AbstractGoogleClientRequest<?>)result);
        return result;
    }

    public GetRobotMetadataRaw getRobotMetadataRaw(String robotEmail) throws IOException {
        GetRobotMetadataRaw result = new GetRobotMetadataRaw(robotEmail);
        this.initialize((AbstractGoogleClientRequest<?>)result);
        return result;
    }

    public GetRobotMetadataX509 getRobotMetadataX509(String robotEmail) throws IOException {
        GetRobotMetadataX509 result = new GetRobotMetadataX509(robotEmail);
        this.initialize((AbstractGoogleClientRequest<?>)result);
        return result;
    }

    public Tokeninfo tokeninfo() throws IOException {
        Tokeninfo result = new Tokeninfo();
        this.initialize((AbstractGoogleClientRequest<?>)result);
        return result;
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.26.0 of the Google OAuth2 API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://www.googleapis.com/", Oauth2.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Oauth2.DEFAULT_BATCH_PATH);
        }

        public Oauth2 build() {
            return new Oauth2(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setOauth2RequestInitializer(Oauth2RequestInitializer oauth2RequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)oauth2RequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Tokeninfo
    extends Oauth2Request<com.google.api.services.oauth2.model.Tokeninfo> {
        private static final String REST_PATH = "oauth2/v1/tokeninfo";
        @Key(value="access_token")
        private String accessToken;
        @Key(value="id_token")
        private String idToken;

        protected Tokeninfo() {
            super(Oauth2.this, "POST", REST_PATH, null, com.google.api.services.oauth2.model.Tokeninfo.class);
        }

        public Tokeninfo setAlt(String alt) {
            return (Tokeninfo)super.setAlt(alt);
        }

        public Tokeninfo setFields(String fields) {
            return (Tokeninfo)super.setFields(fields);
        }

        public Tokeninfo setKey(String key) {
            return (Tokeninfo)super.setKey(key);
        }

        public Tokeninfo setOauthToken(String oauthToken) {
            return (Tokeninfo)super.setOauthToken(oauthToken);
        }

        public Tokeninfo setPrettyPrint(Boolean prettyPrint) {
            return (Tokeninfo)super.setPrettyPrint(prettyPrint);
        }

        public Tokeninfo setQuotaUser(String quotaUser) {
            return (Tokeninfo)super.setQuotaUser(quotaUser);
        }

        public Tokeninfo setUserIp(String userIp) {
            return (Tokeninfo)super.setUserIp(userIp);
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Tokeninfo setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public String getIdToken() {
            return this.idToken;
        }

        public Tokeninfo setIdToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        @Override
        public Tokeninfo set(String parameterName, Object value) {
            return (Tokeninfo)super.set(parameterName, value);
        }
    }

    public class GetRobotMetadataX509
    extends Oauth2Request<X509> {
        private static final String REST_PATH = "service_accounts/v1/metadata/x509/{robotEmail}";
        @Key
        private String robotEmail;

        protected GetRobotMetadataX509(String robotEmail) {
            super(Oauth2.this, "GET", REST_PATH, null, X509.class);
            this.robotEmail = (String)Preconditions.checkNotNull((Object)robotEmail, (Object)"Required parameter robotEmail must be specified.");
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetRobotMetadataX509 setAlt(String alt) {
            return (GetRobotMetadataX509)super.setAlt(alt);
        }

        public GetRobotMetadataX509 setFields(String fields) {
            return (GetRobotMetadataX509)super.setFields(fields);
        }

        public GetRobotMetadataX509 setKey(String key) {
            return (GetRobotMetadataX509)super.setKey(key);
        }

        public GetRobotMetadataX509 setOauthToken(String oauthToken) {
            return (GetRobotMetadataX509)super.setOauthToken(oauthToken);
        }

        public GetRobotMetadataX509 setPrettyPrint(Boolean prettyPrint) {
            return (GetRobotMetadataX509)super.setPrettyPrint(prettyPrint);
        }

        public GetRobotMetadataX509 setQuotaUser(String quotaUser) {
            return (GetRobotMetadataX509)super.setQuotaUser(quotaUser);
        }

        public GetRobotMetadataX509 setUserIp(String userIp) {
            return (GetRobotMetadataX509)super.setUserIp(userIp);
        }

        public String getRobotEmail() {
            return this.robotEmail;
        }

        public GetRobotMetadataX509 setRobotEmail(String robotEmail) {
            this.robotEmail = robotEmail;
            return this;
        }

        @Override
        public GetRobotMetadataX509 set(String parameterName, Object value) {
            return (GetRobotMetadataX509)super.set(parameterName, value);
        }
    }

    public class GetRobotMetadataRaw
    extends Oauth2Request<Raw> {
        private static final String REST_PATH = "service_accounts/v1/metadata/raw/{robotEmail}";
        @Key
        private String robotEmail;

        protected GetRobotMetadataRaw(String robotEmail) {
            super(Oauth2.this, "GET", REST_PATH, null, Raw.class);
            this.robotEmail = (String)Preconditions.checkNotNull((Object)robotEmail, (Object)"Required parameter robotEmail must be specified.");
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetRobotMetadataRaw setAlt(String alt) {
            return (GetRobotMetadataRaw)super.setAlt(alt);
        }

        public GetRobotMetadataRaw setFields(String fields) {
            return (GetRobotMetadataRaw)super.setFields(fields);
        }

        public GetRobotMetadataRaw setKey(String key) {
            return (GetRobotMetadataRaw)super.setKey(key);
        }

        public GetRobotMetadataRaw setOauthToken(String oauthToken) {
            return (GetRobotMetadataRaw)super.setOauthToken(oauthToken);
        }

        public GetRobotMetadataRaw setPrettyPrint(Boolean prettyPrint) {
            return (GetRobotMetadataRaw)super.setPrettyPrint(prettyPrint);
        }

        public GetRobotMetadataRaw setQuotaUser(String quotaUser) {
            return (GetRobotMetadataRaw)super.setQuotaUser(quotaUser);
        }

        public GetRobotMetadataRaw setUserIp(String userIp) {
            return (GetRobotMetadataRaw)super.setUserIp(userIp);
        }

        public String getRobotEmail() {
            return this.robotEmail;
        }

        public GetRobotMetadataRaw setRobotEmail(String robotEmail) {
            this.robotEmail = robotEmail;
            return this;
        }

        @Override
        public GetRobotMetadataRaw set(String parameterName, Object value) {
            return (GetRobotMetadataRaw)super.set(parameterName, value);
        }
    }

    public class GetRobotJwk
    extends Oauth2Request<Jwk> {
        private static final String REST_PATH = "service_accounts/v1/jwk/{robotEmail}";
        @Key
        private String robotEmail;

        protected GetRobotJwk(String robotEmail) {
            super(Oauth2.this, "GET", REST_PATH, null, Jwk.class);
            this.robotEmail = (String)Preconditions.checkNotNull((Object)robotEmail, (Object)"Required parameter robotEmail must be specified.");
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetRobotJwk setAlt(String alt) {
            return (GetRobotJwk)super.setAlt(alt);
        }

        public GetRobotJwk setFields(String fields) {
            return (GetRobotJwk)super.setFields(fields);
        }

        public GetRobotJwk setKey(String key) {
            return (GetRobotJwk)super.setKey(key);
        }

        public GetRobotJwk setOauthToken(String oauthToken) {
            return (GetRobotJwk)super.setOauthToken(oauthToken);
        }

        public GetRobotJwk setPrettyPrint(Boolean prettyPrint) {
            return (GetRobotJwk)super.setPrettyPrint(prettyPrint);
        }

        public GetRobotJwk setQuotaUser(String quotaUser) {
            return (GetRobotJwk)super.setQuotaUser(quotaUser);
        }

        public GetRobotJwk setUserIp(String userIp) {
            return (GetRobotJwk)super.setUserIp(userIp);
        }

        public String getRobotEmail() {
            return this.robotEmail;
        }

        public GetRobotJwk setRobotEmail(String robotEmail) {
            this.robotEmail = robotEmail;
            return this;
        }

        @Override
        public GetRobotJwk set(String parameterName, Object value) {
            return (GetRobotJwk)super.set(parameterName, value);
        }
    }

    public class GetCertForOpenIdConnectRaw
    extends Oauth2Request<Raw> {
        private static final String REST_PATH = "oauth2/v1/raw_public_keys";

        protected GetCertForOpenIdConnectRaw() {
            super(Oauth2.this, "GET", REST_PATH, null, Raw.class);
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetCertForOpenIdConnectRaw setAlt(String alt) {
            return (GetCertForOpenIdConnectRaw)super.setAlt(alt);
        }

        public GetCertForOpenIdConnectRaw setFields(String fields) {
            return (GetCertForOpenIdConnectRaw)super.setFields(fields);
        }

        public GetCertForOpenIdConnectRaw setKey(String key) {
            return (GetCertForOpenIdConnectRaw)super.setKey(key);
        }

        public GetCertForOpenIdConnectRaw setOauthToken(String oauthToken) {
            return (GetCertForOpenIdConnectRaw)super.setOauthToken(oauthToken);
        }

        public GetCertForOpenIdConnectRaw setPrettyPrint(Boolean prettyPrint) {
            return (GetCertForOpenIdConnectRaw)super.setPrettyPrint(prettyPrint);
        }

        public GetCertForOpenIdConnectRaw setQuotaUser(String quotaUser) {
            return (GetCertForOpenIdConnectRaw)super.setQuotaUser(quotaUser);
        }

        public GetCertForOpenIdConnectRaw setUserIp(String userIp) {
            return (GetCertForOpenIdConnectRaw)super.setUserIp(userIp);
        }

        @Override
        public GetCertForOpenIdConnectRaw set(String parameterName, Object value) {
            return (GetCertForOpenIdConnectRaw)super.set(parameterName, value);
        }
    }

    public class GetCertForOpenIdConnect
    extends Oauth2Request<X509> {
        private static final String REST_PATH = "oauth2/v1/certs";

        protected GetCertForOpenIdConnect() {
            super(Oauth2.this, "GET", REST_PATH, null, X509.class);
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetCertForOpenIdConnect setAlt(String alt) {
            return (GetCertForOpenIdConnect)super.setAlt(alt);
        }

        public GetCertForOpenIdConnect setFields(String fields) {
            return (GetCertForOpenIdConnect)super.setFields(fields);
        }

        public GetCertForOpenIdConnect setKey(String key) {
            return (GetCertForOpenIdConnect)super.setKey(key);
        }

        public GetCertForOpenIdConnect setOauthToken(String oauthToken) {
            return (GetCertForOpenIdConnect)super.setOauthToken(oauthToken);
        }

        public GetCertForOpenIdConnect setPrettyPrint(Boolean prettyPrint) {
            return (GetCertForOpenIdConnect)super.setPrettyPrint(prettyPrint);
        }

        public GetCertForOpenIdConnect setQuotaUser(String quotaUser) {
            return (GetCertForOpenIdConnect)super.setQuotaUser(quotaUser);
        }

        public GetCertForOpenIdConnect setUserIp(String userIp) {
            return (GetCertForOpenIdConnect)super.setUserIp(userIp);
        }

        @Override
        public GetCertForOpenIdConnect set(String parameterName, Object value) {
            return (GetCertForOpenIdConnect)super.set(parameterName, value);
        }
    }

    public class Userinfo {
        public Get get() throws IOException {
            Get result = new Get();
            Oauth2.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public V2 v2() {
            return new V2();
        }

        public class V2 {
            public Me me() {
                return new Me();
            }

            public class Me {
                public Get get() throws IOException {
                    Get result = new Get();
                    Oauth2.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Get
                extends Oauth2Request<Userinfoplus> {
                    private static final String REST_PATH = "userinfo/v2/me";

                    protected Get() {
                        super(Oauth2.this, "GET", REST_PATH, null, Userinfoplus.class);
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUserIp(String userIp) {
                        return (Get)super.setUserIp(userIp);
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }
        }

        public class Get
        extends Oauth2Request<Userinfoplus> {
            private static final String REST_PATH = "oauth2/v1/userinfo";

            protected Get() {
                super(Oauth2.this, "GET", REST_PATH, null, Userinfoplus.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

