/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-07 at 19:26:38 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * The response returned by a call to layers.List.published.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PublishedLayersListResponse extends com.google.api.client.json.GenericJson {

  /**
   * Resources returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PublishedLayer> layers;

  static {
    // hack to force ProGuard to consider PublishedLayer used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(PublishedLayer.class);
  }

  /**
   * Next page token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Resources returned.
   * @return value or {@code null} for none
   */
  public java.util.List<PublishedLayer> getLayers() {
    return layers;
  }

  /**
   * Resources returned.
   * @param layers layers or {@code null} for none
   */
  public PublishedLayersListResponse setLayers(java.util.List<PublishedLayer> layers) {
    this.layers = layers;
    return this;
  }

  /**
   * Next page token.
   * @see #decodeNextPageToken()
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Next page token.
   * @see #getNextPageToken()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeNextPageToken() {
    return com.google.api.client.util.Base64.decodeBase64(nextPageToken);
  }

  /**
   * Next page token.
   * @see #encodeNextPageToken()
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public PublishedLayersListResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Next page token.
   * @see #setNextPageToken()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public PublishedLayersListResponse encodeNextPageToken(byte[] nextPageToken) {
    this.nextPageToken = com.google.api.client.util.Base64.encodeBase64URLSafeString(nextPageToken);
    return this;
  }

  @Override
  public PublishedLayersListResponse set(String fieldName, Object value) {
    return (PublishedLayersListResponse) super.set(fieldName, value);
  }

  @Override
  public PublishedLayersListResponse clone() {
    return (PublishedLayersListResponse) super.clone();
  }

}
