/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.mapsengine;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.mapsengine.MapsEngineRequest;
import com.google.api.services.mapsengine.MapsEngineRequestInitializer;
import com.google.api.services.mapsengine.model.Feature;
import com.google.api.services.mapsengine.model.FeaturesBatchDeleteRequest;
import com.google.api.services.mapsengine.model.FeaturesBatchInsertRequest;
import com.google.api.services.mapsengine.model.FeaturesBatchPatchRequest;
import com.google.api.services.mapsengine.model.FeaturesListResponse;
import com.google.api.services.mapsengine.model.Image;
import com.google.api.services.mapsengine.model.Layer;
import com.google.api.services.mapsengine.model.LayersListResponse;
import com.google.api.services.mapsengine.model.Map;
import com.google.api.services.mapsengine.model.MapsListResponse;
import com.google.api.services.mapsengine.model.ParentsListResponse;
import com.google.api.services.mapsengine.model.ProjectsListResponse;
import com.google.api.services.mapsengine.model.RasterCollection;
import com.google.api.services.mapsengine.model.RastercollectionsListResponse;
import com.google.api.services.mapsengine.model.RastersListResponse;
import com.google.api.services.mapsengine.model.Resource;
import com.google.api.services.mapsengine.model.ResourcesListResponse;
import com.google.api.services.mapsengine.model.Table;
import com.google.api.services.mapsengine.model.TablesListResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapsEngine
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "mapsengine/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/mapsengine/v1/";

    public MapsEngine(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    MapsEngine(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Assets assets() {
        return new Assets();
    }

    public Layers layers() {
        return new Layers();
    }

    public Maps maps() {
        return new Maps();
    }

    public Projects projects() {
        return new Projects();
    }

    public RasterCollections rasterCollections() {
        return new RasterCollections();
    }

    public Rasters rasters() {
        return new Rasters();
    }

    public Tables tables() {
        return new Tables();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.15.0-rc of the Google Maps Engine API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, MapsEngine.DEFAULT_ROOT_URL, MapsEngine.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public MapsEngine build() {
            return new MapsEngine(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setMapsEngineRequestInitializer(MapsEngineRequestInitializer mapsEngineRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)mapsEngineRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Tables {
        public Create create(Table table) throws IOException {
            Create create = new Create(table);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Upload upload(Table table) throws IOException {
            Upload upload = new Upload(table);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)upload);
            return upload;
        }

        public Features features() {
            return new Features();
        }

        public Files files() {
            return new Files();
        }

        public Parents parents() {
            return new Parents();
        }

        public class Parents {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<ParentsListResponse> {
                private static final String REST_PATH = "tables/{id}/parents";
                @Key
                private String id;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, ParentsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Files {
            public Insert insert(String string, String string2) throws IOException {
                Insert insert = new Insert(string, string2);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public Insert insert(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Insert insert = new Insert(string, string2, abstractInputStreamContent);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends MapsEngineRequest<Void> {
                private static final String REST_PATH = "tables/{id}/files";
                @Key
                private String id;
                @Key
                private String filename;

                protected Insert(String string, String string2) {
                    super(MapsEngine.this, "POST", REST_PATH, null, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                    this.filename = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filename must be specified.");
                }

                protected Insert(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) {
                    super(MapsEngine.this, "POST", "/upload/" + MapsEngine.this.getServicePath() + REST_PATH, null, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                    this.filename = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filename must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public Insert setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getFilename() {
                    return this.filename;
                }

                public Insert setFilename(String string) {
                    this.filename = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }
        }

        public class Features {
            public BatchDelete batchDelete(String string, FeaturesBatchDeleteRequest featuresBatchDeleteRequest) throws IOException {
                BatchDelete batchDelete = new BatchDelete(string, featuresBatchDeleteRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                return batchDelete;
            }

            public BatchInsert batchInsert(String string, FeaturesBatchInsertRequest featuresBatchInsertRequest) throws IOException {
                BatchInsert batchInsert = new BatchInsert(string, featuresBatchInsertRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchInsert);
                return batchInsert;
            }

            public BatchPatch batchPatch(String string, FeaturesBatchPatchRequest featuresBatchPatchRequest) throws IOException {
                BatchPatch batchPatch = new BatchPatch(string, featuresBatchPatchRequest);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)batchPatch);
                return batchPatch;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<FeaturesListResponse> {
                private static final String REST_PATH = "tables/{id}/features";
                @Key
                private String id;
                @Key
                private String orderBy;
                @Key
                private String intersects;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String version;
                @Key
                private Long limit;
                @Key
                private String include;
                @Key
                private String where;
                @Key
                private String select;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, FeaturesListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String string) {
                    this.orderBy = string;
                    return this;
                }

                public String getIntersects() {
                    return this.intersects;
                }

                public List setIntersects(String string) {
                    this.intersects = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getVersion() {
                    return this.version;
                }

                public List setVersion(String string) {
                    this.version = string;
                    return this;
                }

                public Long getLimit() {
                    return this.limit;
                }

                public List setLimit(Long l) {
                    this.limit = l;
                    return this;
                }

                public String getInclude() {
                    return this.include;
                }

                public List setInclude(String string) {
                    this.include = string;
                    return this;
                }

                public String getWhere() {
                    return this.where;
                }

                public List setWhere(String string) {
                    this.where = string;
                    return this;
                }

                public String getSelect() {
                    return this.select;
                }

                public List setSelect(String string) {
                    this.select = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends MapsEngineRequest<Feature> {
                private static final String REST_PATH = "tables/{tableId}/features/{id}";
                @Key
                private String tableId;
                @Key
                private String id;
                @Key
                private String version;
                @Key
                private String select;

                protected Get(String string, String string2) {
                    super(MapsEngine.this, "GET", REST_PATH, null, Feature.class);
                    this.tableId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter tableId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getTableId() {
                    return this.tableId;
                }

                public Get setTableId(String string) {
                    this.tableId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getVersion() {
                    return this.version;
                }

                public Get setVersion(String string) {
                    this.version = string;
                    return this;
                }

                public String getSelect() {
                    return this.select;
                }

                public Get setSelect(String string) {
                    this.select = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchPatch
            extends MapsEngineRequest<Void> {
                private static final String REST_PATH = "tables/{id}/features/batchPatch";
                @Key
                private String id;

                protected BatchPatch(String string, FeaturesBatchPatchRequest featuresBatchPatchRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)featuresBatchPatchRequest, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchPatch setAlt(String string) {
                    return (BatchPatch)super.setAlt(string);
                }

                public BatchPatch setFields(String string) {
                    return (BatchPatch)super.setFields(string);
                }

                public BatchPatch setKey(String string) {
                    return (BatchPatch)super.setKey(string);
                }

                public BatchPatch setOauthToken(String string) {
                    return (BatchPatch)super.setOauthToken(string);
                }

                public BatchPatch setPrettyPrint(Boolean bl) {
                    return (BatchPatch)super.setPrettyPrint(bl);
                }

                public BatchPatch setQuotaUser(String string) {
                    return (BatchPatch)super.setQuotaUser(string);
                }

                public BatchPatch setUserIp(String string) {
                    return (BatchPatch)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchPatch setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchPatch set(String string, Object object) {
                    return (BatchPatch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchInsert
            extends MapsEngineRequest<Void> {
                private static final String REST_PATH = "tables/{id}/features/batchInsert";
                @Key
                private String id;

                protected BatchInsert(String string, FeaturesBatchInsertRequest featuresBatchInsertRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)featuresBatchInsertRequest, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchInsert setAlt(String string) {
                    return (BatchInsert)super.setAlt(string);
                }

                public BatchInsert setFields(String string) {
                    return (BatchInsert)super.setFields(string);
                }

                public BatchInsert setKey(String string) {
                    return (BatchInsert)super.setKey(string);
                }

                public BatchInsert setOauthToken(String string) {
                    return (BatchInsert)super.setOauthToken(string);
                }

                public BatchInsert setPrettyPrint(Boolean bl) {
                    return (BatchInsert)super.setPrettyPrint(bl);
                }

                public BatchInsert setQuotaUser(String string) {
                    return (BatchInsert)super.setQuotaUser(string);
                }

                public BatchInsert setUserIp(String string) {
                    return (BatchInsert)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchInsert setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchInsert set(String string, Object object) {
                    return (BatchInsert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchDelete
            extends MapsEngineRequest<Void> {
                private static final String REST_PATH = "tables/{id}/features/batchDelete";
                @Key
                private String id;

                protected BatchDelete(String string, FeaturesBatchDeleteRequest featuresBatchDeleteRequest) {
                    super(MapsEngine.this, "POST", REST_PATH, (Object)featuresBatchDeleteRequest, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public BatchDelete setAlt(String string) {
                    return (BatchDelete)super.setAlt(string);
                }

                public BatchDelete setFields(String string) {
                    return (BatchDelete)super.setFields(string);
                }

                public BatchDelete setKey(String string) {
                    return (BatchDelete)super.setKey(string);
                }

                public BatchDelete setOauthToken(String string) {
                    return (BatchDelete)super.setOauthToken(string);
                }

                public BatchDelete setPrettyPrint(Boolean bl) {
                    return (BatchDelete)super.setPrettyPrint(bl);
                }

                public BatchDelete setQuotaUser(String string) {
                    return (BatchDelete)super.setQuotaUser(string);
                }

                public BatchDelete setUserIp(String string) {
                    return (BatchDelete)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public BatchDelete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public BatchDelete set(String string, Object object) {
                    return (BatchDelete)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Upload
        extends MapsEngineRequest<Table> {
            private static final String REST_PATH = "tables/upload";

            protected Upload(Table table) {
                super(MapsEngine.this, "POST", REST_PATH, (Object)table, Table.class);
                this.checkRequiredParameter((Object)table, "content");
                this.checkRequiredParameter(table.getDraftAccessList(), "Table.getDraftAccessList()");
                this.checkRequiredParameter((Object)table, "content");
                this.checkRequiredParameter(table.getName(), "Table.getName()");
                this.checkRequiredParameter((Object)table, "content");
                this.checkRequiredParameter(table.getProjectId(), "Table.getProjectId()");
            }

            public Upload setAlt(String string) {
                return (Upload)super.setAlt(string);
            }

            public Upload setFields(String string) {
                return (Upload)super.setFields(string);
            }

            public Upload setKey(String string) {
                return (Upload)super.setKey(string);
            }

            public Upload setOauthToken(String string) {
                return (Upload)super.setOauthToken(string);
            }

            public Upload setPrettyPrint(Boolean bl) {
                return (Upload)super.setPrettyPrint(bl);
            }

            public Upload setQuotaUser(String string) {
                return (Upload)super.setQuotaUser(string);
            }

            public Upload setUserIp(String string) {
                return (Upload)super.setUserIp(string);
            }

            @Override
            public Upload set(String string, Object object) {
                return (Upload)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<TablesListResponse> {
            private static final String REST_PATH = "tables";
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String projectId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, TablesListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<Table> {
            private static final String REST_PATH = "tables/{id}";
            @Key
            private String id;
            @Key
            private String version;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, Table.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public Get setVersion(String string) {
                this.version = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends MapsEngineRequest<Table> {
            private static final String REST_PATH = "tables";

            protected Create(Table table) {
                super(MapsEngine.this, "POST", REST_PATH, (Object)table, Table.class);
                this.checkRequiredParameter((Object)table, "content");
                this.checkRequiredParameter(table.getDraftAccessList(), "Table.getDraftAccessList()");
                this.checkRequiredParameter((Object)table, "content");
                this.checkRequiredParameter(table.getName(), "Table.getName()");
                this.checkRequiredParameter((Object)table, "content");
                this.checkRequiredParameter(table.getProjectId(), "Table.getProjectId()");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Rasters {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Upload upload(Image image) throws IOException {
            Upload upload = new Upload(image);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)upload);
            return upload;
        }

        public Files files() {
            return new Files();
        }

        public Parents parents() {
            return new Parents();
        }

        public class Parents {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<ParentsListResponse> {
                private static final String REST_PATH = "rasters/{id}/parents";
                @Key
                private String id;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, ParentsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Files {
            public Insert insert(String string, String string2) throws IOException {
                Insert insert = new Insert(string, string2);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public Insert insert(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Insert insert = new Insert(string, string2, abstractInputStreamContent);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends MapsEngineRequest<Void> {
                private static final String REST_PATH = "rasters/{id}/files";
                @Key
                private String id;
                @Key
                private String filename;

                protected Insert(String string, String string2) {
                    super(MapsEngine.this, "POST", REST_PATH, null, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                    this.filename = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filename must be specified.");
                }

                protected Insert(String string, String string2, AbstractInputStreamContent abstractInputStreamContent) {
                    super(MapsEngine.this, "POST", "/upload/" + MapsEngine.this.getServicePath() + REST_PATH, null, Void.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                    this.filename = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filename must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public Insert setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getFilename() {
                    return this.filename;
                }

                public Insert setFilename(String string) {
                    this.filename = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Upload
        extends MapsEngineRequest<Image> {
            private static final String REST_PATH = "rasters/upload";

            protected Upload(Image image) {
                super(MapsEngine.this, "POST", REST_PATH, (Object)image, Image.class);
                this.checkRequiredParameter((Object)image, "content");
                this.checkRequiredParameter(image.getAttribution(), "Image.getAttribution()");
                this.checkRequiredParameter((Object)image, "content");
                this.checkRequiredParameter(image.getDraftAccessList(), "Image.getDraftAccessList()");
                this.checkRequiredParameter((Object)image, "content");
                this.checkRequiredParameter(image.getName(), "Image.getName()");
                this.checkRequiredParameter((Object)image, "content");
                this.checkRequiredParameter(image.getProjectId(), "Image.getProjectId()");
            }

            public Upload setAlt(String string) {
                return (Upload)super.setAlt(string);
            }

            public Upload setFields(String string) {
                return (Upload)super.setFields(string);
            }

            public Upload setKey(String string) {
                return (Upload)super.setKey(string);
            }

            public Upload setOauthToken(String string) {
                return (Upload)super.setOauthToken(string);
            }

            public Upload setPrettyPrint(Boolean bl) {
                return (Upload)super.setPrettyPrint(bl);
            }

            public Upload setQuotaUser(String string) {
                return (Upload)super.setQuotaUser(string);
            }

            public Upload setUserIp(String string) {
                return (Upload)super.setUserIp(string);
            }

            @Override
            public Upload set(String string, Object object) {
                return (Upload)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<Image> {
            private static final String REST_PATH = "rasters/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, Image.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class RasterCollections {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Parents parents() {
            return new Parents();
        }

        public Rasters rasters() {
            return new Rasters();
        }

        public class Rasters {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<RastersListResponse> {
                private static final String REST_PATH = "rasterCollections/{id}/rasters";
                @Key
                private String id;
                @Key
                private DateTime modifiedAfter;
                @Key
                private DateTime createdAfter;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String creatorEmail;
                @Key
                private String bbox;
                @Key
                private DateTime modifiedBefore;
                @Key
                private DateTime createdBefore;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, RastersListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public DateTime getModifiedAfter() {
                    return this.modifiedAfter;
                }

                public List setModifiedAfter(DateTime dateTime) {
                    this.modifiedAfter = dateTime;
                    return this;
                }

                public DateTime getCreatedAfter() {
                    return this.createdAfter;
                }

                public List setCreatedAfter(DateTime dateTime) {
                    this.createdAfter = dateTime;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getCreatorEmail() {
                    return this.creatorEmail;
                }

                public List setCreatorEmail(String string) {
                    this.creatorEmail = string;
                    return this;
                }

                public String getBbox() {
                    return this.bbox;
                }

                public List setBbox(String string) {
                    this.bbox = string;
                    return this;
                }

                public DateTime getModifiedBefore() {
                    return this.modifiedBefore;
                }

                public List setModifiedBefore(DateTime dateTime) {
                    this.modifiedBefore = dateTime;
                    return this;
                }

                public DateTime getCreatedBefore() {
                    return this.createdBefore;
                }

                public List setCreatedBefore(DateTime dateTime) {
                    this.createdBefore = dateTime;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Parents {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<ParentsListResponse> {
                private static final String REST_PATH = "rasterCollections/{id}/parents";
                @Key
                private String id;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, ParentsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<RastercollectionsListResponse> {
            private static final String REST_PATH = "rasterCollections";
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String projectId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, RastercollectionsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<RasterCollection> {
            private static final String REST_PATH = "rasterCollections/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, RasterCollection.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Projects {
        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<ProjectsListResponse> {
            private static final String REST_PATH = "projects";

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, ProjectsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Maps {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<MapsListResponse> {
            private static final String REST_PATH = "maps";
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String projectId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, MapsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<Map> {
            private static final String REST_PATH = "maps/{id}";
            @Key
            private String id;
            @Key
            private String version;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, Map.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public Get setVersion(String string) {
                this.version = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Layers {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Parents parents() {
            return new Parents();
        }

        public class Parents {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<ParentsListResponse> {
                private static final String REST_PATH = "layers/{id}/parents";
                @Key
                private String id;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, ParentsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<LayersListResponse> {
            private static final String REST_PATH = "layers";
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String projectId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, LayersListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<Layer> {
            private static final String REST_PATH = "layers/{id}";
            @Key
            private String id;
            @Key
            private String version;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, Layer.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public Get setVersion(String string) {
                this.version = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Assets {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Parents parents() {
            return new Parents();
        }

        public class Parents {
            public List list(String string) throws IOException {
                List list = new List(string);
                MapsEngine.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends MapsEngineRequest<ParentsListResponse> {
                private static final String REST_PATH = "assets/{id}/parents";
                @Key
                private String id;
                @Key
                private String pageToken;
                @Key
                private Long maxResults;

                protected List(String string) {
                    super(MapsEngine.this, "GET", REST_PATH, null, ParentsListResponse.class);
                    this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getId() {
                    return this.id;
                }

                public List setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends MapsEngineRequest<ResourcesListResponse> {
            private static final String REST_PATH = "assets";
            @Key
            private DateTime modifiedAfter;
            @Key
            private DateTime createdAfter;
            @Key
            private String projectId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String creatorEmail;
            @Key
            private String bbox;
            @Key
            private DateTime modifiedBefore;
            @Key
            private DateTime createdBefore;
            @Key
            private String type;

            protected List() {
                super(MapsEngine.this, "GET", REST_PATH, null, ResourcesListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public DateTime getModifiedAfter() {
                return this.modifiedAfter;
            }

            public List setModifiedAfter(DateTime dateTime) {
                this.modifiedAfter = dateTime;
                return this;
            }

            public DateTime getCreatedAfter() {
                return this.createdAfter;
            }

            public List setCreatedAfter(DateTime dateTime) {
                this.createdAfter = dateTime;
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCreatorEmail() {
                return this.creatorEmail;
            }

            public List setCreatorEmail(String string) {
                this.creatorEmail = string;
                return this;
            }

            public String getBbox() {
                return this.bbox;
            }

            public List setBbox(String string) {
                this.bbox = string;
                return this;
            }

            public DateTime getModifiedBefore() {
                return this.modifiedBefore;
            }

            public List setModifiedBefore(DateTime dateTime) {
                this.modifiedBefore = dateTime;
                return this;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public List setCreatedBefore(DateTime dateTime) {
                this.createdBefore = dateTime;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public List setType(String string) {
                this.type = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends MapsEngineRequest<Resource> {
            private static final String REST_PATH = "assets/{id}";
            @Key
            private String id;

            protected Get(String string) {
                super(MapsEngine.this, "GET", REST_PATH, null, Resource.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

