/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-06-30 15:48:57 UTC)
 * on 2014-07-14 at 07:26:24 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A raster collection groups multiple Raster resources for inclusion in a Layer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RasterCollection extends com.google.api.client.json.GenericJson {

  /**
   * The name of the attribution to be used for this RasterCollection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object attribution;

  /**
   * A rectangular bounding box which contains all of the data in this RasterCollection. The numbers
   * represent latitude and longitude in decimal degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> bbox;

  /**
   * The creation time of this RasterCollection. The value is an RFC 3339 formatted date-time value
   * (e.g. 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime creationTime;

  /**
   * The description of this RasterCollection, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Read About access lists in the
   * Google Maps Engine help center for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String draftAccessList;

  /**
   * The ETag, used to refer to the current version of the asset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * A globally unique ID, used to refer to this RasterCollection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The last modified time of this RasterCollection. The value is an RFC 3339 formatted date-time
   * value (e.g. 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastModifiedTime;

  /**
   * True if this RasterCollection is a mosaic.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean mosaic;

  /**
   * The name of this RasterCollection, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The processing status of this RasterCollection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processingStatus;

  /**
   * The ID of the project that this RasterCollection is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * The type of rasters contained within this RasterCollection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rasterType;

  /**
   * Tags of this RasterCollection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * The name of the attribution to be used for this RasterCollection.
   * @return value or {@code null} for none
   */
  public java.lang.Object getAttribution() {
    return attribution;
  }

  /**
   * The name of the attribution to be used for this RasterCollection.
   * @param attribution attribution or {@code null} for none
   */
  public RasterCollection setAttribution(java.lang.Object attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * A rectangular bounding box which contains all of the data in this RasterCollection. The numbers
   * represent latitude and longitude in decimal degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getBbox() {
    return bbox;
  }

  /**
   * A rectangular bounding box which contains all of the data in this RasterCollection. The numbers
   * represent latitude and longitude in decimal degrees.
   * @param bbox bbox or {@code null} for none
   */
  public RasterCollection setBbox(java.util.List<java.lang.Double> bbox) {
    this.bbox = bbox;
    return this;
  }

  /**
   * The creation time of this RasterCollection. The value is an RFC 3339 formatted date-time value
   * (e.g. 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreationTime() {
    return creationTime;
  }

  /**
   * The creation time of this RasterCollection. The value is an RFC 3339 formatted date-time value
   * (e.g. 1970-01-01T00:00:00Z).
   * @param creationTime creationTime or {@code null} for none
   */
  public RasterCollection setCreationTime(com.google.api.client.util.DateTime creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * The description of this RasterCollection, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this RasterCollection, supplied by the author.
   * @param description description or {@code null} for none
   */
  public RasterCollection setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Read About access lists in the
   * Google Maps Engine help center for more information.
   * @return value or {@code null} for none
   */
  public java.lang.String getDraftAccessList() {
    return draftAccessList;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Read About access lists in the
   * Google Maps Engine help center for more information.
   * @param draftAccessList draftAccessList or {@code null} for none
   */
  public RasterCollection setDraftAccessList(java.lang.String draftAccessList) {
    this.draftAccessList = draftAccessList;
    return this;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @param etag etag or {@code null} for none
   */
  public RasterCollection setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * A globally unique ID, used to refer to this RasterCollection.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A globally unique ID, used to refer to this RasterCollection.
   * @param id id or {@code null} for none
   */
  public RasterCollection setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The last modified time of this RasterCollection. The value is an RFC 3339 formatted date-time
   * value (e.g. 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * The last modified time of this RasterCollection. The value is an RFC 3339 formatted date-time
   * value (e.g. 1970-01-01T00:00:00Z).
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public RasterCollection setLastModifiedTime(com.google.api.client.util.DateTime lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * True if this RasterCollection is a mosaic.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMosaic() {
    return mosaic;
  }

  /**
   * True if this RasterCollection is a mosaic.
   * @param mosaic mosaic or {@code null} for none
   */
  public RasterCollection setMosaic(java.lang.Boolean mosaic) {
    this.mosaic = mosaic;
    return this;
  }

  /**
   * The name of this RasterCollection, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this RasterCollection, supplied by the author.
   * @param name name or {@code null} for none
   */
  public RasterCollection setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The processing status of this RasterCollection.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessingStatus() {
    return processingStatus;
  }

  /**
   * The processing status of this RasterCollection.
   * @param processingStatus processingStatus or {@code null} for none
   */
  public RasterCollection setProcessingStatus(java.lang.String processingStatus) {
    this.processingStatus = processingStatus;
    return this;
  }

  /**
   * The ID of the project that this RasterCollection is in.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the project that this RasterCollection is in.
   * @param projectId projectId or {@code null} for none
   */
  public RasterCollection setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * The type of rasters contained within this RasterCollection.
   * @return value or {@code null} for none
   */
  public java.lang.String getRasterType() {
    return rasterType;
  }

  /**
   * The type of rasters contained within this RasterCollection.
   * @param rasterType rasterType or {@code null} for none
   */
  public RasterCollection setRasterType(java.lang.String rasterType) {
    this.rasterType = rasterType;
    return this;
  }

  /**
   * Tags of this RasterCollection.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * Tags of this RasterCollection.
   * @param tags tags or {@code null} for none
   */
  public RasterCollection setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  @Override
  public RasterCollection set(String fieldName, Object value) {
    return (RasterCollection) super.set(fieldName, value);
  }

  @Override
  public RasterCollection clone() {
    return (RasterCollection) super.clone();
  }

}
