/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-01-12 at 02:46:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A heterogenous collection of GeoJsonGeometry objects.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GeoJsonGeometryCollection extends GeoJsonGeometry {

  /** Constructs GeoJsonGeometryCollection. **/
  public GeoJsonGeometryCollection() {
    super("GeometryCollection");
  }

  /**
   * An array of geometry objects. There must be at least 2 different types of geometries in the
   * array.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GeoJsonGeometry> geometries;

  static {
    // hack to force ProGuard to consider GeoJsonGeometry used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(GeoJsonGeometry.class);
  }

  /**
   * An array of geometry objects. There must be at least 2 different types of geometries in the
   * array.
   * @return value or {@code null} for none
   */
  public java.util.List<GeoJsonGeometry> getGeometries() {
    return geometries;
  }

  /**
   * An array of geometry objects. There must be at least 2 different types of geometries in the
   * array.
   * @param geometries geometries or {@code null} for none
   */
  public GeoJsonGeometryCollection setGeometries(java.util.List<GeoJsonGeometry> geometries) {
    this.geometries = geometries;
    return this;
  }

  @Override
  public GeoJsonGeometryCollection set(String fieldName, Object value) {
    return (GeoJsonGeometryCollection) super.set(fieldName, value);
  }

  @Override
  public GeoJsonGeometryCollection clone() {
    return (GeoJsonGeometryCollection) super.clone();
  }

}
