/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-06-30 at 21:34:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A raster collection groups multiple Raster resources for inclusion in a Layer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RasterCollection extends com.google.api.client.json.GenericJson {

  /**
   * The name of the attribution to be used for this RasterCollection. Note: Attribution is returned
   * in response to a get request but not a list request. After requesting a list of raster
   * collections, you'll need to send a get request to retrieve the attribution for each raster
   * collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attribution;

  /**
   * A rectangular bounding box which contains all of the data in this RasterCollection. The box is
   * expressed as \"west, south, east, north\". The numbers represent latitude and longitude in
   * decimal degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> bbox;

  /**
   * The creation time of this RasterCollection. The value is an RFC 3339 formatted date-time value
   * (e.g. 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime creationTime;

  /**
   * The email address of the creator of this raster collection. This is only returned on GET
   * requests and not LIST requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creatorEmail;

  /**
   * The description of this RasterCollection, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. Instead, each asset has its own list of permissions. For backward
   * compatibility, the API still accepts access lists for projects that are already using access
   * lists. If you created a GME account/project after July 14th, 2014, you will not be able to send
   * API requests that include access lists. Note: This is an input field only. It is not returned
   * in response to a list or get request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String draftAccessList;

  /**
   * The ETag, used to refer to the current version of the asset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * A globally unique ID, used to refer to this RasterCollection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The last modified time of this RasterCollection. The value is an RFC 3339 formatted date-time
   * value (e.g. 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastModifiedTime;

  /**
   * The email address of the last modifier of this raster collection. This is only returned on GET
   * requests and not LIST requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastModifierEmail;

  /**
   * True if this RasterCollection is a mosaic.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean mosaic;

  /**
   * The name of this RasterCollection, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The processing status of this RasterCollection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processingStatus;

  /**
   * The ID of the project that this RasterCollection is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * The type of rasters contained within this RasterCollection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rasterType;

  /**
   * Tags of this RasterCollection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * If true, WRITERs of the asset are able to edit the asset permissions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean writersCanEditPermissions;

  /**
   * The name of the attribution to be used for this RasterCollection. Note: Attribution is returned
   * in response to a get request but not a list request. After requesting a list of raster
   * collections, you'll need to send a get request to retrieve the attribution for each raster
   * collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttribution() {
    return attribution;
  }

  /**
   * The name of the attribution to be used for this RasterCollection. Note: Attribution is returned
   * in response to a get request but not a list request. After requesting a list of raster
   * collections, you'll need to send a get request to retrieve the attribution for each raster
   * collection.
   * @param attribution attribution or {@code null} for none
   */
  public RasterCollection setAttribution(java.lang.String attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * A rectangular bounding box which contains all of the data in this RasterCollection. The box is
   * expressed as \"west, south, east, north\". The numbers represent latitude and longitude in
   * decimal degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getBbox() {
    return bbox;
  }

  /**
   * A rectangular bounding box which contains all of the data in this RasterCollection. The box is
   * expressed as \"west, south, east, north\". The numbers represent latitude and longitude in
   * decimal degrees.
   * @param bbox bbox or {@code null} for none
   */
  public RasterCollection setBbox(java.util.List<java.lang.Double> bbox) {
    this.bbox = bbox;
    return this;
  }

  /**
   * The creation time of this RasterCollection. The value is an RFC 3339 formatted date-time value
   * (e.g. 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreationTime() {
    return creationTime;
  }

  /**
   * The creation time of this RasterCollection. The value is an RFC 3339 formatted date-time value
   * (e.g. 1970-01-01T00:00:00Z).
   * @param creationTime creationTime or {@code null} for none
   */
  public RasterCollection setCreationTime(com.google.api.client.util.DateTime creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * The email address of the creator of this raster collection. This is only returned on GET
   * requests and not LIST requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreatorEmail() {
    return creatorEmail;
  }

  /**
   * The email address of the creator of this raster collection. This is only returned on GET
   * requests and not LIST requests.
   * @param creatorEmail creatorEmail or {@code null} for none
   */
  public RasterCollection setCreatorEmail(java.lang.String creatorEmail) {
    this.creatorEmail = creatorEmail;
    return this;
  }

  /**
   * The description of this RasterCollection, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this RasterCollection, supplied by the author.
   * @param description description or {@code null} for none
   */
  public RasterCollection setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. Instead, each asset has its own list of permissions. For backward
   * compatibility, the API still accepts access lists for projects that are already using access
   * lists. If you created a GME account/project after July 14th, 2014, you will not be able to send
   * API requests that include access lists. Note: This is an input field only. It is not returned
   * in response to a list or get request.
   * @return value or {@code null} for none
   */
  public java.lang.String getDraftAccessList() {
    return draftAccessList;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. Instead, each asset has its own list of permissions. For backward
   * compatibility, the API still accepts access lists for projects that are already using access
   * lists. If you created a GME account/project after July 14th, 2014, you will not be able to send
   * API requests that include access lists. Note: This is an input field only. It is not returned
   * in response to a list or get request.
   * @param draftAccessList draftAccessList or {@code null} for none
   */
  public RasterCollection setDraftAccessList(java.lang.String draftAccessList) {
    this.draftAccessList = draftAccessList;
    return this;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @param etag etag or {@code null} for none
   */
  public RasterCollection setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * A globally unique ID, used to refer to this RasterCollection.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A globally unique ID, used to refer to this RasterCollection.
   * @param id id or {@code null} for none
   */
  public RasterCollection setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The last modified time of this RasterCollection. The value is an RFC 3339 formatted date-time
   * value (e.g. 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * The last modified time of this RasterCollection. The value is an RFC 3339 formatted date-time
   * value (e.g. 1970-01-01T00:00:00Z).
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public RasterCollection setLastModifiedTime(com.google.api.client.util.DateTime lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The email address of the last modifier of this raster collection. This is only returned on GET
   * requests and not LIST requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastModifierEmail() {
    return lastModifierEmail;
  }

  /**
   * The email address of the last modifier of this raster collection. This is only returned on GET
   * requests and not LIST requests.
   * @param lastModifierEmail lastModifierEmail or {@code null} for none
   */
  public RasterCollection setLastModifierEmail(java.lang.String lastModifierEmail) {
    this.lastModifierEmail = lastModifierEmail;
    return this;
  }

  /**
   * True if this RasterCollection is a mosaic.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMosaic() {
    return mosaic;
  }

  /**
   * True if this RasterCollection is a mosaic.
   * @param mosaic mosaic or {@code null} for none
   */
  public RasterCollection setMosaic(java.lang.Boolean mosaic) {
    this.mosaic = mosaic;
    return this;
  }

  /**
   * The name of this RasterCollection, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this RasterCollection, supplied by the author.
   * @param name name or {@code null} for none
   */
  public RasterCollection setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The processing status of this RasterCollection.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessingStatus() {
    return processingStatus;
  }

  /**
   * The processing status of this RasterCollection.
   * @param processingStatus processingStatus or {@code null} for none
   */
  public RasterCollection setProcessingStatus(java.lang.String processingStatus) {
    this.processingStatus = processingStatus;
    return this;
  }

  /**
   * The ID of the project that this RasterCollection is in.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the project that this RasterCollection is in.
   * @param projectId projectId or {@code null} for none
   */
  public RasterCollection setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * The type of rasters contained within this RasterCollection.
   * @return value or {@code null} for none
   */
  public java.lang.String getRasterType() {
    return rasterType;
  }

  /**
   * The type of rasters contained within this RasterCollection.
   * @param rasterType rasterType or {@code null} for none
   */
  public RasterCollection setRasterType(java.lang.String rasterType) {
    this.rasterType = rasterType;
    return this;
  }

  /**
   * Tags of this RasterCollection.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * Tags of this RasterCollection.
   * @param tags tags or {@code null} for none
   */
  public RasterCollection setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  /**
   * If true, WRITERs of the asset are able to edit the asset permissions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWritersCanEditPermissions() {
    return writersCanEditPermissions;
  }

  /**
   * If true, WRITERs of the asset are able to edit the asset permissions.
   * @param writersCanEditPermissions writersCanEditPermissions or {@code null} for none
   */
  public RasterCollection setWritersCanEditPermissions(java.lang.Boolean writersCanEditPermissions) {
    this.writersCanEditPermissions = writersCanEditPermissions;
    return this;
  }

  @Override
  public RasterCollection set(String fieldName, Object value) {
    return (RasterCollection) super.set(fieldName, value);
  }

  @Override
  public RasterCollection clone() {
    return (RasterCollection) super.clone();
  }

}
