/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-06-08 at 23:42:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * Parameters for styling points as scaled shapes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ScaledShape extends com.google.api.client.json.GenericJson {

  /**
   * Border color/width of the shape. If not specified the shape won't have a border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Border border;

  /**
   * The fill color of the shape. If not specified the shape will be transparent (although the
   * borders may not be).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color fill;

  /**
   * Name of the shape.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shape;

  /**
   * Border color/width of the shape. If not specified the shape won't have a border.
   * @return value or {@code null} for none
   */
  public Border getBorder() {
    return border;
  }

  /**
   * Border color/width of the shape. If not specified the shape won't have a border.
   * @param border border or {@code null} for none
   */
  public ScaledShape setBorder(Border border) {
    this.border = border;
    return this;
  }

  /**
   * The fill color of the shape. If not specified the shape will be transparent (although the
   * borders may not be).
   * @return value or {@code null} for none
   */
  public Color getFill() {
    return fill;
  }

  /**
   * The fill color of the shape. If not specified the shape will be transparent (although the
   * borders may not be).
   * @param fill fill or {@code null} for none
   */
  public ScaledShape setFill(Color fill) {
    this.fill = fill;
    return this;
  }

  /**
   * Name of the shape.
   * @return value or {@code null} for none
   */
  public java.lang.String getShape() {
    return shape;
  }

  /**
   * Name of the shape.
   * @param shape shape or {@code null} for none
   */
  public ScaledShape setShape(java.lang.String shape) {
    this.shape = shape;
    return this;
  }

  @Override
  public ScaledShape set(String fieldName, Object value) {
    return (ScaledShape) super.set(fieldName, value);
  }

  @Override
  public ScaledShape clone() {
    return (ScaledShape) super.clone();
  }

}
