/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-11-17 18:43:33 UTC)
 * on 2014-11-25 at 07:13:25 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * The response returned by a call to tables.List. Note: The list response does not include all the
 * fields available in a table. Refer to the table resource description for details of the fields
 * that are not included. You'll need to send a get request to retrieve the additional fields for
 * each table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TablesListResponse extends com.google.api.client.json.GenericJson {

  /**
   * Next page token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Resources returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Table> tables;

  /**
   * Next page token.
   * @see #decodeNextPageToken()
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Next page token.
   * @see #getNextPageToken()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeNextPageToken() {
    return com.google.api.client.util.Base64.decodeBase64(nextPageToken);
  }

  /**
   * Next page token.
   * @see #encodeNextPageToken()
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public TablesListResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Next page token.
   * @see #setNextPageToken()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public TablesListResponse encodeNextPageToken(byte[] nextPageToken) {
    this.nextPageToken = com.google.api.client.util.Base64.encodeBase64URLSafeString(nextPageToken);
    return this;
  }

  /**
   * Resources returned.
   * @return value or {@code null} for none
   */
  public java.util.List<Table> getTables() {
    return tables;
  }

  /**
   * Resources returned.
   * @param tables tables or {@code null} for none
   */
  public TablesListResponse setTables(java.util.List<Table> tables) {
    this.tables = tables;
    return this;
  }

  @Override
  public TablesListResponse set(String fieldName, Object value) {
    return (TablesListResponse) super.set(fieldName, value);
  }

  @Override
  public TablesListResponse clone() {
    return (TablesListResponse) super.clone();
  }

}
