/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-11-17 18:43:33 UTC)
 * on 2014-11-18 at 18:13:27 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * Model definition for MapKmlLink.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MapKmlLink extends com.google.api.client.json.GenericJson {

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> defaultViewport;

  /**
   * The URL to the KML file represented by this MapKmlLink.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kmlUrl;

  /**
   * The name of this MapKmlLink.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The visibility setting of this MapKmlLink. One of "defaultOn" or "defaultOff".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String visibility;

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getDefaultViewport() {
    return defaultViewport;
  }

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * @param defaultViewport defaultViewport or {@code null} for none
   */
  public MapKmlLink setDefaultViewport(java.util.List<java.lang.Double> defaultViewport) {
    this.defaultViewport = defaultViewport;
    return this;
  }

  /**
   * The URL to the KML file represented by this MapKmlLink.
   * @return value or {@code null} for none
   */
  public java.lang.String getKmlUrl() {
    return kmlUrl;
  }

  /**
   * The URL to the KML file represented by this MapKmlLink.
   * @param kmlUrl kmlUrl or {@code null} for none
   */
  public MapKmlLink setKmlUrl(java.lang.String kmlUrl) {
    this.kmlUrl = kmlUrl;
    return this;
  }

  /**
   * The name of this MapKmlLink.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this MapKmlLink.
   * @param name name or {@code null} for none
   */
  public MapKmlLink setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The visibility setting of this MapKmlLink. One of "defaultOn" or "defaultOff".
   * @return value or {@code null} for none
   */
  public java.lang.String getVisibility() {
    return visibility;
  }

  /**
   * The visibility setting of this MapKmlLink. One of "defaultOn" or "defaultOff".
   * @param visibility visibility or {@code null} for none
   */
  public MapKmlLink setVisibility(java.lang.String visibility) {
    this.visibility = visibility;
    return this;
  }

  @Override
  public MapKmlLink set(String fieldName, Object value) {
    return (MapKmlLink) super.set(fieldName, value);
  }

  @Override
  public MapKmlLink clone() {
    return (MapKmlLink) super.clone();
  }

}
