/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-09-20 at 10:59:53 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * The request sent to features.Insert.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FeaturesBatchInsertRequest extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Feature> features;

  static {
    // hack to force ProGuard to consider Feature used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Feature.class);
  }

  /**
   * If true, the server will normalize feature geometries. It is assumed that the South Pole is
   * exterior to any polygons given. See here for a list of normalizations. If false, all feature
   * geometries must be given already normalized. The points in all LinearRings must be listed in
   * counter-clockwise order, and LinearRings may not intersect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean normalizeGeometries;

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<Feature> getFeatures() {
    return features;
  }

  /**
   * @param features features or {@code null} for none
   */
  public FeaturesBatchInsertRequest setFeatures(java.util.List<Feature> features) {
    this.features = features;
    return this;
  }

  /**
   * If true, the server will normalize feature geometries. It is assumed that the South Pole is
   * exterior to any polygons given. See here for a list of normalizations. If false, all feature
   * geometries must be given already normalized. The points in all LinearRings must be listed in
   * counter-clockwise order, and LinearRings may not intersect.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNormalizeGeometries() {
    return normalizeGeometries;
  }

  /**
   * If true, the server will normalize feature geometries. It is assumed that the South Pole is
   * exterior to any polygons given. See here for a list of normalizations. If false, all feature
   * geometries must be given already normalized. The points in all LinearRings must be listed in
   * counter-clockwise order, and LinearRings may not intersect.
   * @param normalizeGeometries normalizeGeometries or {@code null} for none
   */
  public FeaturesBatchInsertRequest setNormalizeGeometries(java.lang.Boolean normalizeGeometries) {
    this.normalizeGeometries = normalizeGeometries;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * If true, the server will normalize feature geometries. It is assumed that the South Pole is
 exterior to any polygons given. See here for a list of normalizations. If false, all feature
 geometries must be given already normalized. The points in all LinearRings must be listed in
 counter-clockwise order, and LinearRings may not intersect.
   * </p>
   */
  public boolean isNormalizeGeometries() {
    if (normalizeGeometries == null || normalizeGeometries == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return normalizeGeometries;
  }

  @Override
  public FeaturesBatchInsertRequest set(String fieldName, Object value) {
    return (FeaturesBatchInsertRequest) super.set(fieldName, value);
  }

  @Override
  public FeaturesBatchInsertRequest clone() {
    return (FeaturesBatchInsertRequest) super.clone();
  }

}
