/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-09-18 at 03:52:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * The request sent to mapsengine.permissions.batchDelete.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PermissionsBatchDeleteRequest extends com.google.api.client.json.GenericJson {

  /**
   * The permissions to be removed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Permissions> permissions;

  static {
    // hack to force ProGuard to consider Permissions used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Permissions.class);
  }

  /**
   * The permissions to be removed.
   * @return value or {@code null} for none
   */
  public java.util.List<Permissions> getPermissions() {
    return permissions;
  }

  /**
   * The permissions to be removed.
   * @param permissions permissions or {@code null} for none
   */
  public PermissionsBatchDeleteRequest setPermissions(java.util.List<Permissions> permissions) {
    this.permissions = permissions;
    return this;
  }

  @Override
  public PermissionsBatchDeleteRequest set(String fieldName, Object value) {
    return (PermissionsBatchDeleteRequest) super.set(fieldName, value);
  }

  @Override
  public PermissionsBatchDeleteRequest clone() {
    return (PermissionsBatchDeleteRequest) super.clone();
  }

  /**
   * Model definition for PermissionsBatchDeleteRequestPermissions.
   */
  public static final class Permissions extends com.google.api.client.json.GenericJson {

    /**
     * The email address of the user or group this permission refers to.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String emailAddress;

    /**
     * The unique identifier of the permission.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * The email address of the user or group this permission refers to.
     * @return value or {@code null} for none
     */
    public java.lang.String getEmailAddress() {
      return emailAddress;
    }

    /**
     * The email address of the user or group this permission refers to.
     * @param emailAddress emailAddress or {@code null} for none
     */
    public Permissions setEmailAddress(java.lang.String emailAddress) {
      this.emailAddress = emailAddress;
      return this;
    }

    /**
     * The unique identifier of the permission.
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * The unique identifier of the permission.
     * @param id id or {@code null} for none
     */
    public Permissions setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    @Override
    public Permissions set(String fieldName, Object value) {
      return (Permissions) super.set(fieldName, value);
    }

    @Override
    public Permissions clone() {
      return (Permissions) super.clone();
    }

  }

}
