/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:59:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.manager.model;

/**
 * Model definition for ReplicaPoolModule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Deployment Manager API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReplicaPoolModule extends com.google.api.client.json.GenericJson {

  /**
   * A list of environment variables.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, EnvVariable> envVariables;

  static {
    // hack to force ProGuard to consider EnvVariable used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(EnvVariable.class);
  }

  /**
   * The Health Checks to configure for the ReplicaPoolModule
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> healthChecks;

  /**
   * Number of replicas in this module.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numReplicas;

  /**
   * Information for a ReplicaPoolModule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplicaPoolParams replicaPoolParams;

  /**
   * [Output Only] The name of the Resource View associated with a ReplicaPoolModule. This field
   * will be generated by the service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceView;

  /**
   * A list of environment variables.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, EnvVariable> getEnvVariables() {
    return envVariables;
  }

  /**
   * A list of environment variables.
   * @param envVariables envVariables or {@code null} for none
   */
  public ReplicaPoolModule setEnvVariables(java.util.Map<String, EnvVariable> envVariables) {
    this.envVariables = envVariables;
    return this;
  }

  /**
   * The Health Checks to configure for the ReplicaPoolModule
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getHealthChecks() {
    return healthChecks;
  }

  /**
   * The Health Checks to configure for the ReplicaPoolModule
   * @param healthChecks healthChecks or {@code null} for none
   */
  public ReplicaPoolModule setHealthChecks(java.util.List<java.lang.String> healthChecks) {
    this.healthChecks = healthChecks;
    return this;
  }

  /**
   * Number of replicas in this module.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumReplicas() {
    return numReplicas;
  }

  /**
   * Number of replicas in this module.
   * @param numReplicas numReplicas or {@code null} for none
   */
  public ReplicaPoolModule setNumReplicas(java.lang.Integer numReplicas) {
    this.numReplicas = numReplicas;
    return this;
  }

  /**
   * Information for a ReplicaPoolModule.
   * @return value or {@code null} for none
   */
  public ReplicaPoolParams getReplicaPoolParams() {
    return replicaPoolParams;
  }

  /**
   * Information for a ReplicaPoolModule.
   * @param replicaPoolParams replicaPoolParams or {@code null} for none
   */
  public ReplicaPoolModule setReplicaPoolParams(ReplicaPoolParams replicaPoolParams) {
    this.replicaPoolParams = replicaPoolParams;
    return this;
  }

  /**
   * [Output Only] The name of the Resource View associated with a ReplicaPoolModule. This field
   * will be generated by the service.
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceView() {
    return resourceView;
  }

  /**
   * [Output Only] The name of the Resource View associated with a ReplicaPoolModule. This field
   * will be generated by the service.
   * @param resourceView resourceView or {@code null} for none
   */
  public ReplicaPoolModule setResourceView(java.lang.String resourceView) {
    this.resourceView = resourceView;
    return this;
  }

  @Override
  public ReplicaPoolModule set(String fieldName, Object value) {
    return (ReplicaPoolModule) super.set(fieldName, value);
  }

  @Override
  public ReplicaPoolModule clone() {
    return (ReplicaPoolModule) super.clone();
  }

}
