/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:59:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.manager.model;

/**
 * Model definition for NetworkModule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Deployment Manager API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkModule extends com.google.api.client.json.GenericJson {

  /**
   * Required; The range of internal addresses that are legal on this network. This range is a CIDR
   * specification, for example: 192.168.0.0/16.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("IPv4Range")
  private java.lang.String iPv4Range;

  /**
   * The description of the network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * An optional address that is used for default routing to other networks. This must be within the
   * range specified by IPv4Range, and is typicall the first usable address in that range. If not
   * specified, the default value is the first usable address in IPv4Range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gatewayIPv4;

  /**
   * Required; The range of internal addresses that are legal on this network. This range is a CIDR
   * specification, for example: 192.168.0.0/16.
   * @return value or {@code null} for none
   */
  public java.lang.String getIPv4Range() {
    return iPv4Range;
  }

  /**
   * Required; The range of internal addresses that are legal on this network. This range is a CIDR
   * specification, for example: 192.168.0.0/16.
   * @param iPv4Range iPv4Range or {@code null} for none
   */
  public NetworkModule setIPv4Range(java.lang.String iPv4Range) {
    this.iPv4Range = iPv4Range;
    return this;
  }

  /**
   * The description of the network.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of the network.
   * @param description description or {@code null} for none
   */
  public NetworkModule setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * An optional address that is used for default routing to other networks. This must be within the
   * range specified by IPv4Range, and is typicall the first usable address in that range. If not
   * specified, the default value is the first usable address in IPv4Range.
   * @return value or {@code null} for none
   */
  public java.lang.String getGatewayIPv4() {
    return gatewayIPv4;
  }

  /**
   * An optional address that is used for default routing to other networks. This must be within the
   * range specified by IPv4Range, and is typicall the first usable address in that range. If not
   * specified, the default value is the first usable address in IPv4Range.
   * @param gatewayIPv4 gatewayIPv4 or {@code null} for none
   */
  public NetworkModule setGatewayIPv4(java.lang.String gatewayIPv4) {
    this.gatewayIPv4 = gatewayIPv4;
    return this;
  }

  @Override
  public NetworkModule set(String fieldName, Object value) {
    return (NetworkModule) super.set(fieldName, value);
  }

  @Override
  public NetworkModule clone() {
    return (NetworkModule) super.clone();
  }

}
