/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:59:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.manager.model;

/**
 * A Compute Engine NetworkInterface resource. Identical to the NetworkInterface on the
 * corresponding Compute Engine resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Deployment Manager API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkInterface extends com.google.api.client.json.GenericJson {

  /**
   * An array of configurations for this interface. This specifies how this interface is configured
   * to interact with other network services
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AccessConfig> accessConfigs;

  static {
    // hack to force ProGuard to consider AccessConfig used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(AccessConfig.class);
  }

  /**
   * Name of the interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The name of the NetworkModule to which this interface applies. If not specified, or specified
   * as 'default', this will use the 'default' network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * An optional IPV4 internal network address to assign to the instance for this network interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String networkIp;

  /**
   * An array of configurations for this interface. This specifies how this interface is configured
   * to interact with other network services
   * @return value or {@code null} for none
   */
  public java.util.List<AccessConfig> getAccessConfigs() {
    return accessConfigs;
  }

  /**
   * An array of configurations for this interface. This specifies how this interface is configured
   * to interact with other network services
   * @param accessConfigs accessConfigs or {@code null} for none
   */
  public NetworkInterface setAccessConfigs(java.util.List<AccessConfig> accessConfigs) {
    this.accessConfigs = accessConfigs;
    return this;
  }

  /**
   * Name of the interface.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the interface.
   * @param name name or {@code null} for none
   */
  public NetworkInterface setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the NetworkModule to which this interface applies. If not specified, or specified
   * as 'default', this will use the 'default' network.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * The name of the NetworkModule to which this interface applies. If not specified, or specified
   * as 'default', this will use the 'default' network.
   * @param network network or {@code null} for none
   */
  public NetworkInterface setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * An optional IPV4 internal network address to assign to the instance for this network interface.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetworkIp() {
    return networkIp;
  }

  /**
   * An optional IPV4 internal network address to assign to the instance for this network interface.
   * @param networkIp networkIp or {@code null} for none
   */
  public NetworkInterface setNetworkIp(java.lang.String networkIp) {
    this.networkIp = networkIp;
    return this;
  }

  @Override
  public NetworkInterface set(String fieldName, Object value) {
    return (NetworkInterface) super.set(fieldName, value);
  }

  @Override
  public NetworkInterface clone() {
    return (NetworkInterface) super.clone();
  }

}
