/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:59:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.manager.model;

/**
 * An Action encapsulates a set of commands as a single runnable module with additional information
 * needed during run-time.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Deployment Manager API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Action extends com.google.api.client.json.GenericJson {

  /**
   * A list of commands to run sequentially for this action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> commands;

  /**
   * The timeout in milliseconds for this action to run.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer timeoutMs;

  /**
   * A list of commands to run sequentially for this action.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCommands() {
    return commands;
  }

  /**
   * A list of commands to run sequentially for this action.
   * @param commands commands or {@code null} for none
   */
  public Action setCommands(java.util.List<java.lang.String> commands) {
    this.commands = commands;
    return this;
  }

  /**
   * The timeout in milliseconds for this action to run.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTimeoutMs() {
    return timeoutMs;
  }

  /**
   * The timeout in milliseconds for this action to run.
   * @param timeoutMs timeoutMs or {@code null} for none
   */
  public Action setTimeoutMs(java.lang.Integer timeoutMs) {
    this.timeoutMs = timeoutMs;
    return this;
  }

  @Override
  public Action set(String fieldName, Object value) {
    return (Action) super.set(fieldName, value);
  }

  @Override
  public Action clone() {
    return (Action) super.clone();
  }

}
