/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:59:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.manager.model;

/**
 * A Compute Engine network accessConfig. Identical to the accessConfig on corresponding Compute
 * Engine resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Deployment Manager API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccessConfig extends com.google.api.client.json.GenericJson {

  /**
   * Name of this access configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * An external IP address associated with this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String natIp;

  /**
   * Type of this access configuration file. (Currently only ONE_TO_ONE_NAT is legal.)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Name of this access configuration.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this access configuration.
   * @param name name or {@code null} for none
   */
  public AccessConfig setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * An external IP address associated with this instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getNatIp() {
    return natIp;
  }

  /**
   * An external IP address associated with this instance.
   * @param natIp natIp or {@code null} for none
   */
  public AccessConfig setNatIp(java.lang.String natIp) {
    this.natIp = natIp;
    return this;
  }

  /**
   * Type of this access configuration file. (Currently only ONE_TO_ONE_NAT is legal.)
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of this access configuration file. (Currently only ONE_TO_ONE_NAT is legal.)
   * @param type type or {@code null} for none
   */
  public AccessConfig setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public AccessConfig set(String fieldName, Object value) {
    return (AccessConfig) super.set(fieldName, value);
  }

  @Override
  public AccessConfig clone() {
    return (AccessConfig) super.clone();
  }

}
