/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:59:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.manager;

/**
 * Service definition for Manager (v1beta2).
 *
 * <p>
 * The Deployment Manager API allows users to declaratively configure, deploy and run complex solutions on the Google Cloud Platform.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/deployment-manager/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link ManagerRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Manager extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.19.1 of the Deployment Manager API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "manager/v1beta2/projects/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Manager(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Manager(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Deployments collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Manager manager = new Manager(...);}
   *   {@code Manager.Deployments.List request = manager.deployments().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Deployments deployments() {
    return new Deployments();
  }

  /**
   * The "deployments" collection of methods.
   */
  public class Deployments {

    /**
     * Create a request for the method "deployments.delete".
     *
     * This request holds the parameters needed by the manager server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId
     * @param region
     * @param deploymentName
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String region, java.lang.String deploymentName) throws java.io.IOException {
      Delete result = new Delete(projectId, region, deploymentName);
      initialize(result);
      return result;
    }

    public class Delete extends ManagerRequest<Void> {

      private static final String REST_PATH = "{projectId}/regions/{region}/deployments/{deploymentName}";

      /**
       * Create a request for the method "deployments.delete".
       *
       * This request holds the parameters needed by the the manager server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId
       * @param region
       * @param deploymentName
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String region, java.lang.String deploymentName) {
        super(Manager.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        this.deploymentName = com.google.api.client.util.Preconditions.checkNotNull(deploymentName, "Required parameter deploymentName must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      public Delete setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String region;

      /**

       */
      public java.lang.String getRegion() {
        return region;
      }

      public Delete setRegion(java.lang.String region) {
        this.region = region;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String deploymentName;

      /**

       */
      public java.lang.String getDeploymentName() {
        return deploymentName;
      }

      public Delete setDeploymentName(java.lang.String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Create a request for the method "deployments.get".
     *
     * This request holds the parameters needed by the manager server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId
     * @param region
     * @param deploymentName
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String region, java.lang.String deploymentName) throws java.io.IOException {
      Get result = new Get(projectId, region, deploymentName);
      initialize(result);
      return result;
    }

    public class Get extends ManagerRequest<com.google.api.services.manager.model.Deployment> {

      private static final String REST_PATH = "{projectId}/regions/{region}/deployments/{deploymentName}";

      /**
       * Create a request for the method "deployments.get".
       *
       * This request holds the parameters needed by the the manager server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId
       * @param region
       * @param deploymentName
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String region, java.lang.String deploymentName) {
        super(Manager.this, "GET", REST_PATH, null, com.google.api.services.manager.model.Deployment.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        this.deploymentName = com.google.api.client.util.Preconditions.checkNotNull(deploymentName, "Required parameter deploymentName must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String region;

      /**

       */
      public java.lang.String getRegion() {
        return region;
      }

      public Get setRegion(java.lang.String region) {
        this.region = region;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String deploymentName;

      /**

       */
      public java.lang.String getDeploymentName() {
        return deploymentName;
      }

      public Get setDeploymentName(java.lang.String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Create a request for the method "deployments.insert".
     *
     * This request holds the parameters needed by the manager server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId
     * @param region
     * @param content the {@link com.google.api.services.manager.model.Deployment}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, java.lang.String region, com.google.api.services.manager.model.Deployment content) throws java.io.IOException {
      Insert result = new Insert(projectId, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ManagerRequest<com.google.api.services.manager.model.Deployment> {

      private static final String REST_PATH = "{projectId}/regions/{region}/deployments";

      /**
       * Create a request for the method "deployments.insert".
       *
       * This request holds the parameters needed by the the manager server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId
       * @param region
       * @param content the {@link com.google.api.services.manager.model.Deployment}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, java.lang.String region, com.google.api.services.manager.model.Deployment content) {
        super(Manager.this, "POST", REST_PATH, content, com.google.api.services.manager.model.Deployment.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      public Insert setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String region;

      /**

       */
      public java.lang.String getRegion() {
        return region;
      }

      public Insert setRegion(java.lang.String region) {
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Create a request for the method "deployments.list".
     *
     * This request holds the parameters needed by the manager server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId
     * @param region
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String region) throws java.io.IOException {
      List result = new List(projectId, region);
      initialize(result);
      return result;
    }

    public class List extends ManagerRequest<com.google.api.services.manager.model.DeploymentsListResponse> {

      private static final String REST_PATH = "{projectId}/regions/{region}/deployments";

      /**
       * Create a request for the method "deployments.list".
       *
       * This request holds the parameters needed by the the manager server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId
       * @param region
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String region) {
        super(Manager.this, "GET", REST_PATH, null, com.google.api.services.manager.model.DeploymentsListResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      public List setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String region;

      /**

       */
      public java.lang.String getRegion() {
        return region;
      }

      public List setRegion(java.lang.String region) {
        this.region = region;
        return this;
      }

      /**
       * Maximum count of results to be returned. Acceptable values are 0 to 100, inclusive.
       * (Default: 50)
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum count of results to be returned. Acceptable values are 0 to 100, inclusive. (Default: 50)
     [default: 50] [minimum: 0] [maximum: 100]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum count of results to be returned. Acceptable values are 0 to 100, inclusive.
       * (Default: 50)
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a nextPageToken returned by a previous list request. This token can be used to
       * request the next page of results from a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a nextPageToken returned by a previous list request. This token can be used to request
     the next page of results from a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a nextPageToken returned by a previous list request. This token can be used to
       * request the next page of results from a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Templates collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Manager manager = new Manager(...);}
   *   {@code Manager.Templates.List request = manager.templates().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Templates templates() {
    return new Templates();
  }

  /**
   * The "templates" collection of methods.
   */
  public class Templates {

    /**
     * Create a request for the method "templates.delete".
     *
     * This request holds the parameters needed by the manager server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId
     * @param templateName
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String templateName) throws java.io.IOException {
      Delete result = new Delete(projectId, templateName);
      initialize(result);
      return result;
    }

    public class Delete extends ManagerRequest<Void> {

      private static final String REST_PATH = "{projectId}/templates/{templateName}";

      /**
       * Create a request for the method "templates.delete".
       *
       * This request holds the parameters needed by the the manager server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId
       * @param templateName
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String templateName) {
        super(Manager.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.templateName = com.google.api.client.util.Preconditions.checkNotNull(templateName, "Required parameter templateName must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      public Delete setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String templateName;

      /**

       */
      public java.lang.String getTemplateName() {
        return templateName;
      }

      public Delete setTemplateName(java.lang.String templateName) {
        this.templateName = templateName;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Create a request for the method "templates.get".
     *
     * This request holds the parameters needed by the manager server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId
     * @param templateName
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String templateName) throws java.io.IOException {
      Get result = new Get(projectId, templateName);
      initialize(result);
      return result;
    }

    public class Get extends ManagerRequest<com.google.api.services.manager.model.Template> {

      private static final String REST_PATH = "{projectId}/templates/{templateName}";

      /**
       * Create a request for the method "templates.get".
       *
       * This request holds the parameters needed by the the manager server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId
       * @param templateName
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String templateName) {
        super(Manager.this, "GET", REST_PATH, null, com.google.api.services.manager.model.Template.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        this.templateName = com.google.api.client.util.Preconditions.checkNotNull(templateName, "Required parameter templateName must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      public Get setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @com.google.api.client.util.Key
      private java.lang.String templateName;

      /**

       */
      public java.lang.String getTemplateName() {
        return templateName;
      }

      public Get setTemplateName(java.lang.String templateName) {
        this.templateName = templateName;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Create a request for the method "templates.insert".
     *
     * This request holds the parameters needed by the manager server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId
     * @param content the {@link com.google.api.services.manager.model.Template}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, com.google.api.services.manager.model.Template content) throws java.io.IOException {
      Insert result = new Insert(projectId, content);
      initialize(result);
      return result;
    }

    public class Insert extends ManagerRequest<com.google.api.services.manager.model.Template> {

      private static final String REST_PATH = "{projectId}/templates";

      /**
       * Create a request for the method "templates.insert".
       *
       * This request holds the parameters needed by the the manager server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId
       * @param content the {@link com.google.api.services.manager.model.Template}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, com.google.api.services.manager.model.Template content) {
        super(Manager.this, "POST", REST_PATH, content, com.google.api.services.manager.model.Template.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      public Insert setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Create a request for the method "templates.list".
     *
     * This request holds the parameters needed by the manager server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId
     * @return the request
     */
    public List list(java.lang.String projectId) throws java.io.IOException {
      List result = new List(projectId);
      initialize(result);
      return result;
    }

    public class List extends ManagerRequest<com.google.api.services.manager.model.TemplatesListResponse> {

      private static final String REST_PATH = "{projectId}/templates";

      /**
       * Create a request for the method "templates.list".
       *
       * This request holds the parameters needed by the the manager server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId
       * @since 1.13
       */
      protected List(java.lang.String projectId) {
        super(Manager.this, "GET", REST_PATH, null, com.google.api.services.manager.model.TemplatesListResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**

       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      public List setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /**
       * Maximum count of results to be returned. Acceptable values are 0 to 100, inclusive.
       * (Default: 50)
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum count of results to be returned. Acceptable values are 0 to 100, inclusive. (Default: 50)
     [default: 50] [minimum: 0] [maximum: 100]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum count of results to be returned. Acceptable values are 0 to 100, inclusive.
       * (Default: 50)
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Specifies a nextPageToken returned by a previous list request. This token can be used to
       * request the next page of results from a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a nextPageToken returned by a previous list request. This token can be used to request
     the next page of results from a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a nextPageToken returned by a previous list request. This token can be used to
       * request the next page of results from a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Manager}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Manager}. */
    @Override
    public Manager build() {
      return new Manager(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link ManagerRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setManagerRequestInitializer(
        ManagerRequestInitializer managerRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(managerRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
