/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.indexing.v3;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.indexing.v3.IndexingRequest;
import com.google.api.services.indexing.v3.IndexingRequestInitializer;
import com.google.api.services.indexing.v3.model.PublishUrlNotificationResponse;
import com.google.api.services.indexing.v3.model.UrlNotification;
import com.google.api.services.indexing.v3.model.UrlNotificationMetadata;
import java.io.IOException;

public class Indexing
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://indexing.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://indexing.googleapis.com/";

    public Indexing(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Indexing(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public UrlNotifications urlNotifications() {
        return new UrlNotifications();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.9 of the Indexing API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://indexing.googleapis.com/", Indexing.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Indexing.DEFAULT_BATCH_PATH);
        }

        public Indexing build() {
            return new Indexing(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setIndexingRequestInitializer(IndexingRequestInitializer indexingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)indexingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class UrlNotifications {
        public GetMetadata getMetadata() throws IOException {
            GetMetadata result = new GetMetadata();
            Indexing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Publish publish(UrlNotification content) throws IOException {
            Publish result = new Publish(content);
            Indexing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Publish
        extends IndexingRequest<PublishUrlNotificationResponse> {
            private static final String REST_PATH = "v3/urlNotifications:publish";

            protected Publish(UrlNotification content) {
                super(Indexing.this, "POST", REST_PATH, (Object)content, PublishUrlNotificationResponse.class);
            }

            public Publish set$Xgafv(String $Xgafv) {
                return (Publish)super.set$Xgafv($Xgafv);
            }

            public Publish setAccessToken(String accessToken) {
                return (Publish)super.setAccessToken(accessToken);
            }

            public Publish setAlt(String alt) {
                return (Publish)super.setAlt(alt);
            }

            public Publish setCallback(String callback) {
                return (Publish)super.setCallback(callback);
            }

            public Publish setFields(String fields) {
                return (Publish)super.setFields(fields);
            }

            public Publish setKey(String key) {
                return (Publish)super.setKey(key);
            }

            public Publish setOauthToken(String oauthToken) {
                return (Publish)super.setOauthToken(oauthToken);
            }

            public Publish setPrettyPrint(Boolean prettyPrint) {
                return (Publish)super.setPrettyPrint(prettyPrint);
            }

            public Publish setQuotaUser(String quotaUser) {
                return (Publish)super.setQuotaUser(quotaUser);
            }

            public Publish setUploadType(String uploadType) {
                return (Publish)super.setUploadType(uploadType);
            }

            public Publish setUploadProtocol(String uploadProtocol) {
                return (Publish)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Publish set(String parameterName, Object value) {
                return (Publish)super.set(parameterName, value);
            }
        }

        public class GetMetadata
        extends IndexingRequest<UrlNotificationMetadata> {
            private static final String REST_PATH = "v3/urlNotifications/metadata";
            @Key
            private String url;

            protected GetMetadata() {
                super(Indexing.this, "GET", REST_PATH, null, UrlNotificationMetadata.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetMetadata set$Xgafv(String $Xgafv) {
                return (GetMetadata)super.set$Xgafv($Xgafv);
            }

            public GetMetadata setAccessToken(String accessToken) {
                return (GetMetadata)super.setAccessToken(accessToken);
            }

            public GetMetadata setAlt(String alt) {
                return (GetMetadata)super.setAlt(alt);
            }

            public GetMetadata setCallback(String callback) {
                return (GetMetadata)super.setCallback(callback);
            }

            public GetMetadata setFields(String fields) {
                return (GetMetadata)super.setFields(fields);
            }

            public GetMetadata setKey(String key) {
                return (GetMetadata)super.setKey(key);
            }

            public GetMetadata setOauthToken(String oauthToken) {
                return (GetMetadata)super.setOauthToken(oauthToken);
            }

            public GetMetadata setPrettyPrint(Boolean prettyPrint) {
                return (GetMetadata)super.setPrettyPrint(prettyPrint);
            }

            public GetMetadata setQuotaUser(String quotaUser) {
                return (GetMetadata)super.setQuotaUser(quotaUser);
            }

            public GetMetadata setUploadType(String uploadType) {
                return (GetMetadata)super.setUploadType(uploadType);
            }

            public GetMetadata setUploadProtocol(String uploadProtocol) {
                return (GetMetadata)super.setUploadProtocol(uploadProtocol);
            }

            public String getUrl() {
                return this.url;
            }

            public GetMetadata setUrl(String url) {
                this.url = url;
                return this;
            }

            @Override
            public GetMetadata set(String parameterName, Object value) {
                return (GetMetadata)super.set(parameterName, value);
            }
        }
    }
}

