/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.indexing.v3;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.indexing.v3.IndexingRequest;
import com.google.api.services.indexing.v3.IndexingRequestInitializer;
import com.google.api.services.indexing.v3.model.PublishUrlNotificationResponse;
import com.google.api.services.indexing.v3.model.UrlNotification;
import com.google.api.services.indexing.v3.model.UrlNotificationMetadata;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indexing
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://indexing.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://indexing.googleapis.com/";

    public Indexing(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Indexing(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public UrlNotifications urlNotifications() {
        return new UrlNotifications();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Indexing API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://indexing.googleapis.com/", Indexing.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Indexing.DEFAULT_BATCH_PATH);
        }

        public Indexing build() {
            return new Indexing(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setIndexingRequestInitializer(IndexingRequestInitializer indexingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)indexingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class UrlNotifications {
        public GetMetadata getMetadata() throws IOException {
            GetMetadata getMetadata = new GetMetadata();
            Indexing.this.initialize((AbstractGoogleClientRequest<?>)getMetadata);
            return getMetadata;
        }

        public Publish publish(UrlNotification urlNotification) throws IOException {
            Publish publish = new Publish(urlNotification);
            Indexing.this.initialize((AbstractGoogleClientRequest<?>)publish);
            return publish;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Publish
        extends IndexingRequest<PublishUrlNotificationResponse> {
            private static final String REST_PATH = "v3/urlNotifications:publish";

            protected Publish(UrlNotification urlNotification) {
                super(Indexing.this, "POST", REST_PATH, (Object)urlNotification, PublishUrlNotificationResponse.class);
            }

            public Publish set$Xgafv(String string) {
                return (Publish)super.set$Xgafv(string);
            }

            public Publish setAccessToken(String string) {
                return (Publish)super.setAccessToken(string);
            }

            public Publish setAlt(String string) {
                return (Publish)super.setAlt(string);
            }

            public Publish setCallback(String string) {
                return (Publish)super.setCallback(string);
            }

            public Publish setFields(String string) {
                return (Publish)super.setFields(string);
            }

            public Publish setKey(String string) {
                return (Publish)super.setKey(string);
            }

            public Publish setOauthToken(String string) {
                return (Publish)super.setOauthToken(string);
            }

            public Publish setPrettyPrint(Boolean bl) {
                return (Publish)super.setPrettyPrint(bl);
            }

            public Publish setQuotaUser(String string) {
                return (Publish)super.setQuotaUser(string);
            }

            public Publish setUploadType(String string) {
                return (Publish)super.setUploadType(string);
            }

            public Publish setUploadProtocol(String string) {
                return (Publish)super.setUploadProtocol(string);
            }

            @Override
            public Publish set(String string, Object object) {
                return (Publish)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetMetadata
        extends IndexingRequest<UrlNotificationMetadata> {
            private static final String REST_PATH = "v3/urlNotifications/metadata";
            @Key
            private String url;

            protected GetMetadata() {
                super(Indexing.this, "GET", REST_PATH, null, UrlNotificationMetadata.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetMetadata set$Xgafv(String string) {
                return (GetMetadata)super.set$Xgafv(string);
            }

            public GetMetadata setAccessToken(String string) {
                return (GetMetadata)super.setAccessToken(string);
            }

            public GetMetadata setAlt(String string) {
                return (GetMetadata)super.setAlt(string);
            }

            public GetMetadata setCallback(String string) {
                return (GetMetadata)super.setCallback(string);
            }

            public GetMetadata setFields(String string) {
                return (GetMetadata)super.setFields(string);
            }

            public GetMetadata setKey(String string) {
                return (GetMetadata)super.setKey(string);
            }

            public GetMetadata setOauthToken(String string) {
                return (GetMetadata)super.setOauthToken(string);
            }

            public GetMetadata setPrettyPrint(Boolean bl) {
                return (GetMetadata)super.setPrettyPrint(bl);
            }

            public GetMetadata setQuotaUser(String string) {
                return (GetMetadata)super.setQuotaUser(string);
            }

            public GetMetadata setUploadType(String string) {
                return (GetMetadata)super.setUploadType(string);
            }

            public GetMetadata setUploadProtocol(String string) {
                return (GetMetadata)super.setUploadProtocol(string);
            }

            public String getUrl() {
                return this.url;
            }

            public GetMetadata setUrl(String string) {
                this.url = string;
                return this;
            }

            @Override
            public GetMetadata set(String string, Object object) {
                return (GetMetadata)super.set(string, object);
            }
        }
    }
}

