/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Response of verifying the IDP assertion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VerifyAssertionResponse extends com.google.api.client.json.GenericJson {

  /**
   * The action code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String action;

  /**
   * URL for OTA app installation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appInstallationUrl;

  /**
   * The custom scheme used by mobile app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appScheme;

  /**
   * The opaque value used by the client to maintain context info between the authentication request
   * and the IDP callback.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String context;

  /**
   * The birth date of the IdP account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dateOfBirth;

  /**
   * The display name of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The email returned by the IdP. NOTE: The federated login user may not own the email.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * It's true if the email is recycled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean emailRecycled;

  /**
   * The value is true if the IDP is also the email provider. It means the user owns the email.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean emailVerified;

  /**
   * Client error code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String errorMessage;

  /**
   * If idToken is STS id token, then this field will be expiration time of STS id token in seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expiresIn;

  /**
   * The unique ID identifies the IdP account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String federatedId;

  /**
   * The first name of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String firstName;

  /**
   * The full name of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fullName;

  /**
   * The ID token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String idToken;

  /**
   * It's the identifier param in the createAuthUri request if the identifier is an email. It can be
   * used to check whether the user input email is different from the asserted email.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String inputEmail;

  /**
   * True if it's a new user sign-in, false if it's a returning user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isNewUser;

  /**
   * The fixed string "identitytoolkit#VerifyAssertionResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The language preference of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String language;

  /**
   * The last name of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastName;

  /**
   * The RP local ID if it's already been mapped to the IdP account identified by the federated ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localId;

  /**
   * Whether the assertion is from a non-trusted IDP and need account linking confirmation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean needConfirmation;

  /**
   * Whether need client to supply email to complete the federated login flow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean needEmail;

  /**
   * The nick name of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nickName;

  /**
   * The OAuth2 access token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oauthAccessToken;

  /**
   * The OAuth2 authorization code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oauthAuthorizationCode;

  /**
   * The lifetime in seconds of the OAuth2 access token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer oauthExpireIn;

  /**
   * The OIDC id token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oauthIdToken;

  /**
   * The user approved request token for the OpenID OAuth extension.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oauthRequestToken;

  /**
   * The scope for the OpenID OAuth extension.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oauthScope;

  /**
   * The OAuth1 access token secret.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oauthTokenSecret;

  /**
   * The original email stored in the mapping storage. It's returned when the federated ID is
   * associated to a different email.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originalEmail;

  /**
   * The URI of the public accessible profiel picture.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String photoUrl;

  /**
   * The IdP ID. For white listed IdPs it's a short domain name e.g. google.com, aol.com, live.net
   * and yahoo.com. If the "providerId" param is set to OpenID OP identifer other than the whilte
   * listed IdPs the OP identifier is returned. If the "identifier" param is federated ID in the
   * createAuthUri request. The domain part of the federated ID is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String providerId;

  /**
   * Raw IDP-returned user info.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rawUserInfo;

  /**
   * If idToken is STS id token, then this field will be refresh token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String refreshToken;

  /**
   * The screen_name of a Twitter user or the login name at Github.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String screenName;

  /**
   * The timezone of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * When action is 'map', contains the idps which can be used for confirmation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> verifiedProvider;

  /**
   * The action code.
   * @return value or {@code null} for none
   */
  public java.lang.String getAction() {
    return action;
  }

  /**
   * The action code.
   * @param action action or {@code null} for none
   */
  public VerifyAssertionResponse setAction(java.lang.String action) {
    this.action = action;
    return this;
  }

  /**
   * URL for OTA app installation.
   * @return value or {@code null} for none
   */
  public java.lang.String getAppInstallationUrl() {
    return appInstallationUrl;
  }

  /**
   * URL for OTA app installation.
   * @param appInstallationUrl appInstallationUrl or {@code null} for none
   */
  public VerifyAssertionResponse setAppInstallationUrl(java.lang.String appInstallationUrl) {
    this.appInstallationUrl = appInstallationUrl;
    return this;
  }

  /**
   * The custom scheme used by mobile app.
   * @return value or {@code null} for none
   */
  public java.lang.String getAppScheme() {
    return appScheme;
  }

  /**
   * The custom scheme used by mobile app.
   * @param appScheme appScheme or {@code null} for none
   */
  public VerifyAssertionResponse setAppScheme(java.lang.String appScheme) {
    this.appScheme = appScheme;
    return this;
  }

  /**
   * The opaque value used by the client to maintain context info between the authentication request
   * and the IDP callback.
   * @return value or {@code null} for none
   */
  public java.lang.String getContext() {
    return context;
  }

  /**
   * The opaque value used by the client to maintain context info between the authentication request
   * and the IDP callback.
   * @param context context or {@code null} for none
   */
  public VerifyAssertionResponse setContext(java.lang.String context) {
    this.context = context;
    return this;
  }

  /**
   * The birth date of the IdP account.
   * @return value or {@code null} for none
   */
  public java.lang.String getDateOfBirth() {
    return dateOfBirth;
  }

  /**
   * The birth date of the IdP account.
   * @param dateOfBirth dateOfBirth or {@code null} for none
   */
  public VerifyAssertionResponse setDateOfBirth(java.lang.String dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

  /**
   * The display name of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The display name of the user.
   * @param displayName displayName or {@code null} for none
   */
  public VerifyAssertionResponse setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The email returned by the IdP. NOTE: The federated login user may not own the email.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The email returned by the IdP. NOTE: The federated login user may not own the email.
   * @param email email or {@code null} for none
   */
  public VerifyAssertionResponse setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * It's true if the email is recycled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEmailRecycled() {
    return emailRecycled;
  }

  /**
   * It's true if the email is recycled.
   * @param emailRecycled emailRecycled or {@code null} for none
   */
  public VerifyAssertionResponse setEmailRecycled(java.lang.Boolean emailRecycled) {
    this.emailRecycled = emailRecycled;
    return this;
  }

  /**
   * The value is true if the IDP is also the email provider. It means the user owns the email.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEmailVerified() {
    return emailVerified;
  }

  /**
   * The value is true if the IDP is also the email provider. It means the user owns the email.
   * @param emailVerified emailVerified or {@code null} for none
   */
  public VerifyAssertionResponse setEmailVerified(java.lang.Boolean emailVerified) {
    this.emailVerified = emailVerified;
    return this;
  }

  /**
   * Client error code.
   * @return value or {@code null} for none
   */
  public java.lang.String getErrorMessage() {
    return errorMessage;
  }

  /**
   * Client error code.
   * @param errorMessage errorMessage or {@code null} for none
   */
  public VerifyAssertionResponse setErrorMessage(java.lang.String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * If idToken is STS id token, then this field will be expiration time of STS id token in seconds.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpiresIn() {
    return expiresIn;
  }

  /**
   * If idToken is STS id token, then this field will be expiration time of STS id token in seconds.
   * @param expiresIn expiresIn or {@code null} for none
   */
  public VerifyAssertionResponse setExpiresIn(java.lang.Long expiresIn) {
    this.expiresIn = expiresIn;
    return this;
  }

  /**
   * The unique ID identifies the IdP account.
   * @return value or {@code null} for none
   */
  public java.lang.String getFederatedId() {
    return federatedId;
  }

  /**
   * The unique ID identifies the IdP account.
   * @param federatedId federatedId or {@code null} for none
   */
  public VerifyAssertionResponse setFederatedId(java.lang.String federatedId) {
    this.federatedId = federatedId;
    return this;
  }

  /**
   * The first name of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getFirstName() {
    return firstName;
  }

  /**
   * The first name of the user.
   * @param firstName firstName or {@code null} for none
   */
  public VerifyAssertionResponse setFirstName(java.lang.String firstName) {
    this.firstName = firstName;
    return this;
  }

  /**
   * The full name of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getFullName() {
    return fullName;
  }

  /**
   * The full name of the user.
   * @param fullName fullName or {@code null} for none
   */
  public VerifyAssertionResponse setFullName(java.lang.String fullName) {
    this.fullName = fullName;
    return this;
  }

  /**
   * The ID token.
   * @return value or {@code null} for none
   */
  public java.lang.String getIdToken() {
    return idToken;
  }

  /**
   * The ID token.
   * @param idToken idToken or {@code null} for none
   */
  public VerifyAssertionResponse setIdToken(java.lang.String idToken) {
    this.idToken = idToken;
    return this;
  }

  /**
   * It's the identifier param in the createAuthUri request if the identifier is an email. It can be
   * used to check whether the user input email is different from the asserted email.
   * @return value or {@code null} for none
   */
  public java.lang.String getInputEmail() {
    return inputEmail;
  }

  /**
   * It's the identifier param in the createAuthUri request if the identifier is an email. It can be
   * used to check whether the user input email is different from the asserted email.
   * @param inputEmail inputEmail or {@code null} for none
   */
  public VerifyAssertionResponse setInputEmail(java.lang.String inputEmail) {
    this.inputEmail = inputEmail;
    return this;
  }

  /**
   * True if it's a new user sign-in, false if it's a returning user.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsNewUser() {
    return isNewUser;
  }

  /**
   * True if it's a new user sign-in, false if it's a returning user.
   * @param isNewUser isNewUser or {@code null} for none
   */
  public VerifyAssertionResponse setIsNewUser(java.lang.Boolean isNewUser) {
    this.isNewUser = isNewUser;
    return this;
  }

  /**
   * The fixed string "identitytoolkit#VerifyAssertionResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The fixed string "identitytoolkit#VerifyAssertionResponse".
   * @param kind kind or {@code null} for none
   */
  public VerifyAssertionResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The language preference of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguage() {
    return language;
  }

  /**
   * The language preference of the user.
   * @param language language or {@code null} for none
   */
  public VerifyAssertionResponse setLanguage(java.lang.String language) {
    this.language = language;
    return this;
  }

  /**
   * The last name of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastName() {
    return lastName;
  }

  /**
   * The last name of the user.
   * @param lastName lastName or {@code null} for none
   */
  public VerifyAssertionResponse setLastName(java.lang.String lastName) {
    this.lastName = lastName;
    return this;
  }

  /**
   * The RP local ID if it's already been mapped to the IdP account identified by the federated ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalId() {
    return localId;
  }

  /**
   * The RP local ID if it's already been mapped to the IdP account identified by the federated ID.
   * @param localId localId or {@code null} for none
   */
  public VerifyAssertionResponse setLocalId(java.lang.String localId) {
    this.localId = localId;
    return this;
  }

  /**
   * Whether the assertion is from a non-trusted IDP and need account linking confirmation.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNeedConfirmation() {
    return needConfirmation;
  }

  /**
   * Whether the assertion is from a non-trusted IDP and need account linking confirmation.
   * @param needConfirmation needConfirmation or {@code null} for none
   */
  public VerifyAssertionResponse setNeedConfirmation(java.lang.Boolean needConfirmation) {
    this.needConfirmation = needConfirmation;
    return this;
  }

  /**
   * Whether need client to supply email to complete the federated login flow.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNeedEmail() {
    return needEmail;
  }

  /**
   * Whether need client to supply email to complete the federated login flow.
   * @param needEmail needEmail or {@code null} for none
   */
  public VerifyAssertionResponse setNeedEmail(java.lang.Boolean needEmail) {
    this.needEmail = needEmail;
    return this;
  }

  /**
   * The nick name of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getNickName() {
    return nickName;
  }

  /**
   * The nick name of the user.
   * @param nickName nickName or {@code null} for none
   */
  public VerifyAssertionResponse setNickName(java.lang.String nickName) {
    this.nickName = nickName;
    return this;
  }

  /**
   * The OAuth2 access token.
   * @return value or {@code null} for none
   */
  public java.lang.String getOauthAccessToken() {
    return oauthAccessToken;
  }

  /**
   * The OAuth2 access token.
   * @param oauthAccessToken oauthAccessToken or {@code null} for none
   */
  public VerifyAssertionResponse setOauthAccessToken(java.lang.String oauthAccessToken) {
    this.oauthAccessToken = oauthAccessToken;
    return this;
  }

  /**
   * The OAuth2 authorization code.
   * @return value or {@code null} for none
   */
  public java.lang.String getOauthAuthorizationCode() {
    return oauthAuthorizationCode;
  }

  /**
   * The OAuth2 authorization code.
   * @param oauthAuthorizationCode oauthAuthorizationCode or {@code null} for none
   */
  public VerifyAssertionResponse setOauthAuthorizationCode(java.lang.String oauthAuthorizationCode) {
    this.oauthAuthorizationCode = oauthAuthorizationCode;
    return this;
  }

  /**
   * The lifetime in seconds of the OAuth2 access token.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOauthExpireIn() {
    return oauthExpireIn;
  }

  /**
   * The lifetime in seconds of the OAuth2 access token.
   * @param oauthExpireIn oauthExpireIn or {@code null} for none
   */
  public VerifyAssertionResponse setOauthExpireIn(java.lang.Integer oauthExpireIn) {
    this.oauthExpireIn = oauthExpireIn;
    return this;
  }

  /**
   * The OIDC id token.
   * @return value or {@code null} for none
   */
  public java.lang.String getOauthIdToken() {
    return oauthIdToken;
  }

  /**
   * The OIDC id token.
   * @param oauthIdToken oauthIdToken or {@code null} for none
   */
  public VerifyAssertionResponse setOauthIdToken(java.lang.String oauthIdToken) {
    this.oauthIdToken = oauthIdToken;
    return this;
  }

  /**
   * The user approved request token for the OpenID OAuth extension.
   * @return value or {@code null} for none
   */
  public java.lang.String getOauthRequestToken() {
    return oauthRequestToken;
  }

  /**
   * The user approved request token for the OpenID OAuth extension.
   * @param oauthRequestToken oauthRequestToken or {@code null} for none
   */
  public VerifyAssertionResponse setOauthRequestToken(java.lang.String oauthRequestToken) {
    this.oauthRequestToken = oauthRequestToken;
    return this;
  }

  /**
   * The scope for the OpenID OAuth extension.
   * @return value or {@code null} for none
   */
  public java.lang.String getOauthScope() {
    return oauthScope;
  }

  /**
   * The scope for the OpenID OAuth extension.
   * @param oauthScope oauthScope or {@code null} for none
   */
  public VerifyAssertionResponse setOauthScope(java.lang.String oauthScope) {
    this.oauthScope = oauthScope;
    return this;
  }

  /**
   * The OAuth1 access token secret.
   * @return value or {@code null} for none
   */
  public java.lang.String getOauthTokenSecret() {
    return oauthTokenSecret;
  }

  /**
   * The OAuth1 access token secret.
   * @param oauthTokenSecret oauthTokenSecret or {@code null} for none
   */
  public VerifyAssertionResponse setOauthTokenSecret(java.lang.String oauthTokenSecret) {
    this.oauthTokenSecret = oauthTokenSecret;
    return this;
  }

  /**
   * The original email stored in the mapping storage. It's returned when the federated ID is
   * associated to a different email.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginalEmail() {
    return originalEmail;
  }

  /**
   * The original email stored in the mapping storage. It's returned when the federated ID is
   * associated to a different email.
   * @param originalEmail originalEmail or {@code null} for none
   */
  public VerifyAssertionResponse setOriginalEmail(java.lang.String originalEmail) {
    this.originalEmail = originalEmail;
    return this;
  }

  /**
   * The URI of the public accessible profiel picture.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhotoUrl() {
    return photoUrl;
  }

  /**
   * The URI of the public accessible profiel picture.
   * @param photoUrl photoUrl or {@code null} for none
   */
  public VerifyAssertionResponse setPhotoUrl(java.lang.String photoUrl) {
    this.photoUrl = photoUrl;
    return this;
  }

  /**
   * The IdP ID. For white listed IdPs it's a short domain name e.g. google.com, aol.com, live.net
   * and yahoo.com. If the "providerId" param is set to OpenID OP identifer other than the whilte
   * listed IdPs the OP identifier is returned. If the "identifier" param is federated ID in the
   * createAuthUri request. The domain part of the federated ID is returned.
   * @return value or {@code null} for none
   */
  public java.lang.String getProviderId() {
    return providerId;
  }

  /**
   * The IdP ID. For white listed IdPs it's a short domain name e.g. google.com, aol.com, live.net
   * and yahoo.com. If the "providerId" param is set to OpenID OP identifer other than the whilte
   * listed IdPs the OP identifier is returned. If the "identifier" param is federated ID in the
   * createAuthUri request. The domain part of the federated ID is returned.
   * @param providerId providerId or {@code null} for none
   */
  public VerifyAssertionResponse setProviderId(java.lang.String providerId) {
    this.providerId = providerId;
    return this;
  }

  /**
   * Raw IDP-returned user info.
   * @return value or {@code null} for none
   */
  public java.lang.String getRawUserInfo() {
    return rawUserInfo;
  }

  /**
   * Raw IDP-returned user info.
   * @param rawUserInfo rawUserInfo or {@code null} for none
   */
  public VerifyAssertionResponse setRawUserInfo(java.lang.String rawUserInfo) {
    this.rawUserInfo = rawUserInfo;
    return this;
  }

  /**
   * If idToken is STS id token, then this field will be refresh token.
   * @return value or {@code null} for none
   */
  public java.lang.String getRefreshToken() {
    return refreshToken;
  }

  /**
   * If idToken is STS id token, then this field will be refresh token.
   * @param refreshToken refreshToken or {@code null} for none
   */
  public VerifyAssertionResponse setRefreshToken(java.lang.String refreshToken) {
    this.refreshToken = refreshToken;
    return this;
  }

  /**
   * The screen_name of a Twitter user or the login name at Github.
   * @return value or {@code null} for none
   */
  public java.lang.String getScreenName() {
    return screenName;
  }

  /**
   * The screen_name of a Twitter user or the login name at Github.
   * @param screenName screenName or {@code null} for none
   */
  public VerifyAssertionResponse setScreenName(java.lang.String screenName) {
    this.screenName = screenName;
    return this;
  }

  /**
   * The timezone of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * The timezone of the user.
   * @param timeZone timeZone or {@code null} for none
   */
  public VerifyAssertionResponse setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * When action is 'map', contains the idps which can be used for confirmation.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getVerifiedProvider() {
    return verifiedProvider;
  }

  /**
   * When action is 'map', contains the idps which can be used for confirmation.
   * @param verifiedProvider verifiedProvider or {@code null} for none
   */
  public VerifyAssertionResponse setVerifiedProvider(java.util.List<java.lang.String> verifiedProvider) {
    this.verifiedProvider = verifiedProvider;
    return this;
  }

  @Override
  public VerifyAssertionResponse set(String fieldName, Object value) {
    return (VerifyAssertionResponse) super.set(fieldName, value);
  }

  @Override
  public VerifyAssertionResponse clone() {
    return (VerifyAssertionResponse) super.clone();
  }

}
