/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Response of resetting the password.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResetPasswordResponse extends com.google.api.client.json.GenericJson {

  /**
   * The user's email. If the out-of-band code is for email recovery, the user's original email.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * The fixed string "identitytoolkit#ResetPasswordResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * If the out-of-band code is for email recovery, the user's new email.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String newEmail;

  /**
   * The request type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestType;

  /**
   * The user's email. If the out-of-band code is for email recovery, the user's original email.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The user's email. If the out-of-band code is for email recovery, the user's original email.
   * @param email email or {@code null} for none
   */
  public ResetPasswordResponse setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * The fixed string "identitytoolkit#ResetPasswordResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The fixed string "identitytoolkit#ResetPasswordResponse".
   * @param kind kind or {@code null} for none
   */
  public ResetPasswordResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * If the out-of-band code is for email recovery, the user's new email.
   * @return value or {@code null} for none
   */
  public java.lang.String getNewEmail() {
    return newEmail;
  }

  /**
   * If the out-of-band code is for email recovery, the user's new email.
   * @param newEmail newEmail or {@code null} for none
   */
  public ResetPasswordResponse setNewEmail(java.lang.String newEmail) {
    this.newEmail = newEmail;
    return this;
  }

  /**
   * The request type.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestType() {
    return requestType;
  }

  /**
   * The request type.
   * @param requestType requestType or {@code null} for none
   */
  public ResetPasswordResponse setRequestType(java.lang.String requestType) {
    this.requestType = requestType;
    return this;
  }

  @Override
  public ResetPasswordResponse set(String fieldName, Object value) {
    return (ResetPasswordResponse) super.set(fieldName, value);
  }

  @Override
  public ResetPasswordResponse clone() {
    return (ResetPasswordResponse) super.clone();
  }

}
