/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Request to verify a custom token
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IdentitytoolkitRelyingpartyVerifyCustomTokenRequest extends com.google.api.client.json.GenericJson {

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long delegatedProjectNumber;

  /**
   * Instance id token of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceId;

  /**
   * Whether return sts id token and refresh token instead of gitkit token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean returnSecureToken;

  /**
   * The custom token to verify
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String token;

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDelegatedProjectNumber() {
    return delegatedProjectNumber;
  }

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * @param delegatedProjectNumber delegatedProjectNumber or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyVerifyCustomTokenRequest setDelegatedProjectNumber(java.lang.Long delegatedProjectNumber) {
    this.delegatedProjectNumber = delegatedProjectNumber;
    return this;
  }

  /**
   * Instance id token of the app.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceId() {
    return instanceId;
  }

  /**
   * Instance id token of the app.
   * @param instanceId instanceId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyVerifyCustomTokenRequest setInstanceId(java.lang.String instanceId) {
    this.instanceId = instanceId;
    return this;
  }

  /**
   * Whether return sts id token and refresh token instead of gitkit token.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getReturnSecureToken() {
    return returnSecureToken;
  }

  /**
   * Whether return sts id token and refresh token instead of gitkit token.
   * @param returnSecureToken returnSecureToken or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyVerifyCustomTokenRequest setReturnSecureToken(java.lang.Boolean returnSecureToken) {
    this.returnSecureToken = returnSecureToken;
    return this;
  }

  /**
   * The custom token to verify
   * @return value or {@code null} for none
   */
  public java.lang.String getToken() {
    return token;
  }

  /**
   * The custom token to verify
   * @param token token or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyVerifyCustomTokenRequest setToken(java.lang.String token) {
    this.token = token;
    return this;
  }

  @Override
  public IdentitytoolkitRelyingpartyVerifyCustomTokenRequest set(String fieldName, Object value) {
    return (IdentitytoolkitRelyingpartyVerifyCustomTokenRequest) super.set(fieldName, value);
  }

  @Override
  public IdentitytoolkitRelyingpartyVerifyCustomTokenRequest clone() {
    return (IdentitytoolkitRelyingpartyVerifyCustomTokenRequest) super.clone();
  }

}
