/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Request for Identitytoolkit-SendVerificationCode
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IdentitytoolkitRelyingpartySendVerificationCodeRequest extends com.google.api.client.json.GenericJson {

  /**
   * Receipt of successful app token validation with APNS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iosReceipt;

  /**
   * Secret delivered to iOS app via APNS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iosSecret;

  /**
   * The phone number to send the verification code to in E.164 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneNumber;

  /**
   * Recaptcha solution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String recaptchaToken;

  /**
   * Receipt of successful app token validation with APNS.
   * @return value or {@code null} for none
   */
  public java.lang.String getIosReceipt() {
    return iosReceipt;
  }

  /**
   * Receipt of successful app token validation with APNS.
   * @param iosReceipt iosReceipt or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySendVerificationCodeRequest setIosReceipt(java.lang.String iosReceipt) {
    this.iosReceipt = iosReceipt;
    return this;
  }

  /**
   * Secret delivered to iOS app via APNS.
   * @return value or {@code null} for none
   */
  public java.lang.String getIosSecret() {
    return iosSecret;
  }

  /**
   * Secret delivered to iOS app via APNS.
   * @param iosSecret iosSecret or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySendVerificationCodeRequest setIosSecret(java.lang.String iosSecret) {
    this.iosSecret = iosSecret;
    return this;
  }

  /**
   * The phone number to send the verification code to in E.164 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * The phone number to send the verification code to in E.164 format.
   * @param phoneNumber phoneNumber or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySendVerificationCodeRequest setPhoneNumber(java.lang.String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Recaptcha solution.
   * @return value or {@code null} for none
   */
  public java.lang.String getRecaptchaToken() {
    return recaptchaToken;
  }

  /**
   * Recaptcha solution.
   * @param recaptchaToken recaptchaToken or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySendVerificationCodeRequest setRecaptchaToken(java.lang.String recaptchaToken) {
    this.recaptchaToken = recaptchaToken;
    return this;
  }

  @Override
  public IdentitytoolkitRelyingpartySendVerificationCodeRequest set(String fieldName, Object value) {
    return (IdentitytoolkitRelyingpartySendVerificationCodeRequest) super.set(fieldName, value);
  }

  @Override
  public IdentitytoolkitRelyingpartySendVerificationCodeRequest clone() {
    return (IdentitytoolkitRelyingpartySendVerificationCodeRequest) super.clone();
  }

}
