/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Request to get the IDP authentication URL.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IdentitytoolkitRelyingpartyCreateAuthUriRequest extends com.google.api.client.json.GenericJson {

  /**
   * The app ID of the mobile app, base64(CERT_SHA1):PACKAGE_NAME for Android, BUNDLE_ID for iOS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appId;

  /**
   * Explicitly specify the auth flow type. Currently only support "CODE_FLOW" type. The field is
   * only used for Google provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String authFlowType;

  /**
   * The relying party OAuth client ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clientId;

  /**
   * The opaque value used by the client to maintain context info between the authentication request
   * and the IDP callback.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String context;

  /**
   * The URI to which the IDP redirects the user after the federated login flow.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String continueUri;

  /**
   * The query parameter that client can customize by themselves in auth url. The following
   * parameters are reserved for server so that they cannot be customized by clients: client_id,
   * response_type, scope, redirect_uri, state, oauth_token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> customParameter;

  /**
   * The hosted domain to restrict sign-in to accounts at that domain for Google Apps hosted
   * accounts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hostedDomain;

  /**
   * The email or federated ID of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String identifier;

  /**
   * The developer's consumer key for OpenId OAuth Extension
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oauthConsumerKey;

  /**
   * Additional oauth scopes, beyond the basid user profile, that the user would be prompted to
   * grant
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oauthScope;

  /**
   * Optional realm for OpenID protocol. The sub string "scheme://domain:port" of the param
   * "continueUri" is used if this is not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String openidRealm;

  /**
   * The native app package for OTA installation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String otaApp;

  /**
   * The IdP ID. For white listed IdPs it's a short domain name e.g. google.com, aol.com, live.net
   * and yahoo.com. For other OpenID IdPs it's the OP identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String providerId;

  /**
   * The session_id passed by client.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sessionId;

  /**
   * For multi-tenant use cases, in order to construct sign-in URL with the correct IDP parameters,
   * Firebear needs to know which Tenant to retrieve IDP configs from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tenantId;

  /**
   * Tenant project number to be used for idp discovery.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger tenantProjectNumber;

  /**
   * The app ID of the mobile app, base64(CERT_SHA1):PACKAGE_NAME for Android, BUNDLE_ID for iOS.
   * @return value or {@code null} for none
   */
  public java.lang.String getAppId() {
    return appId;
  }

  /**
   * The app ID of the mobile app, base64(CERT_SHA1):PACKAGE_NAME for Android, BUNDLE_ID for iOS.
   * @param appId appId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setAppId(java.lang.String appId) {
    this.appId = appId;
    return this;
  }

  /**
   * Explicitly specify the auth flow type. Currently only support "CODE_FLOW" type. The field is
   * only used for Google provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getAuthFlowType() {
    return authFlowType;
  }

  /**
   * Explicitly specify the auth flow type. Currently only support "CODE_FLOW" type. The field is
   * only used for Google provider.
   * @param authFlowType authFlowType or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setAuthFlowType(java.lang.String authFlowType) {
    this.authFlowType = authFlowType;
    return this;
  }

  /**
   * The relying party OAuth client ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getClientId() {
    return clientId;
  }

  /**
   * The relying party OAuth client ID.
   * @param clientId clientId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setClientId(java.lang.String clientId) {
    this.clientId = clientId;
    return this;
  }

  /**
   * The opaque value used by the client to maintain context info between the authentication request
   * and the IDP callback.
   * @return value or {@code null} for none
   */
  public java.lang.String getContext() {
    return context;
  }

  /**
   * The opaque value used by the client to maintain context info between the authentication request
   * and the IDP callback.
   * @param context context or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setContext(java.lang.String context) {
    this.context = context;
    return this;
  }

  /**
   * The URI to which the IDP redirects the user after the federated login flow.
   * @return value or {@code null} for none
   */
  public java.lang.String getContinueUri() {
    return continueUri;
  }

  /**
   * The URI to which the IDP redirects the user after the federated login flow.
   * @param continueUri continueUri or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setContinueUri(java.lang.String continueUri) {
    this.continueUri = continueUri;
    return this;
  }

  /**
   * The query parameter that client can customize by themselves in auth url. The following
   * parameters are reserved for server so that they cannot be customized by clients: client_id,
   * response_type, scope, redirect_uri, state, oauth_token.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getCustomParameter() {
    return customParameter;
  }

  /**
   * The query parameter that client can customize by themselves in auth url. The following
   * parameters are reserved for server so that they cannot be customized by clients: client_id,
   * response_type, scope, redirect_uri, state, oauth_token.
   * @param customParameter customParameter or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setCustomParameter(java.util.Map<String, java.lang.String> customParameter) {
    this.customParameter = customParameter;
    return this;
  }

  /**
   * The hosted domain to restrict sign-in to accounts at that domain for Google Apps hosted
   * accounts.
   * @return value or {@code null} for none
   */
  public java.lang.String getHostedDomain() {
    return hostedDomain;
  }

  /**
   * The hosted domain to restrict sign-in to accounts at that domain for Google Apps hosted
   * accounts.
   * @param hostedDomain hostedDomain or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setHostedDomain(java.lang.String hostedDomain) {
    this.hostedDomain = hostedDomain;
    return this;
  }

  /**
   * The email or federated ID of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getIdentifier() {
    return identifier;
  }

  /**
   * The email or federated ID of the user.
   * @param identifier identifier or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setIdentifier(java.lang.String identifier) {
    this.identifier = identifier;
    return this;
  }

  /**
   * The developer's consumer key for OpenId OAuth Extension
   * @return value or {@code null} for none
   */
  public java.lang.String getOauthConsumerKey() {
    return oauthConsumerKey;
  }

  /**
   * The developer's consumer key for OpenId OAuth Extension
   * @param oauthConsumerKey oauthConsumerKey or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setOauthConsumerKey(java.lang.String oauthConsumerKey) {
    this.oauthConsumerKey = oauthConsumerKey;
    return this;
  }

  /**
   * Additional oauth scopes, beyond the basid user profile, that the user would be prompted to
   * grant
   * @return value or {@code null} for none
   */
  public java.lang.String getOauthScope() {
    return oauthScope;
  }

  /**
   * Additional oauth scopes, beyond the basid user profile, that the user would be prompted to
   * grant
   * @param oauthScope oauthScope or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setOauthScope(java.lang.String oauthScope) {
    this.oauthScope = oauthScope;
    return this;
  }

  /**
   * Optional realm for OpenID protocol. The sub string "scheme://domain:port" of the param
   * "continueUri" is used if this is not set.
   * @return value or {@code null} for none
   */
  public java.lang.String getOpenidRealm() {
    return openidRealm;
  }

  /**
   * Optional realm for OpenID protocol. The sub string "scheme://domain:port" of the param
   * "continueUri" is used if this is not set.
   * @param openidRealm openidRealm or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setOpenidRealm(java.lang.String openidRealm) {
    this.openidRealm = openidRealm;
    return this;
  }

  /**
   * The native app package for OTA installation.
   * @return value or {@code null} for none
   */
  public java.lang.String getOtaApp() {
    return otaApp;
  }

  /**
   * The native app package for OTA installation.
   * @param otaApp otaApp or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setOtaApp(java.lang.String otaApp) {
    this.otaApp = otaApp;
    return this;
  }

  /**
   * The IdP ID. For white listed IdPs it's a short domain name e.g. google.com, aol.com, live.net
   * and yahoo.com. For other OpenID IdPs it's the OP identifier.
   * @return value or {@code null} for none
   */
  public java.lang.String getProviderId() {
    return providerId;
  }

  /**
   * The IdP ID. For white listed IdPs it's a short domain name e.g. google.com, aol.com, live.net
   * and yahoo.com. For other OpenID IdPs it's the OP identifier.
   * @param providerId providerId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setProviderId(java.lang.String providerId) {
    this.providerId = providerId;
    return this;
  }

  /**
   * The session_id passed by client.
   * @return value or {@code null} for none
   */
  public java.lang.String getSessionId() {
    return sessionId;
  }

  /**
   * The session_id passed by client.
   * @param sessionId sessionId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setSessionId(java.lang.String sessionId) {
    this.sessionId = sessionId;
    return this;
  }

  /**
   * For multi-tenant use cases, in order to construct sign-in URL with the correct IDP parameters,
   * Firebear needs to know which Tenant to retrieve IDP configs from.
   * @return value or {@code null} for none
   */
  public java.lang.String getTenantId() {
    return tenantId;
  }

  /**
   * For multi-tenant use cases, in order to construct sign-in URL with the correct IDP parameters,
   * Firebear needs to know which Tenant to retrieve IDP configs from.
   * @param tenantId tenantId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setTenantId(java.lang.String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * Tenant project number to be used for idp discovery.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getTenantProjectNumber() {
    return tenantProjectNumber;
  }

  /**
   * Tenant project number to be used for idp discovery.
   * @param tenantProjectNumber tenantProjectNumber or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest setTenantProjectNumber(java.math.BigInteger tenantProjectNumber) {
    this.tenantProjectNumber = tenantProjectNumber;
    return this;
  }

  @Override
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest set(String fieldName, Object value) {
    return (IdentitytoolkitRelyingpartyCreateAuthUriRequest) super.set(fieldName, value);
  }

  @Override
  public IdentitytoolkitRelyingpartyCreateAuthUriRequest clone() {
    return (IdentitytoolkitRelyingpartyCreateAuthUriRequest) super.clone();
  }

}
