/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Response of getting a code for user confirmation (reset password, change email etc.).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetOobConfirmationCodeResponse extends com.google.api.client.json.GenericJson {

  /**
   * The email address that the email is sent to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * The fixed string "identitytoolkit#GetOobConfirmationCodeResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The code to be send to the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oobCode;

  /**
   * The email address that the email is sent to.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The email address that the email is sent to.
   * @param email email or {@code null} for none
   */
  public GetOobConfirmationCodeResponse setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * The fixed string "identitytoolkit#GetOobConfirmationCodeResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The fixed string "identitytoolkit#GetOobConfirmationCodeResponse".
   * @param kind kind or {@code null} for none
   */
  public GetOobConfirmationCodeResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The code to be send to the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getOobCode() {
    return oobCode;
  }

  /**
   * The code to be send to the user.
   * @param oobCode oobCode or {@code null} for none
   */
  public GetOobConfirmationCodeResponse setOobCode(java.lang.String oobCode) {
    this.oobCode = oobCode;
    return this;
  }

  @Override
  public GetOobConfirmationCodeResponse set(String fieldName, Object value) {
    return (GetOobConfirmationCodeResponse) super.set(fieldName, value);
  }

  @Override
  public GetOobConfirmationCodeResponse clone() {
    return (GetOobConfirmationCodeResponse) super.clone();
  }

}
