/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Response of creating the IDP authentication URL.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateAuthUriResponse extends com.google.api.client.json.GenericJson {

  /**
   * all providers the user has once used to do federated login
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> allProviders;

  /**
   * The URI used by the IDP to authenticate the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String authUri;

  /**
   * True if captcha is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean captchaRequired;

  /**
   * True if the authUri is for user's existing provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean forExistingProvider;

  /**
   * The fixed string identitytoolkit#CreateAuthUriResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The provider ID of the auth URI.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String providerId;

  /**
   * Whether the user is registered if the identifier is an email.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean registered;

  /**
   * Session ID which should be passed in the following verifyAssertion request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sessionId;

  /**
   * All sign-in methods this user has used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> signinMethods;

  /**
   * all providers the user has once used to do federated login
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAllProviders() {
    return allProviders;
  }

  /**
   * all providers the user has once used to do federated login
   * @param allProviders allProviders or {@code null} for none
   */
  public CreateAuthUriResponse setAllProviders(java.util.List<java.lang.String> allProviders) {
    this.allProviders = allProviders;
    return this;
  }

  /**
   * The URI used by the IDP to authenticate the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getAuthUri() {
    return authUri;
  }

  /**
   * The URI used by the IDP to authenticate the user.
   * @param authUri authUri or {@code null} for none
   */
  public CreateAuthUriResponse setAuthUri(java.lang.String authUri) {
    this.authUri = authUri;
    return this;
  }

  /**
   * True if captcha is required.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCaptchaRequired() {
    return captchaRequired;
  }

  /**
   * True if captcha is required.
   * @param captchaRequired captchaRequired or {@code null} for none
   */
  public CreateAuthUriResponse setCaptchaRequired(java.lang.Boolean captchaRequired) {
    this.captchaRequired = captchaRequired;
    return this;
  }

  /**
   * True if the authUri is for user's existing provider.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getForExistingProvider() {
    return forExistingProvider;
  }

  /**
   * True if the authUri is for user's existing provider.
   * @param forExistingProvider forExistingProvider or {@code null} for none
   */
  public CreateAuthUriResponse setForExistingProvider(java.lang.Boolean forExistingProvider) {
    this.forExistingProvider = forExistingProvider;
    return this;
  }

  /**
   * The fixed string identitytoolkit#CreateAuthUriResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The fixed string identitytoolkit#CreateAuthUriResponse".
   * @param kind kind or {@code null} for none
   */
  public CreateAuthUriResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The provider ID of the auth URI.
   * @return value or {@code null} for none
   */
  public java.lang.String getProviderId() {
    return providerId;
  }

  /**
   * The provider ID of the auth URI.
   * @param providerId providerId or {@code null} for none
   */
  public CreateAuthUriResponse setProviderId(java.lang.String providerId) {
    this.providerId = providerId;
    return this;
  }

  /**
   * Whether the user is registered if the identifier is an email.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRegistered() {
    return registered;
  }

  /**
   * Whether the user is registered if the identifier is an email.
   * @param registered registered or {@code null} for none
   */
  public CreateAuthUriResponse setRegistered(java.lang.Boolean registered) {
    this.registered = registered;
    return this;
  }

  /**
   * Session ID which should be passed in the following verifyAssertion request.
   * @return value or {@code null} for none
   */
  public java.lang.String getSessionId() {
    return sessionId;
  }

  /**
   * Session ID which should be passed in the following verifyAssertion request.
   * @param sessionId sessionId or {@code null} for none
   */
  public CreateAuthUriResponse setSessionId(java.lang.String sessionId) {
    this.sessionId = sessionId;
    return this;
  }

  /**
   * All sign-in methods this user has used.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSigninMethods() {
    return signinMethods;
  }

  /**
   * All sign-in methods this user has used.
   * @param signinMethods signinMethods or {@code null} for none
   */
  public CreateAuthUriResponse setSigninMethods(java.util.List<java.lang.String> signinMethods) {
    this.signinMethods = signinMethods;
    return this;
  }

  @Override
  public CreateAuthUriResponse set(String fieldName, Object value) {
    return (CreateAuthUriResponse) super.set(fieldName, value);
  }

  @Override
  public CreateAuthUriResponse clone() {
    return (CreateAuthUriResponse) super.clone();
  }

}
