/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-23 at 03:23:23 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Resource definition for Gmail filters. Filters apply to specific messages instead of an entire
 * email thread.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Filter extends com.google.api.client.json.GenericJson {

  /**
   * Action that the filter performs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FilterAction action;

  /**
   * Matching criteria for the filter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FilterCriteria criteria;

  /**
   * The server assigned ID of the filter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Action that the filter performs.
   * @return value or {@code null} for none
   */
  public FilterAction getAction() {
    return action;
  }

  /**
   * Action that the filter performs.
   * @param action action or {@code null} for none
   */
  public Filter setAction(FilterAction action) {
    this.action = action;
    return this;
  }

  /**
   * Matching criteria for the filter.
   * @return value or {@code null} for none
   */
  public FilterCriteria getCriteria() {
    return criteria;
  }

  /**
   * Matching criteria for the filter.
   * @param criteria criteria or {@code null} for none
   */
  public Filter setCriteria(FilterCriteria criteria) {
    this.criteria = criteria;
    return this;
  }

  /**
   * The server assigned ID of the filter.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The server assigned ID of the filter.
   * @param id id or {@code null} for none
   */
  public Filter setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  @Override
  public Filter set(String fieldName, Object value) {
    return (Filter) super.set(fieldName, value);
  }

  @Override
  public Filter clone() {
    return (Filter) super.clone();
  }

}
