/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.gmail;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.gmail.GmailRequest;
import com.google.api.services.gmail.GmailRequestInitializer;
import com.google.api.services.gmail.model.AutoForwarding;
import com.google.api.services.gmail.model.BatchDeleteMessagesRequest;
import com.google.api.services.gmail.model.Draft;
import com.google.api.services.gmail.model.Filter;
import com.google.api.services.gmail.model.ForwardingAddress;
import com.google.api.services.gmail.model.ImapSettings;
import com.google.api.services.gmail.model.Label;
import com.google.api.services.gmail.model.ListDraftsResponse;
import com.google.api.services.gmail.model.ListFiltersResponse;
import com.google.api.services.gmail.model.ListForwardingAddressesResponse;
import com.google.api.services.gmail.model.ListHistoryResponse;
import com.google.api.services.gmail.model.ListLabelsResponse;
import com.google.api.services.gmail.model.ListMessagesResponse;
import com.google.api.services.gmail.model.ListSendAsResponse;
import com.google.api.services.gmail.model.ListThreadsResponse;
import com.google.api.services.gmail.model.Message;
import com.google.api.services.gmail.model.MessagePartBody;
import com.google.api.services.gmail.model.ModifyMessageRequest;
import com.google.api.services.gmail.model.ModifyThreadRequest;
import com.google.api.services.gmail.model.PopSettings;
import com.google.api.services.gmail.model.Profile;
import com.google.api.services.gmail.model.SendAs;
import com.google.api.services.gmail.model.Thread;
import com.google.api.services.gmail.model.VacationSettings;
import com.google.api.services.gmail.model.WatchRequest;
import com.google.api.services.gmail.model.WatchResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gmail
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "gmail/v1/users/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/gmail/v1/users/";

    public Gmail(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Gmail(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the Gmail API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Gmail.DEFAULT_ROOT_URL, Gmail.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Gmail build() {
            return new Gmail(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setGmailRequestInitializer(GmailRequestInitializer gmailRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)gmailRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Users {
        public GetProfile getProfile(String string) throws IOException {
            GetProfile getProfile = new GetProfile(string);
            Gmail.this.initialize((AbstractGoogleClientRequest<?>)getProfile);
            return getProfile;
        }

        public Stop stop(String string) throws IOException {
            Stop stop = new Stop(string);
            Gmail.this.initialize((AbstractGoogleClientRequest<?>)stop);
            return stop;
        }

        public Watch watch(String string, WatchRequest watchRequest) throws IOException {
            Watch watch = new Watch(string, watchRequest);
            Gmail.this.initialize((AbstractGoogleClientRequest<?>)watch);
            return watch;
        }

        public Drafts drafts() {
            return new Drafts();
        }

        public History history() {
            return new History();
        }

        public Labels labels() {
            return new Labels();
        }

        public Messages messages() {
            return new Messages();
        }

        public Settings settings() {
            return new Settings();
        }

        public Threads threads() {
            return new Threads();
        }

        public class Threads {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Modify modify(String string, String string2, ModifyThreadRequest modifyThreadRequest) throws IOException {
                Modify modify = new Modify(string, string2, modifyThreadRequest);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)modify);
                return modify;
            }

            public Trash trash(String string, String string2) throws IOException {
                Trash trash = new Trash(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)trash);
                return trash;
            }

            public Untrash untrash(String string, String string2) throws IOException {
                Untrash untrash = new Untrash(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)untrash);
                return untrash;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Untrash
            extends GmailRequest<Thread> {
                private static final String REST_PATH = "{userId}/threads/{id}/untrash";
                @Key
                private String userId;
                @Key
                private String id;

                protected Untrash(String string, String string2) {
                    super(Gmail.this, "POST", REST_PATH, null, Thread.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Untrash setAlt(String string) {
                    return (Untrash)super.setAlt(string);
                }

                public Untrash setFields(String string) {
                    return (Untrash)super.setFields(string);
                }

                public Untrash setKey(String string) {
                    return (Untrash)super.setKey(string);
                }

                public Untrash setOauthToken(String string) {
                    return (Untrash)super.setOauthToken(string);
                }

                public Untrash setPrettyPrint(Boolean bl) {
                    return (Untrash)super.setPrettyPrint(bl);
                }

                public Untrash setQuotaUser(String string) {
                    return (Untrash)super.setQuotaUser(string);
                }

                public Untrash setUserIp(String string) {
                    return (Untrash)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Untrash setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Untrash setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Untrash set(String string, Object object) {
                    return (Untrash)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Trash
            extends GmailRequest<Thread> {
                private static final String REST_PATH = "{userId}/threads/{id}/trash";
                @Key
                private String userId;
                @Key
                private String id;

                protected Trash(String string, String string2) {
                    super(Gmail.this, "POST", REST_PATH, null, Thread.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Trash setAlt(String string) {
                    return (Trash)super.setAlt(string);
                }

                public Trash setFields(String string) {
                    return (Trash)super.setFields(string);
                }

                public Trash setKey(String string) {
                    return (Trash)super.setKey(string);
                }

                public Trash setOauthToken(String string) {
                    return (Trash)super.setOauthToken(string);
                }

                public Trash setPrettyPrint(Boolean bl) {
                    return (Trash)super.setPrettyPrint(bl);
                }

                public Trash setQuotaUser(String string) {
                    return (Trash)super.setQuotaUser(string);
                }

                public Trash setUserIp(String string) {
                    return (Trash)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Trash setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Trash setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Trash set(String string, Object object) {
                    return (Trash)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Modify
            extends GmailRequest<Thread> {
                private static final String REST_PATH = "{userId}/threads/{id}/modify";
                @Key
                private String userId;
                @Key
                private String id;

                protected Modify(String string, String string2, ModifyThreadRequest modifyThreadRequest) {
                    super(Gmail.this, "POST", REST_PATH, (Object)modifyThreadRequest, Thread.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Modify setAlt(String string) {
                    return (Modify)super.setAlt(string);
                }

                public Modify setFields(String string) {
                    return (Modify)super.setFields(string);
                }

                public Modify setKey(String string) {
                    return (Modify)super.setKey(string);
                }

                public Modify setOauthToken(String string) {
                    return (Modify)super.setOauthToken(string);
                }

                public Modify setPrettyPrint(Boolean bl) {
                    return (Modify)super.setPrettyPrint(bl);
                }

                public Modify setQuotaUser(String string) {
                    return (Modify)super.setQuotaUser(string);
                }

                public Modify setUserIp(String string) {
                    return (Modify)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Modify setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Modify setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Modify set(String string, Object object) {
                    return (Modify)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends GmailRequest<ListThreadsResponse> {
                private static final String REST_PATH = "{userId}/threads";
                @Key
                private String userId;
                @Key
                private Boolean includeSpamTrash;
                @Key
                private java.util.List<String> labelIds;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String q;

                protected List(String string) {
                    super(Gmail.this, "GET", REST_PATH, null, ListThreadsResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public Boolean getIncludeSpamTrash() {
                    return this.includeSpamTrash;
                }

                public List setIncludeSpamTrash(Boolean bl) {
                    this.includeSpamTrash = bl;
                    return this;
                }

                public boolean isIncludeSpamTrash() {
                    if (this.includeSpamTrash == null || this.includeSpamTrash == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.includeSpamTrash;
                }

                public java.util.List<String> getLabelIds() {
                    return this.labelIds;
                }

                public List setLabelIds(java.util.List<String> list) {
                    this.labelIds = list;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getQ() {
                    return this.q;
                }

                public List setQ(String string) {
                    this.q = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends GmailRequest<Thread> {
                private static final String REST_PATH = "{userId}/threads/{id}";
                @Key
                private String userId;
                @Key
                private String id;
                @Key
                private String format;
                @Key
                private java.util.List<String> metadataHeaders;

                protected Get(String string, String string2) {
                    super(Gmail.this, "GET", REST_PATH, null, Thread.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getFormat() {
                    return this.format;
                }

                public Get setFormat(String string) {
                    this.format = string;
                    return this;
                }

                public java.util.List<String> getMetadataHeaders() {
                    return this.metadataHeaders;
                }

                public Get setMetadataHeaders(java.util.List<String> list) {
                    this.metadataHeaders = list;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/threads/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Delete(String string, String string2) {
                    super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Settings {
            public GetAutoForwarding getAutoForwarding(String string) throws IOException {
                GetAutoForwarding getAutoForwarding = new GetAutoForwarding(string);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)getAutoForwarding);
                return getAutoForwarding;
            }

            public GetImap getImap(String string) throws IOException {
                GetImap getImap = new GetImap(string);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)getImap);
                return getImap;
            }

            public GetPop getPop(String string) throws IOException {
                GetPop getPop = new GetPop(string);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)getPop);
                return getPop;
            }

            public GetVacation getVacation(String string) throws IOException {
                GetVacation getVacation = new GetVacation(string);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)getVacation);
                return getVacation;
            }

            public UpdateAutoForwarding updateAutoForwarding(String string, AutoForwarding autoForwarding) throws IOException {
                UpdateAutoForwarding updateAutoForwarding = new UpdateAutoForwarding(string, autoForwarding);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)updateAutoForwarding);
                return updateAutoForwarding;
            }

            public UpdateImap updateImap(String string, ImapSettings imapSettings) throws IOException {
                UpdateImap updateImap = new UpdateImap(string, imapSettings);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)updateImap);
                return updateImap;
            }

            public UpdatePop updatePop(String string, PopSettings popSettings) throws IOException {
                UpdatePop updatePop = new UpdatePop(string, popSettings);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)updatePop);
                return updatePop;
            }

            public UpdateVacation updateVacation(String string, VacationSettings vacationSettings) throws IOException {
                UpdateVacation updateVacation = new UpdateVacation(string, vacationSettings);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)updateVacation);
                return updateVacation;
            }

            public Filters filters() {
                return new Filters();
            }

            public ForwardingAddresses forwardingAddresses() {
                return new ForwardingAddresses();
            }

            public SendAs sendAs() {
                return new SendAs();
            }

            public class SendAs {
                public Create create(String string, com.google.api.services.gmail.model.SendAs sendAs) throws IOException {
                    Create create = new Create(string, sendAs);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string, String string2) throws IOException {
                    Delete delete = new Delete(string, string2);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string, String string2) throws IOException {
                    Get get = new Get(string, string2);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, String string2, com.google.api.services.gmail.model.SendAs sendAs) throws IOException {
                    Patch patch = new Patch(string, string2, sendAs);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                public Update update(String string, String string2, com.google.api.services.gmail.model.SendAs sendAs) throws IOException {
                    Update update = new Update(string, string2, sendAs);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)update);
                    return update;
                }

                public Verify verify(String string, String string2) throws IOException {
                    Verify verify = new Verify(string, string2);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)verify);
                    return verify;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Verify
                extends GmailRequest<Void> {
                    private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}/verify";
                    @Key
                    private String userId;
                    @Key
                    private String sendAsEmail;

                    protected Verify(String string, String string2) {
                        super(Gmail.this, "POST", REST_PATH, null, Void.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                        this.sendAsEmail = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sendAsEmail must be specified.");
                    }

                    public Verify setAlt(String string) {
                        return (Verify)super.setAlt(string);
                    }

                    public Verify setFields(String string) {
                        return (Verify)super.setFields(string);
                    }

                    public Verify setKey(String string) {
                        return (Verify)super.setKey(string);
                    }

                    public Verify setOauthToken(String string) {
                        return (Verify)super.setOauthToken(string);
                    }

                    public Verify setPrettyPrint(Boolean bl) {
                        return (Verify)super.setPrettyPrint(bl);
                    }

                    public Verify setQuotaUser(String string) {
                        return (Verify)super.setQuotaUser(string);
                    }

                    public Verify setUserIp(String string) {
                        return (Verify)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Verify setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    public String getSendAsEmail() {
                        return this.sendAsEmail;
                    }

                    public Verify setSendAsEmail(String string) {
                        this.sendAsEmail = string;
                        return this;
                    }

                    @Override
                    public Verify set(String string, Object object) {
                        return (Verify)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends GmailRequest<com.google.api.services.gmail.model.SendAs> {
                    private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String sendAsEmail;

                    protected Update(String string, String string2, com.google.api.services.gmail.model.SendAs sendAs2) {
                        super(Gmail.this, "PUT", REST_PATH, (Object)sendAs2, com.google.api.services.gmail.model.SendAs.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                        this.sendAsEmail = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sendAsEmail must be specified.");
                    }

                    public Update setAlt(String string) {
                        return (Update)super.setAlt(string);
                    }

                    public Update setFields(String string) {
                        return (Update)super.setFields(string);
                    }

                    public Update setKey(String string) {
                        return (Update)super.setKey(string);
                    }

                    public Update setOauthToken(String string) {
                        return (Update)super.setOauthToken(string);
                    }

                    public Update setPrettyPrint(Boolean bl) {
                        return (Update)super.setPrettyPrint(bl);
                    }

                    public Update setQuotaUser(String string) {
                        return (Update)super.setQuotaUser(string);
                    }

                    public Update setUserIp(String string) {
                        return (Update)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Update setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    public String getSendAsEmail() {
                        return this.sendAsEmail;
                    }

                    public Update setSendAsEmail(String string) {
                        this.sendAsEmail = string;
                        return this;
                    }

                    @Override
                    public Update set(String string, Object object) {
                        return (Update)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends GmailRequest<com.google.api.services.gmail.model.SendAs> {
                    private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String sendAsEmail;

                    protected Patch(String string, String string2, com.google.api.services.gmail.model.SendAs sendAs2) {
                        super(Gmail.this, "PATCH", REST_PATH, (Object)sendAs2, com.google.api.services.gmail.model.SendAs.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                        this.sendAsEmail = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sendAsEmail must be specified.");
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUserIp(String string) {
                        return (Patch)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Patch setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    public String getSendAsEmail() {
                        return this.sendAsEmail;
                    }

                    public Patch setSendAsEmail(String string) {
                        this.sendAsEmail = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends GmailRequest<ListSendAsResponse> {
                    private static final String REST_PATH = "{userId}/settings/sendAs";
                    @Key
                    private String userId;

                    protected List(String string) {
                        super(Gmail.this, "GET", REST_PATH, null, ListSendAsResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUserIp(String string) {
                        return (List)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends GmailRequest<com.google.api.services.gmail.model.SendAs> {
                    private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String sendAsEmail;

                    protected Get(String string, String string2) {
                        super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.SendAs.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                        this.sendAsEmail = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sendAsEmail must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUserIp(String string) {
                        return (Get)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    public String getSendAsEmail() {
                        return this.sendAsEmail;
                    }

                    public Get setSendAsEmail(String string) {
                        this.sendAsEmail = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends GmailRequest<Void> {
                    private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String sendAsEmail;

                    protected Delete(String string, String string2) {
                        super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                        this.sendAsEmail = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sendAsEmail must be specified.");
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUserIp(String string) {
                        return (Delete)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Delete setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    public String getSendAsEmail() {
                        return this.sendAsEmail;
                    }

                    public Delete setSendAsEmail(String string) {
                        this.sendAsEmail = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends GmailRequest<com.google.api.services.gmail.model.SendAs> {
                    private static final String REST_PATH = "{userId}/settings/sendAs";
                    @Key
                    private String userId;

                    protected Create(String string, com.google.api.services.gmail.model.SendAs sendAs2) {
                        super(Gmail.this, "POST", REST_PATH, (Object)sendAs2, com.google.api.services.gmail.model.SendAs.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUserIp(String string) {
                        return (Create)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Create setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            public class ForwardingAddresses {
                public Create create(String string, ForwardingAddress forwardingAddress) throws IOException {
                    Create create = new Create(string, forwardingAddress);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string, String string2) throws IOException {
                    Delete delete = new Delete(string, string2);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string, String string2) throws IOException {
                    Get get = new Get(string, string2);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends GmailRequest<ListForwardingAddressesResponse> {
                    private static final String REST_PATH = "{userId}/settings/forwardingAddresses";
                    @Key
                    private String userId;

                    protected List(String string) {
                        super(Gmail.this, "GET", REST_PATH, null, ListForwardingAddressesResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUserIp(String string) {
                        return (List)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends GmailRequest<ForwardingAddress> {
                    private static final String REST_PATH = "{userId}/settings/forwardingAddresses/{forwardingEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String forwardingEmail;

                    protected Get(String string, String string2) {
                        super(Gmail.this, "GET", REST_PATH, null, ForwardingAddress.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                        this.forwardingEmail = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter forwardingEmail must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUserIp(String string) {
                        return (Get)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    public String getForwardingEmail() {
                        return this.forwardingEmail;
                    }

                    public Get setForwardingEmail(String string) {
                        this.forwardingEmail = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends GmailRequest<Void> {
                    private static final String REST_PATH = "{userId}/settings/forwardingAddresses/{forwardingEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String forwardingEmail;

                    protected Delete(String string, String string2) {
                        super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                        this.forwardingEmail = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter forwardingEmail must be specified.");
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUserIp(String string) {
                        return (Delete)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Delete setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    public String getForwardingEmail() {
                        return this.forwardingEmail;
                    }

                    public Delete setForwardingEmail(String string) {
                        this.forwardingEmail = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends GmailRequest<ForwardingAddress> {
                    private static final String REST_PATH = "{userId}/settings/forwardingAddresses";
                    @Key
                    private String userId;

                    protected Create(String string, ForwardingAddress forwardingAddress) {
                        super(Gmail.this, "POST", REST_PATH, (Object)forwardingAddress, ForwardingAddress.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUserIp(String string) {
                        return (Create)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Create setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            public class Filters {
                public Create create(String string, Filter filter) throws IOException {
                    Create create = new Create(string, filter);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string, String string2) throws IOException {
                    Delete delete = new Delete(string, string2);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string, String string2) throws IOException {
                    Get get = new Get(string, string2);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends GmailRequest<ListFiltersResponse> {
                    private static final String REST_PATH = "{userId}/settings/filters";
                    @Key
                    private String userId;

                    protected List(String string) {
                        super(Gmail.this, "GET", REST_PATH, null, ListFiltersResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUserIp(String string) {
                        return (List)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends GmailRequest<Filter> {
                    private static final String REST_PATH = "{userId}/settings/filters/{id}";
                    @Key
                    private String userId;
                    @Key
                    private String id;

                    protected Get(String string, String string2) {
                        super(Gmail.this, "GET", REST_PATH, null, Filter.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUserIp(String string) {
                        return (Get)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Get setId(String string) {
                        this.id = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends GmailRequest<Void> {
                    private static final String REST_PATH = "{userId}/settings/filters/{id}";
                    @Key
                    private String userId;
                    @Key
                    private String id;

                    protected Delete(String string, String string2) {
                        super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUserIp(String string) {
                        return (Delete)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Delete setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Delete setId(String string) {
                        this.id = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends GmailRequest<Filter> {
                    private static final String REST_PATH = "{userId}/settings/filters";
                    @Key
                    private String userId;

                    protected Create(String string, Filter filter) {
                        super(Gmail.this, "POST", REST_PATH, (Object)filter, Filter.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUserIp(String string) {
                        return (Create)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Create setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class UpdateVacation
            extends GmailRequest<VacationSettings> {
                private static final String REST_PATH = "{userId}/settings/vacation";
                @Key
                private String userId;

                protected UpdateVacation(String string, VacationSettings vacationSettings) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)vacationSettings, VacationSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public UpdateVacation setAlt(String string) {
                    return (UpdateVacation)super.setAlt(string);
                }

                public UpdateVacation setFields(String string) {
                    return (UpdateVacation)super.setFields(string);
                }

                public UpdateVacation setKey(String string) {
                    return (UpdateVacation)super.setKey(string);
                }

                public UpdateVacation setOauthToken(String string) {
                    return (UpdateVacation)super.setOauthToken(string);
                }

                public UpdateVacation setPrettyPrint(Boolean bl) {
                    return (UpdateVacation)super.setPrettyPrint(bl);
                }

                public UpdateVacation setQuotaUser(String string) {
                    return (UpdateVacation)super.setQuotaUser(string);
                }

                public UpdateVacation setUserIp(String string) {
                    return (UpdateVacation)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public UpdateVacation setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public UpdateVacation set(String string, Object object) {
                    return (UpdateVacation)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class UpdatePop
            extends GmailRequest<PopSettings> {
                private static final String REST_PATH = "{userId}/settings/pop";
                @Key
                private String userId;

                protected UpdatePop(String string, PopSettings popSettings) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)popSettings, PopSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public UpdatePop setAlt(String string) {
                    return (UpdatePop)super.setAlt(string);
                }

                public UpdatePop setFields(String string) {
                    return (UpdatePop)super.setFields(string);
                }

                public UpdatePop setKey(String string) {
                    return (UpdatePop)super.setKey(string);
                }

                public UpdatePop setOauthToken(String string) {
                    return (UpdatePop)super.setOauthToken(string);
                }

                public UpdatePop setPrettyPrint(Boolean bl) {
                    return (UpdatePop)super.setPrettyPrint(bl);
                }

                public UpdatePop setQuotaUser(String string) {
                    return (UpdatePop)super.setQuotaUser(string);
                }

                public UpdatePop setUserIp(String string) {
                    return (UpdatePop)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public UpdatePop setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public UpdatePop set(String string, Object object) {
                    return (UpdatePop)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class UpdateImap
            extends GmailRequest<ImapSettings> {
                private static final String REST_PATH = "{userId}/settings/imap";
                @Key
                private String userId;

                protected UpdateImap(String string, ImapSettings imapSettings) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)imapSettings, ImapSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public UpdateImap setAlt(String string) {
                    return (UpdateImap)super.setAlt(string);
                }

                public UpdateImap setFields(String string) {
                    return (UpdateImap)super.setFields(string);
                }

                public UpdateImap setKey(String string) {
                    return (UpdateImap)super.setKey(string);
                }

                public UpdateImap setOauthToken(String string) {
                    return (UpdateImap)super.setOauthToken(string);
                }

                public UpdateImap setPrettyPrint(Boolean bl) {
                    return (UpdateImap)super.setPrettyPrint(bl);
                }

                public UpdateImap setQuotaUser(String string) {
                    return (UpdateImap)super.setQuotaUser(string);
                }

                public UpdateImap setUserIp(String string) {
                    return (UpdateImap)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public UpdateImap setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public UpdateImap set(String string, Object object) {
                    return (UpdateImap)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class UpdateAutoForwarding
            extends GmailRequest<AutoForwarding> {
                private static final String REST_PATH = "{userId}/settings/autoForwarding";
                @Key
                private String userId;

                protected UpdateAutoForwarding(String string, AutoForwarding autoForwarding) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)autoForwarding, AutoForwarding.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public UpdateAutoForwarding setAlt(String string) {
                    return (UpdateAutoForwarding)super.setAlt(string);
                }

                public UpdateAutoForwarding setFields(String string) {
                    return (UpdateAutoForwarding)super.setFields(string);
                }

                public UpdateAutoForwarding setKey(String string) {
                    return (UpdateAutoForwarding)super.setKey(string);
                }

                public UpdateAutoForwarding setOauthToken(String string) {
                    return (UpdateAutoForwarding)super.setOauthToken(string);
                }

                public UpdateAutoForwarding setPrettyPrint(Boolean bl) {
                    return (UpdateAutoForwarding)super.setPrettyPrint(bl);
                }

                public UpdateAutoForwarding setQuotaUser(String string) {
                    return (UpdateAutoForwarding)super.setQuotaUser(string);
                }

                public UpdateAutoForwarding setUserIp(String string) {
                    return (UpdateAutoForwarding)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public UpdateAutoForwarding setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public UpdateAutoForwarding set(String string, Object object) {
                    return (UpdateAutoForwarding)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetVacation
            extends GmailRequest<VacationSettings> {
                private static final String REST_PATH = "{userId}/settings/vacation";
                @Key
                private String userId;

                protected GetVacation(String string) {
                    super(Gmail.this, "GET", REST_PATH, null, VacationSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetVacation setAlt(String string) {
                    return (GetVacation)super.setAlt(string);
                }

                public GetVacation setFields(String string) {
                    return (GetVacation)super.setFields(string);
                }

                public GetVacation setKey(String string) {
                    return (GetVacation)super.setKey(string);
                }

                public GetVacation setOauthToken(String string) {
                    return (GetVacation)super.setOauthToken(string);
                }

                public GetVacation setPrettyPrint(Boolean bl) {
                    return (GetVacation)super.setPrettyPrint(bl);
                }

                public GetVacation setQuotaUser(String string) {
                    return (GetVacation)super.setQuotaUser(string);
                }

                public GetVacation setUserIp(String string) {
                    return (GetVacation)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GetVacation setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public GetVacation set(String string, Object object) {
                    return (GetVacation)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetPop
            extends GmailRequest<PopSettings> {
                private static final String REST_PATH = "{userId}/settings/pop";
                @Key
                private String userId;

                protected GetPop(String string) {
                    super(Gmail.this, "GET", REST_PATH, null, PopSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetPop setAlt(String string) {
                    return (GetPop)super.setAlt(string);
                }

                public GetPop setFields(String string) {
                    return (GetPop)super.setFields(string);
                }

                public GetPop setKey(String string) {
                    return (GetPop)super.setKey(string);
                }

                public GetPop setOauthToken(String string) {
                    return (GetPop)super.setOauthToken(string);
                }

                public GetPop setPrettyPrint(Boolean bl) {
                    return (GetPop)super.setPrettyPrint(bl);
                }

                public GetPop setQuotaUser(String string) {
                    return (GetPop)super.setQuotaUser(string);
                }

                public GetPop setUserIp(String string) {
                    return (GetPop)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GetPop setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public GetPop set(String string, Object object) {
                    return (GetPop)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetImap
            extends GmailRequest<ImapSettings> {
                private static final String REST_PATH = "{userId}/settings/imap";
                @Key
                private String userId;

                protected GetImap(String string) {
                    super(Gmail.this, "GET", REST_PATH, null, ImapSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetImap setAlt(String string) {
                    return (GetImap)super.setAlt(string);
                }

                public GetImap setFields(String string) {
                    return (GetImap)super.setFields(string);
                }

                public GetImap setKey(String string) {
                    return (GetImap)super.setKey(string);
                }

                public GetImap setOauthToken(String string) {
                    return (GetImap)super.setOauthToken(string);
                }

                public GetImap setPrettyPrint(Boolean bl) {
                    return (GetImap)super.setPrettyPrint(bl);
                }

                public GetImap setQuotaUser(String string) {
                    return (GetImap)super.setQuotaUser(string);
                }

                public GetImap setUserIp(String string) {
                    return (GetImap)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GetImap setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public GetImap set(String string, Object object) {
                    return (GetImap)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetAutoForwarding
            extends GmailRequest<AutoForwarding> {
                private static final String REST_PATH = "{userId}/settings/autoForwarding";
                @Key
                private String userId;

                protected GetAutoForwarding(String string) {
                    super(Gmail.this, "GET", REST_PATH, null, AutoForwarding.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetAutoForwarding setAlt(String string) {
                    return (GetAutoForwarding)super.setAlt(string);
                }

                public GetAutoForwarding setFields(String string) {
                    return (GetAutoForwarding)super.setFields(string);
                }

                public GetAutoForwarding setKey(String string) {
                    return (GetAutoForwarding)super.setKey(string);
                }

                public GetAutoForwarding setOauthToken(String string) {
                    return (GetAutoForwarding)super.setOauthToken(string);
                }

                public GetAutoForwarding setPrettyPrint(Boolean bl) {
                    return (GetAutoForwarding)super.setPrettyPrint(bl);
                }

                public GetAutoForwarding setQuotaUser(String string) {
                    return (GetAutoForwarding)super.setQuotaUser(string);
                }

                public GetAutoForwarding setUserIp(String string) {
                    return (GetAutoForwarding)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GetAutoForwarding setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public GetAutoForwarding set(String string, Object object) {
                    return (GetAutoForwarding)super.set(string, object);
                }
            }
        }

        public class Messages {
            public BatchDelete batchDelete(String string, BatchDeleteMessagesRequest batchDeleteMessagesRequest) throws IOException {
                BatchDelete batchDelete = new BatchDelete(string, batchDeleteMessagesRequest);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)batchDelete);
                return batchDelete;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GmailImport gmailImport(String string, Message message) throws IOException {
                GmailImport gmailImport = new GmailImport(string, message);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)gmailImport);
                return gmailImport;
            }

            public GmailImport gmailImport(String string, Message message, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                GmailImport gmailImport = new GmailImport(string, message, abstractInputStreamContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)gmailImport);
                return gmailImport;
            }

            public Insert insert(String string, Message message) throws IOException {
                Insert insert = new Insert(string, message);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public Insert insert(String string, Message message, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Insert insert = new Insert(string, message, abstractInputStreamContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Modify modify(String string, String string2, ModifyMessageRequest modifyMessageRequest) throws IOException {
                Modify modify = new Modify(string, string2, modifyMessageRequest);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)modify);
                return modify;
            }

            public Send send(String string, Message message) throws IOException {
                Send send = new Send(string, message);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)send);
                return send;
            }

            public Send send(String string, Message message, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Send send = new Send(string, message, abstractInputStreamContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)send);
                return send;
            }

            public Trash trash(String string, String string2) throws IOException {
                Trash trash = new Trash(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)trash);
                return trash;
            }

            public Untrash untrash(String string, String string2) throws IOException {
                Untrash untrash = new Untrash(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)untrash);
                return untrash;
            }

            public Attachments attachments() {
                return new Attachments();
            }

            public class Attachments {
                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends GmailRequest<MessagePartBody> {
                    private static final String REST_PATH = "{userId}/messages/{messageId}/attachments/{id}";
                    @Key
                    private String userId;
                    @Key
                    private String messageId;
                    @Key
                    private String id;

                    protected Get(String string, String string2, String string3) {
                        super(Gmail.this, "GET", REST_PATH, null, MessagePartBody.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                        this.messageId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter messageId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter id must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUserIp(String string) {
                        return (Get)super.setUserIp(string);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String string) {
                        this.userId = string;
                        return this;
                    }

                    public String getMessageId() {
                        return this.messageId;
                    }

                    public Get setMessageId(String string) {
                        this.messageId = string;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Get setId(String string) {
                        this.id = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Untrash
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/{id}/untrash";
                @Key
                private String userId;
                @Key
                private String id;

                protected Untrash(String string, String string2) {
                    super(Gmail.this, "POST", REST_PATH, null, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Untrash setAlt(String string) {
                    return (Untrash)super.setAlt(string);
                }

                public Untrash setFields(String string) {
                    return (Untrash)super.setFields(string);
                }

                public Untrash setKey(String string) {
                    return (Untrash)super.setKey(string);
                }

                public Untrash setOauthToken(String string) {
                    return (Untrash)super.setOauthToken(string);
                }

                public Untrash setPrettyPrint(Boolean bl) {
                    return (Untrash)super.setPrettyPrint(bl);
                }

                public Untrash setQuotaUser(String string) {
                    return (Untrash)super.setQuotaUser(string);
                }

                public Untrash setUserIp(String string) {
                    return (Untrash)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Untrash setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Untrash setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Untrash set(String string, Object object) {
                    return (Untrash)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Trash
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/{id}/trash";
                @Key
                private String userId;
                @Key
                private String id;

                protected Trash(String string, String string2) {
                    super(Gmail.this, "POST", REST_PATH, null, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Trash setAlt(String string) {
                    return (Trash)super.setAlt(string);
                }

                public Trash setFields(String string) {
                    return (Trash)super.setFields(string);
                }

                public Trash setKey(String string) {
                    return (Trash)super.setKey(string);
                }

                public Trash setOauthToken(String string) {
                    return (Trash)super.setOauthToken(string);
                }

                public Trash setPrettyPrint(Boolean bl) {
                    return (Trash)super.setPrettyPrint(bl);
                }

                public Trash setQuotaUser(String string) {
                    return (Trash)super.setQuotaUser(string);
                }

                public Trash setUserIp(String string) {
                    return (Trash)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Trash setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Trash setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Trash set(String string, Object object) {
                    return (Trash)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Send
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/send";
                @Key
                private String userId;

                protected Send(String string, Message message) {
                    super(Gmail.this, "POST", REST_PATH, (Object)message, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.checkRequiredParameter((Object)message, "content");
                    this.checkRequiredParameter(message.getRaw(), "Message.getRaw()");
                }

                protected Send(String string, Message message, AbstractInputStreamContent abstractInputStreamContent) {
                    super(Gmail.this, "POST", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)message, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Send setAlt(String string) {
                    return (Send)super.setAlt(string);
                }

                public Send setFields(String string) {
                    return (Send)super.setFields(string);
                }

                public Send setKey(String string) {
                    return (Send)super.setKey(string);
                }

                public Send setOauthToken(String string) {
                    return (Send)super.setOauthToken(string);
                }

                public Send setPrettyPrint(Boolean bl) {
                    return (Send)super.setPrettyPrint(bl);
                }

                public Send setQuotaUser(String string) {
                    return (Send)super.setQuotaUser(string);
                }

                public Send setUserIp(String string) {
                    return (Send)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Send setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public Send set(String string, Object object) {
                    return (Send)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Modify
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/{id}/modify";
                @Key
                private String userId;
                @Key
                private String id;

                protected Modify(String string, String string2, ModifyMessageRequest modifyMessageRequest) {
                    super(Gmail.this, "POST", REST_PATH, (Object)modifyMessageRequest, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Modify setAlt(String string) {
                    return (Modify)super.setAlt(string);
                }

                public Modify setFields(String string) {
                    return (Modify)super.setFields(string);
                }

                public Modify setKey(String string) {
                    return (Modify)super.setKey(string);
                }

                public Modify setOauthToken(String string) {
                    return (Modify)super.setOauthToken(string);
                }

                public Modify setPrettyPrint(Boolean bl) {
                    return (Modify)super.setPrettyPrint(bl);
                }

                public Modify setQuotaUser(String string) {
                    return (Modify)super.setQuotaUser(string);
                }

                public Modify setUserIp(String string) {
                    return (Modify)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Modify setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Modify setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Modify set(String string, Object object) {
                    return (Modify)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends GmailRequest<ListMessagesResponse> {
                private static final String REST_PATH = "{userId}/messages";
                @Key
                private String userId;
                @Key
                private Boolean includeSpamTrash;
                @Key
                private java.util.List<String> labelIds;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String q;

                protected List(String string) {
                    super(Gmail.this, "GET", REST_PATH, null, ListMessagesResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public Boolean getIncludeSpamTrash() {
                    return this.includeSpamTrash;
                }

                public List setIncludeSpamTrash(Boolean bl) {
                    this.includeSpamTrash = bl;
                    return this;
                }

                public boolean isIncludeSpamTrash() {
                    if (this.includeSpamTrash == null || this.includeSpamTrash == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.includeSpamTrash;
                }

                public java.util.List<String> getLabelIds() {
                    return this.labelIds;
                }

                public List setLabelIds(java.util.List<String> list) {
                    this.labelIds = list;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getQ() {
                    return this.q;
                }

                public List setQ(String string) {
                    this.q = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages";
                @Key
                private String userId;
                @Key
                private Boolean deleted;
                @Key
                private String internalDateSource;

                protected Insert(String string, Message message) {
                    super(Gmail.this, "POST", REST_PATH, (Object)message, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.checkRequiredParameter((Object)message, "content");
                    this.checkRequiredParameter(message.getRaw(), "Message.getRaw()");
                }

                protected Insert(String string, Message message, AbstractInputStreamContent abstractInputStreamContent) {
                    super(Gmail.this, "POST", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)message, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Insert setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public Boolean getDeleted() {
                    return this.deleted;
                }

                public Insert setDeleted(Boolean bl) {
                    this.deleted = bl;
                    return this;
                }

                public boolean isDeleted() {
                    if (this.deleted == null || this.deleted == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.deleted;
                }

                public String getInternalDateSource() {
                    return this.internalDateSource;
                }

                public Insert setInternalDateSource(String string) {
                    this.internalDateSource = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GmailImport
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/import";
                @Key
                private String userId;
                @Key
                private Boolean deleted;
                @Key
                private String internalDateSource;
                @Key
                private Boolean neverMarkSpam;
                @Key
                private Boolean processForCalendar;

                protected GmailImport(String string, Message message) {
                    super(Gmail.this, "POST", REST_PATH, (Object)message, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                protected GmailImport(String string, Message message, AbstractInputStreamContent abstractInputStreamContent) {
                    super(Gmail.this, "POST", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)message, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public GmailImport setAlt(String string) {
                    return (GmailImport)super.setAlt(string);
                }

                public GmailImport setFields(String string) {
                    return (GmailImport)super.setFields(string);
                }

                public GmailImport setKey(String string) {
                    return (GmailImport)super.setKey(string);
                }

                public GmailImport setOauthToken(String string) {
                    return (GmailImport)super.setOauthToken(string);
                }

                public GmailImport setPrettyPrint(Boolean bl) {
                    return (GmailImport)super.setPrettyPrint(bl);
                }

                public GmailImport setQuotaUser(String string) {
                    return (GmailImport)super.setQuotaUser(string);
                }

                public GmailImport setUserIp(String string) {
                    return (GmailImport)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GmailImport setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public Boolean getDeleted() {
                    return this.deleted;
                }

                public GmailImport setDeleted(Boolean bl) {
                    this.deleted = bl;
                    return this;
                }

                public boolean isDeleted() {
                    if (this.deleted == null || this.deleted == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.deleted;
                }

                public String getInternalDateSource() {
                    return this.internalDateSource;
                }

                public GmailImport setInternalDateSource(String string) {
                    this.internalDateSource = string;
                    return this;
                }

                public Boolean getNeverMarkSpam() {
                    return this.neverMarkSpam;
                }

                public GmailImport setNeverMarkSpam(Boolean bl) {
                    this.neverMarkSpam = bl;
                    return this;
                }

                public boolean isNeverMarkSpam() {
                    if (this.neverMarkSpam == null || this.neverMarkSpam == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.neverMarkSpam;
                }

                public Boolean getProcessForCalendar() {
                    return this.processForCalendar;
                }

                public GmailImport setProcessForCalendar(Boolean bl) {
                    this.processForCalendar = bl;
                    return this;
                }

                public boolean isProcessForCalendar() {
                    if (this.processForCalendar == null || this.processForCalendar == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.processForCalendar;
                }

                @Override
                public GmailImport set(String string, Object object) {
                    return (GmailImport)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/{id}";
                @Key
                private String userId;
                @Key
                private String id;
                @Key
                private String format;
                @Key
                private java.util.List<String> metadataHeaders;

                protected Get(String string, String string2) {
                    super(Gmail.this, "GET", REST_PATH, null, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getFormat() {
                    return this.format;
                }

                public Get setFormat(String string) {
                    this.format = string;
                    return this;
                }

                public java.util.List<String> getMetadataHeaders() {
                    return this.metadataHeaders;
                }

                public Get setMetadataHeaders(java.util.List<String> list) {
                    this.metadataHeaders = list;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/messages/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Delete(String string, String string2) {
                    super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchDelete
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/messages/batchDelete";
                @Key
                private String userId;

                protected BatchDelete(String string, BatchDeleteMessagesRequest batchDeleteMessagesRequest) {
                    super(Gmail.this, "POST", REST_PATH, (Object)batchDeleteMessagesRequest, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public BatchDelete setAlt(String string) {
                    return (BatchDelete)super.setAlt(string);
                }

                public BatchDelete setFields(String string) {
                    return (BatchDelete)super.setFields(string);
                }

                public BatchDelete setKey(String string) {
                    return (BatchDelete)super.setKey(string);
                }

                public BatchDelete setOauthToken(String string) {
                    return (BatchDelete)super.setOauthToken(string);
                }

                public BatchDelete setPrettyPrint(Boolean bl) {
                    return (BatchDelete)super.setPrettyPrint(bl);
                }

                public BatchDelete setQuotaUser(String string) {
                    return (BatchDelete)super.setQuotaUser(string);
                }

                public BatchDelete setUserIp(String string) {
                    return (BatchDelete)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public BatchDelete setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public BatchDelete set(String string, Object object) {
                    return (BatchDelete)super.set(string, object);
                }
            }
        }

        public class Labels {
            public Create create(String string, Label label) throws IOException {
                Create create = new Create(string, label);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, Label label) throws IOException {
                Patch patch = new Patch(string, string2, label);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, Label label) throws IOException {
                Update update = new Update(string, string2, label);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends GmailRequest<Label> {
                private static final String REST_PATH = "{userId}/labels/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Update(String string, String string2, Label label) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)label, Label.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                    this.checkRequiredParameter((Object)label, "content");
                    this.checkRequiredParameter(label.getId(), "Label.getId()");
                    this.checkRequiredParameter((Object)label, "content");
                    this.checkRequiredParameter(label.getLabelListVisibility(), "Label.getLabelListVisibility()");
                    this.checkRequiredParameter((Object)label, "content");
                    this.checkRequiredParameter(label.getMessageListVisibility(), "Label.getMessageListVisibility()");
                    this.checkRequiredParameter((Object)label, "content");
                    this.checkRequiredParameter(label.getName(), "Label.getName()");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Update setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Update setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends GmailRequest<Label> {
                private static final String REST_PATH = "{userId}/labels/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Patch(String string, String string2, Label label) {
                    super(Gmail.this, "PATCH", REST_PATH, (Object)label, Label.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Patch setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Patch setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends GmailRequest<ListLabelsResponse> {
                private static final String REST_PATH = "{userId}/labels";
                @Key
                private String userId;

                protected List(String string) {
                    super(Gmail.this, "GET", REST_PATH, null, ListLabelsResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends GmailRequest<Label> {
                private static final String REST_PATH = "{userId}/labels/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Get(String string, String string2) {
                    super(Gmail.this, "GET", REST_PATH, null, Label.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/labels/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Delete(String string, String string2) {
                    super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends GmailRequest<Label> {
                private static final String REST_PATH = "{userId}/labels";
                @Key
                private String userId;

                protected Create(String string, Label label) {
                    super(Gmail.this, "POST", REST_PATH, (Object)label, Label.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.checkRequiredParameter((Object)label, "content");
                    this.checkRequiredParameter(label.getLabelListVisibility(), "Label.getLabelListVisibility()");
                    this.checkRequiredParameter((Object)label, "content");
                    this.checkRequiredParameter(label.getMessageListVisibility(), "Label.getMessageListVisibility()");
                    this.checkRequiredParameter((Object)label, "content");
                    this.checkRequiredParameter(label.getName(), "Label.getName()");
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUserIp(String string) {
                    return (Create)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Create setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class History {
            public List list(String string) throws IOException {
                List list = new List(string);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends GmailRequest<ListHistoryResponse> {
                private static final String REST_PATH = "{userId}/history";
                @Key
                private String userId;
                @Key
                private String labelId;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private BigInteger startHistoryId;

                protected List(String string) {
                    super(Gmail.this, "GET", REST_PATH, null, ListHistoryResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getLabelId() {
                    return this.labelId;
                }

                public List setLabelId(String string) {
                    this.labelId = string;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public BigInteger getStartHistoryId() {
                    return this.startHistoryId;
                }

                public List setStartHistoryId(BigInteger bigInteger) {
                    this.startHistoryId = bigInteger;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Drafts {
            public Create create(String string, Draft draft) throws IOException {
                Create create = new Create(string, draft);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Create create(String string, Draft draft, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Create create = new Create(string, draft, abstractInputStreamContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Send send(String string, Draft draft) throws IOException {
                Send send = new Send(string, draft);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)send);
                return send;
            }

            public Send send(String string, Draft draft, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Send send = new Send(string, draft, abstractInputStreamContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)send);
                return send;
            }

            public Update update(String string, String string2, Draft draft) throws IOException {
                Update update = new Update(string, string2, draft);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            public Update update(String string, String string2, Draft draft, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Update update = new Update(string, string2, draft, abstractInputStreamContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends GmailRequest<Draft> {
                private static final String REST_PATH = "{userId}/drafts/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Update(String string, String string2, Draft draft) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)draft, Draft.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                protected Update(String string, String string2, Draft draft, AbstractInputStreamContent abstractInputStreamContent) {
                    super(Gmail.this, "PUT", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)draft, Draft.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Update setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Update setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Send
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/drafts/send";
                @Key
                private String userId;

                protected Send(String string, Draft draft) {
                    super(Gmail.this, "POST", REST_PATH, (Object)draft, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                protected Send(String string, Draft draft, AbstractInputStreamContent abstractInputStreamContent) {
                    super(Gmail.this, "POST", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)draft, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Send setAlt(String string) {
                    return (Send)super.setAlt(string);
                }

                public Send setFields(String string) {
                    return (Send)super.setFields(string);
                }

                public Send setKey(String string) {
                    return (Send)super.setKey(string);
                }

                public Send setOauthToken(String string) {
                    return (Send)super.setOauthToken(string);
                }

                public Send setPrettyPrint(Boolean bl) {
                    return (Send)super.setPrettyPrint(bl);
                }

                public Send setQuotaUser(String string) {
                    return (Send)super.setQuotaUser(string);
                }

                public Send setUserIp(String string) {
                    return (Send)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Send setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public Send set(String string, Object object) {
                    return (Send)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends GmailRequest<ListDraftsResponse> {
                private static final String REST_PATH = "{userId}/drafts";
                @Key
                private String userId;
                @Key
                private Boolean includeSpamTrash;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String q;

                protected List(String string) {
                    super(Gmail.this, "GET", REST_PATH, null, ListDraftsResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public Boolean getIncludeSpamTrash() {
                    return this.includeSpamTrash;
                }

                public List setIncludeSpamTrash(Boolean bl) {
                    this.includeSpamTrash = bl;
                    return this;
                }

                public boolean isIncludeSpamTrash() {
                    if (this.includeSpamTrash == null || this.includeSpamTrash == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.includeSpamTrash;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public String getQ() {
                    return this.q;
                }

                public List setQ(String string) {
                    this.q = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends GmailRequest<Draft> {
                private static final String REST_PATH = "{userId}/drafts/{id}";
                @Key
                private String userId;
                @Key
                private String id;
                @Key
                private String format;

                protected Get(String string, String string2) {
                    super(Gmail.this, "GET", REST_PATH, null, Draft.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String string) {
                    this.id = string;
                    return this;
                }

                public String getFormat() {
                    return this.format;
                }

                public Get setFormat(String string) {
                    this.format = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/drafts/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Delete(String string, String string2) {
                    super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String string) {
                    this.id = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends GmailRequest<Draft> {
                private static final String REST_PATH = "{userId}/drafts";
                @Key
                private String userId;

                protected Create(String string, Draft draft) {
                    super(Gmail.this, "POST", REST_PATH, (Object)draft, Draft.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                }

                protected Create(String string, Draft draft, AbstractInputStreamContent abstractInputStreamContent) {
                    super(Gmail.this, "POST", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)draft, Draft.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUserIp(String string) {
                    return (Create)super.setUserIp(string);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Create setUserId(String string) {
                    this.userId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Watch
        extends GmailRequest<WatchResponse> {
            private static final String REST_PATH = "{userId}/watch";
            @Key
            private String userId;

            protected Watch(String string, WatchRequest watchRequest) {
                super(Gmail.this, "POST", REST_PATH, (Object)watchRequest, WatchResponse.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
            }

            public Watch setAlt(String string) {
                return (Watch)super.setAlt(string);
            }

            public Watch setFields(String string) {
                return (Watch)super.setFields(string);
            }

            public Watch setKey(String string) {
                return (Watch)super.setKey(string);
            }

            public Watch setOauthToken(String string) {
                return (Watch)super.setOauthToken(string);
            }

            public Watch setPrettyPrint(Boolean bl) {
                return (Watch)super.setPrettyPrint(bl);
            }

            public Watch setQuotaUser(String string) {
                return (Watch)super.setQuotaUser(string);
            }

            public Watch setUserIp(String string) {
                return (Watch)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public Watch setUserId(String string) {
                this.userId = string;
                return this;
            }

            @Override
            public Watch set(String string, Object object) {
                return (Watch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Stop
        extends GmailRequest<Void> {
            private static final String REST_PATH = "{userId}/stop";
            @Key
            private String userId;

            protected Stop(String string) {
                super(Gmail.this, "POST", REST_PATH, null, Void.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
            }

            public Stop setAlt(String string) {
                return (Stop)super.setAlt(string);
            }

            public Stop setFields(String string) {
                return (Stop)super.setFields(string);
            }

            public Stop setKey(String string) {
                return (Stop)super.setKey(string);
            }

            public Stop setOauthToken(String string) {
                return (Stop)super.setOauthToken(string);
            }

            public Stop setPrettyPrint(Boolean bl) {
                return (Stop)super.setPrettyPrint(bl);
            }

            public Stop setQuotaUser(String string) {
                return (Stop)super.setQuotaUser(string);
            }

            public Stop setUserIp(String string) {
                return (Stop)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public Stop setUserId(String string) {
                this.userId = string;
                return this;
            }

            @Override
            public Stop set(String string, Object object) {
                return (Stop)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetProfile
        extends GmailRequest<Profile> {
            private static final String REST_PATH = "{userId}/profile";
            @Key
            private String userId;

            protected GetProfile(String string) {
                super(Gmail.this, "GET", REST_PATH, null, Profile.class);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetProfile setAlt(String string) {
                return (GetProfile)super.setAlt(string);
            }

            public GetProfile setFields(String string) {
                return (GetProfile)super.setFields(string);
            }

            public GetProfile setKey(String string) {
                return (GetProfile)super.setKey(string);
            }

            public GetProfile setOauthToken(String string) {
                return (GetProfile)super.setOauthToken(string);
            }

            public GetProfile setPrettyPrint(Boolean bl) {
                return (GetProfile)super.setPrettyPrint(bl);
            }

            public GetProfile setQuotaUser(String string) {
                return (GetProfile)super.setQuotaUser(string);
            }

            public GetProfile setUserIp(String string) {
                return (GetProfile)super.setUserIp(string);
            }

            public String getUserId() {
                return this.userId;
            }

            public GetProfile setUserId(String string) {
                this.userId = string;
                return this;
            }

            @Override
            public GetProfile set(String string, Object object) {
                return (GetProfile)super.set(string, object);
            }
        }
    }
}

