/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Push notification watch response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WatchResponse extends com.google.api.client.json.GenericJson {

  /**
   * When Gmail will stop sending notifications for mailbox updates (epoch millis). Call `watch`
   * again before this time to renew the watch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expiration;

  /**
   * The ID of the mailbox's current history record.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger historyId;

  /**
   * When Gmail will stop sending notifications for mailbox updates (epoch millis). Call `watch`
   * again before this time to renew the watch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpiration() {
    return expiration;
  }

  /**
   * When Gmail will stop sending notifications for mailbox updates (epoch millis). Call `watch`
   * again before this time to renew the watch.
   * @param expiration expiration or {@code null} for none
   */
  public WatchResponse setExpiration(java.lang.Long expiration) {
    this.expiration = expiration;
    return this;
  }

  /**
   * The ID of the mailbox's current history record.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getHistoryId() {
    return historyId;
  }

  /**
   * The ID of the mailbox's current history record.
   * @param historyId historyId or {@code null} for none
   */
  public WatchResponse setHistoryId(java.math.BigInteger historyId) {
    this.historyId = historyId;
    return this;
  }

  @Override
  public WatchResponse set(String fieldName, Object value) {
    return (WatchResponse) super.set(fieldName, value);
  }

  @Override
  public WatchResponse clone() {
    return (WatchResponse) super.clone();
  }

}
