/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Settings for a delegate. Delegates can read, send, and delete messages, as well as view and add
 * contacts, for the delegator's account. See "Set up mail delegation" for more information about
 * delegates.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Delegate extends com.google.api.client.json.GenericJson {

  /**
   * The email address of the delegate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String delegateEmail;

  /**
   * Indicates whether this address has been verified and can act as a delegate for the account.
   * Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String verificationStatus;

  /**
   * The email address of the delegate.
   * @return value or {@code null} for none
   */
  public java.lang.String getDelegateEmail() {
    return delegateEmail;
  }

  /**
   * The email address of the delegate.
   * @param delegateEmail delegateEmail or {@code null} for none
   */
  public Delegate setDelegateEmail(java.lang.String delegateEmail) {
    this.delegateEmail = delegateEmail;
    return this;
  }

  /**
   * Indicates whether this address has been verified and can act as a delegate for the account.
   * Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getVerificationStatus() {
    return verificationStatus;
  }

  /**
   * Indicates whether this address has been verified and can act as a delegate for the account.
   * Read-only.
   * @param verificationStatus verificationStatus or {@code null} for none
   */
  public Delegate setVerificationStatus(java.lang.String verificationStatus) {
    this.verificationStatus = verificationStatus;
    return this;
  }

  @Override
  public Delegate set(String fieldName, Object value) {
    return (Delegate) super.set(fieldName, value);
  }

  @Override
  public Delegate clone() {
    return (Delegate) super.clone();
  }

}
