/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Model definition for ListCseIdentitiesResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListCseIdentitiesResponse extends com.google.api.client.json.GenericJson {

  /**
   * One page of the list of CSE identities configured for the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CseIdentity> cseIdentities;

  static {
    // hack to force ProGuard to consider CseIdentity used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CseIdentity.class);
  }

  /**
   * Pagination token to be passed to a subsequent ListCseIdentities call in order to retrieve the
   * next page of identities. If this value is not returned or is the empty string, then no further
   * pages remain.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * One page of the list of CSE identities configured for the user.
   * @return value or {@code null} for none
   */
  public java.util.List<CseIdentity> getCseIdentities() {
    return cseIdentities;
  }

  /**
   * One page of the list of CSE identities configured for the user.
   * @param cseIdentities cseIdentities or {@code null} for none
   */
  public ListCseIdentitiesResponse setCseIdentities(java.util.List<CseIdentity> cseIdentities) {
    this.cseIdentities = cseIdentities;
    return this;
  }

  /**
   * Pagination token to be passed to a subsequent ListCseIdentities call in order to retrieve the
   * next page of identities. If this value is not returned or is the empty string, then no further
   * pages remain.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Pagination token to be passed to a subsequent ListCseIdentities call in order to retrieve the
   * next page of identities. If this value is not returned or is the empty string, then no further
   * pages remain.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListCseIdentitiesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListCseIdentitiesResponse set(String fieldName, Object value) {
    return (ListCseIdentitiesResponse) super.set(fieldName, value);
  }

  @Override
  public ListCseIdentitiesResponse clone() {
    return (ListCseIdentitiesResponse) super.clone();
  }

}
