/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Metadata for a private key instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CsePrivateKeyMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Metadata for a private key instance managed by an external key access control list service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private KaclsKeyMetadata kaclsKeyMetadata;

  /**
   * Output only. The immutable ID for the private key metadata instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String privateKeyMetadataId;

  /**
   * Metadata for a private key instance managed by an external key access control list service.
   * @return value or {@code null} for none
   */
  public KaclsKeyMetadata getKaclsKeyMetadata() {
    return kaclsKeyMetadata;
  }

  /**
   * Metadata for a private key instance managed by an external key access control list service.
   * @param kaclsKeyMetadata kaclsKeyMetadata or {@code null} for none
   */
  public CsePrivateKeyMetadata setKaclsKeyMetadata(KaclsKeyMetadata kaclsKeyMetadata) {
    this.kaclsKeyMetadata = kaclsKeyMetadata;
    return this;
  }

  /**
   * Output only. The immutable ID for the private key metadata instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrivateKeyMetadataId() {
    return privateKeyMetadataId;
  }

  /**
   * Output only. The immutable ID for the private key metadata instance.
   * @param privateKeyMetadataId privateKeyMetadataId or {@code null} for none
   */
  public CsePrivateKeyMetadata setPrivateKeyMetadataId(java.lang.String privateKeyMetadataId) {
    this.privateKeyMetadataId = privateKeyMetadataId;
    return this;
  }

  @Override
  public CsePrivateKeyMetadata set(String fieldName, Object value) {
    return (CsePrivateKeyMetadata) super.set(fieldName, value);
  }

  @Override
  public CsePrivateKeyMetadata clone() {
    return (CsePrivateKeyMetadata) super.clone();
  }

}
