/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Set up or update a new push notification watch on this user's mailbox.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WatchRequest extends com.google.api.client.json.GenericJson {

  /**
   * Filtering behavior of labelIds list specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String labelFilterAction;

  /**
   * List of label_ids to restrict notifications about. By default, if unspecified, all changes are
   * pushed out. If specified then dictates which labels are required for a push notification to be
   * generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> labelIds;

  /**
   * A fully qualified Google Cloud Pub/Sub API topic name to publish the events to. This topic name
   * **must** already exist in Cloud Pub/Sub and you **must** have already granted gmail "publish"
   * permission on it. For example, "projects/my-project-identifier/topics/my-topic-name" (using the
   * Cloud Pub/Sub "v1" topic naming format). Note that the "my-project-identifier" portion must
   * exactly match your Google developer project id (the one executing this watch request).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topicName;

  /**
   * Filtering behavior of labelIds list specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabelFilterAction() {
    return labelFilterAction;
  }

  /**
   * Filtering behavior of labelIds list specified.
   * @param labelFilterAction labelFilterAction or {@code null} for none
   */
  public WatchRequest setLabelFilterAction(java.lang.String labelFilterAction) {
    this.labelFilterAction = labelFilterAction;
    return this;
  }

  /**
   * List of label_ids to restrict notifications about. By default, if unspecified, all changes are
   * pushed out. If specified then dictates which labels are required for a push notification to be
   * generated.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLabelIds() {
    return labelIds;
  }

  /**
   * List of label_ids to restrict notifications about. By default, if unspecified, all changes are
   * pushed out. If specified then dictates which labels are required for a push notification to be
   * generated.
   * @param labelIds labelIds or {@code null} for none
   */
  public WatchRequest setLabelIds(java.util.List<java.lang.String> labelIds) {
    this.labelIds = labelIds;
    return this;
  }

  /**
   * A fully qualified Google Cloud Pub/Sub API topic name to publish the events to. This topic name
   * **must** already exist in Cloud Pub/Sub and you **must** have already granted gmail "publish"
   * permission on it. For example, "projects/my-project-identifier/topics/my-topic-name" (using the
   * Cloud Pub/Sub "v1" topic naming format). Note that the "my-project-identifier" portion must
   * exactly match your Google developer project id (the one executing this watch request).
   * @return value or {@code null} for none
   */
  public java.lang.String getTopicName() {
    return topicName;
  }

  /**
   * A fully qualified Google Cloud Pub/Sub API topic name to publish the events to. This topic name
   * **must** already exist in Cloud Pub/Sub and you **must** have already granted gmail "publish"
   * permission on it. For example, "projects/my-project-identifier/topics/my-topic-name" (using the
   * Cloud Pub/Sub "v1" topic naming format). Note that the "my-project-identifier" portion must
   * exactly match your Google developer project id (the one executing this watch request).
   * @param topicName topicName or {@code null} for none
   */
  public WatchRequest setTopicName(java.lang.String topicName) {
    this.topicName = topicName;
    return this;
  }

  @Override
  public WatchRequest set(String fieldName, Object value) {
    return (WatchRequest) super.set(fieldName, value);
  }

  @Override
  public WatchRequest clone() {
    return (WatchRequest) super.clone();
  }

}
