/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.gmail;

/**
 * Service definition for Gmail (v1).
 *
 * <p>
 * The Gmail API lets you view and manage Gmail mailbox data like threads, messages, and labels.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/gmail/api/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link GmailRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Gmail extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Gmail API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://gmail.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://gmail.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Gmail(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Gmail(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Users collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Gmail gmail = new Gmail(...);}
   *   {@code Gmail.Users.List request = gmail.users().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Users users() {
    return new Users();
  }

  /**
   * The "users" collection of methods.
   */
  public class Users {

    /**
     * Gets the current user's Gmail profile.
     *
     * Create a request for the method "users.getProfile".
     *
     * This request holds the parameters needed by the gmail server.  After setting any optional
     * parameters, call the {@link GetProfile#execute()} method to invoke the remote operation.
     *
     * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
     *        [default: me]
     * @return the request
     */
    public GetProfile getProfile(java.lang.String userId) throws java.io.IOException {
      GetProfile result = new GetProfile(userId);
      initialize(result);
      return result;
    }

    public class GetProfile extends GmailRequest<com.google.api.services.gmail.model.Profile> {

      private static final String REST_PATH = "gmail/v1/users/{userId}/profile";

      /**
       * Gets the current user's Gmail profile.
       *
       * Create a request for the method "users.getProfile".
       *
       * This request holds the parameters needed by the the gmail server.  After setting any optional
       * parameters, call the {@link GetProfile#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetProfile#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
     *        [default: me]
       * @since 1.13
       */
      protected GetProfile(java.lang.String userId) {
        super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.Profile.class);
        this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetProfile set$Xgafv(java.lang.String $Xgafv) {
        return (GetProfile) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetProfile setAccessToken(java.lang.String accessToken) {
        return (GetProfile) super.setAccessToken(accessToken);
      }

      @Override
      public GetProfile setAlt(java.lang.String alt) {
        return (GetProfile) super.setAlt(alt);
      }

      @Override
      public GetProfile setCallback(java.lang.String callback) {
        return (GetProfile) super.setCallback(callback);
      }

      @Override
      public GetProfile setFields(java.lang.String fields) {
        return (GetProfile) super.setFields(fields);
      }

      @Override
      public GetProfile setKey(java.lang.String key) {
        return (GetProfile) super.setKey(key);
      }

      @Override
      public GetProfile setOauthToken(java.lang.String oauthToken) {
        return (GetProfile) super.setOauthToken(oauthToken);
      }

      @Override
      public GetProfile setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetProfile) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetProfile setQuotaUser(java.lang.String quotaUser) {
        return (GetProfile) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetProfile setUploadType(java.lang.String uploadType) {
        return (GetProfile) super.setUploadType(uploadType);
      }

      @Override
      public GetProfile setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetProfile) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The user's email address. The special value `me` can be used to indicate the authenticated
       * user.
       */
      @com.google.api.client.util.Key
      private java.lang.String userId;

      /** The user's email address. The special value `me` can be used to indicate the authenticated user.
     [default: me]
       */
      public java.lang.String getUserId() {
        return userId;
      }

      /**
       * The user's email address. The special value `me` can be used to indicate the authenticated
       * user.
       */
      public GetProfile setUserId(java.lang.String userId) {
        this.userId = userId;
        return this;
      }

      @Override
      public GetProfile set(String parameterName, Object value) {
        return (GetProfile) super.set(parameterName, value);
      }
    }
    /**
     * Stop receiving push notifications for the given user mailbox.
     *
     * Create a request for the method "users.stop".
     *
     * This request holds the parameters needed by the gmail server.  After setting any optional
     * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
     *
     * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
     *        [default: me]
     * @return the request
     */
    public Stop stop(java.lang.String userId) throws java.io.IOException {
      Stop result = new Stop(userId);
      initialize(result);
      return result;
    }

    public class Stop extends GmailRequest<Void> {

      private static final String REST_PATH = "gmail/v1/users/{userId}/stop";

      /**
       * Stop receiving push notifications for the given user mailbox.
       *
       * Create a request for the method "users.stop".
       *
       * This request holds the parameters needed by the the gmail server.  After setting any optional
       * parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p> {@link
       * Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
     *        [default: me]
       * @since 1.13
       */
      protected Stop(java.lang.String userId) {
        super(Gmail.this, "POST", REST_PATH, null, Void.class);
        this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
      }

      @Override
      public Stop set$Xgafv(java.lang.String $Xgafv) {
        return (Stop) super.set$Xgafv($Xgafv);
      }

      @Override
      public Stop setAccessToken(java.lang.String accessToken) {
        return (Stop) super.setAccessToken(accessToken);
      }

      @Override
      public Stop setAlt(java.lang.String alt) {
        return (Stop) super.setAlt(alt);
      }

      @Override
      public Stop setCallback(java.lang.String callback) {
        return (Stop) super.setCallback(callback);
      }

      @Override
      public Stop setFields(java.lang.String fields) {
        return (Stop) super.setFields(fields);
      }

      @Override
      public Stop setKey(java.lang.String key) {
        return (Stop) super.setKey(key);
      }

      @Override
      public Stop setOauthToken(java.lang.String oauthToken) {
        return (Stop) super.setOauthToken(oauthToken);
      }

      @Override
      public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Stop) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Stop setQuotaUser(java.lang.String quotaUser) {
        return (Stop) super.setQuotaUser(quotaUser);
      }

      @Override
      public Stop setUploadType(java.lang.String uploadType) {
        return (Stop) super.setUploadType(uploadType);
      }

      @Override
      public Stop setUploadProtocol(java.lang.String uploadProtocol) {
        return (Stop) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The user's email address. The special value `me` can be used to indicate the authenticated
       * user.
       */
      @com.google.api.client.util.Key
      private java.lang.String userId;

      /** The user's email address. The special value `me` can be used to indicate the authenticated user.
     [default: me]
       */
      public java.lang.String getUserId() {
        return userId;
      }

      /**
       * The user's email address. The special value `me` can be used to indicate the authenticated
       * user.
       */
      public Stop setUserId(java.lang.String userId) {
        this.userId = userId;
        return this;
      }

      @Override
      public Stop set(String parameterName, Object value) {
        return (Stop) super.set(parameterName, value);
      }
    }
    /**
     * Set up or update a push notification watch on the given user mailbox.
     *
     * Create a request for the method "users.watch".
     *
     * This request holds the parameters needed by the gmail server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
     *        [default: me]
     * @param content the {@link com.google.api.services.gmail.model.WatchRequest}
     * @return the request
     */
    public Watch watch(java.lang.String userId, com.google.api.services.gmail.model.WatchRequest content) throws java.io.IOException {
      Watch result = new Watch(userId, content);
      initialize(result);
      return result;
    }

    public class Watch extends GmailRequest<com.google.api.services.gmail.model.WatchResponse> {

      private static final String REST_PATH = "gmail/v1/users/{userId}/watch";

      /**
       * Set up or update a push notification watch on the given user mailbox.
       *
       * Create a request for the method "users.watch".
       *
       * This request holds the parameters needed by the the gmail server.  After setting any optional
       * parameters, call the {@link Watch#execute()} method to invoke the remote operation. <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
     *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.WatchRequest}
       * @since 1.13
       */
      protected Watch(java.lang.String userId, com.google.api.services.gmail.model.WatchRequest content) {
        super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.WatchResponse.class);
        this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
      }

      @Override
      public Watch set$Xgafv(java.lang.String $Xgafv) {
        return (Watch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Watch setAccessToken(java.lang.String accessToken) {
        return (Watch) super.setAccessToken(accessToken);
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setCallback(java.lang.String callback) {
        return (Watch) super.setCallback(callback);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUploadType(java.lang.String uploadType) {
        return (Watch) super.setUploadType(uploadType);
      }

      @Override
      public Watch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Watch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The user's email address. The special value `me` can be used to indicate the authenticated
       * user.
       */
      @com.google.api.client.util.Key
      private java.lang.String userId;

      /** The user's email address. The special value `me` can be used to indicate the authenticated user.
     [default: me]
       */
      public java.lang.String getUserId() {
        return userId;
      }

      /**
       * The user's email address. The special value `me` can be used to indicate the authenticated
       * user.
       */
      public Watch setUserId(java.lang.String userId) {
        this.userId = userId;
        return this;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Drafts collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Gmail gmail = new Gmail(...);}
     *   {@code Gmail.Drafts.List request = gmail.drafts().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Drafts drafts() {
      return new Drafts();
    }

    /**
     * The "drafts" collection of methods.
     */
    public class Drafts {

      /**
       * Creates a new draft with the `DRAFT` label.
       *
       * Create a request for the method "drafts.create".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Draft}
       * @return the request
       */
      public Create create(java.lang.String userId, com.google.api.services.gmail.model.Draft content) throws java.io.IOException {
        Create result = new Create(userId, content);
        initialize(result);
        return result;
      }

      /**
       * Creates a new draft with the `DRAFT` label.
       *
       * Create a request for the method "drafts.create".
       *
       * This request holds the parameters needed by the the gmail server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Draft} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Create create(java.lang.String userId, com.google.api.services.gmail.model.Draft content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Create result = new Create(userId, content, mediaContent);
        initialize(result);
        return result;
      }

      public class Create extends GmailRequest<com.google.api.services.gmail.model.Draft> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/drafts";

        /**
         * Creates a new draft with the `DRAFT` label.
         *
         * Create a request for the method "drafts.create".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Draft}
         * @since 1.13
         */
        protected Create(java.lang.String userId, com.google.api.services.gmail.model.Draft content) {
          super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.Draft.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        /**
         * Creates a new draft with the `DRAFT` label.
         *
         * Create a request for the method "drafts.create".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Draft} media metadata or {@code null} if none
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Create(java.lang.String userId, com.google.api.services.gmail.model.Draft content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(Gmail.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.gmail.model.Draft.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Create setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Immediately and permanently deletes the specified draft. Does not simply trash it.
       *
       * Create a request for the method "drafts.delete".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the draft to delete.
       * @return the request
       */
      public Delete delete(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Delete result = new Delete(userId, id);
        initialize(result);
        return result;
      }

      public class Delete extends GmailRequest<Void> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/drafts/{id}";

        /**
         * Immediately and permanently deletes the specified draft. Does not simply trash it.
         *
         * Create a request for the method "drafts.delete".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the draft to delete.
         * @since 1.13
         */
        protected Delete(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Delete setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the draft to delete. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the draft to delete.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the draft to delete. */
        public Delete setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the specified draft.
       *
       * Create a request for the method "drafts.get".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the draft to retrieve.
       * @return the request
       */
      public Get get(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Get result = new Get(userId, id);
        initialize(result);
        return result;
      }

      public class Get extends GmailRequest<com.google.api.services.gmail.model.Draft> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/drafts/{id}";

        /**
         * Gets the specified draft.
         *
         * Create a request for the method "drafts.get".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the draft to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.Draft.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Get setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the draft to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the draft to retrieve.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the draft to retrieve. */
        public Get setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        /** The format to return the draft in. */
        @com.google.api.client.util.Key
        private java.lang.String format;

        /** The format to return the draft in. [default: full]
         */
        public java.lang.String getFormat() {
          return format;
        }

        /** The format to return the draft in. */
        public Get setFormat(java.lang.String format) {
          this.format = format;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists the drafts in the user's mailbox.
       *
       * Create a request for the method "drafts.list".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @return the request
       */
      public List list(java.lang.String userId) throws java.io.IOException {
        List result = new List(userId);
        initialize(result);
        return result;
      }

      public class List extends GmailRequest<com.google.api.services.gmail.model.ListDraftsResponse> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/drafts";

        /**
         * Lists the drafts in the user's mailbox.
         *
         * Create a request for the method "drafts.list".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @since 1.13
         */
        protected List(java.lang.String userId) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ListDraftsResponse.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public List setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** Include drafts from `SPAM` and `TRASH` in the results. */
        @com.google.api.client.util.Key
        private java.lang.Boolean includeSpamTrash;

        /** Include drafts from `SPAM` and `TRASH` in the results. [default: false]
         */
        public java.lang.Boolean getIncludeSpamTrash() {
          return includeSpamTrash;
        }

        /** Include drafts from `SPAM` and `TRASH` in the results. */
        public List setIncludeSpamTrash(java.lang.Boolean includeSpamTrash) {
          this.includeSpamTrash = includeSpamTrash;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Include drafts from `SPAM` and `TRASH` in the results.
         * </p>
         */
        public boolean isIncludeSpamTrash() {
          if (includeSpamTrash == null || includeSpamTrash == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return includeSpamTrash;
        }

        /**
         * Maximum number of drafts to return. This field defaults to 100. The maximum allowed value
         * for this field is 500.
         */
        @com.google.api.client.util.Key
        private java.lang.Long maxResults;

        /** Maximum number of drafts to return. This field defaults to 100. The maximum allowed value for this
       field is 500. [default: 100]
         */
        public java.lang.Long getMaxResults() {
          return maxResults;
        }

        /**
         * Maximum number of drafts to return. This field defaults to 100. The maximum allowed value
         * for this field is 500.
         */
        public List setMaxResults(java.lang.Long maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /** Page token to retrieve a specific page of results in the list. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Page token to retrieve a specific page of results in the list.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** Page token to retrieve a specific page of results in the list. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * Only return draft messages matching the specified query. Supports the same query format
         * as the Gmail search box. For example, `"from:someuser@example.com rfc822msgid:
         * is:unread"`.
         */
        @com.google.api.client.util.Key
        private java.lang.String q;

        /** Only return draft messages matching the specified query. Supports the same query format as the
       Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
         */
        public java.lang.String getQ() {
          return q;
        }

        /**
         * Only return draft messages matching the specified query. Supports the same query format
         * as the Gmail search box. For example, `"from:someuser@example.com rfc822msgid:
         * is:unread"`.
         */
        public List setQ(java.lang.String q) {
          this.q = q;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Sends the specified, existing draft to the recipients in the `To`, `Cc`, and `Bcc` headers.
       *
       * Create a request for the method "drafts.send".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Send#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Draft}
       * @return the request
       */
      public Send send(java.lang.String userId, com.google.api.services.gmail.model.Draft content) throws java.io.IOException {
        Send result = new Send(userId, content);
        initialize(result);
        return result;
      }

      /**
       * Sends the specified, existing draft to the recipients in the `To`, `Cc`, and `Bcc` headers.
       *
       * Create a request for the method "drafts.send".
       *
       * This request holds the parameters needed by the the gmail server.  After setting any optional
       * parameters, call the {@link Send#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Draft} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Send send(java.lang.String userId, com.google.api.services.gmail.model.Draft content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Send result = new Send(userId, content, mediaContent);
        initialize(result);
        return result;
      }

      public class Send extends GmailRequest<com.google.api.services.gmail.model.Message> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/drafts/send";

        /**
         * Sends the specified, existing draft to the recipients in the `To`, `Cc`, and `Bcc` headers.
         *
         * Create a request for the method "drafts.send".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Send#execute()} method to invoke the remote operation. <p> {@link
         * Send#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Draft}
         * @since 1.13
         */
        protected Send(java.lang.String userId, com.google.api.services.gmail.model.Draft content) {
          super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        /**
         * Sends the specified, existing draft to the recipients in the `To`, `Cc`, and `Bcc` headers.
         *
         * Create a request for the method "drafts.send".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Send#execute()} method to invoke the remote operation. <p> {@link
         * Send#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Draft} media metadata or {@code null} if none
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Send(java.lang.String userId, com.google.api.services.gmail.model.Draft content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(Gmail.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Send set$Xgafv(java.lang.String $Xgafv) {
          return (Send) super.set$Xgafv($Xgafv);
        }

        @Override
        public Send setAccessToken(java.lang.String accessToken) {
          return (Send) super.setAccessToken(accessToken);
        }

        @Override
        public Send setAlt(java.lang.String alt) {
          return (Send) super.setAlt(alt);
        }

        @Override
        public Send setCallback(java.lang.String callback) {
          return (Send) super.setCallback(callback);
        }

        @Override
        public Send setFields(java.lang.String fields) {
          return (Send) super.setFields(fields);
        }

        @Override
        public Send setKey(java.lang.String key) {
          return (Send) super.setKey(key);
        }

        @Override
        public Send setOauthToken(java.lang.String oauthToken) {
          return (Send) super.setOauthToken(oauthToken);
        }

        @Override
        public Send setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Send) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Send setQuotaUser(java.lang.String quotaUser) {
          return (Send) super.setQuotaUser(quotaUser);
        }

        @Override
        public Send setUploadType(java.lang.String uploadType) {
          return (Send) super.setUploadType(uploadType);
        }

        @Override
        public Send setUploadProtocol(java.lang.String uploadProtocol) {
          return (Send) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Send setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public Send set(String parameterName, Object value) {
          return (Send) super.set(parameterName, value);
        }
      }
      /**
       * Replaces a draft's content.
       *
       * Create a request for the method "drafts.update".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the draft to update.
       * @param content the {@link com.google.api.services.gmail.model.Draft}
       * @return the request
       */
      public Update update(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.Draft content) throws java.io.IOException {
        Update result = new Update(userId, id, content);
        initialize(result);
        return result;
      }

      /**
       * Replaces a draft's content.
       *
       * Create a request for the method "drafts.update".
       *
       * This request holds the parameters needed by the the gmail server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]@param id The ID of the draft to update.
       * @param content the {@link com.google.api.services.gmail.model.Draft} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Update update(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.Draft content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Update result = new Update(userId, id, content, mediaContent);
        initialize(result);
        return result;
      }

      public class Update extends GmailRequest<com.google.api.services.gmail.model.Draft> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/drafts/{id}";

        /**
         * Replaces a draft's content.
         *
         * Create a request for the method "drafts.update".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the draft to update.
         * @param content the {@link com.google.api.services.gmail.model.Draft}
         * @since 1.13
         */
        protected Update(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.Draft content) {
          super(Gmail.this, "PUT", REST_PATH, content, com.google.api.services.gmail.model.Draft.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        /**
         * Replaces a draft's content.
         *
         * Create a request for the method "drafts.update".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]@param id The ID of the draft to update.
         * @param content the {@link com.google.api.services.gmail.model.Draft} media metadata or {@code null} if none
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Update(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.Draft content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(Gmail.this, "PUT", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.gmail.model.Draft.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Update setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the draft to update. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the draft to update.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the draft to update. */
        public Update setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the History collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Gmail gmail = new Gmail(...);}
     *   {@code Gmail.History.List request = gmail.history().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public History history() {
      return new History();
    }

    /**
     * The "history" collection of methods.
     */
    public class History {

      /**
       * Lists the history of all changes to the given mailbox. History results are returned in
       * chronological order (increasing `historyId`).
       *
       * Create a request for the method "history.list".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @return the request
       */
      public List list(java.lang.String userId) throws java.io.IOException {
        List result = new List(userId);
        initialize(result);
        return result;
      }

      public class List extends GmailRequest<com.google.api.services.gmail.model.ListHistoryResponse> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/history";

        /**
         * Lists the history of all changes to the given mailbox. History results are returned in
         * chronological order (increasing `historyId`).
         *
         * Create a request for the method "history.list".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @since 1.13
         */
        protected List(java.lang.String userId) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ListHistoryResponse.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public List setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** History types to be returned by the function */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> historyTypes;

        /** History types to be returned by the function
         */
        public java.util.List<java.lang.String> getHistoryTypes() {
          return historyTypes;
        }

        /** History types to be returned by the function */
        public List setHistoryTypes(java.util.List<java.lang.String> historyTypes) {
          this.historyTypes = historyTypes;
          return this;
        }

        /** Only return messages with a label matching the ID. */
        @com.google.api.client.util.Key
        private java.lang.String labelId;

        /** Only return messages with a label matching the ID.
         */
        public java.lang.String getLabelId() {
          return labelId;
        }

        /** Only return messages with a label matching the ID. */
        public List setLabelId(java.lang.String labelId) {
          this.labelId = labelId;
          return this;
        }

        /**
         * Maximum number of history records to return. This field defaults to 100. The maximum
         * allowed value for this field is 500.
         */
        @com.google.api.client.util.Key
        private java.lang.Long maxResults;

        /** Maximum number of history records to return. This field defaults to 100. The maximum allowed value
       for this field is 500. [default: 100]
         */
        public java.lang.Long getMaxResults() {
          return maxResults;
        }

        /**
         * Maximum number of history records to return. This field defaults to 100. The maximum
         * allowed value for this field is 500.
         */
        public List setMaxResults(java.lang.Long maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /** Page token to retrieve a specific page of results in the list. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Page token to retrieve a specific page of results in the list.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** Page token to retrieve a specific page of results in the list. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * Required. Returns history records after the specified `startHistoryId`. The supplied
         * `startHistoryId` should be obtained from the `historyId` of a message, thread, or
         * previous `list` response. History IDs increase chronologically but are not contiguous
         * with random gaps in between valid IDs. Supplying an invalid or out of date
         * `startHistoryId` typically returns an `HTTP 404` error code. A `historyId` is typically
         * valid for at least a week, but in some rare circumstances may be valid for only a few
         * hours. If you receive an `HTTP 404` error response, your application should perform a
         * full sync. If you receive no `nextPageToken` in the response, there are no updates to
         * retrieve and you can store the returned `historyId` for a future request.
         */
        @com.google.api.client.util.Key
        private java.math.BigInteger startHistoryId;

        /** Required. Returns history records after the specified `startHistoryId`. The supplied
       `startHistoryId` should be obtained from the `historyId` of a message, thread, or previous `list`
       response. History IDs increase chronologically but are not contiguous with random gaps in between
       valid IDs. Supplying an invalid or out of date `startHistoryId` typically returns an `HTTP 404`
       error code. A `historyId` is typically valid for at least a week, but in some rare circumstances
       may be valid for only a few hours. If you receive an `HTTP 404` error response, your application
       should perform a full sync. If you receive no `nextPageToken` in the response, there are no updates
       to retrieve and you can store the returned `historyId` for a future request.
         */
        public java.math.BigInteger getStartHistoryId() {
          return startHistoryId;
        }

        /**
         * Required. Returns history records after the specified `startHistoryId`. The supplied
         * `startHistoryId` should be obtained from the `historyId` of a message, thread, or
         * previous `list` response. History IDs increase chronologically but are not contiguous
         * with random gaps in between valid IDs. Supplying an invalid or out of date
         * `startHistoryId` typically returns an `HTTP 404` error code. A `historyId` is typically
         * valid for at least a week, but in some rare circumstances may be valid for only a few
         * hours. If you receive an `HTTP 404` error response, your application should perform a
         * full sync. If you receive no `nextPageToken` in the response, there are no updates to
         * retrieve and you can store the returned `historyId` for a future request.
         */
        public List setStartHistoryId(java.math.BigInteger startHistoryId) {
          this.startHistoryId = startHistoryId;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Labels collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Gmail gmail = new Gmail(...);}
     *   {@code Gmail.Labels.List request = gmail.labels().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Labels labels() {
      return new Labels();
    }

    /**
     * The "labels" collection of methods.
     */
    public class Labels {

      /**
       * Creates a new label.
       *
       * Create a request for the method "labels.create".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Label}
       * @return the request
       */
      public Create create(java.lang.String userId, com.google.api.services.gmail.model.Label content) throws java.io.IOException {
        Create result = new Create(userId, content);
        initialize(result);
        return result;
      }

      public class Create extends GmailRequest<com.google.api.services.gmail.model.Label> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/labels";

        /**
         * Creates a new label.
         *
         * Create a request for the method "labels.create".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Label}
         * @since 1.13
         */
        protected Create(java.lang.String userId, com.google.api.services.gmail.model.Label content) {
          super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.Label.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getLabelListVisibility(), "Label.getLabelListVisibility()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getMessageListVisibility(), "Label.getMessageListVisibility()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "Label.getName()");
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Create setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Immediately and permanently deletes the specified label and removes it from any messages and
       * threads that it is applied to.
       *
       * Create a request for the method "labels.delete".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the label to delete.
       * @return the request
       */
      public Delete delete(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Delete result = new Delete(userId, id);
        initialize(result);
        return result;
      }

      public class Delete extends GmailRequest<Void> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/labels/{id}";

        /**
         * Immediately and permanently deletes the specified label and removes it from any messages and
         * threads that it is applied to.
         *
         * Create a request for the method "labels.delete".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the label to delete.
         * @since 1.13
         */
        protected Delete(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Delete setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the label to delete. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the label to delete.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the label to delete. */
        public Delete setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the specified label.
       *
       * Create a request for the method "labels.get".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the label to retrieve.
       * @return the request
       */
      public Get get(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Get result = new Get(userId, id);
        initialize(result);
        return result;
      }

      public class Get extends GmailRequest<com.google.api.services.gmail.model.Label> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/labels/{id}";

        /**
         * Gets the specified label.
         *
         * Create a request for the method "labels.get".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the label to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.Label.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Get setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the label to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the label to retrieve.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the label to retrieve. */
        public Get setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists all labels in the user's mailbox.
       *
       * Create a request for the method "labels.list".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @return the request
       */
      public List list(java.lang.String userId) throws java.io.IOException {
        List result = new List(userId);
        initialize(result);
        return result;
      }

      public class List extends GmailRequest<com.google.api.services.gmail.model.ListLabelsResponse> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/labels";

        /**
         * Lists all labels in the user's mailbox.
         *
         * Create a request for the method "labels.list".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @since 1.13
         */
        protected List(java.lang.String userId) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ListLabelsResponse.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public List setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Patch the specified label.
       *
       * Create a request for the method "labels.patch".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the label to update.
       * @param content the {@link com.google.api.services.gmail.model.Label}
       * @return the request
       */
      public Patch patch(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.Label content) throws java.io.IOException {
        Patch result = new Patch(userId, id, content);
        initialize(result);
        return result;
      }

      public class Patch extends GmailRequest<com.google.api.services.gmail.model.Label> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/labels/{id}";

        /**
         * Patch the specified label.
         *
         * Create a request for the method "labels.patch".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the label to update.
         * @param content the {@link com.google.api.services.gmail.model.Label}
         * @since 1.13
         */
        protected Patch(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.Label content) {
          super(Gmail.this, "PATCH", REST_PATH, content, com.google.api.services.gmail.model.Label.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Patch setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the label to update. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the label to update.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the label to update. */
        public Patch setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Updates the specified label.
       *
       * Create a request for the method "labels.update".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the label to update.
       * @param content the {@link com.google.api.services.gmail.model.Label}
       * @return the request
       */
      public Update update(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.Label content) throws java.io.IOException {
        Update result = new Update(userId, id, content);
        initialize(result);
        return result;
      }

      public class Update extends GmailRequest<com.google.api.services.gmail.model.Label> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/labels/{id}";

        /**
         * Updates the specified label.
         *
         * Create a request for the method "labels.update".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the label to update.
         * @param content the {@link com.google.api.services.gmail.model.Label}
         * @since 1.13
         */
        protected Update(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.Label content) {
          super(Gmail.this, "PUT", REST_PATH, content, com.google.api.services.gmail.model.Label.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getId(), "Label.getId()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getLabelListVisibility(), "Label.getLabelListVisibility()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getMessageListVisibility(), "Label.getMessageListVisibility()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "Label.getName()");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Update setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the label to update. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the label to update.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the label to update. */
        public Update setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Messages collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Gmail gmail = new Gmail(...);}
     *   {@code Gmail.Messages.List request = gmail.messages().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Messages messages() {
      return new Messages();
    }

    /**
     * The "messages" collection of methods.
     */
    public class Messages {

      /**
       * Deletes many messages by message ID. Provides no guarantees that messages were not already
       * deleted or even existed at all.
       *
       * Create a request for the method "messages.batchDelete".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link BatchDelete#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.BatchDeleteMessagesRequest}
       * @return the request
       */
      public BatchDelete batchDelete(java.lang.String userId, com.google.api.services.gmail.model.BatchDeleteMessagesRequest content) throws java.io.IOException {
        BatchDelete result = new BatchDelete(userId, content);
        initialize(result);
        return result;
      }

      public class BatchDelete extends GmailRequest<Void> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages/batchDelete";

        /**
         * Deletes many messages by message ID. Provides no guarantees that messages were not already
         * deleted or even existed at all.
         *
         * Create a request for the method "messages.batchDelete".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link BatchDelete#execute()} method to invoke the remote operation. <p>
         * {@link
         * BatchDelete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.BatchDeleteMessagesRequest}
         * @since 1.13
         */
        protected BatchDelete(java.lang.String userId, com.google.api.services.gmail.model.BatchDeleteMessagesRequest content) {
          super(Gmail.this, "POST", REST_PATH, content, Void.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public BatchDelete set$Xgafv(java.lang.String $Xgafv) {
          return (BatchDelete) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchDelete setAccessToken(java.lang.String accessToken) {
          return (BatchDelete) super.setAccessToken(accessToken);
        }

        @Override
        public BatchDelete setAlt(java.lang.String alt) {
          return (BatchDelete) super.setAlt(alt);
        }

        @Override
        public BatchDelete setCallback(java.lang.String callback) {
          return (BatchDelete) super.setCallback(callback);
        }

        @Override
        public BatchDelete setFields(java.lang.String fields) {
          return (BatchDelete) super.setFields(fields);
        }

        @Override
        public BatchDelete setKey(java.lang.String key) {
          return (BatchDelete) super.setKey(key);
        }

        @Override
        public BatchDelete setOauthToken(java.lang.String oauthToken) {
          return (BatchDelete) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchDelete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchDelete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchDelete setQuotaUser(java.lang.String quotaUser) {
          return (BatchDelete) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchDelete setUploadType(java.lang.String uploadType) {
          return (BatchDelete) super.setUploadType(uploadType);
        }

        @Override
        public BatchDelete setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchDelete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public BatchDelete setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public BatchDelete set(String parameterName, Object value) {
          return (BatchDelete) super.set(parameterName, value);
        }
      }
      /**
       * Modifies the labels on the specified messages.
       *
       * Create a request for the method "messages.batchModify".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link BatchModify#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.BatchModifyMessagesRequest}
       * @return the request
       */
      public BatchModify batchModify(java.lang.String userId, com.google.api.services.gmail.model.BatchModifyMessagesRequest content) throws java.io.IOException {
        BatchModify result = new BatchModify(userId, content);
        initialize(result);
        return result;
      }

      public class BatchModify extends GmailRequest<Void> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages/batchModify";

        /**
         * Modifies the labels on the specified messages.
         *
         * Create a request for the method "messages.batchModify".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link BatchModify#execute()} method to invoke the remote operation. <p>
         * {@link
         * BatchModify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.BatchModifyMessagesRequest}
         * @since 1.13
         */
        protected BatchModify(java.lang.String userId, com.google.api.services.gmail.model.BatchModifyMessagesRequest content) {
          super(Gmail.this, "POST", REST_PATH, content, Void.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public BatchModify set$Xgafv(java.lang.String $Xgafv) {
          return (BatchModify) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchModify setAccessToken(java.lang.String accessToken) {
          return (BatchModify) super.setAccessToken(accessToken);
        }

        @Override
        public BatchModify setAlt(java.lang.String alt) {
          return (BatchModify) super.setAlt(alt);
        }

        @Override
        public BatchModify setCallback(java.lang.String callback) {
          return (BatchModify) super.setCallback(callback);
        }

        @Override
        public BatchModify setFields(java.lang.String fields) {
          return (BatchModify) super.setFields(fields);
        }

        @Override
        public BatchModify setKey(java.lang.String key) {
          return (BatchModify) super.setKey(key);
        }

        @Override
        public BatchModify setOauthToken(java.lang.String oauthToken) {
          return (BatchModify) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchModify setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchModify) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchModify setQuotaUser(java.lang.String quotaUser) {
          return (BatchModify) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchModify setUploadType(java.lang.String uploadType) {
          return (BatchModify) super.setUploadType(uploadType);
        }

        @Override
        public BatchModify setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchModify) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public BatchModify setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public BatchModify set(String parameterName, Object value) {
          return (BatchModify) super.set(parameterName, value);
        }
      }
      /**
       * Immediately and permanently deletes the specified message. This operation cannot be undone.
       * Prefer `messages.trash` instead.
       *
       * Create a request for the method "messages.delete".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the message to delete.
       * @return the request
       */
      public Delete delete(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Delete result = new Delete(userId, id);
        initialize(result);
        return result;
      }

      public class Delete extends GmailRequest<Void> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages/{id}";

        /**
         * Immediately and permanently deletes the specified message. This operation cannot be undone.
         * Prefer `messages.trash` instead.
         *
         * Create a request for the method "messages.delete".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the message to delete.
         * @since 1.13
         */
        protected Delete(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Delete setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the message to delete. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the message to delete.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the message to delete. */
        public Delete setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the specified message.
       *
       * Create a request for the method "messages.get".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the message to retrieve. This ID is usually retrieved using `messages.list`. The ID is
       *        also contained in the result when a message is inserted (`messages.insert`) or imported
       *        (`messages.import`).
       * @return the request
       */
      public Get get(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Get result = new Get(userId, id);
        initialize(result);
        return result;
      }

      public class Get extends GmailRequest<com.google.api.services.gmail.model.Message> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages/{id}";

        /**
         * Gets the specified message.
         *
         * Create a request for the method "messages.get".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the message to retrieve. This ID is usually retrieved using `messages.list`. The ID is
       *        also contained in the result when a message is inserted (`messages.insert`) or imported
       *        (`messages.import`).
         * @since 1.13
         */
        protected Get(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Get setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /**
         * The ID of the message to retrieve. This ID is usually retrieved using `messages.list`.
         * The ID is also contained in the result when a message is inserted (`messages.insert`) or
         * imported (`messages.import`).
         */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the message to retrieve. This ID is usually retrieved using `messages.list`. The ID is
       also contained in the result when a message is inserted (`messages.insert`) or imported
       (`messages.import`).
         */
        public java.lang.String getId() {
          return id;
        }

        /**
         * The ID of the message to retrieve. This ID is usually retrieved using `messages.list`.
         * The ID is also contained in the result when a message is inserted (`messages.insert`) or
         * imported (`messages.import`).
         */
        public Get setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        /** The format to return the message in. */
        @com.google.api.client.util.Key
        private java.lang.String format;

        /** The format to return the message in. [default: full]
         */
        public java.lang.String getFormat() {
          return format;
        }

        /** The format to return the message in. */
        public Get setFormat(java.lang.String format) {
          this.format = format;
          return this;
        }

        /** When given and format is `METADATA`, only include headers specified. */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> metadataHeaders;

        /** When given and format is `METADATA`, only include headers specified.
         */
        public java.util.List<java.lang.String> getMetadataHeaders() {
          return metadataHeaders;
        }

        /** When given and format is `METADATA`, only include headers specified. */
        public Get setMetadataHeaders(java.util.List<java.lang.String> metadataHeaders) {
          this.metadataHeaders = metadataHeaders;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Imports a message into only this user's mailbox, with standard email delivery scanning and
       * classification similar to receiving via SMTP. This method doesn't perform SPF checks, so it might
       * not work for some spam messages, such as those attempting to perform domain spoofing. This method
       * does not send a message. Note: This function doesn't trigger forwarding rules or filters set up
       * by the user.
       *
       * Create a request for the method "messages.import".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link GmailImport#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Message}
       * @return the request
       */
      public GmailImport gmailImport(java.lang.String userId, com.google.api.services.gmail.model.Message content) throws java.io.IOException {
        GmailImport result = new GmailImport(userId, content);
        initialize(result);
        return result;
      }

      /**
       * Imports a message into only this user's mailbox, with standard email delivery scanning and
       * classification similar to receiving via SMTP. This method doesn't perform SPF checks, so it might
       * not work for some spam messages, such as those attempting to perform domain spoofing. This method
       * does not send a message. Note: This function doesn't trigger forwarding rules or filters set up
       * by the user.
       *
       * Create a request for the method "messages.import".
       *
       * This request holds the parameters needed by the the gmail server.  After setting any optional
       * parameters, call the {@link GmailImport#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Message} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public GmailImport gmailImport(java.lang.String userId, com.google.api.services.gmail.model.Message content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        GmailImport result = new GmailImport(userId, content, mediaContent);
        initialize(result);
        return result;
      }

      public class GmailImport extends GmailRequest<com.google.api.services.gmail.model.Message> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages/import";

        /**
         * Imports a message into only this user's mailbox, with standard email delivery scanning and
         * classification similar to receiving via SMTP. This method doesn't perform SPF checks, so it
         * might not work for some spam messages, such as those attempting to perform domain spoofing.
         * This method does not send a message. Note: This function doesn't trigger forwarding rules or
         * filters set up by the user.
         *
         * Create a request for the method "messages.import".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link GmailImport#execute()} method to invoke the remote operation. <p>
         * {@link
         * GmailImport#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Message}
         * @since 1.13
         */
        protected GmailImport(java.lang.String userId, com.google.api.services.gmail.model.Message content) {
          super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        /**
         * Imports a message into only this user's mailbox, with standard email delivery scanning and
         * classification similar to receiving via SMTP. This method doesn't perform SPF checks, so it
         * might not work for some spam messages, such as those attempting to perform domain spoofing.
         * This method does not send a message. Note: This function doesn't trigger forwarding rules or
         * filters set up by the user.
         *
         * Create a request for the method "messages.import".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link GmailImport#execute()} method to invoke the remote operation. <p>
         * {@link
         * GmailImport#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Message} media metadata or {@code null} if none
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected GmailImport(java.lang.String userId, com.google.api.services.gmail.model.Message content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(Gmail.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public GmailImport set$Xgafv(java.lang.String $Xgafv) {
          return (GmailImport) super.set$Xgafv($Xgafv);
        }

        @Override
        public GmailImport setAccessToken(java.lang.String accessToken) {
          return (GmailImport) super.setAccessToken(accessToken);
        }

        @Override
        public GmailImport setAlt(java.lang.String alt) {
          return (GmailImport) super.setAlt(alt);
        }

        @Override
        public GmailImport setCallback(java.lang.String callback) {
          return (GmailImport) super.setCallback(callback);
        }

        @Override
        public GmailImport setFields(java.lang.String fields) {
          return (GmailImport) super.setFields(fields);
        }

        @Override
        public GmailImport setKey(java.lang.String key) {
          return (GmailImport) super.setKey(key);
        }

        @Override
        public GmailImport setOauthToken(java.lang.String oauthToken) {
          return (GmailImport) super.setOauthToken(oauthToken);
        }

        @Override
        public GmailImport setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GmailImport) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GmailImport setQuotaUser(java.lang.String quotaUser) {
          return (GmailImport) super.setQuotaUser(quotaUser);
        }

        @Override
        public GmailImport setUploadType(java.lang.String uploadType) {
          return (GmailImport) super.setUploadType(uploadType);
        }

        @Override
        public GmailImport setUploadProtocol(java.lang.String uploadProtocol) {
          return (GmailImport) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public GmailImport setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /**
         * Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a
         * Vault administrator. Only used for G Suite accounts.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean deleted;

        /** Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a Vault
       administrator. Only used for G Suite accounts. [default: false]
         */
        public java.lang.Boolean getDeleted() {
          return deleted;
        }

        /**
         * Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a
         * Vault administrator. Only used for G Suite accounts.
         */
        public GmailImport setDeleted(java.lang.Boolean deleted) {
          this.deleted = deleted;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a Vault
       administrator. Only used for G Suite accounts.
         * </p>
         */
        public boolean isDeleted() {
          if (deleted == null || deleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return deleted;
        }

        /** Source for Gmail's internal date of the message. */
        @com.google.api.client.util.Key
        private java.lang.String internalDateSource;

        /** Source for Gmail's internal date of the message. [default: dateHeader]
         */
        public java.lang.String getInternalDateSource() {
          return internalDateSource;
        }

        /** Source for Gmail's internal date of the message. */
        public GmailImport setInternalDateSource(java.lang.String internalDateSource) {
          this.internalDateSource = internalDateSource;
          return this;
        }

        /**
         * Ignore the Gmail spam classifier decision and never mark this email as SPAM in the
         * mailbox.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean neverMarkSpam;

        /** Ignore the Gmail spam classifier decision and never mark this email as SPAM in the mailbox.
       [default: false]
         */
        public java.lang.Boolean getNeverMarkSpam() {
          return neverMarkSpam;
        }

        /**
         * Ignore the Gmail spam classifier decision and never mark this email as SPAM in the
         * mailbox.
         */
        public GmailImport setNeverMarkSpam(java.lang.Boolean neverMarkSpam) {
          this.neverMarkSpam = neverMarkSpam;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Ignore the Gmail spam classifier decision and never mark this email as SPAM in the mailbox.
         * </p>
         */
        public boolean isNeverMarkSpam() {
          if (neverMarkSpam == null || neverMarkSpam == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return neverMarkSpam;
        }

        /**
         * Process calendar invites in the email and add any extracted meetings to the Google
         * Calendar for this user.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean processForCalendar;

        /** Process calendar invites in the email and add any extracted meetings to the Google Calendar for
       this user. [default: false]
         */
        public java.lang.Boolean getProcessForCalendar() {
          return processForCalendar;
        }

        /**
         * Process calendar invites in the email and add any extracted meetings to the Google
         * Calendar for this user.
         */
        public GmailImport setProcessForCalendar(java.lang.Boolean processForCalendar) {
          this.processForCalendar = processForCalendar;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Process calendar invites in the email and add any extracted meetings to the Google Calendar for
       this user.
         * </p>
         */
        public boolean isProcessForCalendar() {
          if (processForCalendar == null || processForCalendar == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return processForCalendar;
        }

        @Override
        public GmailImport set(String parameterName, Object value) {
          return (GmailImport) super.set(parameterName, value);
        }
      }
      /**
       * Directly inserts a message into only this user's mailbox similar to `IMAP APPEND`, bypassing most
       * scanning and classification. Does not send a message.
       *
       * Create a request for the method "messages.insert".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Message}
       * @return the request
       */
      public Insert insert(java.lang.String userId, com.google.api.services.gmail.model.Message content) throws java.io.IOException {
        Insert result = new Insert(userId, content);
        initialize(result);
        return result;
      }

      /**
       * Directly inserts a message into only this user's mailbox similar to `IMAP APPEND`, bypassing most
       * scanning and classification. Does not send a message.
       *
       * Create a request for the method "messages.insert".
       *
       * This request holds the parameters needed by the the gmail server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Message} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Insert insert(java.lang.String userId, com.google.api.services.gmail.model.Message content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Insert result = new Insert(userId, content, mediaContent);
        initialize(result);
        return result;
      }

      public class Insert extends GmailRequest<com.google.api.services.gmail.model.Message> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages";

        /**
         * Directly inserts a message into only this user's mailbox similar to `IMAP APPEND`, bypassing
         * most scanning and classification. Does not send a message.
         *
         * Create a request for the method "messages.insert".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Message}
         * @since 1.13
         */
        protected Insert(java.lang.String userId, com.google.api.services.gmail.model.Message content) {
          super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getRaw(), "Message.getRaw()");
        }

        /**
         * Directly inserts a message into only this user's mailbox similar to `IMAP APPEND`, bypassing
         * most scanning and classification. Does not send a message.
         *
         * Create a request for the method "messages.insert".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
         * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Message} media metadata or {@code null} if none
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Insert(java.lang.String userId, com.google.api.services.gmail.model.Message content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(Gmail.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Insert set$Xgafv(java.lang.String $Xgafv) {
          return (Insert) super.set$Xgafv($Xgafv);
        }

        @Override
        public Insert setAccessToken(java.lang.String accessToken) {
          return (Insert) super.setAccessToken(accessToken);
        }

        @Override
        public Insert setAlt(java.lang.String alt) {
          return (Insert) super.setAlt(alt);
        }

        @Override
        public Insert setCallback(java.lang.String callback) {
          return (Insert) super.setCallback(callback);
        }

        @Override
        public Insert setFields(java.lang.String fields) {
          return (Insert) super.setFields(fields);
        }

        @Override
        public Insert setKey(java.lang.String key) {
          return (Insert) super.setKey(key);
        }

        @Override
        public Insert setOauthToken(java.lang.String oauthToken) {
          return (Insert) super.setOauthToken(oauthToken);
        }

        @Override
        public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Insert) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Insert setQuotaUser(java.lang.String quotaUser) {
          return (Insert) super.setQuotaUser(quotaUser);
        }

        @Override
        public Insert setUploadType(java.lang.String uploadType) {
          return (Insert) super.setUploadType(uploadType);
        }

        @Override
        public Insert setUploadProtocol(java.lang.String uploadProtocol) {
          return (Insert) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Insert setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /**
         * Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a
         * Vault administrator. Only used for G Suite accounts.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean deleted;

        /** Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a Vault
       administrator. Only used for G Suite accounts. [default: false]
         */
        public java.lang.Boolean getDeleted() {
          return deleted;
        }

        /**
         * Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a
         * Vault administrator. Only used for G Suite accounts.
         */
        public Insert setDeleted(java.lang.Boolean deleted) {
          this.deleted = deleted;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a Vault
       administrator. Only used for G Suite accounts.
         * </p>
         */
        public boolean isDeleted() {
          if (deleted == null || deleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return deleted;
        }

        /** Source for Gmail's internal date of the message. */
        @com.google.api.client.util.Key
        private java.lang.String internalDateSource;

        /** Source for Gmail's internal date of the message. [default: receivedTime]
         */
        public java.lang.String getInternalDateSource() {
          return internalDateSource;
        }

        /** Source for Gmail's internal date of the message. */
        public Insert setInternalDateSource(java.lang.String internalDateSource) {
          this.internalDateSource = internalDateSource;
          return this;
        }

        @Override
        public Insert set(String parameterName, Object value) {
          return (Insert) super.set(parameterName, value);
        }
      }
      /**
       * Lists the messages in the user's mailbox.
       *
       * Create a request for the method "messages.list".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @return the request
       */
      public List list(java.lang.String userId) throws java.io.IOException {
        List result = new List(userId);
        initialize(result);
        return result;
      }

      public class List extends GmailRequest<com.google.api.services.gmail.model.ListMessagesResponse> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages";

        /**
         * Lists the messages in the user's mailbox.
         *
         * Create a request for the method "messages.list".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @since 1.13
         */
        protected List(java.lang.String userId) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ListMessagesResponse.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public List setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** Include messages from `SPAM` and `TRASH` in the results. */
        @com.google.api.client.util.Key
        private java.lang.Boolean includeSpamTrash;

        /** Include messages from `SPAM` and `TRASH` in the results. [default: false]
         */
        public java.lang.Boolean getIncludeSpamTrash() {
          return includeSpamTrash;
        }

        /** Include messages from `SPAM` and `TRASH` in the results. */
        public List setIncludeSpamTrash(java.lang.Boolean includeSpamTrash) {
          this.includeSpamTrash = includeSpamTrash;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Include messages from `SPAM` and `TRASH` in the results.
         * </p>
         */
        public boolean isIncludeSpamTrash() {
          if (includeSpamTrash == null || includeSpamTrash == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return includeSpamTrash;
        }

        /** Only return messages with labels that match all of the specified label IDs. */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> labelIds;

        /** Only return messages with labels that match all of the specified label IDs.
         */
        public java.util.List<java.lang.String> getLabelIds() {
          return labelIds;
        }

        /** Only return messages with labels that match all of the specified label IDs. */
        public List setLabelIds(java.util.List<java.lang.String> labelIds) {
          this.labelIds = labelIds;
          return this;
        }

        /**
         * Maximum number of messages to return. This field defaults to 100. The maximum allowed
         * value for this field is 500.
         */
        @com.google.api.client.util.Key
        private java.lang.Long maxResults;

        /** Maximum number of messages to return. This field defaults to 100. The maximum allowed value for
       this field is 500. [default: 100]
         */
        public java.lang.Long getMaxResults() {
          return maxResults;
        }

        /**
         * Maximum number of messages to return. This field defaults to 100. The maximum allowed
         * value for this field is 500.
         */
        public List setMaxResults(java.lang.Long maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /** Page token to retrieve a specific page of results in the list. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Page token to retrieve a specific page of results in the list.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** Page token to retrieve a specific page of results in the list. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * Only return messages matching the specified query. Supports the same query format as the
         * Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
         * Parameter cannot be used when accessing the api using the gmail.metadata scope.
         */
        @com.google.api.client.util.Key
        private java.lang.String q;

        /** Only return messages matching the specified query. Supports the same query format as the Gmail
       search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`. Parameter cannot be
       used when accessing the api using the gmail.metadata scope.
         */
        public java.lang.String getQ() {
          return q;
        }

        /**
         * Only return messages matching the specified query. Supports the same query format as the
         * Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
         * Parameter cannot be used when accessing the api using the gmail.metadata scope.
         */
        public List setQ(java.lang.String q) {
          this.q = q;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Modifies the labels on the specified message.
       *
       * Create a request for the method "messages.modify".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Modify#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the message to modify.
       * @param content the {@link com.google.api.services.gmail.model.ModifyMessageRequest}
       * @return the request
       */
      public Modify modify(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.ModifyMessageRequest content) throws java.io.IOException {
        Modify result = new Modify(userId, id, content);
        initialize(result);
        return result;
      }

      public class Modify extends GmailRequest<com.google.api.services.gmail.model.Message> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages/{id}/modify";

        /**
         * Modifies the labels on the specified message.
         *
         * Create a request for the method "messages.modify".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Modify#execute()} method to invoke the remote operation. <p> {@link
         * Modify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the message to modify.
         * @param content the {@link com.google.api.services.gmail.model.ModifyMessageRequest}
         * @since 1.13
         */
        protected Modify(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.ModifyMessageRequest content) {
          super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Modify set$Xgafv(java.lang.String $Xgafv) {
          return (Modify) super.set$Xgafv($Xgafv);
        }

        @Override
        public Modify setAccessToken(java.lang.String accessToken) {
          return (Modify) super.setAccessToken(accessToken);
        }

        @Override
        public Modify setAlt(java.lang.String alt) {
          return (Modify) super.setAlt(alt);
        }

        @Override
        public Modify setCallback(java.lang.String callback) {
          return (Modify) super.setCallback(callback);
        }

        @Override
        public Modify setFields(java.lang.String fields) {
          return (Modify) super.setFields(fields);
        }

        @Override
        public Modify setKey(java.lang.String key) {
          return (Modify) super.setKey(key);
        }

        @Override
        public Modify setOauthToken(java.lang.String oauthToken) {
          return (Modify) super.setOauthToken(oauthToken);
        }

        @Override
        public Modify setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Modify) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Modify setQuotaUser(java.lang.String quotaUser) {
          return (Modify) super.setQuotaUser(quotaUser);
        }

        @Override
        public Modify setUploadType(java.lang.String uploadType) {
          return (Modify) super.setUploadType(uploadType);
        }

        @Override
        public Modify setUploadProtocol(java.lang.String uploadProtocol) {
          return (Modify) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Modify setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the message to modify. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the message to modify.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the message to modify. */
        public Modify setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Modify set(String parameterName, Object value) {
          return (Modify) super.set(parameterName, value);
        }
      }
      /**
       * Sends the specified message to the recipients in the `To`, `Cc`, and `Bcc` headers.
       *
       * Create a request for the method "messages.send".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Send#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Message}
       * @return the request
       */
      public Send send(java.lang.String userId, com.google.api.services.gmail.model.Message content) throws java.io.IOException {
        Send result = new Send(userId, content);
        initialize(result);
        return result;
      }

      /**
       * Sends the specified message to the recipients in the `To`, `Cc`, and `Bcc` headers.
       *
       * Create a request for the method "messages.send".
       *
       * This request holds the parameters needed by the the gmail server.  After setting any optional
       * parameters, call the {@link Send#execute()} method to invoke the remote operation.
       *
       * <p>
       * This method should be used for uploading media content.
       * </p>
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.Message} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @return the request
       * @throws java.io.IOException if the initialization of the request fails
       */
      public Send send(java.lang.String userId, com.google.api.services.gmail.model.Message content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
        Send result = new Send(userId, content, mediaContent);
        initialize(result);
        return result;
      }

      public class Send extends GmailRequest<com.google.api.services.gmail.model.Message> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages/send";

        /**
         * Sends the specified message to the recipients in the `To`, `Cc`, and `Bcc` headers.
         *
         * Create a request for the method "messages.send".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Send#execute()} method to invoke the remote operation. <p> {@link
         * Send#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Message}
         * @since 1.13
         */
        protected Send(java.lang.String userId, com.google.api.services.gmail.model.Message content) {
          super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getRaw(), "Message.getRaw()");
        }

        /**
         * Sends the specified message to the recipients in the `To`, `Cc`, and `Bcc` headers.
         *
         * Create a request for the method "messages.send".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Send#execute()} method to invoke the remote operation. <p> {@link
         * Send#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * <p>
         * This constructor should be used for uploading media content.
         * </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Message} media metadata or {@code null} if none
         * @param mediaContent The media HTTP content or {@code null} if none.
         * @since 1.13
         */
        protected Send(java.lang.String userId, com.google.api.services.gmail.model.Message content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
          super(Gmail.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          initializeMediaUpload(mediaContent);
        }

        @Override
        public Send set$Xgafv(java.lang.String $Xgafv) {
          return (Send) super.set$Xgafv($Xgafv);
        }

        @Override
        public Send setAccessToken(java.lang.String accessToken) {
          return (Send) super.setAccessToken(accessToken);
        }

        @Override
        public Send setAlt(java.lang.String alt) {
          return (Send) super.setAlt(alt);
        }

        @Override
        public Send setCallback(java.lang.String callback) {
          return (Send) super.setCallback(callback);
        }

        @Override
        public Send setFields(java.lang.String fields) {
          return (Send) super.setFields(fields);
        }

        @Override
        public Send setKey(java.lang.String key) {
          return (Send) super.setKey(key);
        }

        @Override
        public Send setOauthToken(java.lang.String oauthToken) {
          return (Send) super.setOauthToken(oauthToken);
        }

        @Override
        public Send setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Send) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Send setQuotaUser(java.lang.String quotaUser) {
          return (Send) super.setQuotaUser(quotaUser);
        }

        @Override
        public Send setUploadType(java.lang.String uploadType) {
          return (Send) super.setUploadType(uploadType);
        }

        @Override
        public Send setUploadProtocol(java.lang.String uploadProtocol) {
          return (Send) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Send setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public Send set(String parameterName, Object value) {
          return (Send) super.set(parameterName, value);
        }
      }
      /**
       * Moves the specified message to the trash.
       *
       * Create a request for the method "messages.trash".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Trash#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the message to Trash.
       * @return the request
       */
      public Trash trash(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Trash result = new Trash(userId, id);
        initialize(result);
        return result;
      }

      public class Trash extends GmailRequest<com.google.api.services.gmail.model.Message> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages/{id}/trash";

        /**
         * Moves the specified message to the trash.
         *
         * Create a request for the method "messages.trash".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Trash#execute()} method to invoke the remote operation. <p> {@link
         * Trash#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the message to Trash.
         * @since 1.13
         */
        protected Trash(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "POST", REST_PATH, null, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Trash set$Xgafv(java.lang.String $Xgafv) {
          return (Trash) super.set$Xgafv($Xgafv);
        }

        @Override
        public Trash setAccessToken(java.lang.String accessToken) {
          return (Trash) super.setAccessToken(accessToken);
        }

        @Override
        public Trash setAlt(java.lang.String alt) {
          return (Trash) super.setAlt(alt);
        }

        @Override
        public Trash setCallback(java.lang.String callback) {
          return (Trash) super.setCallback(callback);
        }

        @Override
        public Trash setFields(java.lang.String fields) {
          return (Trash) super.setFields(fields);
        }

        @Override
        public Trash setKey(java.lang.String key) {
          return (Trash) super.setKey(key);
        }

        @Override
        public Trash setOauthToken(java.lang.String oauthToken) {
          return (Trash) super.setOauthToken(oauthToken);
        }

        @Override
        public Trash setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Trash) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Trash setQuotaUser(java.lang.String quotaUser) {
          return (Trash) super.setQuotaUser(quotaUser);
        }

        @Override
        public Trash setUploadType(java.lang.String uploadType) {
          return (Trash) super.setUploadType(uploadType);
        }

        @Override
        public Trash setUploadProtocol(java.lang.String uploadProtocol) {
          return (Trash) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Trash setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the message to Trash. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the message to Trash.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the message to Trash. */
        public Trash setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Trash set(String parameterName, Object value) {
          return (Trash) super.set(parameterName, value);
        }
      }
      /**
       * Removes the specified message from the trash.
       *
       * Create a request for the method "messages.untrash".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Untrash#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the message to remove from Trash.
       * @return the request
       */
      public Untrash untrash(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Untrash result = new Untrash(userId, id);
        initialize(result);
        return result;
      }

      public class Untrash extends GmailRequest<com.google.api.services.gmail.model.Message> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/messages/{id}/untrash";

        /**
         * Removes the specified message from the trash.
         *
         * Create a request for the method "messages.untrash".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Untrash#execute()} method to invoke the remote operation. <p>
         * {@link
         * Untrash#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the message to remove from Trash.
         * @since 1.13
         */
        protected Untrash(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "POST", REST_PATH, null, com.google.api.services.gmail.model.Message.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Untrash set$Xgafv(java.lang.String $Xgafv) {
          return (Untrash) super.set$Xgafv($Xgafv);
        }

        @Override
        public Untrash setAccessToken(java.lang.String accessToken) {
          return (Untrash) super.setAccessToken(accessToken);
        }

        @Override
        public Untrash setAlt(java.lang.String alt) {
          return (Untrash) super.setAlt(alt);
        }

        @Override
        public Untrash setCallback(java.lang.String callback) {
          return (Untrash) super.setCallback(callback);
        }

        @Override
        public Untrash setFields(java.lang.String fields) {
          return (Untrash) super.setFields(fields);
        }

        @Override
        public Untrash setKey(java.lang.String key) {
          return (Untrash) super.setKey(key);
        }

        @Override
        public Untrash setOauthToken(java.lang.String oauthToken) {
          return (Untrash) super.setOauthToken(oauthToken);
        }

        @Override
        public Untrash setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Untrash) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Untrash setQuotaUser(java.lang.String quotaUser) {
          return (Untrash) super.setQuotaUser(quotaUser);
        }

        @Override
        public Untrash setUploadType(java.lang.String uploadType) {
          return (Untrash) super.setUploadType(uploadType);
        }

        @Override
        public Untrash setUploadProtocol(java.lang.String uploadProtocol) {
          return (Untrash) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Untrash setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the message to remove from Trash. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the message to remove from Trash.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the message to remove from Trash. */
        public Untrash setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Untrash set(String parameterName, Object value) {
          return (Untrash) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Attachments collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Gmail gmail = new Gmail(...);}
       *   {@code Gmail.Attachments.List request = gmail.attachments().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Attachments attachments() {
        return new Attachments();
      }

      /**
       * The "attachments" collection of methods.
       */
      public class Attachments {

        /**
         * Gets the specified message attachment.
         *
         * Create a request for the method "attachments.get".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
         *        [default: me]
         * @param messageId The ID of the message containing the attachment.
         * @param id The ID of the attachment.
         * @return the request
         */
        public Get get(java.lang.String userId, java.lang.String messageId, java.lang.String id) throws java.io.IOException {
          Get result = new Get(userId, messageId, id);
          initialize(result);
          return result;
        }

        public class Get extends GmailRequest<com.google.api.services.gmail.model.MessagePartBody> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/messages/{messageId}/attachments/{id}";

          /**
           * Gets the specified message attachment.
           *
           * Create a request for the method "attachments.get".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
         *        [default: me]
           * @param messageId The ID of the message containing the attachment.
           * @param id The ID of the attachment.
           * @since 1.13
           */
          protected Get(java.lang.String userId, java.lang.String messageId, java.lang.String id) {
            super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.MessagePartBody.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.messageId = com.google.api.client.util.Preconditions.checkNotNull(messageId, "Required parameter messageId must be specified.");
            this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The user's email address. The special value `me` can be used to indicate the
           * authenticated user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** The user's email address. The special value `me` can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * The user's email address. The special value `me` can be used to indicate the
           * authenticated user.
           */
          public Get setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The ID of the message containing the attachment. */
          @com.google.api.client.util.Key
          private java.lang.String messageId;

          /** The ID of the message containing the attachment.
           */
          public java.lang.String getMessageId() {
            return messageId;
          }

          /** The ID of the message containing the attachment. */
          public Get setMessageId(java.lang.String messageId) {
            this.messageId = messageId;
            return this;
          }

          /** The ID of the attachment. */
          @com.google.api.client.util.Key
          private java.lang.String id;

          /** The ID of the attachment.
           */
          public java.lang.String getId() {
            return id;
          }

          /** The ID of the attachment. */
          public Get setId(java.lang.String id) {
            this.id = id;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }

      }
    }
    /**
     * An accessor for creating requests from the Settings collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Gmail gmail = new Gmail(...);}
     *   {@code Gmail.Settings.List request = gmail.settings().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Settings settings() {
      return new Settings();
    }

    /**
     * The "settings" collection of methods.
     */
    public class Settings {

      /**
       * Gets the auto-forwarding setting for the specified account.
       *
       * Create a request for the method "settings.getAutoForwarding".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link GetAutoForwarding#execute()} method to invoke the remote operation.
       *
       * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
       * @return the request
       */
      public GetAutoForwarding getAutoForwarding(java.lang.String userId) throws java.io.IOException {
        GetAutoForwarding result = new GetAutoForwarding(userId);
        initialize(result);
        return result;
      }

      public class GetAutoForwarding extends GmailRequest<com.google.api.services.gmail.model.AutoForwarding> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/settings/autoForwarding";

        /**
         * Gets the auto-forwarding setting for the specified account.
         *
         * Create a request for the method "settings.getAutoForwarding".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link GetAutoForwarding#execute()} method to invoke the remote operation.
         * <p> {@link GetAutoForwarding#initialize(com.google.api.client.googleapis.services.AbstractGoogl
         * eClientRequest)} must be called to initialize this instance immediately after invoking the
         * constructor. </p>
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
         * @since 1.13
         */
        protected GetAutoForwarding(java.lang.String userId) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.AutoForwarding.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetAutoForwarding set$Xgafv(java.lang.String $Xgafv) {
          return (GetAutoForwarding) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetAutoForwarding setAccessToken(java.lang.String accessToken) {
          return (GetAutoForwarding) super.setAccessToken(accessToken);
        }

        @Override
        public GetAutoForwarding setAlt(java.lang.String alt) {
          return (GetAutoForwarding) super.setAlt(alt);
        }

        @Override
        public GetAutoForwarding setCallback(java.lang.String callback) {
          return (GetAutoForwarding) super.setCallback(callback);
        }

        @Override
        public GetAutoForwarding setFields(java.lang.String fields) {
          return (GetAutoForwarding) super.setFields(fields);
        }

        @Override
        public GetAutoForwarding setKey(java.lang.String key) {
          return (GetAutoForwarding) super.setKey(key);
        }

        @Override
        public GetAutoForwarding setOauthToken(java.lang.String oauthToken) {
          return (GetAutoForwarding) super.setOauthToken(oauthToken);
        }

        @Override
        public GetAutoForwarding setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetAutoForwarding) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetAutoForwarding setQuotaUser(java.lang.String quotaUser) {
          return (GetAutoForwarding) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetAutoForwarding setUploadType(java.lang.String uploadType) {
          return (GetAutoForwarding) super.setUploadType(uploadType);
        }

        @Override
        public GetAutoForwarding setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetAutoForwarding) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** User's email address. The special value "me" can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        public GetAutoForwarding setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public GetAutoForwarding set(String parameterName, Object value) {
          return (GetAutoForwarding) super.set(parameterName, value);
        }
      }
      /**
       * Gets IMAP settings.
       *
       * Create a request for the method "settings.getImap".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link GetImap#execute()} method to invoke the remote operation.
       *
       * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
       * @return the request
       */
      public GetImap getImap(java.lang.String userId) throws java.io.IOException {
        GetImap result = new GetImap(userId);
        initialize(result);
        return result;
      }

      public class GetImap extends GmailRequest<com.google.api.services.gmail.model.ImapSettings> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/settings/imap";

        /**
         * Gets IMAP settings.
         *
         * Create a request for the method "settings.getImap".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link GetImap#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetImap#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
         * @since 1.13
         */
        protected GetImap(java.lang.String userId) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ImapSettings.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetImap set$Xgafv(java.lang.String $Xgafv) {
          return (GetImap) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetImap setAccessToken(java.lang.String accessToken) {
          return (GetImap) super.setAccessToken(accessToken);
        }

        @Override
        public GetImap setAlt(java.lang.String alt) {
          return (GetImap) super.setAlt(alt);
        }

        @Override
        public GetImap setCallback(java.lang.String callback) {
          return (GetImap) super.setCallback(callback);
        }

        @Override
        public GetImap setFields(java.lang.String fields) {
          return (GetImap) super.setFields(fields);
        }

        @Override
        public GetImap setKey(java.lang.String key) {
          return (GetImap) super.setKey(key);
        }

        @Override
        public GetImap setOauthToken(java.lang.String oauthToken) {
          return (GetImap) super.setOauthToken(oauthToken);
        }

        @Override
        public GetImap setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetImap) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetImap setQuotaUser(java.lang.String quotaUser) {
          return (GetImap) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetImap setUploadType(java.lang.String uploadType) {
          return (GetImap) super.setUploadType(uploadType);
        }

        @Override
        public GetImap setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetImap) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** User's email address. The special value "me" can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        public GetImap setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public GetImap set(String parameterName, Object value) {
          return (GetImap) super.set(parameterName, value);
        }
      }
      /**
       * Gets language settings.
       *
       * Create a request for the method "settings.getLanguage".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link GetLanguage#execute()} method to invoke the remote operation.
       *
       * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
       * @return the request
       */
      public GetLanguage getLanguage(java.lang.String userId) throws java.io.IOException {
        GetLanguage result = new GetLanguage(userId);
        initialize(result);
        return result;
      }

      public class GetLanguage extends GmailRequest<com.google.api.services.gmail.model.LanguageSettings> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/settings/language";

        /**
         * Gets language settings.
         *
         * Create a request for the method "settings.getLanguage".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link GetLanguage#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetLanguage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
         * @since 1.13
         */
        protected GetLanguage(java.lang.String userId) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.LanguageSettings.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetLanguage set$Xgafv(java.lang.String $Xgafv) {
          return (GetLanguage) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetLanguage setAccessToken(java.lang.String accessToken) {
          return (GetLanguage) super.setAccessToken(accessToken);
        }

        @Override
        public GetLanguage setAlt(java.lang.String alt) {
          return (GetLanguage) super.setAlt(alt);
        }

        @Override
        public GetLanguage setCallback(java.lang.String callback) {
          return (GetLanguage) super.setCallback(callback);
        }

        @Override
        public GetLanguage setFields(java.lang.String fields) {
          return (GetLanguage) super.setFields(fields);
        }

        @Override
        public GetLanguage setKey(java.lang.String key) {
          return (GetLanguage) super.setKey(key);
        }

        @Override
        public GetLanguage setOauthToken(java.lang.String oauthToken) {
          return (GetLanguage) super.setOauthToken(oauthToken);
        }

        @Override
        public GetLanguage setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetLanguage) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetLanguage setQuotaUser(java.lang.String quotaUser) {
          return (GetLanguage) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetLanguage setUploadType(java.lang.String uploadType) {
          return (GetLanguage) super.setUploadType(uploadType);
        }

        @Override
        public GetLanguage setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetLanguage) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** User's email address. The special value "me" can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        public GetLanguage setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public GetLanguage set(String parameterName, Object value) {
          return (GetLanguage) super.set(parameterName, value);
        }
      }
      /**
       * Gets POP settings.
       *
       * Create a request for the method "settings.getPop".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link GetPop#execute()} method to invoke the remote operation.
       *
       * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
       * @return the request
       */
      public GetPop getPop(java.lang.String userId) throws java.io.IOException {
        GetPop result = new GetPop(userId);
        initialize(result);
        return result;
      }

      public class GetPop extends GmailRequest<com.google.api.services.gmail.model.PopSettings> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/settings/pop";

        /**
         * Gets POP settings.
         *
         * Create a request for the method "settings.getPop".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link GetPop#execute()} method to invoke the remote operation. <p> {@link
         * GetPop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
         * @since 1.13
         */
        protected GetPop(java.lang.String userId) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.PopSettings.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetPop set$Xgafv(java.lang.String $Xgafv) {
          return (GetPop) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetPop setAccessToken(java.lang.String accessToken) {
          return (GetPop) super.setAccessToken(accessToken);
        }

        @Override
        public GetPop setAlt(java.lang.String alt) {
          return (GetPop) super.setAlt(alt);
        }

        @Override
        public GetPop setCallback(java.lang.String callback) {
          return (GetPop) super.setCallback(callback);
        }

        @Override
        public GetPop setFields(java.lang.String fields) {
          return (GetPop) super.setFields(fields);
        }

        @Override
        public GetPop setKey(java.lang.String key) {
          return (GetPop) super.setKey(key);
        }

        @Override
        public GetPop setOauthToken(java.lang.String oauthToken) {
          return (GetPop) super.setOauthToken(oauthToken);
        }

        @Override
        public GetPop setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetPop) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetPop setQuotaUser(java.lang.String quotaUser) {
          return (GetPop) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetPop setUploadType(java.lang.String uploadType) {
          return (GetPop) super.setUploadType(uploadType);
        }

        @Override
        public GetPop setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetPop) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** User's email address. The special value "me" can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        public GetPop setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public GetPop set(String parameterName, Object value) {
          return (GetPop) super.set(parameterName, value);
        }
      }
      /**
       * Gets vacation responder settings.
       *
       * Create a request for the method "settings.getVacation".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link GetVacation#execute()} method to invoke the remote operation.
       *
       * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
       * @return the request
       */
      public GetVacation getVacation(java.lang.String userId) throws java.io.IOException {
        GetVacation result = new GetVacation(userId);
        initialize(result);
        return result;
      }

      public class GetVacation extends GmailRequest<com.google.api.services.gmail.model.VacationSettings> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/settings/vacation";

        /**
         * Gets vacation responder settings.
         *
         * Create a request for the method "settings.getVacation".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link GetVacation#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetVacation#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
         * @since 1.13
         */
        protected GetVacation(java.lang.String userId) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.VacationSettings.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetVacation set$Xgafv(java.lang.String $Xgafv) {
          return (GetVacation) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetVacation setAccessToken(java.lang.String accessToken) {
          return (GetVacation) super.setAccessToken(accessToken);
        }

        @Override
        public GetVacation setAlt(java.lang.String alt) {
          return (GetVacation) super.setAlt(alt);
        }

        @Override
        public GetVacation setCallback(java.lang.String callback) {
          return (GetVacation) super.setCallback(callback);
        }

        @Override
        public GetVacation setFields(java.lang.String fields) {
          return (GetVacation) super.setFields(fields);
        }

        @Override
        public GetVacation setKey(java.lang.String key) {
          return (GetVacation) super.setKey(key);
        }

        @Override
        public GetVacation setOauthToken(java.lang.String oauthToken) {
          return (GetVacation) super.setOauthToken(oauthToken);
        }

        @Override
        public GetVacation setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetVacation) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetVacation setQuotaUser(java.lang.String quotaUser) {
          return (GetVacation) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetVacation setUploadType(java.lang.String uploadType) {
          return (GetVacation) super.setUploadType(uploadType);
        }

        @Override
        public GetVacation setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetVacation) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** User's email address. The special value "me" can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        public GetVacation setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public GetVacation set(String parameterName, Object value) {
          return (GetVacation) super.set(parameterName, value);
        }
      }
      /**
       * Updates the auto-forwarding setting for the specified account. A verified forwarding address must
       * be specified when auto-forwarding is enabled. This method is only available to service account
       * clients that have been delegated domain-wide authority.
       *
       * Create a request for the method "settings.updateAutoForwarding".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link UpdateAutoForwarding#execute()} method to invoke the remote
       * operation.
       *
       * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.AutoForwarding}
       * @return the request
       */
      public UpdateAutoForwarding updateAutoForwarding(java.lang.String userId, com.google.api.services.gmail.model.AutoForwarding content) throws java.io.IOException {
        UpdateAutoForwarding result = new UpdateAutoForwarding(userId, content);
        initialize(result);
        return result;
      }

      public class UpdateAutoForwarding extends GmailRequest<com.google.api.services.gmail.model.AutoForwarding> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/settings/autoForwarding";

        /**
         * Updates the auto-forwarding setting for the specified account. A verified forwarding address
         * must be specified when auto-forwarding is enabled. This method is only available to service
         * account clients that have been delegated domain-wide authority.
         *
         * Create a request for the method "settings.updateAutoForwarding".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link UpdateAutoForwarding#execute()} method to invoke the remote
         * operation. <p> {@link UpdateAutoForwarding#initialize(com.google.api.client.googleapis.services
         * .AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.AutoForwarding}
         * @since 1.13
         */
        protected UpdateAutoForwarding(java.lang.String userId, com.google.api.services.gmail.model.AutoForwarding content) {
          super(Gmail.this, "PUT", REST_PATH, content, com.google.api.services.gmail.model.AutoForwarding.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public UpdateAutoForwarding set$Xgafv(java.lang.String $Xgafv) {
          return (UpdateAutoForwarding) super.set$Xgafv($Xgafv);
        }

        @Override
        public UpdateAutoForwarding setAccessToken(java.lang.String accessToken) {
          return (UpdateAutoForwarding) super.setAccessToken(accessToken);
        }

        @Override
        public UpdateAutoForwarding setAlt(java.lang.String alt) {
          return (UpdateAutoForwarding) super.setAlt(alt);
        }

        @Override
        public UpdateAutoForwarding setCallback(java.lang.String callback) {
          return (UpdateAutoForwarding) super.setCallback(callback);
        }

        @Override
        public UpdateAutoForwarding setFields(java.lang.String fields) {
          return (UpdateAutoForwarding) super.setFields(fields);
        }

        @Override
        public UpdateAutoForwarding setKey(java.lang.String key) {
          return (UpdateAutoForwarding) super.setKey(key);
        }

        @Override
        public UpdateAutoForwarding setOauthToken(java.lang.String oauthToken) {
          return (UpdateAutoForwarding) super.setOauthToken(oauthToken);
        }

        @Override
        public UpdateAutoForwarding setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UpdateAutoForwarding) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UpdateAutoForwarding setQuotaUser(java.lang.String quotaUser) {
          return (UpdateAutoForwarding) super.setQuotaUser(quotaUser);
        }

        @Override
        public UpdateAutoForwarding setUploadType(java.lang.String uploadType) {
          return (UpdateAutoForwarding) super.setUploadType(uploadType);
        }

        @Override
        public UpdateAutoForwarding setUploadProtocol(java.lang.String uploadProtocol) {
          return (UpdateAutoForwarding) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** User's email address. The special value "me" can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        public UpdateAutoForwarding setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public UpdateAutoForwarding set(String parameterName, Object value) {
          return (UpdateAutoForwarding) super.set(parameterName, value);
        }
      }
      /**
       * Updates IMAP settings.
       *
       * Create a request for the method "settings.updateImap".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link UpdateImap#execute()} method to invoke the remote operation.
       *
       * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.ImapSettings}
       * @return the request
       */
      public UpdateImap updateImap(java.lang.String userId, com.google.api.services.gmail.model.ImapSettings content) throws java.io.IOException {
        UpdateImap result = new UpdateImap(userId, content);
        initialize(result);
        return result;
      }

      public class UpdateImap extends GmailRequest<com.google.api.services.gmail.model.ImapSettings> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/settings/imap";

        /**
         * Updates IMAP settings.
         *
         * Create a request for the method "settings.updateImap".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link UpdateImap#execute()} method to invoke the remote operation. <p>
         * {@link
         * UpdateImap#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.ImapSettings}
         * @since 1.13
         */
        protected UpdateImap(java.lang.String userId, com.google.api.services.gmail.model.ImapSettings content) {
          super(Gmail.this, "PUT", REST_PATH, content, com.google.api.services.gmail.model.ImapSettings.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public UpdateImap set$Xgafv(java.lang.String $Xgafv) {
          return (UpdateImap) super.set$Xgafv($Xgafv);
        }

        @Override
        public UpdateImap setAccessToken(java.lang.String accessToken) {
          return (UpdateImap) super.setAccessToken(accessToken);
        }

        @Override
        public UpdateImap setAlt(java.lang.String alt) {
          return (UpdateImap) super.setAlt(alt);
        }

        @Override
        public UpdateImap setCallback(java.lang.String callback) {
          return (UpdateImap) super.setCallback(callback);
        }

        @Override
        public UpdateImap setFields(java.lang.String fields) {
          return (UpdateImap) super.setFields(fields);
        }

        @Override
        public UpdateImap setKey(java.lang.String key) {
          return (UpdateImap) super.setKey(key);
        }

        @Override
        public UpdateImap setOauthToken(java.lang.String oauthToken) {
          return (UpdateImap) super.setOauthToken(oauthToken);
        }

        @Override
        public UpdateImap setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UpdateImap) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UpdateImap setQuotaUser(java.lang.String quotaUser) {
          return (UpdateImap) super.setQuotaUser(quotaUser);
        }

        @Override
        public UpdateImap setUploadType(java.lang.String uploadType) {
          return (UpdateImap) super.setUploadType(uploadType);
        }

        @Override
        public UpdateImap setUploadProtocol(java.lang.String uploadProtocol) {
          return (UpdateImap) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** User's email address. The special value "me" can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        public UpdateImap setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public UpdateImap set(String parameterName, Object value) {
          return (UpdateImap) super.set(parameterName, value);
        }
      }
      /**
       * Updates language settings. If successful, the return object contains the `displayLanguage` that
       * was saved for the user, which may differ from the value passed into the request. This is because
       * the requested `displayLanguage` may not be directly supported by Gmail but have a close variant
       * that is, and so the variant may be chosen and saved instead.
       *
       * Create a request for the method "settings.updateLanguage".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link UpdateLanguage#execute()} method to invoke the remote operation.
       *
       * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.LanguageSettings}
       * @return the request
       */
      public UpdateLanguage updateLanguage(java.lang.String userId, com.google.api.services.gmail.model.LanguageSettings content) throws java.io.IOException {
        UpdateLanguage result = new UpdateLanguage(userId, content);
        initialize(result);
        return result;
      }

      public class UpdateLanguage extends GmailRequest<com.google.api.services.gmail.model.LanguageSettings> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/settings/language";

        /**
         * Updates language settings. If successful, the return object contains the `displayLanguage` that
         * was saved for the user, which may differ from the value passed into the request. This is
         * because the requested `displayLanguage` may not be directly supported by Gmail but have a close
         * variant that is, and so the variant may be chosen and saved instead.
         *
         * Create a request for the method "settings.updateLanguage".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link UpdateLanguage#execute()} method to invoke the remote operation.
         * <p> {@link UpdateLanguage#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
         * ientRequest)} must be called to initialize this instance immediately after invoking the
         * constructor. </p>
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.LanguageSettings}
         * @since 1.13
         */
        protected UpdateLanguage(java.lang.String userId, com.google.api.services.gmail.model.LanguageSettings content) {
          super(Gmail.this, "PUT", REST_PATH, content, com.google.api.services.gmail.model.LanguageSettings.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public UpdateLanguage set$Xgafv(java.lang.String $Xgafv) {
          return (UpdateLanguage) super.set$Xgafv($Xgafv);
        }

        @Override
        public UpdateLanguage setAccessToken(java.lang.String accessToken) {
          return (UpdateLanguage) super.setAccessToken(accessToken);
        }

        @Override
        public UpdateLanguage setAlt(java.lang.String alt) {
          return (UpdateLanguage) super.setAlt(alt);
        }

        @Override
        public UpdateLanguage setCallback(java.lang.String callback) {
          return (UpdateLanguage) super.setCallback(callback);
        }

        @Override
        public UpdateLanguage setFields(java.lang.String fields) {
          return (UpdateLanguage) super.setFields(fields);
        }

        @Override
        public UpdateLanguage setKey(java.lang.String key) {
          return (UpdateLanguage) super.setKey(key);
        }

        @Override
        public UpdateLanguage setOauthToken(java.lang.String oauthToken) {
          return (UpdateLanguage) super.setOauthToken(oauthToken);
        }

        @Override
        public UpdateLanguage setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UpdateLanguage) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UpdateLanguage setQuotaUser(java.lang.String quotaUser) {
          return (UpdateLanguage) super.setQuotaUser(quotaUser);
        }

        @Override
        public UpdateLanguage setUploadType(java.lang.String uploadType) {
          return (UpdateLanguage) super.setUploadType(uploadType);
        }

        @Override
        public UpdateLanguage setUploadProtocol(java.lang.String uploadProtocol) {
          return (UpdateLanguage) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** User's email address. The special value "me" can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        public UpdateLanguage setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public UpdateLanguage set(String parameterName, Object value) {
          return (UpdateLanguage) super.set(parameterName, value);
        }
      }
      /**
       * Updates POP settings.
       *
       * Create a request for the method "settings.updatePop".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link UpdatePop#execute()} method to invoke the remote operation.
       *
       * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.PopSettings}
       * @return the request
       */
      public UpdatePop updatePop(java.lang.String userId, com.google.api.services.gmail.model.PopSettings content) throws java.io.IOException {
        UpdatePop result = new UpdatePop(userId, content);
        initialize(result);
        return result;
      }

      public class UpdatePop extends GmailRequest<com.google.api.services.gmail.model.PopSettings> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/settings/pop";

        /**
         * Updates POP settings.
         *
         * Create a request for the method "settings.updatePop".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link UpdatePop#execute()} method to invoke the remote operation. <p>
         * {@link
         * UpdatePop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.PopSettings}
         * @since 1.13
         */
        protected UpdatePop(java.lang.String userId, com.google.api.services.gmail.model.PopSettings content) {
          super(Gmail.this, "PUT", REST_PATH, content, com.google.api.services.gmail.model.PopSettings.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public UpdatePop set$Xgafv(java.lang.String $Xgafv) {
          return (UpdatePop) super.set$Xgafv($Xgafv);
        }

        @Override
        public UpdatePop setAccessToken(java.lang.String accessToken) {
          return (UpdatePop) super.setAccessToken(accessToken);
        }

        @Override
        public UpdatePop setAlt(java.lang.String alt) {
          return (UpdatePop) super.setAlt(alt);
        }

        @Override
        public UpdatePop setCallback(java.lang.String callback) {
          return (UpdatePop) super.setCallback(callback);
        }

        @Override
        public UpdatePop setFields(java.lang.String fields) {
          return (UpdatePop) super.setFields(fields);
        }

        @Override
        public UpdatePop setKey(java.lang.String key) {
          return (UpdatePop) super.setKey(key);
        }

        @Override
        public UpdatePop setOauthToken(java.lang.String oauthToken) {
          return (UpdatePop) super.setOauthToken(oauthToken);
        }

        @Override
        public UpdatePop setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UpdatePop) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UpdatePop setQuotaUser(java.lang.String quotaUser) {
          return (UpdatePop) super.setQuotaUser(quotaUser);
        }

        @Override
        public UpdatePop setUploadType(java.lang.String uploadType) {
          return (UpdatePop) super.setUploadType(uploadType);
        }

        @Override
        public UpdatePop setUploadProtocol(java.lang.String uploadProtocol) {
          return (UpdatePop) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** User's email address. The special value "me" can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        public UpdatePop setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public UpdatePop set(String parameterName, Object value) {
          return (UpdatePop) super.set(parameterName, value);
        }
      }
      /**
       * Updates vacation responder settings.
       *
       * Create a request for the method "settings.updateVacation".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link UpdateVacation#execute()} method to invoke the remote operation.
       *
       * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
       * @param content the {@link com.google.api.services.gmail.model.VacationSettings}
       * @return the request
       */
      public UpdateVacation updateVacation(java.lang.String userId, com.google.api.services.gmail.model.VacationSettings content) throws java.io.IOException {
        UpdateVacation result = new UpdateVacation(userId, content);
        initialize(result);
        return result;
      }

      public class UpdateVacation extends GmailRequest<com.google.api.services.gmail.model.VacationSettings> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/settings/vacation";

        /**
         * Updates vacation responder settings.
         *
         * Create a request for the method "settings.updateVacation".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link UpdateVacation#execute()} method to invoke the remote operation.
         * <p> {@link UpdateVacation#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
         * ientRequest)} must be called to initialize this instance immediately after invoking the
         * constructor. </p>
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
       *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.VacationSettings}
         * @since 1.13
         */
        protected UpdateVacation(java.lang.String userId, com.google.api.services.gmail.model.VacationSettings content) {
          super(Gmail.this, "PUT", REST_PATH, content, com.google.api.services.gmail.model.VacationSettings.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public UpdateVacation set$Xgafv(java.lang.String $Xgafv) {
          return (UpdateVacation) super.set$Xgafv($Xgafv);
        }

        @Override
        public UpdateVacation setAccessToken(java.lang.String accessToken) {
          return (UpdateVacation) super.setAccessToken(accessToken);
        }

        @Override
        public UpdateVacation setAlt(java.lang.String alt) {
          return (UpdateVacation) super.setAlt(alt);
        }

        @Override
        public UpdateVacation setCallback(java.lang.String callback) {
          return (UpdateVacation) super.setCallback(callback);
        }

        @Override
        public UpdateVacation setFields(java.lang.String fields) {
          return (UpdateVacation) super.setFields(fields);
        }

        @Override
        public UpdateVacation setKey(java.lang.String key) {
          return (UpdateVacation) super.setKey(key);
        }

        @Override
        public UpdateVacation setOauthToken(java.lang.String oauthToken) {
          return (UpdateVacation) super.setOauthToken(oauthToken);
        }

        @Override
        public UpdateVacation setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UpdateVacation) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UpdateVacation setQuotaUser(java.lang.String quotaUser) {
          return (UpdateVacation) super.setQuotaUser(quotaUser);
        }

        @Override
        public UpdateVacation setUploadType(java.lang.String uploadType) {
          return (UpdateVacation) super.setUploadType(uploadType);
        }

        @Override
        public UpdateVacation setUploadProtocol(java.lang.String uploadProtocol) {
          return (UpdateVacation) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** User's email address. The special value "me" can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * User's email address. The special value "me" can be used to indicate the authenticated
         * user.
         */
        public UpdateVacation setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public UpdateVacation set(String parameterName, Object value) {
          return (UpdateVacation) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Delegates collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Gmail gmail = new Gmail(...);}
       *   {@code Gmail.Delegates.List request = gmail.delegates().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Delegates delegates() {
        return new Delegates();
      }

      /**
       * The "delegates" collection of methods.
       */
      public class Delegates {

        /**
         * Adds a delegate with its verification status set directly to `accepted`, without sending any
         * verification email. The delegate user must be a member of the same G Suite organization as the
         * delegator user. Gmail imposes limitations on the number of delegates and delegators each user in
         * a G Suite organization can have. These limits depend on your organization, but in general each
         * user can have up to 25 delegates and up to 10 delegators. Note that a delegate user must be
         * referred to by their primary email address, and not an email alias. Also note that when a new
         * delegate is created, there may be up to a one minute delay before the new delegate is available
         * for use. This method is only available to service account clients that have been delegated
         * domain-wide authority.
         *
         * Create a request for the method "delegates.create".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Delegate}
         * @return the request
         */
        public Create create(java.lang.String userId, com.google.api.services.gmail.model.Delegate content) throws java.io.IOException {
          Create result = new Create(userId, content);
          initialize(result);
          return result;
        }

        public class Create extends GmailRequest<com.google.api.services.gmail.model.Delegate> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/delegates";

          /**
           * Adds a delegate with its verification status set directly to `accepted`, without sending any
           * verification email. The delegate user must be a member of the same G Suite organization as the
           * delegator user. Gmail imposes limitations on the number of delegates and delegators each user
           * in a G Suite organization can have. These limits depend on your organization, but in general
           * each user can have up to 25 delegates and up to 10 delegators. Note that a delegate user must
           * be referred to by their primary email address, and not an email alias. Also note that when a
           * new delegate is created, there may be up to a one minute delay before the new delegate is
           * available for use. This method is only available to service account clients that have been
           * delegated domain-wide authority.
           *
           * Create a request for the method "delegates.create".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param content the {@link com.google.api.services.gmail.model.Delegate}
           * @since 1.13
           */
          protected Create(java.lang.String userId, com.google.api.services.gmail.model.Delegate content) {
            super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.Delegate.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Create setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Removes the specified delegate (which can be of any verification status), and revokes any
         * verification that may have been required for using it. Note that a delegate user must be referred
         * to by their primary email address, and not an email alias. This method is only available to
         * service account clients that have been delegated domain-wide authority.
         *
         * Create a request for the method "delegates.delete".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param delegateEmail The email address of the user to be removed as a delegate.
         * @return the request
         */
        public Delete delete(java.lang.String userId, java.lang.String delegateEmail) throws java.io.IOException {
          Delete result = new Delete(userId, delegateEmail);
          initialize(result);
          return result;
        }

        public class Delete extends GmailRequest<Void> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/delegates/{delegateEmail}";

          /**
           * Removes the specified delegate (which can be of any verification status), and revokes any
           * verification that may have been required for using it. Note that a delegate user must be
           * referred to by their primary email address, and not an email alias. This method is only
           * available to service account clients that have been delegated domain-wide authority.
           *
           * Create a request for the method "delegates.delete".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param delegateEmail The email address of the user to be removed as a delegate.
           * @since 1.13
           */
          protected Delete(java.lang.String userId, java.lang.String delegateEmail) {
            super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.delegateEmail = com.google.api.client.util.Preconditions.checkNotNull(delegateEmail, "Required parameter delegateEmail must be specified.");
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Delete setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The email address of the user to be removed as a delegate. */
          @com.google.api.client.util.Key
          private java.lang.String delegateEmail;

          /** The email address of the user to be removed as a delegate.
           */
          public java.lang.String getDelegateEmail() {
            return delegateEmail;
          }

          /** The email address of the user to be removed as a delegate. */
          public Delete setDelegateEmail(java.lang.String delegateEmail) {
            this.delegateEmail = delegateEmail;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the specified delegate. Note that a delegate user must be referred to by their primary email
         * address, and not an email alias. This method is only available to service account clients that
         * have been delegated domain-wide authority.
         *
         * Create a request for the method "delegates.get".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param delegateEmail The email address of the user whose delegate relationship is to be retrieved.
         * @return the request
         */
        public Get get(java.lang.String userId, java.lang.String delegateEmail) throws java.io.IOException {
          Get result = new Get(userId, delegateEmail);
          initialize(result);
          return result;
        }

        public class Get extends GmailRequest<com.google.api.services.gmail.model.Delegate> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/delegates/{delegateEmail}";

          /**
           * Gets the specified delegate. Note that a delegate user must be referred to by their primary
           * email address, and not an email alias. This method is only available to service account clients
           * that have been delegated domain-wide authority.
           *
           * Create a request for the method "delegates.get".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param delegateEmail The email address of the user whose delegate relationship is to be retrieved.
           * @since 1.13
           */
          protected Get(java.lang.String userId, java.lang.String delegateEmail) {
            super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.Delegate.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.delegateEmail = com.google.api.client.util.Preconditions.checkNotNull(delegateEmail, "Required parameter delegateEmail must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Get setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The email address of the user whose delegate relationship is to be retrieved. */
          @com.google.api.client.util.Key
          private java.lang.String delegateEmail;

          /** The email address of the user whose delegate relationship is to be retrieved.
           */
          public java.lang.String getDelegateEmail() {
            return delegateEmail;
          }

          /** The email address of the user whose delegate relationship is to be retrieved. */
          public Get setDelegateEmail(java.lang.String delegateEmail) {
            this.delegateEmail = delegateEmail;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists the delegates for the specified account. This method is only available to service account
         * clients that have been delegated domain-wide authority.
         *
         * Create a request for the method "delegates.list".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @return the request
         */
        public List list(java.lang.String userId) throws java.io.IOException {
          List result = new List(userId);
          initialize(result);
          return result;
        }

        public class List extends GmailRequest<com.google.api.services.gmail.model.ListDelegatesResponse> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/delegates";

          /**
           * Lists the delegates for the specified account. This method is only available to service account
           * clients that have been delegated domain-wide authority.
           *
           * Create a request for the method "delegates.list".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @since 1.13
           */
          protected List(java.lang.String userId) {
            super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ListDelegatesResponse.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public List setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Filters collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Gmail gmail = new Gmail(...);}
       *   {@code Gmail.Filters.List request = gmail.filters().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Filters filters() {
        return new Filters();
      }

      /**
       * The "filters" collection of methods.
       */
      public class Filters {

        /**
         * Creates a filter. Note: you can only create a maximum of 1,000 filters.
         *
         * Create a request for the method "filters.create".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.Filter}
         * @return the request
         */
        public Create create(java.lang.String userId, com.google.api.services.gmail.model.Filter content) throws java.io.IOException {
          Create result = new Create(userId, content);
          initialize(result);
          return result;
        }

        public class Create extends GmailRequest<com.google.api.services.gmail.model.Filter> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/filters";

          /**
           * Creates a filter. Note: you can only create a maximum of 1,000 filters.
           *
           * Create a request for the method "filters.create".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param content the {@link com.google.api.services.gmail.model.Filter}
           * @since 1.13
           */
          protected Create(java.lang.String userId, com.google.api.services.gmail.model.Filter content) {
            super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.Filter.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Create setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Immediately and permanently deletes the specified filter.
         *
         * Create a request for the method "filters.delete".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param id The ID of the filter to be deleted.
         * @return the request
         */
        public Delete delete(java.lang.String userId, java.lang.String id) throws java.io.IOException {
          Delete result = new Delete(userId, id);
          initialize(result);
          return result;
        }

        public class Delete extends GmailRequest<Void> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/filters/{id}";

          /**
           * Immediately and permanently deletes the specified filter.
           *
           * Create a request for the method "filters.delete".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param id The ID of the filter to be deleted.
           * @since 1.13
           */
          protected Delete(java.lang.String userId, java.lang.String id) {
            super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Delete setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The ID of the filter to be deleted. */
          @com.google.api.client.util.Key
          private java.lang.String id;

          /** The ID of the filter to be deleted.
           */
          public java.lang.String getId() {
            return id;
          }

          /** The ID of the filter to be deleted. */
          public Delete setId(java.lang.String id) {
            this.id = id;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets a filter.
         *
         * Create a request for the method "filters.get".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param id The ID of the filter to be fetched.
         * @return the request
         */
        public Get get(java.lang.String userId, java.lang.String id) throws java.io.IOException {
          Get result = new Get(userId, id);
          initialize(result);
          return result;
        }

        public class Get extends GmailRequest<com.google.api.services.gmail.model.Filter> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/filters/{id}";

          /**
           * Gets a filter.
           *
           * Create a request for the method "filters.get".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param id The ID of the filter to be fetched.
           * @since 1.13
           */
          protected Get(java.lang.String userId, java.lang.String id) {
            super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.Filter.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Get setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The ID of the filter to be fetched. */
          @com.google.api.client.util.Key
          private java.lang.String id;

          /** The ID of the filter to be fetched.
           */
          public java.lang.String getId() {
            return id;
          }

          /** The ID of the filter to be fetched. */
          public Get setId(java.lang.String id) {
            this.id = id;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists the message filters of a Gmail user.
         *
         * Create a request for the method "filters.list".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @return the request
         */
        public List list(java.lang.String userId) throws java.io.IOException {
          List result = new List(userId);
          initialize(result);
          return result;
        }

        public class List extends GmailRequest<com.google.api.services.gmail.model.ListFiltersResponse> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/filters";

          /**
           * Lists the message filters of a Gmail user.
           *
           * Create a request for the method "filters.list".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @since 1.13
           */
          protected List(java.lang.String userId) {
            super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ListFiltersResponse.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public List setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the ForwardingAddresses collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Gmail gmail = new Gmail(...);}
       *   {@code Gmail.ForwardingAddresses.List request = gmail.forwardingAddresses().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public ForwardingAddresses forwardingAddresses() {
        return new ForwardingAddresses();
      }

      /**
       * The "forwardingAddresses" collection of methods.
       */
      public class ForwardingAddresses {

        /**
         * Creates a forwarding address. If ownership verification is required, a message will be sent to
         * the recipient and the resource's verification status will be set to `pending`; otherwise, the
         * resource will be created with verification status set to `accepted`. This method is only
         * available to service account clients that have been delegated domain-wide authority.
         *
         * Create a request for the method "forwardingAddresses.create".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.ForwardingAddress}
         * @return the request
         */
        public Create create(java.lang.String userId, com.google.api.services.gmail.model.ForwardingAddress content) throws java.io.IOException {
          Create result = new Create(userId, content);
          initialize(result);
          return result;
        }

        public class Create extends GmailRequest<com.google.api.services.gmail.model.ForwardingAddress> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/forwardingAddresses";

          /**
           * Creates a forwarding address. If ownership verification is required, a message will be sent to
           * the recipient and the resource's verification status will be set to `pending`; otherwise, the
           * resource will be created with verification status set to `accepted`. This method is only
           * available to service account clients that have been delegated domain-wide authority.
           *
           * Create a request for the method "forwardingAddresses.create".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param content the {@link com.google.api.services.gmail.model.ForwardingAddress}
           * @since 1.13
           */
          protected Create(java.lang.String userId, com.google.api.services.gmail.model.ForwardingAddress content) {
            super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.ForwardingAddress.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Create setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes the specified forwarding address and revokes any verification that may have been
         * required. This method is only available to service account clients that have been delegated
         * domain-wide authority.
         *
         * Create a request for the method "forwardingAddresses.delete".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param forwardingEmail The forwarding address to be deleted.
         * @return the request
         */
        public Delete delete(java.lang.String userId, java.lang.String forwardingEmail) throws java.io.IOException {
          Delete result = new Delete(userId, forwardingEmail);
          initialize(result);
          return result;
        }

        public class Delete extends GmailRequest<Void> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/forwardingAddresses/{forwardingEmail}";

          /**
           * Deletes the specified forwarding address and revokes any verification that may have been
           * required. This method is only available to service account clients that have been delegated
           * domain-wide authority.
           *
           * Create a request for the method "forwardingAddresses.delete".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param forwardingEmail The forwarding address to be deleted.
           * @since 1.13
           */
          protected Delete(java.lang.String userId, java.lang.String forwardingEmail) {
            super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.forwardingEmail = com.google.api.client.util.Preconditions.checkNotNull(forwardingEmail, "Required parameter forwardingEmail must be specified.");
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Delete setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The forwarding address to be deleted. */
          @com.google.api.client.util.Key
          private java.lang.String forwardingEmail;

          /** The forwarding address to be deleted.
           */
          public java.lang.String getForwardingEmail() {
            return forwardingEmail;
          }

          /** The forwarding address to be deleted. */
          public Delete setForwardingEmail(java.lang.String forwardingEmail) {
            this.forwardingEmail = forwardingEmail;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the specified forwarding address.
         *
         * Create a request for the method "forwardingAddresses.get".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param forwardingEmail The forwarding address to be retrieved.
         * @return the request
         */
        public Get get(java.lang.String userId, java.lang.String forwardingEmail) throws java.io.IOException {
          Get result = new Get(userId, forwardingEmail);
          initialize(result);
          return result;
        }

        public class Get extends GmailRequest<com.google.api.services.gmail.model.ForwardingAddress> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/forwardingAddresses/{forwardingEmail}";

          /**
           * Gets the specified forwarding address.
           *
           * Create a request for the method "forwardingAddresses.get".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param forwardingEmail The forwarding address to be retrieved.
           * @since 1.13
           */
          protected Get(java.lang.String userId, java.lang.String forwardingEmail) {
            super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ForwardingAddress.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.forwardingEmail = com.google.api.client.util.Preconditions.checkNotNull(forwardingEmail, "Required parameter forwardingEmail must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Get setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The forwarding address to be retrieved. */
          @com.google.api.client.util.Key
          private java.lang.String forwardingEmail;

          /** The forwarding address to be retrieved.
           */
          public java.lang.String getForwardingEmail() {
            return forwardingEmail;
          }

          /** The forwarding address to be retrieved. */
          public Get setForwardingEmail(java.lang.String forwardingEmail) {
            this.forwardingEmail = forwardingEmail;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists the forwarding addresses for the specified account.
         *
         * Create a request for the method "forwardingAddresses.list".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @return the request
         */
        public List list(java.lang.String userId) throws java.io.IOException {
          List result = new List(userId);
          initialize(result);
          return result;
        }

        public class List extends GmailRequest<com.google.api.services.gmail.model.ListForwardingAddressesResponse> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/forwardingAddresses";

          /**
           * Lists the forwarding addresses for the specified account.
           *
           * Create a request for the method "forwardingAddresses.list".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @since 1.13
           */
          protected List(java.lang.String userId) {
            super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ListForwardingAddressesResponse.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public List setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the SendAs collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Gmail gmail = new Gmail(...);}
       *   {@code Gmail.SendAs.List request = gmail.sendAs().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public SendAs sendAs() {
        return new SendAs();
      }

      /**
       * The "sendAs" collection of methods.
       */
      public class SendAs {

        /**
         * Creates a custom "from" send-as alias. If an SMTP MSA is specified, Gmail will attempt to connect
         * to the SMTP service to validate the configuration before creating the alias. If ownership
         * verification is required for the alias, a message will be sent to the email address and the
         * resource's verification status will be set to `pending`; otherwise, the resource will be created
         * with verification status set to `accepted`. If a signature is provided, Gmail will sanitize the
         * HTML before saving it with the alias. This method is only available to service account clients
         * that have been delegated domain-wide authority.
         *
         * Create a request for the method "sendAs.create".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param content the {@link com.google.api.services.gmail.model.SendAs}
         * @return the request
         */
        public Create create(java.lang.String userId, com.google.api.services.gmail.model.SendAs content) throws java.io.IOException {
          Create result = new Create(userId, content);
          initialize(result);
          return result;
        }

        public class Create extends GmailRequest<com.google.api.services.gmail.model.SendAs> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs";

          /**
           * Creates a custom "from" send-as alias. If an SMTP MSA is specified, Gmail will attempt to
           * connect to the SMTP service to validate the configuration before creating the alias. If
           * ownership verification is required for the alias, a message will be sent to the email address
           * and the resource's verification status will be set to `pending`; otherwise, the resource will
           * be created with verification status set to `accepted`. If a signature is provided, Gmail will
           * sanitize the HTML before saving it with the alias. This method is only available to service
           * account clients that have been delegated domain-wide authority.
           *
           * Create a request for the method "sendAs.create".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param content the {@link com.google.api.services.gmail.model.SendAs}
           * @since 1.13
           */
          protected Create(java.lang.String userId, com.google.api.services.gmail.model.SendAs content) {
            super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.SendAs.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Create setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes the specified send-as alias. Revokes any verification that may have been required for
         * using it. This method is only available to service account clients that have been delegated
         * domain-wide authority.
         *
         * Create a request for the method "sendAs.delete".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param sendAsEmail The send-as alias to be deleted.
         * @return the request
         */
        public Delete delete(java.lang.String userId, java.lang.String sendAsEmail) throws java.io.IOException {
          Delete result = new Delete(userId, sendAsEmail);
          initialize(result);
          return result;
        }

        public class Delete extends GmailRequest<Void> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}";

          /**
           * Deletes the specified send-as alias. Revokes any verification that may have been required for
           * using it. This method is only available to service account clients that have been delegated
           * domain-wide authority.
           *
           * Create a request for the method "sendAs.delete".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param sendAsEmail The send-as alias to be deleted.
           * @since 1.13
           */
          protected Delete(java.lang.String userId, java.lang.String sendAsEmail) {
            super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.sendAsEmail = com.google.api.client.util.Preconditions.checkNotNull(sendAsEmail, "Required parameter sendAsEmail must be specified.");
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Delete setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The send-as alias to be deleted. */
          @com.google.api.client.util.Key
          private java.lang.String sendAsEmail;

          /** The send-as alias to be deleted.
           */
          public java.lang.String getSendAsEmail() {
            return sendAsEmail;
          }

          /** The send-as alias to be deleted. */
          public Delete setSendAsEmail(java.lang.String sendAsEmail) {
            this.sendAsEmail = sendAsEmail;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the specified send-as alias. Fails with an HTTP 404 error if the specified address is not a
         * member of the collection.
         *
         * Create a request for the method "sendAs.get".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param sendAsEmail The send-as alias to be retrieved.
         * @return the request
         */
        public Get get(java.lang.String userId, java.lang.String sendAsEmail) throws java.io.IOException {
          Get result = new Get(userId, sendAsEmail);
          initialize(result);
          return result;
        }

        public class Get extends GmailRequest<com.google.api.services.gmail.model.SendAs> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}";

          /**
           * Gets the specified send-as alias. Fails with an HTTP 404 error if the specified address is not
           * a member of the collection.
           *
           * Create a request for the method "sendAs.get".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param sendAsEmail The send-as alias to be retrieved.
           * @since 1.13
           */
          protected Get(java.lang.String userId, java.lang.String sendAsEmail) {
            super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.SendAs.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.sendAsEmail = com.google.api.client.util.Preconditions.checkNotNull(sendAsEmail, "Required parameter sendAsEmail must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Get setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The send-as alias to be retrieved. */
          @com.google.api.client.util.Key
          private java.lang.String sendAsEmail;

          /** The send-as alias to be retrieved.
           */
          public java.lang.String getSendAsEmail() {
            return sendAsEmail;
          }

          /** The send-as alias to be retrieved. */
          public Get setSendAsEmail(java.lang.String sendAsEmail) {
            this.sendAsEmail = sendAsEmail;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists the send-as aliases for the specified account. The result includes the primary send-as
         * address associated with the account as well as any custom "from" aliases.
         *
         * Create a request for the method "sendAs.list".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @return the request
         */
        public List list(java.lang.String userId) throws java.io.IOException {
          List result = new List(userId);
          initialize(result);
          return result;
        }

        public class List extends GmailRequest<com.google.api.services.gmail.model.ListSendAsResponse> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs";

          /**
           * Lists the send-as aliases for the specified account. The result includes the primary send-as
           * address associated with the account as well as any custom "from" aliases.
           *
           * Create a request for the method "sendAs.list".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @since 1.13
           */
          protected List(java.lang.String userId) {
            super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ListSendAsResponse.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public List setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Patch the specified send-as alias.
         *
         * Create a request for the method "sendAs.patch".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param sendAsEmail The send-as alias to be updated.
         * @param content the {@link com.google.api.services.gmail.model.SendAs}
         * @return the request
         */
        public Patch patch(java.lang.String userId, java.lang.String sendAsEmail, com.google.api.services.gmail.model.SendAs content) throws java.io.IOException {
          Patch result = new Patch(userId, sendAsEmail, content);
          initialize(result);
          return result;
        }

        public class Patch extends GmailRequest<com.google.api.services.gmail.model.SendAs> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}";

          /**
           * Patch the specified send-as alias.
           *
           * Create a request for the method "sendAs.patch".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param sendAsEmail The send-as alias to be updated.
           * @param content the {@link com.google.api.services.gmail.model.SendAs}
           * @since 1.13
           */
          protected Patch(java.lang.String userId, java.lang.String sendAsEmail, com.google.api.services.gmail.model.SendAs content) {
            super(Gmail.this, "PATCH", REST_PATH, content, com.google.api.services.gmail.model.SendAs.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.sendAsEmail = com.google.api.client.util.Preconditions.checkNotNull(sendAsEmail, "Required parameter sendAsEmail must be specified.");
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Patch setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The send-as alias to be updated. */
          @com.google.api.client.util.Key
          private java.lang.String sendAsEmail;

          /** The send-as alias to be updated.
           */
          public java.lang.String getSendAsEmail() {
            return sendAsEmail;
          }

          /** The send-as alias to be updated. */
          public Patch setSendAsEmail(java.lang.String sendAsEmail) {
            this.sendAsEmail = sendAsEmail;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }
        /**
         * Updates a send-as alias. If a signature is provided, Gmail will sanitize the HTML before saving
         * it with the alias. Addresses other than the primary address for the account can only be updated
         * by service account clients that have been delegated domain-wide authority.
         *
         * Create a request for the method "sendAs.update".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param sendAsEmail The send-as alias to be updated.
         * @param content the {@link com.google.api.services.gmail.model.SendAs}
         * @return the request
         */
        public Update update(java.lang.String userId, java.lang.String sendAsEmail, com.google.api.services.gmail.model.SendAs content) throws java.io.IOException {
          Update result = new Update(userId, sendAsEmail, content);
          initialize(result);
          return result;
        }

        public class Update extends GmailRequest<com.google.api.services.gmail.model.SendAs> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}";

          /**
           * Updates a send-as alias. If a signature is provided, Gmail will sanitize the HTML before saving
           * it with the alias. Addresses other than the primary address for the account can only be updated
           * by service account clients that have been delegated domain-wide authority.
           *
           * Create a request for the method "sendAs.update".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
           * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param sendAsEmail The send-as alias to be updated.
           * @param content the {@link com.google.api.services.gmail.model.SendAs}
           * @since 1.13
           */
          protected Update(java.lang.String userId, java.lang.String sendAsEmail, com.google.api.services.gmail.model.SendAs content) {
            super(Gmail.this, "PUT", REST_PATH, content, com.google.api.services.gmail.model.SendAs.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.sendAsEmail = com.google.api.client.util.Preconditions.checkNotNull(sendAsEmail, "Required parameter sendAsEmail must be specified.");
          }

          @Override
          public Update set$Xgafv(java.lang.String $Xgafv) {
            return (Update) super.set$Xgafv($Xgafv);
          }

          @Override
          public Update setAccessToken(java.lang.String accessToken) {
            return (Update) super.setAccessToken(accessToken);
          }

          @Override
          public Update setAlt(java.lang.String alt) {
            return (Update) super.setAlt(alt);
          }

          @Override
          public Update setCallback(java.lang.String callback) {
            return (Update) super.setCallback(callback);
          }

          @Override
          public Update setFields(java.lang.String fields) {
            return (Update) super.setFields(fields);
          }

          @Override
          public Update setKey(java.lang.String key) {
            return (Update) super.setKey(key);
          }

          @Override
          public Update setOauthToken(java.lang.String oauthToken) {
            return (Update) super.setOauthToken(oauthToken);
          }

          @Override
          public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Update) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Update setQuotaUser(java.lang.String quotaUser) {
            return (Update) super.setQuotaUser(quotaUser);
          }

          @Override
          public Update setUploadType(java.lang.String uploadType) {
            return (Update) super.setUploadType(uploadType);
          }

          @Override
          public Update setUploadProtocol(java.lang.String uploadProtocol) {
            return (Update) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Update setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The send-as alias to be updated. */
          @com.google.api.client.util.Key
          private java.lang.String sendAsEmail;

          /** The send-as alias to be updated.
           */
          public java.lang.String getSendAsEmail() {
            return sendAsEmail;
          }

          /** The send-as alias to be updated. */
          public Update setSendAsEmail(java.lang.String sendAsEmail) {
            this.sendAsEmail = sendAsEmail;
            return this;
          }

          @Override
          public Update set(String parameterName, Object value) {
            return (Update) super.set(parameterName, value);
          }
        }
        /**
         * Sends a verification email to the specified send-as alias address. The verification status must
         * be `pending`. This method is only available to service account clients that have been delegated
         * domain-wide authority.
         *
         * Create a request for the method "sendAs.verify".
         *
         * This request holds the parameters needed by the gmail server.  After setting any optional
         * parameters, call the {@link Verify#execute()} method to invoke the remote operation.
         *
         * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
         * @param sendAsEmail The send-as alias to be verified.
         * @return the request
         */
        public Verify verify(java.lang.String userId, java.lang.String sendAsEmail) throws java.io.IOException {
          Verify result = new Verify(userId, sendAsEmail);
          initialize(result);
          return result;
        }

        public class Verify extends GmailRequest<Void> {

          private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/verify";

          /**
           * Sends a verification email to the specified send-as alias address. The verification status must
           * be `pending`. This method is only available to service account clients that have been delegated
           * domain-wide authority.
           *
           * Create a request for the method "sendAs.verify".
           *
           * This request holds the parameters needed by the the gmail server.  After setting any optional
           * parameters, call the {@link Verify#execute()} method to invoke the remote operation. <p> {@link
           * Verify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId User's email address. The special value "me" can be used to indicate the authenticated user.
         *        [default: me]
           * @param sendAsEmail The send-as alias to be verified.
           * @since 1.13
           */
          protected Verify(java.lang.String userId, java.lang.String sendAsEmail) {
            super(Gmail.this, "POST", REST_PATH, null, Void.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.sendAsEmail = com.google.api.client.util.Preconditions.checkNotNull(sendAsEmail, "Required parameter sendAsEmail must be specified.");
          }

          @Override
          public Verify set$Xgafv(java.lang.String $Xgafv) {
            return (Verify) super.set$Xgafv($Xgafv);
          }

          @Override
          public Verify setAccessToken(java.lang.String accessToken) {
            return (Verify) super.setAccessToken(accessToken);
          }

          @Override
          public Verify setAlt(java.lang.String alt) {
            return (Verify) super.setAlt(alt);
          }

          @Override
          public Verify setCallback(java.lang.String callback) {
            return (Verify) super.setCallback(callback);
          }

          @Override
          public Verify setFields(java.lang.String fields) {
            return (Verify) super.setFields(fields);
          }

          @Override
          public Verify setKey(java.lang.String key) {
            return (Verify) super.setKey(key);
          }

          @Override
          public Verify setOauthToken(java.lang.String oauthToken) {
            return (Verify) super.setOauthToken(oauthToken);
          }

          @Override
          public Verify setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Verify) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Verify setQuotaUser(java.lang.String quotaUser) {
            return (Verify) super.setQuotaUser(quotaUser);
          }

          @Override
          public Verify setUploadType(java.lang.String uploadType) {
            return (Verify) super.setUploadType(uploadType);
          }

          @Override
          public Verify setUploadProtocol(java.lang.String uploadProtocol) {
            return (Verify) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** User's email address. The special value "me" can be used to indicate the authenticated user.
         [default: me]
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * User's email address. The special value "me" can be used to indicate the authenticated
           * user.
           */
          public Verify setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The send-as alias to be verified. */
          @com.google.api.client.util.Key
          private java.lang.String sendAsEmail;

          /** The send-as alias to be verified.
           */
          public java.lang.String getSendAsEmail() {
            return sendAsEmail;
          }

          /** The send-as alias to be verified. */
          public Verify setSendAsEmail(java.lang.String sendAsEmail) {
            this.sendAsEmail = sendAsEmail;
            return this;
          }

          @Override
          public Verify set(String parameterName, Object value) {
            return (Verify) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the SmimeInfo collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code Gmail gmail = new Gmail(...);}
         *   {@code Gmail.SmimeInfo.List request = gmail.smimeInfo().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public SmimeInfo smimeInfo() {
          return new SmimeInfo();
        }

        /**
         * The "smimeInfo" collection of methods.
         */
        public class SmimeInfo {

          /**
           * Deletes the specified S/MIME config for the specified send-as alias.
           *
           * Create a request for the method "smimeInfo.delete".
           *
           * This request holds the parameters needed by the gmail server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
           *        [default: me]
           * @param sendAsEmail The email address that appears in the "From:" header for mail sent using this alias.
           * @param id The immutable ID for the SmimeInfo.
           * @return the request
           */
          public Delete delete(java.lang.String userId, java.lang.String sendAsEmail, java.lang.String id) throws java.io.IOException {
            Delete result = new Delete(userId, sendAsEmail, id);
            initialize(result);
            return result;
          }

          public class Delete extends GmailRequest<Void> {

            private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/smimeInfo/{id}";

            /**
             * Deletes the specified S/MIME config for the specified send-as alias.
             *
             * Create a request for the method "smimeInfo.delete".
             *
             * This request holds the parameters needed by the the gmail server.  After setting any optional
             * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
           *        [default: me]
             * @param sendAsEmail The email address that appears in the "From:" header for mail sent using this alias.
             * @param id The immutable ID for the SmimeInfo.
             * @since 1.13
             */
            protected Delete(java.lang.String userId, java.lang.String sendAsEmail, java.lang.String id) {
              super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
              this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
              this.sendAsEmail = com.google.api.client.util.Preconditions.checkNotNull(sendAsEmail, "Required parameter sendAsEmail must be specified.");
              this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The user's email address. The special value `me` can be used to indicate the
             * authenticated user.
             */
            @com.google.api.client.util.Key
            private java.lang.String userId;

            /** The user's email address. The special value `me` can be used to indicate the authenticated user.
           [default: me]
             */
            public java.lang.String getUserId() {
              return userId;
            }

            /**
             * The user's email address. The special value `me` can be used to indicate the
             * authenticated user.
             */
            public Delete setUserId(java.lang.String userId) {
              this.userId = userId;
              return this;
            }

            /**
             * The email address that appears in the "From:" header for mail sent using this alias.
             */
            @com.google.api.client.util.Key
            private java.lang.String sendAsEmail;

            /** The email address that appears in the "From:" header for mail sent using this alias.
             */
            public java.lang.String getSendAsEmail() {
              return sendAsEmail;
            }

            /**
             * The email address that appears in the "From:" header for mail sent using this alias.
             */
            public Delete setSendAsEmail(java.lang.String sendAsEmail) {
              this.sendAsEmail = sendAsEmail;
              return this;
            }

            /** The immutable ID for the SmimeInfo. */
            @com.google.api.client.util.Key
            private java.lang.String id;

            /** The immutable ID for the SmimeInfo.
             */
            public java.lang.String getId() {
              return id;
            }

            /** The immutable ID for the SmimeInfo. */
            public Delete setId(java.lang.String id) {
              this.id = id;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Gets the specified S/MIME config for the specified send-as alias.
           *
           * Create a request for the method "smimeInfo.get".
           *
           * This request holds the parameters needed by the gmail server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
           *        [default: me]
           * @param sendAsEmail The email address that appears in the "From:" header for mail sent using this alias.
           * @param id The immutable ID for the SmimeInfo.
           * @return the request
           */
          public Get get(java.lang.String userId, java.lang.String sendAsEmail, java.lang.String id) throws java.io.IOException {
            Get result = new Get(userId, sendAsEmail, id);
            initialize(result);
            return result;
          }

          public class Get extends GmailRequest<com.google.api.services.gmail.model.SmimeInfo> {

            private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/smimeInfo/{id}";

            /**
             * Gets the specified S/MIME config for the specified send-as alias.
             *
             * Create a request for the method "smimeInfo.get".
             *
             * This request holds the parameters needed by the the gmail server.  After setting any optional
             * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
             * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
             * called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
           *        [default: me]
             * @param sendAsEmail The email address that appears in the "From:" header for mail sent using this alias.
             * @param id The immutable ID for the SmimeInfo.
             * @since 1.13
             */
            protected Get(java.lang.String userId, java.lang.String sendAsEmail, java.lang.String id) {
              super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.SmimeInfo.class);
              this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
              this.sendAsEmail = com.google.api.client.util.Preconditions.checkNotNull(sendAsEmail, "Required parameter sendAsEmail must be specified.");
              this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The user's email address. The special value `me` can be used to indicate the
             * authenticated user.
             */
            @com.google.api.client.util.Key
            private java.lang.String userId;

            /** The user's email address. The special value `me` can be used to indicate the authenticated user.
           [default: me]
             */
            public java.lang.String getUserId() {
              return userId;
            }

            /**
             * The user's email address. The special value `me` can be used to indicate the
             * authenticated user.
             */
            public Get setUserId(java.lang.String userId) {
              this.userId = userId;
              return this;
            }

            /**
             * The email address that appears in the "From:" header for mail sent using this alias.
             */
            @com.google.api.client.util.Key
            private java.lang.String sendAsEmail;

            /** The email address that appears in the "From:" header for mail sent using this alias.
             */
            public java.lang.String getSendAsEmail() {
              return sendAsEmail;
            }

            /**
             * The email address that appears in the "From:" header for mail sent using this alias.
             */
            public Get setSendAsEmail(java.lang.String sendAsEmail) {
              this.sendAsEmail = sendAsEmail;
              return this;
            }

            /** The immutable ID for the SmimeInfo. */
            @com.google.api.client.util.Key
            private java.lang.String id;

            /** The immutable ID for the SmimeInfo.
             */
            public java.lang.String getId() {
              return id;
            }

            /** The immutable ID for the SmimeInfo. */
            public Get setId(java.lang.String id) {
              this.id = id;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Insert (upload) the given S/MIME config for the specified send-as alias. Note that pkcs12 format
           * is required for the key.
           *
           * Create a request for the method "smimeInfo.insert".
           *
           * This request holds the parameters needed by the gmail server.  After setting any optional
           * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
           *
           * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
           *        [default: me]
           * @param sendAsEmail The email address that appears in the "From:" header for mail sent using this alias.
           * @param content the {@link com.google.api.services.gmail.model.SmimeInfo}
           * @return the request
           */
          public Insert insert(java.lang.String userId, java.lang.String sendAsEmail, com.google.api.services.gmail.model.SmimeInfo content) throws java.io.IOException {
            Insert result = new Insert(userId, sendAsEmail, content);
            initialize(result);
            return result;
          }

          public class Insert extends GmailRequest<com.google.api.services.gmail.model.SmimeInfo> {

            private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/smimeInfo";

            /**
             * Insert (upload) the given S/MIME config for the specified send-as alias. Note that pkcs12
             * format is required for the key.
             *
             * Create a request for the method "smimeInfo.insert".
             *
             * This request holds the parameters needed by the the gmail server.  After setting any optional
             * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
             * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
           *        [default: me]
             * @param sendAsEmail The email address that appears in the "From:" header for mail sent using this alias.
             * @param content the {@link com.google.api.services.gmail.model.SmimeInfo}
             * @since 1.13
             */
            protected Insert(java.lang.String userId, java.lang.String sendAsEmail, com.google.api.services.gmail.model.SmimeInfo content) {
              super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.SmimeInfo.class);
              this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
              this.sendAsEmail = com.google.api.client.util.Preconditions.checkNotNull(sendAsEmail, "Required parameter sendAsEmail must be specified.");
            }

            @Override
            public Insert set$Xgafv(java.lang.String $Xgafv) {
              return (Insert) super.set$Xgafv($Xgafv);
            }

            @Override
            public Insert setAccessToken(java.lang.String accessToken) {
              return (Insert) super.setAccessToken(accessToken);
            }

            @Override
            public Insert setAlt(java.lang.String alt) {
              return (Insert) super.setAlt(alt);
            }

            @Override
            public Insert setCallback(java.lang.String callback) {
              return (Insert) super.setCallback(callback);
            }

            @Override
            public Insert setFields(java.lang.String fields) {
              return (Insert) super.setFields(fields);
            }

            @Override
            public Insert setKey(java.lang.String key) {
              return (Insert) super.setKey(key);
            }

            @Override
            public Insert setOauthToken(java.lang.String oauthToken) {
              return (Insert) super.setOauthToken(oauthToken);
            }

            @Override
            public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Insert) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Insert setQuotaUser(java.lang.String quotaUser) {
              return (Insert) super.setQuotaUser(quotaUser);
            }

            @Override
            public Insert setUploadType(java.lang.String uploadType) {
              return (Insert) super.setUploadType(uploadType);
            }

            @Override
            public Insert setUploadProtocol(java.lang.String uploadProtocol) {
              return (Insert) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The user's email address. The special value `me` can be used to indicate the
             * authenticated user.
             */
            @com.google.api.client.util.Key
            private java.lang.String userId;

            /** The user's email address. The special value `me` can be used to indicate the authenticated user.
           [default: me]
             */
            public java.lang.String getUserId() {
              return userId;
            }

            /**
             * The user's email address. The special value `me` can be used to indicate the
             * authenticated user.
             */
            public Insert setUserId(java.lang.String userId) {
              this.userId = userId;
              return this;
            }

            /**
             * The email address that appears in the "From:" header for mail sent using this alias.
             */
            @com.google.api.client.util.Key
            private java.lang.String sendAsEmail;

            /** The email address that appears in the "From:" header for mail sent using this alias.
             */
            public java.lang.String getSendAsEmail() {
              return sendAsEmail;
            }

            /**
             * The email address that appears in the "From:" header for mail sent using this alias.
             */
            public Insert setSendAsEmail(java.lang.String sendAsEmail) {
              this.sendAsEmail = sendAsEmail;
              return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
              return (Insert) super.set(parameterName, value);
            }
          }
          /**
           * Lists S/MIME configs for the specified send-as alias.
           *
           * Create a request for the method "smimeInfo.list".
           *
           * This request holds the parameters needed by the gmail server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
           *        [default: me]
           * @param sendAsEmail The email address that appears in the "From:" header for mail sent using this alias.
           * @return the request
           */
          public List list(java.lang.String userId, java.lang.String sendAsEmail) throws java.io.IOException {
            List result = new List(userId, sendAsEmail);
            initialize(result);
            return result;
          }

          public class List extends GmailRequest<com.google.api.services.gmail.model.ListSmimeInfoResponse> {

            private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/smimeInfo";

            /**
             * Lists S/MIME configs for the specified send-as alias.
             *
             * Create a request for the method "smimeInfo.list".
             *
             * This request holds the parameters needed by the the gmail server.  After setting any optional
             * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
             * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
             * called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
           *        [default: me]
             * @param sendAsEmail The email address that appears in the "From:" header for mail sent using this alias.
             * @since 1.13
             */
            protected List(java.lang.String userId, java.lang.String sendAsEmail) {
              super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ListSmimeInfoResponse.class);
              this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
              this.sendAsEmail = com.google.api.client.util.Preconditions.checkNotNull(sendAsEmail, "Required parameter sendAsEmail must be specified.");
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The user's email address. The special value `me` can be used to indicate the
             * authenticated user.
             */
            @com.google.api.client.util.Key
            private java.lang.String userId;

            /** The user's email address. The special value `me` can be used to indicate the authenticated user.
           [default: me]
             */
            public java.lang.String getUserId() {
              return userId;
            }

            /**
             * The user's email address. The special value `me` can be used to indicate the
             * authenticated user.
             */
            public List setUserId(java.lang.String userId) {
              this.userId = userId;
              return this;
            }

            /**
             * The email address that appears in the "From:" header for mail sent using this alias.
             */
            @com.google.api.client.util.Key
            private java.lang.String sendAsEmail;

            /** The email address that appears in the "From:" header for mail sent using this alias.
             */
            public java.lang.String getSendAsEmail() {
              return sendAsEmail;
            }

            /**
             * The email address that appears in the "From:" header for mail sent using this alias.
             */
            public List setSendAsEmail(java.lang.String sendAsEmail) {
              this.sendAsEmail = sendAsEmail;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Sets the default S/MIME config for the specified send-as alias.
           *
           * Create a request for the method "smimeInfo.setDefault".
           *
           * This request holds the parameters needed by the gmail server.  After setting any optional
           * parameters, call the {@link SetDefault#execute()} method to invoke the remote operation.
           *
           * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
           *        [default: me]
           * @param sendAsEmail The email address that appears in the "From:" header for mail sent using this alias.
           * @param id The immutable ID for the SmimeInfo.
           * @return the request
           */
          public SetDefault setDefault(java.lang.String userId, java.lang.String sendAsEmail, java.lang.String id) throws java.io.IOException {
            SetDefault result = new SetDefault(userId, sendAsEmail, id);
            initialize(result);
            return result;
          }

          public class SetDefault extends GmailRequest<Void> {

            private static final String REST_PATH = "gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/smimeInfo/{id}/setDefault";

            /**
             * Sets the default S/MIME config for the specified send-as alias.
             *
             * Create a request for the method "smimeInfo.setDefault".
             *
             * This request holds the parameters needed by the the gmail server.  After setting any optional
             * parameters, call the {@link SetDefault#execute()} method to invoke the remote operation. <p>
             * {@link
             * SetDefault#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
           *        [default: me]
             * @param sendAsEmail The email address that appears in the "From:" header for mail sent using this alias.
             * @param id The immutable ID for the SmimeInfo.
             * @since 1.13
             */
            protected SetDefault(java.lang.String userId, java.lang.String sendAsEmail, java.lang.String id) {
              super(Gmail.this, "POST", REST_PATH, null, Void.class);
              this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
              this.sendAsEmail = com.google.api.client.util.Preconditions.checkNotNull(sendAsEmail, "Required parameter sendAsEmail must be specified.");
              this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
            }

            @Override
            public SetDefault set$Xgafv(java.lang.String $Xgafv) {
              return (SetDefault) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetDefault setAccessToken(java.lang.String accessToken) {
              return (SetDefault) super.setAccessToken(accessToken);
            }

            @Override
            public SetDefault setAlt(java.lang.String alt) {
              return (SetDefault) super.setAlt(alt);
            }

            @Override
            public SetDefault setCallback(java.lang.String callback) {
              return (SetDefault) super.setCallback(callback);
            }

            @Override
            public SetDefault setFields(java.lang.String fields) {
              return (SetDefault) super.setFields(fields);
            }

            @Override
            public SetDefault setKey(java.lang.String key) {
              return (SetDefault) super.setKey(key);
            }

            @Override
            public SetDefault setOauthToken(java.lang.String oauthToken) {
              return (SetDefault) super.setOauthToken(oauthToken);
            }

            @Override
            public SetDefault setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetDefault) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetDefault setQuotaUser(java.lang.String quotaUser) {
              return (SetDefault) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetDefault setUploadType(java.lang.String uploadType) {
              return (SetDefault) super.setUploadType(uploadType);
            }

            @Override
            public SetDefault setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetDefault) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * The user's email address. The special value `me` can be used to indicate the
             * authenticated user.
             */
            @com.google.api.client.util.Key
            private java.lang.String userId;

            /** The user's email address. The special value `me` can be used to indicate the authenticated user.
           [default: me]
             */
            public java.lang.String getUserId() {
              return userId;
            }

            /**
             * The user's email address. The special value `me` can be used to indicate the
             * authenticated user.
             */
            public SetDefault setUserId(java.lang.String userId) {
              this.userId = userId;
              return this;
            }

            /**
             * The email address that appears in the "From:" header for mail sent using this alias.
             */
            @com.google.api.client.util.Key
            private java.lang.String sendAsEmail;

            /** The email address that appears in the "From:" header for mail sent using this alias.
             */
            public java.lang.String getSendAsEmail() {
              return sendAsEmail;
            }

            /**
             * The email address that appears in the "From:" header for mail sent using this alias.
             */
            public SetDefault setSendAsEmail(java.lang.String sendAsEmail) {
              this.sendAsEmail = sendAsEmail;
              return this;
            }

            /** The immutable ID for the SmimeInfo. */
            @com.google.api.client.util.Key
            private java.lang.String id;

            /** The immutable ID for the SmimeInfo.
             */
            public java.lang.String getId() {
              return id;
            }

            /** The immutable ID for the SmimeInfo. */
            public SetDefault setId(java.lang.String id) {
              this.id = id;
              return this;
            }

            @Override
            public SetDefault set(String parameterName, Object value) {
              return (SetDefault) super.set(parameterName, value);
            }
          }

        }
      }
    }
    /**
     * An accessor for creating requests from the Threads collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Gmail gmail = new Gmail(...);}
     *   {@code Gmail.Threads.List request = gmail.threads().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Threads threads() {
      return new Threads();
    }

    /**
     * The "threads" collection of methods.
     */
    public class Threads {

      /**
       * Immediately and permanently deletes the specified thread. Any messages that belong to the thread
       * are also deleted. This operation cannot be undone. Prefer `threads.trash` instead.
       *
       * Create a request for the method "threads.delete".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id ID of the Thread to delete.
       * @return the request
       */
      public Delete delete(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Delete result = new Delete(userId, id);
        initialize(result);
        return result;
      }

      public class Delete extends GmailRequest<Void> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/threads/{id}";

        /**
         * Immediately and permanently deletes the specified thread. Any messages that belong to the
         * thread are also deleted. This operation cannot be undone. Prefer `threads.trash` instead.
         *
         * Create a request for the method "threads.delete".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id ID of the Thread to delete.
         * @since 1.13
         */
        protected Delete(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Delete setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** ID of the Thread to delete. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** ID of the Thread to delete.
         */
        public java.lang.String getId() {
          return id;
        }

        /** ID of the Thread to delete. */
        public Delete setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the specified thread.
       *
       * Create a request for the method "threads.get".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the thread to retrieve.
       * @return the request
       */
      public Get get(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Get result = new Get(userId, id);
        initialize(result);
        return result;
      }

      public class Get extends GmailRequest<com.google.api.services.gmail.model.Thread> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/threads/{id}";

        /**
         * Gets the specified thread.
         *
         * Create a request for the method "threads.get".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the thread to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.Thread.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Get setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the thread to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the thread to retrieve.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the thread to retrieve. */
        public Get setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        /** The format to return the messages in. */
        @com.google.api.client.util.Key
        private java.lang.String format;

        /** The format to return the messages in. [default: full]
         */
        public java.lang.String getFormat() {
          return format;
        }

        /** The format to return the messages in. */
        public Get setFormat(java.lang.String format) {
          this.format = format;
          return this;
        }

        /** When given and format is METADATA, only include headers specified. */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> metadataHeaders;

        /** When given and format is METADATA, only include headers specified.
         */
        public java.util.List<java.lang.String> getMetadataHeaders() {
          return metadataHeaders;
        }

        /** When given and format is METADATA, only include headers specified. */
        public Get setMetadataHeaders(java.util.List<java.lang.String> metadataHeaders) {
          this.metadataHeaders = metadataHeaders;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists the threads in the user's mailbox.
       *
       * Create a request for the method "threads.list".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @return the request
       */
      public List list(java.lang.String userId) throws java.io.IOException {
        List result = new List(userId);
        initialize(result);
        return result;
      }

      public class List extends GmailRequest<com.google.api.services.gmail.model.ListThreadsResponse> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/threads";

        /**
         * Lists the threads in the user's mailbox.
         *
         * Create a request for the method "threads.list".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @since 1.13
         */
        protected List(java.lang.String userId) {
          super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.ListThreadsResponse.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public List setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** Include threads from `SPAM` and `TRASH` in the results. */
        @com.google.api.client.util.Key
        private java.lang.Boolean includeSpamTrash;

        /** Include threads from `SPAM` and `TRASH` in the results. [default: false]
         */
        public java.lang.Boolean getIncludeSpamTrash() {
          return includeSpamTrash;
        }

        /** Include threads from `SPAM` and `TRASH` in the results. */
        public List setIncludeSpamTrash(java.lang.Boolean includeSpamTrash) {
          this.includeSpamTrash = includeSpamTrash;
          return this;
        }

        /**
         * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
         *
         * <p>
         * Boolean properties can have four possible values:
         * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
         * or {@link Boolean#FALSE}.
         * </p>
         *
         * <p>
         * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
         * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
         * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
         * </p>
         *
         * <p>
         * Include threads from `SPAM` and `TRASH` in the results.
         * </p>
         */
        public boolean isIncludeSpamTrash() {
          if (includeSpamTrash == null || includeSpamTrash == com.google.api.client.util.Data.NULL_BOOLEAN) {
            return false;
          }
          return includeSpamTrash;
        }

        /** Only return threads with labels that match all of the specified label IDs. */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> labelIds;

        /** Only return threads with labels that match all of the specified label IDs.
         */
        public java.util.List<java.lang.String> getLabelIds() {
          return labelIds;
        }

        /** Only return threads with labels that match all of the specified label IDs. */
        public List setLabelIds(java.util.List<java.lang.String> labelIds) {
          this.labelIds = labelIds;
          return this;
        }

        /**
         * Maximum number of threads to return. This field defaults to 100. The maximum allowed
         * value for this field is 500.
         */
        @com.google.api.client.util.Key
        private java.lang.Long maxResults;

        /** Maximum number of threads to return. This field defaults to 100. The maximum allowed value for this
       field is 500. [default: 100]
         */
        public java.lang.Long getMaxResults() {
          return maxResults;
        }

        /**
         * Maximum number of threads to return. This field defaults to 100. The maximum allowed
         * value for this field is 500.
         */
        public List setMaxResults(java.lang.Long maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /** Page token to retrieve a specific page of results in the list. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Page token to retrieve a specific page of results in the list.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** Page token to retrieve a specific page of results in the list. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * Only return threads matching the specified query. Supports the same query format as the
         * Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
         * Parameter cannot be used when accessing the api using the gmail.metadata scope.
         */
        @com.google.api.client.util.Key
        private java.lang.String q;

        /** Only return threads matching the specified query. Supports the same query format as the Gmail
       search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`. Parameter cannot be
       used when accessing the api using the gmail.metadata scope.
         */
        public java.lang.String getQ() {
          return q;
        }

        /**
         * Only return threads matching the specified query. Supports the same query format as the
         * Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
         * Parameter cannot be used when accessing the api using the gmail.metadata scope.
         */
        public List setQ(java.lang.String q) {
          this.q = q;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Modifies the labels applied to the thread. This applies to all messages in the thread.
       *
       * Create a request for the method "threads.modify".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Modify#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the thread to modify.
       * @param content the {@link com.google.api.services.gmail.model.ModifyThreadRequest}
       * @return the request
       */
      public Modify modify(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.ModifyThreadRequest content) throws java.io.IOException {
        Modify result = new Modify(userId, id, content);
        initialize(result);
        return result;
      }

      public class Modify extends GmailRequest<com.google.api.services.gmail.model.Thread> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/threads/{id}/modify";

        /**
         * Modifies the labels applied to the thread. This applies to all messages in the thread.
         *
         * Create a request for the method "threads.modify".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Modify#execute()} method to invoke the remote operation. <p> {@link
         * Modify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the thread to modify.
         * @param content the {@link com.google.api.services.gmail.model.ModifyThreadRequest}
         * @since 1.13
         */
        protected Modify(java.lang.String userId, java.lang.String id, com.google.api.services.gmail.model.ModifyThreadRequest content) {
          super(Gmail.this, "POST", REST_PATH, content, com.google.api.services.gmail.model.Thread.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Modify set$Xgafv(java.lang.String $Xgafv) {
          return (Modify) super.set$Xgafv($Xgafv);
        }

        @Override
        public Modify setAccessToken(java.lang.String accessToken) {
          return (Modify) super.setAccessToken(accessToken);
        }

        @Override
        public Modify setAlt(java.lang.String alt) {
          return (Modify) super.setAlt(alt);
        }

        @Override
        public Modify setCallback(java.lang.String callback) {
          return (Modify) super.setCallback(callback);
        }

        @Override
        public Modify setFields(java.lang.String fields) {
          return (Modify) super.setFields(fields);
        }

        @Override
        public Modify setKey(java.lang.String key) {
          return (Modify) super.setKey(key);
        }

        @Override
        public Modify setOauthToken(java.lang.String oauthToken) {
          return (Modify) super.setOauthToken(oauthToken);
        }

        @Override
        public Modify setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Modify) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Modify setQuotaUser(java.lang.String quotaUser) {
          return (Modify) super.setQuotaUser(quotaUser);
        }

        @Override
        public Modify setUploadType(java.lang.String uploadType) {
          return (Modify) super.setUploadType(uploadType);
        }

        @Override
        public Modify setUploadProtocol(java.lang.String uploadProtocol) {
          return (Modify) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Modify setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the thread to modify. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the thread to modify.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the thread to modify. */
        public Modify setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Modify set(String parameterName, Object value) {
          return (Modify) super.set(parameterName, value);
        }
      }
      /**
       * Moves the specified thread to the trash. Any messages that belong to the thread are also moved to
       * the trash.
       *
       * Create a request for the method "threads.trash".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Trash#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the thread to Trash.
       * @return the request
       */
      public Trash trash(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Trash result = new Trash(userId, id);
        initialize(result);
        return result;
      }

      public class Trash extends GmailRequest<com.google.api.services.gmail.model.Thread> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/threads/{id}/trash";

        /**
         * Moves the specified thread to the trash. Any messages that belong to the thread are also moved
         * to the trash.
         *
         * Create a request for the method "threads.trash".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Trash#execute()} method to invoke the remote operation. <p> {@link
         * Trash#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the thread to Trash.
         * @since 1.13
         */
        protected Trash(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "POST", REST_PATH, null, com.google.api.services.gmail.model.Thread.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Trash set$Xgafv(java.lang.String $Xgafv) {
          return (Trash) super.set$Xgafv($Xgafv);
        }

        @Override
        public Trash setAccessToken(java.lang.String accessToken) {
          return (Trash) super.setAccessToken(accessToken);
        }

        @Override
        public Trash setAlt(java.lang.String alt) {
          return (Trash) super.setAlt(alt);
        }

        @Override
        public Trash setCallback(java.lang.String callback) {
          return (Trash) super.setCallback(callback);
        }

        @Override
        public Trash setFields(java.lang.String fields) {
          return (Trash) super.setFields(fields);
        }

        @Override
        public Trash setKey(java.lang.String key) {
          return (Trash) super.setKey(key);
        }

        @Override
        public Trash setOauthToken(java.lang.String oauthToken) {
          return (Trash) super.setOauthToken(oauthToken);
        }

        @Override
        public Trash setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Trash) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Trash setQuotaUser(java.lang.String quotaUser) {
          return (Trash) super.setQuotaUser(quotaUser);
        }

        @Override
        public Trash setUploadType(java.lang.String uploadType) {
          return (Trash) super.setUploadType(uploadType);
        }

        @Override
        public Trash setUploadProtocol(java.lang.String uploadProtocol) {
          return (Trash) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Trash setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the thread to Trash. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the thread to Trash.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the thread to Trash. */
        public Trash setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Trash set(String parameterName, Object value) {
          return (Trash) super.set(parameterName, value);
        }
      }
      /**
       * Removes the specified thread from the trash. Any messages that belong to the thread are also
       * removed from the trash.
       *
       * Create a request for the method "threads.untrash".
       *
       * This request holds the parameters needed by the gmail server.  After setting any optional
       * parameters, call the {@link Untrash#execute()} method to invoke the remote operation.
       *
       * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
       * @param id The ID of the thread to remove from Trash.
       * @return the request
       */
      public Untrash untrash(java.lang.String userId, java.lang.String id) throws java.io.IOException {
        Untrash result = new Untrash(userId, id);
        initialize(result);
        return result;
      }

      public class Untrash extends GmailRequest<com.google.api.services.gmail.model.Thread> {

        private static final String REST_PATH = "gmail/v1/users/{userId}/threads/{id}/untrash";

        /**
         * Removes the specified thread from the trash. Any messages that belong to the thread are also
         * removed from the trash.
         *
         * Create a request for the method "threads.untrash".
         *
         * This request holds the parameters needed by the the gmail server.  After setting any optional
         * parameters, call the {@link Untrash#execute()} method to invoke the remote operation. <p>
         * {@link
         * Untrash#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId The user's email address. The special value `me` can be used to indicate the authenticated user.
       *        [default: me]
         * @param id The ID of the thread to remove from Trash.
         * @since 1.13
         */
        protected Untrash(java.lang.String userId, java.lang.String id) {
          super(Gmail.this, "POST", REST_PATH, null, com.google.api.services.gmail.model.Thread.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
        }

        @Override
        public Untrash set$Xgafv(java.lang.String $Xgafv) {
          return (Untrash) super.set$Xgafv($Xgafv);
        }

        @Override
        public Untrash setAccessToken(java.lang.String accessToken) {
          return (Untrash) super.setAccessToken(accessToken);
        }

        @Override
        public Untrash setAlt(java.lang.String alt) {
          return (Untrash) super.setAlt(alt);
        }

        @Override
        public Untrash setCallback(java.lang.String callback) {
          return (Untrash) super.setCallback(callback);
        }

        @Override
        public Untrash setFields(java.lang.String fields) {
          return (Untrash) super.setFields(fields);
        }

        @Override
        public Untrash setKey(java.lang.String key) {
          return (Untrash) super.setKey(key);
        }

        @Override
        public Untrash setOauthToken(java.lang.String oauthToken) {
          return (Untrash) super.setOauthToken(oauthToken);
        }

        @Override
        public Untrash setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Untrash) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Untrash setQuotaUser(java.lang.String quotaUser) {
          return (Untrash) super.setQuotaUser(quotaUser);
        }

        @Override
        public Untrash setUploadType(java.lang.String uploadType) {
          return (Untrash) super.setUploadType(uploadType);
        }

        @Override
        public Untrash setUploadProtocol(java.lang.String uploadProtocol) {
          return (Untrash) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** The user's email address. The special value `me` can be used to indicate the authenticated user.
       [default: me]
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * The user's email address. The special value `me` can be used to indicate the
         * authenticated user.
         */
        public Untrash setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the thread to remove from Trash. */
        @com.google.api.client.util.Key
        private java.lang.String id;

        /** The ID of the thread to remove from Trash.
         */
        public java.lang.String getId() {
          return id;
        }

        /** The ID of the thread to remove from Trash. */
        public Untrash setId(java.lang.String id) {
          this.id = id;
          return this;
        }

        @Override
        public Untrash set(String parameterName, Object value) {
          return (Untrash) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link Gmail}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Gmail}. */
    @Override
    public Gmail build() {
      return new Gmail(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link GmailRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setGmailRequestInitializer(
        GmailRequestInitializer gmailRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(gmailRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
