/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.gmail;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.gmail.GmailRequest;
import com.google.api.services.gmail.GmailRequestInitializer;
import com.google.api.services.gmail.model.AutoForwarding;
import com.google.api.services.gmail.model.BatchDeleteMessagesRequest;
import com.google.api.services.gmail.model.BatchModifyMessagesRequest;
import com.google.api.services.gmail.model.Delegate;
import com.google.api.services.gmail.model.Draft;
import com.google.api.services.gmail.model.Filter;
import com.google.api.services.gmail.model.ForwardingAddress;
import com.google.api.services.gmail.model.ImapSettings;
import com.google.api.services.gmail.model.Label;
import com.google.api.services.gmail.model.LanguageSettings;
import com.google.api.services.gmail.model.ListDelegatesResponse;
import com.google.api.services.gmail.model.ListDraftsResponse;
import com.google.api.services.gmail.model.ListFiltersResponse;
import com.google.api.services.gmail.model.ListForwardingAddressesResponse;
import com.google.api.services.gmail.model.ListHistoryResponse;
import com.google.api.services.gmail.model.ListLabelsResponse;
import com.google.api.services.gmail.model.ListMessagesResponse;
import com.google.api.services.gmail.model.ListSendAsResponse;
import com.google.api.services.gmail.model.ListSmimeInfoResponse;
import com.google.api.services.gmail.model.ListThreadsResponse;
import com.google.api.services.gmail.model.Message;
import com.google.api.services.gmail.model.MessagePartBody;
import com.google.api.services.gmail.model.ModifyMessageRequest;
import com.google.api.services.gmail.model.ModifyThreadRequest;
import com.google.api.services.gmail.model.PopSettings;
import com.google.api.services.gmail.model.Profile;
import com.google.api.services.gmail.model.SendAs;
import com.google.api.services.gmail.model.SmimeInfo;
import com.google.api.services.gmail.model.Thread;
import com.google.api.services.gmail.model.VacationSettings;
import com.google.api.services.gmail.model.WatchRequest;
import com.google.api.services.gmail.model.WatchResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;

public class Gmail
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "gmail/v1/users/";
    public static final String DEFAULT_BATCH_PATH = "batch/gmail/v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/gmail/v1/users/";

    public Gmail(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Gmail(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.27.0 of the Gmail API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Gmail.DEFAULT_ROOT_URL, Gmail.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Gmail.DEFAULT_BATCH_PATH);
        }

        public Gmail build() {
            return new Gmail(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setGmailRequestInitializer(GmailRequestInitializer gmailRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)gmailRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Users {
        public GetProfile getProfile(String userId) throws IOException {
            GetProfile result = new GetProfile(userId);
            Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Stop stop(String userId) throws IOException {
            Stop result = new Stop(userId);
            Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Watch watch(String userId, WatchRequest content) throws IOException {
            Watch result = new Watch(userId, content);
            Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Drafts drafts() {
            return new Drafts();
        }

        public History history() {
            return new History();
        }

        public Labels labels() {
            return new Labels();
        }

        public Messages messages() {
            return new Messages();
        }

        public Settings settings() {
            return new Settings();
        }

        public Threads threads() {
            return new Threads();
        }

        public class Threads {
            public Delete delete(String userId, String id) throws IOException {
                Delete result = new Delete(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String userId, String id) throws IOException {
                Get result = new Get(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String userId) throws IOException {
                List result = new List(userId);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Modify modify(String userId, String id, ModifyThreadRequest content) throws IOException {
                Modify result = new Modify(userId, id, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Trash trash(String userId, String id) throws IOException {
                Trash result = new Trash(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Untrash untrash(String userId, String id) throws IOException {
                Untrash result = new Untrash(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Untrash
            extends GmailRequest<Thread> {
                private static final String REST_PATH = "{userId}/threads/{id}/untrash";
                @Key
                private String userId;
                @Key
                private String id;

                protected Untrash(String userId, String id) {
                    super(Gmail.this, "POST", REST_PATH, null, Thread.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Untrash setAlt(String alt) {
                    return (Untrash)super.setAlt(alt);
                }

                public Untrash setFields(String fields) {
                    return (Untrash)super.setFields(fields);
                }

                public Untrash setKey(String key) {
                    return (Untrash)super.setKey(key);
                }

                public Untrash setOauthToken(String oauthToken) {
                    return (Untrash)super.setOauthToken(oauthToken);
                }

                public Untrash setPrettyPrint(Boolean prettyPrint) {
                    return (Untrash)super.setPrettyPrint(prettyPrint);
                }

                public Untrash setQuotaUser(String quotaUser) {
                    return (Untrash)super.setQuotaUser(quotaUser);
                }

                public Untrash setUserIp(String userIp) {
                    return (Untrash)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Untrash setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Untrash setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Untrash set(String parameterName, Object value) {
                    return (Untrash)super.set(parameterName, value);
                }
            }

            public class Trash
            extends GmailRequest<Thread> {
                private static final String REST_PATH = "{userId}/threads/{id}/trash";
                @Key
                private String userId;
                @Key
                private String id;

                protected Trash(String userId, String id) {
                    super(Gmail.this, "POST", REST_PATH, null, Thread.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Trash setAlt(String alt) {
                    return (Trash)super.setAlt(alt);
                }

                public Trash setFields(String fields) {
                    return (Trash)super.setFields(fields);
                }

                public Trash setKey(String key) {
                    return (Trash)super.setKey(key);
                }

                public Trash setOauthToken(String oauthToken) {
                    return (Trash)super.setOauthToken(oauthToken);
                }

                public Trash setPrettyPrint(Boolean prettyPrint) {
                    return (Trash)super.setPrettyPrint(prettyPrint);
                }

                public Trash setQuotaUser(String quotaUser) {
                    return (Trash)super.setQuotaUser(quotaUser);
                }

                public Trash setUserIp(String userIp) {
                    return (Trash)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Trash setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Trash setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Trash set(String parameterName, Object value) {
                    return (Trash)super.set(parameterName, value);
                }
            }

            public class Modify
            extends GmailRequest<Thread> {
                private static final String REST_PATH = "{userId}/threads/{id}/modify";
                @Key
                private String userId;
                @Key
                private String id;

                protected Modify(String userId, String id, ModifyThreadRequest content) {
                    super(Gmail.this, "POST", REST_PATH, (Object)content, Thread.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Modify setAlt(String alt) {
                    return (Modify)super.setAlt(alt);
                }

                public Modify setFields(String fields) {
                    return (Modify)super.setFields(fields);
                }

                public Modify setKey(String key) {
                    return (Modify)super.setKey(key);
                }

                public Modify setOauthToken(String oauthToken) {
                    return (Modify)super.setOauthToken(oauthToken);
                }

                public Modify setPrettyPrint(Boolean prettyPrint) {
                    return (Modify)super.setPrettyPrint(prettyPrint);
                }

                public Modify setQuotaUser(String quotaUser) {
                    return (Modify)super.setQuotaUser(quotaUser);
                }

                public Modify setUserIp(String userIp) {
                    return (Modify)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Modify setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Modify setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Modify set(String parameterName, Object value) {
                    return (Modify)super.set(parameterName, value);
                }
            }

            public class List
            extends GmailRequest<ListThreadsResponse> {
                private static final String REST_PATH = "{userId}/threads";
                @Key
                private String userId;
                @Key
                private Boolean includeSpamTrash;
                @Key
                private java.util.List<String> labelIds;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String q;

                protected List(String userId) {
                    super(Gmail.this, "GET", REST_PATH, null, ListThreadsResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public Boolean getIncludeSpamTrash() {
                    return this.includeSpamTrash;
                }

                public List setIncludeSpamTrash(Boolean includeSpamTrash) {
                    this.includeSpamTrash = includeSpamTrash;
                    return this;
                }

                public boolean isIncludeSpamTrash() {
                    if (this.includeSpamTrash == null || this.includeSpamTrash == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.includeSpamTrash;
                }

                public java.util.List<String> getLabelIds() {
                    return this.labelIds;
                }

                public List setLabelIds(java.util.List<String> labelIds) {
                    this.labelIds = labelIds;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getQ() {
                    return this.q;
                }

                public List setQ(String q) {
                    this.q = q;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends GmailRequest<Thread> {
                private static final String REST_PATH = "{userId}/threads/{id}";
                @Key
                private String userId;
                @Key
                private String id;
                @Key
                private String format;
                @Key
                private java.util.List<String> metadataHeaders;

                protected Get(String userId, String id) {
                    super(Gmail.this, "GET", REST_PATH, null, Thread.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String id) {
                    this.id = id;
                    return this;
                }

                public String getFormat() {
                    return this.format;
                }

                public Get setFormat(String format) {
                    this.format = format;
                    return this;
                }

                public java.util.List<String> getMetadataHeaders() {
                    return this.metadataHeaders;
                }

                public Get setMetadataHeaders(java.util.List<String> metadataHeaders) {
                    this.metadataHeaders = metadataHeaders;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/threads/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Delete(String userId, String id) {
                    super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Settings {
            public GetAutoForwarding getAutoForwarding(String userId) throws IOException {
                GetAutoForwarding result = new GetAutoForwarding(userId);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetImap getImap(String userId) throws IOException {
                GetImap result = new GetImap(userId);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetLanguage getLanguage(String userId) throws IOException {
                GetLanguage result = new GetLanguage(userId);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetPop getPop(String userId) throws IOException {
                GetPop result = new GetPop(userId);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetVacation getVacation(String userId) throws IOException {
                GetVacation result = new GetVacation(userId);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdateAutoForwarding updateAutoForwarding(String userId, AutoForwarding content) throws IOException {
                UpdateAutoForwarding result = new UpdateAutoForwarding(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdateImap updateImap(String userId, ImapSettings content) throws IOException {
                UpdateImap result = new UpdateImap(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdateLanguage updateLanguage(String userId, LanguageSettings content) throws IOException {
                UpdateLanguage result = new UpdateLanguage(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdatePop updatePop(String userId, PopSettings content) throws IOException {
                UpdatePop result = new UpdatePop(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdateVacation updateVacation(String userId, VacationSettings content) throws IOException {
                UpdateVacation result = new UpdateVacation(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delegates delegates() {
                return new Delegates();
            }

            public Filters filters() {
                return new Filters();
            }

            public ForwardingAddresses forwardingAddresses() {
                return new ForwardingAddresses();
            }

            public SendAs sendAs() {
                return new SendAs();
            }

            public class SendAs {
                public Create create(String userId, com.google.api.services.gmail.model.SendAs content) throws IOException {
                    Create result = new Create(userId, content);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String userId, String sendAsEmail) throws IOException {
                    Delete result = new Delete(userId, sendAsEmail);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String userId, String sendAsEmail) throws IOException {
                    Get result = new Get(userId, sendAsEmail);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String userId) throws IOException {
                    List result = new List(userId);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String userId, String sendAsEmail, com.google.api.services.gmail.model.SendAs content) throws IOException {
                    Patch result = new Patch(userId, sendAsEmail, content);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Update update(String userId, String sendAsEmail, com.google.api.services.gmail.model.SendAs content) throws IOException {
                    Update result = new Update(userId, sendAsEmail, content);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Verify verify(String userId, String sendAsEmail) throws IOException {
                    Verify result = new Verify(userId, sendAsEmail);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SmimeInfo smimeInfo() {
                    return new SmimeInfo();
                }

                public class SmimeInfo {
                    public Delete delete(String userId, String sendAsEmail, String id) throws IOException {
                        Delete result = new Delete(userId, sendAsEmail, id);
                        Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String userId, String sendAsEmail, String id) throws IOException {
                        Get result = new Get(userId, sendAsEmail, id);
                        Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Insert insert(String userId, String sendAsEmail, com.google.api.services.gmail.model.SmimeInfo content) throws IOException {
                        Insert result = new Insert(userId, sendAsEmail, content);
                        Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String userId, String sendAsEmail) throws IOException {
                        List result = new List(userId, sendAsEmail);
                        Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetDefault setDefault(String userId, String sendAsEmail, String id) throws IOException {
                        SetDefault result = new SetDefault(userId, sendAsEmail, id);
                        Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class SetDefault
                    extends GmailRequest<Void> {
                        private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}/smimeInfo/{id}/setDefault";
                        @Key
                        private String userId;
                        @Key
                        private String sendAsEmail;
                        @Key
                        private String id;

                        protected SetDefault(String userId, String sendAsEmail, String id) {
                            super(Gmail.this, "POST", REST_PATH, null, Void.class);
                            this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                            this.sendAsEmail = (String)Preconditions.checkNotNull((Object)sendAsEmail, (Object)"Required parameter sendAsEmail must be specified.");
                            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                        }

                        public SetDefault setAlt(String alt) {
                            return (SetDefault)super.setAlt(alt);
                        }

                        public SetDefault setFields(String fields) {
                            return (SetDefault)super.setFields(fields);
                        }

                        public SetDefault setKey(String key) {
                            return (SetDefault)super.setKey(key);
                        }

                        public SetDefault setOauthToken(String oauthToken) {
                            return (SetDefault)super.setOauthToken(oauthToken);
                        }

                        public SetDefault setPrettyPrint(Boolean prettyPrint) {
                            return (SetDefault)super.setPrettyPrint(prettyPrint);
                        }

                        public SetDefault setQuotaUser(String quotaUser) {
                            return (SetDefault)super.setQuotaUser(quotaUser);
                        }

                        public SetDefault setUserIp(String userIp) {
                            return (SetDefault)super.setUserIp(userIp);
                        }

                        public String getUserId() {
                            return this.userId;
                        }

                        public SetDefault setUserId(String userId) {
                            this.userId = userId;
                            return this;
                        }

                        public String getSendAsEmail() {
                            return this.sendAsEmail;
                        }

                        public SetDefault setSendAsEmail(String sendAsEmail) {
                            this.sendAsEmail = sendAsEmail;
                            return this;
                        }

                        public String getId() {
                            return this.id;
                        }

                        public SetDefault setId(String id) {
                            this.id = id;
                            return this;
                        }

                        @Override
                        public SetDefault set(String parameterName, Object value) {
                            return (SetDefault)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends GmailRequest<ListSmimeInfoResponse> {
                        private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}/smimeInfo";
                        @Key
                        private String userId;
                        @Key
                        private String sendAsEmail;

                        protected List(String userId, String sendAsEmail) {
                            super(Gmail.this, "GET", REST_PATH, null, ListSmimeInfoResponse.class);
                            this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                            this.sendAsEmail = (String)Preconditions.checkNotNull((Object)sendAsEmail, (Object)"Required parameter sendAsEmail must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUserIp(String userIp) {
                            return (List)super.setUserIp(userIp);
                        }

                        public String getUserId() {
                            return this.userId;
                        }

                        public List setUserId(String userId) {
                            this.userId = userId;
                            return this;
                        }

                        public String getSendAsEmail() {
                            return this.sendAsEmail;
                        }

                        public List setSendAsEmail(String sendAsEmail) {
                            this.sendAsEmail = sendAsEmail;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Insert
                    extends GmailRequest<com.google.api.services.gmail.model.SmimeInfo> {
                        private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}/smimeInfo";
                        @Key
                        private String userId;
                        @Key
                        private String sendAsEmail;

                        protected Insert(String userId, String sendAsEmail, com.google.api.services.gmail.model.SmimeInfo content) {
                            super(Gmail.this, "POST", REST_PATH, (Object)content, com.google.api.services.gmail.model.SmimeInfo.class);
                            this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                            this.sendAsEmail = (String)Preconditions.checkNotNull((Object)sendAsEmail, (Object)"Required parameter sendAsEmail must be specified.");
                        }

                        public Insert setAlt(String alt) {
                            return (Insert)super.setAlt(alt);
                        }

                        public Insert setFields(String fields) {
                            return (Insert)super.setFields(fields);
                        }

                        public Insert setKey(String key) {
                            return (Insert)super.setKey(key);
                        }

                        public Insert setOauthToken(String oauthToken) {
                            return (Insert)super.setOauthToken(oauthToken);
                        }

                        public Insert setPrettyPrint(Boolean prettyPrint) {
                            return (Insert)super.setPrettyPrint(prettyPrint);
                        }

                        public Insert setQuotaUser(String quotaUser) {
                            return (Insert)super.setQuotaUser(quotaUser);
                        }

                        public Insert setUserIp(String userIp) {
                            return (Insert)super.setUserIp(userIp);
                        }

                        public String getUserId() {
                            return this.userId;
                        }

                        public Insert setUserId(String userId) {
                            this.userId = userId;
                            return this;
                        }

                        public String getSendAsEmail() {
                            return this.sendAsEmail;
                        }

                        public Insert setSendAsEmail(String sendAsEmail) {
                            this.sendAsEmail = sendAsEmail;
                            return this;
                        }

                        @Override
                        public Insert set(String parameterName, Object value) {
                            return (Insert)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends GmailRequest<com.google.api.services.gmail.model.SmimeInfo> {
                        private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}/smimeInfo/{id}";
                        @Key
                        private String userId;
                        @Key
                        private String sendAsEmail;
                        @Key
                        private String id;

                        protected Get(String userId, String sendAsEmail, String id) {
                            super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.SmimeInfo.class);
                            this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                            this.sendAsEmail = (String)Preconditions.checkNotNull((Object)sendAsEmail, (Object)"Required parameter sendAsEmail must be specified.");
                            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUserIp(String userIp) {
                            return (Get)super.setUserIp(userIp);
                        }

                        public String getUserId() {
                            return this.userId;
                        }

                        public Get setUserId(String userId) {
                            this.userId = userId;
                            return this;
                        }

                        public String getSendAsEmail() {
                            return this.sendAsEmail;
                        }

                        public Get setSendAsEmail(String sendAsEmail) {
                            this.sendAsEmail = sendAsEmail;
                            return this;
                        }

                        public String getId() {
                            return this.id;
                        }

                        public Get setId(String id) {
                            this.id = id;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends GmailRequest<Void> {
                        private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}/smimeInfo/{id}";
                        @Key
                        private String userId;
                        @Key
                        private String sendAsEmail;
                        @Key
                        private String id;

                        protected Delete(String userId, String sendAsEmail, String id) {
                            super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                            this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                            this.sendAsEmail = (String)Preconditions.checkNotNull((Object)sendAsEmail, (Object)"Required parameter sendAsEmail must be specified.");
                            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUserIp(String userIp) {
                            return (Delete)super.setUserIp(userIp);
                        }

                        public String getUserId() {
                            return this.userId;
                        }

                        public Delete setUserId(String userId) {
                            this.userId = userId;
                            return this;
                        }

                        public String getSendAsEmail() {
                            return this.sendAsEmail;
                        }

                        public Delete setSendAsEmail(String sendAsEmail) {
                            this.sendAsEmail = sendAsEmail;
                            return this;
                        }

                        public String getId() {
                            return this.id;
                        }

                        public Delete setId(String id) {
                            this.id = id;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }
                }

                public class Verify
                extends GmailRequest<Void> {
                    private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}/verify";
                    @Key
                    private String userId;
                    @Key
                    private String sendAsEmail;

                    protected Verify(String userId, String sendAsEmail) {
                        super(Gmail.this, "POST", REST_PATH, null, Void.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.sendAsEmail = (String)Preconditions.checkNotNull((Object)sendAsEmail, (Object)"Required parameter sendAsEmail must be specified.");
                    }

                    public Verify setAlt(String alt) {
                        return (Verify)super.setAlt(alt);
                    }

                    public Verify setFields(String fields) {
                        return (Verify)super.setFields(fields);
                    }

                    public Verify setKey(String key) {
                        return (Verify)super.setKey(key);
                    }

                    public Verify setOauthToken(String oauthToken) {
                        return (Verify)super.setOauthToken(oauthToken);
                    }

                    public Verify setPrettyPrint(Boolean prettyPrint) {
                        return (Verify)super.setPrettyPrint(prettyPrint);
                    }

                    public Verify setQuotaUser(String quotaUser) {
                        return (Verify)super.setQuotaUser(quotaUser);
                    }

                    public Verify setUserIp(String userIp) {
                        return (Verify)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Verify setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getSendAsEmail() {
                        return this.sendAsEmail;
                    }

                    public Verify setSendAsEmail(String sendAsEmail) {
                        this.sendAsEmail = sendAsEmail;
                        return this;
                    }

                    @Override
                    public Verify set(String parameterName, Object value) {
                        return (Verify)super.set(parameterName, value);
                    }
                }

                public class Update
                extends GmailRequest<com.google.api.services.gmail.model.SendAs> {
                    private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String sendAsEmail;

                    protected Update(String userId, String sendAsEmail, com.google.api.services.gmail.model.SendAs content) {
                        super(Gmail.this, "PUT", REST_PATH, (Object)content, com.google.api.services.gmail.model.SendAs.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.sendAsEmail = (String)Preconditions.checkNotNull((Object)sendAsEmail, (Object)"Required parameter sendAsEmail must be specified.");
                    }

                    public Update setAlt(String alt) {
                        return (Update)super.setAlt(alt);
                    }

                    public Update setFields(String fields) {
                        return (Update)super.setFields(fields);
                    }

                    public Update setKey(String key) {
                        return (Update)super.setKey(key);
                    }

                    public Update setOauthToken(String oauthToken) {
                        return (Update)super.setOauthToken(oauthToken);
                    }

                    public Update setPrettyPrint(Boolean prettyPrint) {
                        return (Update)super.setPrettyPrint(prettyPrint);
                    }

                    public Update setQuotaUser(String quotaUser) {
                        return (Update)super.setQuotaUser(quotaUser);
                    }

                    public Update setUserIp(String userIp) {
                        return (Update)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Update setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getSendAsEmail() {
                        return this.sendAsEmail;
                    }

                    public Update setSendAsEmail(String sendAsEmail) {
                        this.sendAsEmail = sendAsEmail;
                        return this;
                    }

                    @Override
                    public Update set(String parameterName, Object value) {
                        return (Update)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends GmailRequest<com.google.api.services.gmail.model.SendAs> {
                    private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String sendAsEmail;

                    protected Patch(String userId, String sendAsEmail, com.google.api.services.gmail.model.SendAs content) {
                        super(Gmail.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.gmail.model.SendAs.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.sendAsEmail = (String)Preconditions.checkNotNull((Object)sendAsEmail, (Object)"Required parameter sendAsEmail must be specified.");
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUserIp(String userIp) {
                        return (Patch)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Patch setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getSendAsEmail() {
                        return this.sendAsEmail;
                    }

                    public Patch setSendAsEmail(String sendAsEmail) {
                        this.sendAsEmail = sendAsEmail;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends GmailRequest<ListSendAsResponse> {
                    private static final String REST_PATH = "{userId}/settings/sendAs";
                    @Key
                    private String userId;

                    protected List(String userId) {
                        super(Gmail.this, "GET", REST_PATH, null, ListSendAsResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUserIp(String userIp) {
                        return (List)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends GmailRequest<com.google.api.services.gmail.model.SendAs> {
                    private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String sendAsEmail;

                    protected Get(String userId, String sendAsEmail) {
                        super(Gmail.this, "GET", REST_PATH, null, com.google.api.services.gmail.model.SendAs.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.sendAsEmail = (String)Preconditions.checkNotNull((Object)sendAsEmail, (Object)"Required parameter sendAsEmail must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUserIp(String userIp) {
                        return (Get)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getSendAsEmail() {
                        return this.sendAsEmail;
                    }

                    public Get setSendAsEmail(String sendAsEmail) {
                        this.sendAsEmail = sendAsEmail;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends GmailRequest<Void> {
                    private static final String REST_PATH = "{userId}/settings/sendAs/{sendAsEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String sendAsEmail;

                    protected Delete(String userId, String sendAsEmail) {
                        super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.sendAsEmail = (String)Preconditions.checkNotNull((Object)sendAsEmail, (Object)"Required parameter sendAsEmail must be specified.");
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUserIp(String userIp) {
                        return (Delete)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Delete setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getSendAsEmail() {
                        return this.sendAsEmail;
                    }

                    public Delete setSendAsEmail(String sendAsEmail) {
                        this.sendAsEmail = sendAsEmail;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends GmailRequest<com.google.api.services.gmail.model.SendAs> {
                    private static final String REST_PATH = "{userId}/settings/sendAs";
                    @Key
                    private String userId;

                    protected Create(String userId, com.google.api.services.gmail.model.SendAs content) {
                        super(Gmail.this, "POST", REST_PATH, (Object)content, com.google.api.services.gmail.model.SendAs.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUserIp(String userIp) {
                        return (Create)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Create setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class ForwardingAddresses {
                public Create create(String userId, ForwardingAddress content) throws IOException {
                    Create result = new Create(userId, content);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String userId, String forwardingEmail) throws IOException {
                    Delete result = new Delete(userId, forwardingEmail);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String userId, String forwardingEmail) throws IOException {
                    Get result = new Get(userId, forwardingEmail);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String userId) throws IOException {
                    List result = new List(userId);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends GmailRequest<ListForwardingAddressesResponse> {
                    private static final String REST_PATH = "{userId}/settings/forwardingAddresses";
                    @Key
                    private String userId;

                    protected List(String userId) {
                        super(Gmail.this, "GET", REST_PATH, null, ListForwardingAddressesResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUserIp(String userIp) {
                        return (List)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends GmailRequest<ForwardingAddress> {
                    private static final String REST_PATH = "{userId}/settings/forwardingAddresses/{forwardingEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String forwardingEmail;

                    protected Get(String userId, String forwardingEmail) {
                        super(Gmail.this, "GET", REST_PATH, null, ForwardingAddress.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.forwardingEmail = (String)Preconditions.checkNotNull((Object)forwardingEmail, (Object)"Required parameter forwardingEmail must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUserIp(String userIp) {
                        return (Get)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getForwardingEmail() {
                        return this.forwardingEmail;
                    }

                    public Get setForwardingEmail(String forwardingEmail) {
                        this.forwardingEmail = forwardingEmail;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends GmailRequest<Void> {
                    private static final String REST_PATH = "{userId}/settings/forwardingAddresses/{forwardingEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String forwardingEmail;

                    protected Delete(String userId, String forwardingEmail) {
                        super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.forwardingEmail = (String)Preconditions.checkNotNull((Object)forwardingEmail, (Object)"Required parameter forwardingEmail must be specified.");
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUserIp(String userIp) {
                        return (Delete)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Delete setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getForwardingEmail() {
                        return this.forwardingEmail;
                    }

                    public Delete setForwardingEmail(String forwardingEmail) {
                        this.forwardingEmail = forwardingEmail;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends GmailRequest<ForwardingAddress> {
                    private static final String REST_PATH = "{userId}/settings/forwardingAddresses";
                    @Key
                    private String userId;

                    protected Create(String userId, ForwardingAddress content) {
                        super(Gmail.this, "POST", REST_PATH, (Object)content, ForwardingAddress.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUserIp(String userIp) {
                        return (Create)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Create setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Filters {
                public Create create(String userId, Filter content) throws IOException {
                    Create result = new Create(userId, content);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String userId, String id) throws IOException {
                    Delete result = new Delete(userId, id);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String userId, String id) throws IOException {
                    Get result = new Get(userId, id);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String userId) throws IOException {
                    List result = new List(userId);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends GmailRequest<ListFiltersResponse> {
                    private static final String REST_PATH = "{userId}/settings/filters";
                    @Key
                    private String userId;

                    protected List(String userId) {
                        super(Gmail.this, "GET", REST_PATH, null, ListFiltersResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUserIp(String userIp) {
                        return (List)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends GmailRequest<Filter> {
                    private static final String REST_PATH = "{userId}/settings/filters/{id}";
                    @Key
                    private String userId;
                    @Key
                    private String id;

                    protected Get(String userId, String id) {
                        super(Gmail.this, "GET", REST_PATH, null, Filter.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUserIp(String userIp) {
                        return (Get)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Get setId(String id) {
                        this.id = id;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends GmailRequest<Void> {
                    private static final String REST_PATH = "{userId}/settings/filters/{id}";
                    @Key
                    private String userId;
                    @Key
                    private String id;

                    protected Delete(String userId, String id) {
                        super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUserIp(String userIp) {
                        return (Delete)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Delete setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Delete setId(String id) {
                        this.id = id;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends GmailRequest<Filter> {
                    private static final String REST_PATH = "{userId}/settings/filters";
                    @Key
                    private String userId;

                    protected Create(String userId, Filter content) {
                        super(Gmail.this, "POST", REST_PATH, (Object)content, Filter.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUserIp(String userIp) {
                        return (Create)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Create setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Delegates {
                public Create create(String userId, Delegate content) throws IOException {
                    Create result = new Create(userId, content);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String userId, String delegateEmail) throws IOException {
                    Delete result = new Delete(userId, delegateEmail);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String userId, String delegateEmail) throws IOException {
                    Get result = new Get(userId, delegateEmail);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String userId) throws IOException {
                    List result = new List(userId);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends GmailRequest<ListDelegatesResponse> {
                    private static final String REST_PATH = "{userId}/settings/delegates";
                    @Key
                    private String userId;

                    protected List(String userId) {
                        super(Gmail.this, "GET", REST_PATH, null, ListDelegatesResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUserIp(String userIp) {
                        return (List)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends GmailRequest<Delegate> {
                    private static final String REST_PATH = "{userId}/settings/delegates/{delegateEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String delegateEmail;

                    protected Get(String userId, String delegateEmail) {
                        super(Gmail.this, "GET", REST_PATH, null, Delegate.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.delegateEmail = (String)Preconditions.checkNotNull((Object)delegateEmail, (Object)"Required parameter delegateEmail must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUserIp(String userIp) {
                        return (Get)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getDelegateEmail() {
                        return this.delegateEmail;
                    }

                    public Get setDelegateEmail(String delegateEmail) {
                        this.delegateEmail = delegateEmail;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends GmailRequest<Void> {
                    private static final String REST_PATH = "{userId}/settings/delegates/{delegateEmail}";
                    @Key
                    private String userId;
                    @Key
                    private String delegateEmail;

                    protected Delete(String userId, String delegateEmail) {
                        super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.delegateEmail = (String)Preconditions.checkNotNull((Object)delegateEmail, (Object)"Required parameter delegateEmail must be specified.");
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUserIp(String userIp) {
                        return (Delete)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Delete setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getDelegateEmail() {
                        return this.delegateEmail;
                    }

                    public Delete setDelegateEmail(String delegateEmail) {
                        this.delegateEmail = delegateEmail;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends GmailRequest<Delegate> {
                    private static final String REST_PATH = "{userId}/settings/delegates";
                    @Key
                    private String userId;

                    protected Create(String userId, Delegate content) {
                        super(Gmail.this, "POST", REST_PATH, (Object)content, Delegate.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUserIp(String userIp) {
                        return (Create)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Create setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class UpdateVacation
            extends GmailRequest<VacationSettings> {
                private static final String REST_PATH = "{userId}/settings/vacation";
                @Key
                private String userId;

                protected UpdateVacation(String userId, VacationSettings content) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)content, VacationSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public UpdateVacation setAlt(String alt) {
                    return (UpdateVacation)super.setAlt(alt);
                }

                public UpdateVacation setFields(String fields) {
                    return (UpdateVacation)super.setFields(fields);
                }

                public UpdateVacation setKey(String key) {
                    return (UpdateVacation)super.setKey(key);
                }

                public UpdateVacation setOauthToken(String oauthToken) {
                    return (UpdateVacation)super.setOauthToken(oauthToken);
                }

                public UpdateVacation setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateVacation)super.setPrettyPrint(prettyPrint);
                }

                public UpdateVacation setQuotaUser(String quotaUser) {
                    return (UpdateVacation)super.setQuotaUser(quotaUser);
                }

                public UpdateVacation setUserIp(String userIp) {
                    return (UpdateVacation)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public UpdateVacation setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public UpdateVacation set(String parameterName, Object value) {
                    return (UpdateVacation)super.set(parameterName, value);
                }
            }

            public class UpdatePop
            extends GmailRequest<PopSettings> {
                private static final String REST_PATH = "{userId}/settings/pop";
                @Key
                private String userId;

                protected UpdatePop(String userId, PopSettings content) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)content, PopSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public UpdatePop setAlt(String alt) {
                    return (UpdatePop)super.setAlt(alt);
                }

                public UpdatePop setFields(String fields) {
                    return (UpdatePop)super.setFields(fields);
                }

                public UpdatePop setKey(String key) {
                    return (UpdatePop)super.setKey(key);
                }

                public UpdatePop setOauthToken(String oauthToken) {
                    return (UpdatePop)super.setOauthToken(oauthToken);
                }

                public UpdatePop setPrettyPrint(Boolean prettyPrint) {
                    return (UpdatePop)super.setPrettyPrint(prettyPrint);
                }

                public UpdatePop setQuotaUser(String quotaUser) {
                    return (UpdatePop)super.setQuotaUser(quotaUser);
                }

                public UpdatePop setUserIp(String userIp) {
                    return (UpdatePop)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public UpdatePop setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public UpdatePop set(String parameterName, Object value) {
                    return (UpdatePop)super.set(parameterName, value);
                }
            }

            public class UpdateLanguage
            extends GmailRequest<LanguageSettings> {
                private static final String REST_PATH = "{userId}/settings/language";
                @Key
                private String userId;

                protected UpdateLanguage(String userId, LanguageSettings content) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)content, LanguageSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public UpdateLanguage setAlt(String alt) {
                    return (UpdateLanguage)super.setAlt(alt);
                }

                public UpdateLanguage setFields(String fields) {
                    return (UpdateLanguage)super.setFields(fields);
                }

                public UpdateLanguage setKey(String key) {
                    return (UpdateLanguage)super.setKey(key);
                }

                public UpdateLanguage setOauthToken(String oauthToken) {
                    return (UpdateLanguage)super.setOauthToken(oauthToken);
                }

                public UpdateLanguage setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateLanguage)super.setPrettyPrint(prettyPrint);
                }

                public UpdateLanguage setQuotaUser(String quotaUser) {
                    return (UpdateLanguage)super.setQuotaUser(quotaUser);
                }

                public UpdateLanguage setUserIp(String userIp) {
                    return (UpdateLanguage)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public UpdateLanguage setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public UpdateLanguage set(String parameterName, Object value) {
                    return (UpdateLanguage)super.set(parameterName, value);
                }
            }

            public class UpdateImap
            extends GmailRequest<ImapSettings> {
                private static final String REST_PATH = "{userId}/settings/imap";
                @Key
                private String userId;

                protected UpdateImap(String userId, ImapSettings content) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)content, ImapSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public UpdateImap setAlt(String alt) {
                    return (UpdateImap)super.setAlt(alt);
                }

                public UpdateImap setFields(String fields) {
                    return (UpdateImap)super.setFields(fields);
                }

                public UpdateImap setKey(String key) {
                    return (UpdateImap)super.setKey(key);
                }

                public UpdateImap setOauthToken(String oauthToken) {
                    return (UpdateImap)super.setOauthToken(oauthToken);
                }

                public UpdateImap setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateImap)super.setPrettyPrint(prettyPrint);
                }

                public UpdateImap setQuotaUser(String quotaUser) {
                    return (UpdateImap)super.setQuotaUser(quotaUser);
                }

                public UpdateImap setUserIp(String userIp) {
                    return (UpdateImap)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public UpdateImap setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public UpdateImap set(String parameterName, Object value) {
                    return (UpdateImap)super.set(parameterName, value);
                }
            }

            public class UpdateAutoForwarding
            extends GmailRequest<AutoForwarding> {
                private static final String REST_PATH = "{userId}/settings/autoForwarding";
                @Key
                private String userId;

                protected UpdateAutoForwarding(String userId, AutoForwarding content) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)content, AutoForwarding.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public UpdateAutoForwarding setAlt(String alt) {
                    return (UpdateAutoForwarding)super.setAlt(alt);
                }

                public UpdateAutoForwarding setFields(String fields) {
                    return (UpdateAutoForwarding)super.setFields(fields);
                }

                public UpdateAutoForwarding setKey(String key) {
                    return (UpdateAutoForwarding)super.setKey(key);
                }

                public UpdateAutoForwarding setOauthToken(String oauthToken) {
                    return (UpdateAutoForwarding)super.setOauthToken(oauthToken);
                }

                public UpdateAutoForwarding setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateAutoForwarding)super.setPrettyPrint(prettyPrint);
                }

                public UpdateAutoForwarding setQuotaUser(String quotaUser) {
                    return (UpdateAutoForwarding)super.setQuotaUser(quotaUser);
                }

                public UpdateAutoForwarding setUserIp(String userIp) {
                    return (UpdateAutoForwarding)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public UpdateAutoForwarding setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public UpdateAutoForwarding set(String parameterName, Object value) {
                    return (UpdateAutoForwarding)super.set(parameterName, value);
                }
            }

            public class GetVacation
            extends GmailRequest<VacationSettings> {
                private static final String REST_PATH = "{userId}/settings/vacation";
                @Key
                private String userId;

                protected GetVacation(String userId) {
                    super(Gmail.this, "GET", REST_PATH, null, VacationSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetVacation setAlt(String alt) {
                    return (GetVacation)super.setAlt(alt);
                }

                public GetVacation setFields(String fields) {
                    return (GetVacation)super.setFields(fields);
                }

                public GetVacation setKey(String key) {
                    return (GetVacation)super.setKey(key);
                }

                public GetVacation setOauthToken(String oauthToken) {
                    return (GetVacation)super.setOauthToken(oauthToken);
                }

                public GetVacation setPrettyPrint(Boolean prettyPrint) {
                    return (GetVacation)super.setPrettyPrint(prettyPrint);
                }

                public GetVacation setQuotaUser(String quotaUser) {
                    return (GetVacation)super.setQuotaUser(quotaUser);
                }

                public GetVacation setUserIp(String userIp) {
                    return (GetVacation)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GetVacation setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public GetVacation set(String parameterName, Object value) {
                    return (GetVacation)super.set(parameterName, value);
                }
            }

            public class GetPop
            extends GmailRequest<PopSettings> {
                private static final String REST_PATH = "{userId}/settings/pop";
                @Key
                private String userId;

                protected GetPop(String userId) {
                    super(Gmail.this, "GET", REST_PATH, null, PopSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetPop setAlt(String alt) {
                    return (GetPop)super.setAlt(alt);
                }

                public GetPop setFields(String fields) {
                    return (GetPop)super.setFields(fields);
                }

                public GetPop setKey(String key) {
                    return (GetPop)super.setKey(key);
                }

                public GetPop setOauthToken(String oauthToken) {
                    return (GetPop)super.setOauthToken(oauthToken);
                }

                public GetPop setPrettyPrint(Boolean prettyPrint) {
                    return (GetPop)super.setPrettyPrint(prettyPrint);
                }

                public GetPop setQuotaUser(String quotaUser) {
                    return (GetPop)super.setQuotaUser(quotaUser);
                }

                public GetPop setUserIp(String userIp) {
                    return (GetPop)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GetPop setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public GetPop set(String parameterName, Object value) {
                    return (GetPop)super.set(parameterName, value);
                }
            }

            public class GetLanguage
            extends GmailRequest<LanguageSettings> {
                private static final String REST_PATH = "{userId}/settings/language";
                @Key
                private String userId;

                protected GetLanguage(String userId) {
                    super(Gmail.this, "GET", REST_PATH, null, LanguageSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetLanguage setAlt(String alt) {
                    return (GetLanguage)super.setAlt(alt);
                }

                public GetLanguage setFields(String fields) {
                    return (GetLanguage)super.setFields(fields);
                }

                public GetLanguage setKey(String key) {
                    return (GetLanguage)super.setKey(key);
                }

                public GetLanguage setOauthToken(String oauthToken) {
                    return (GetLanguage)super.setOauthToken(oauthToken);
                }

                public GetLanguage setPrettyPrint(Boolean prettyPrint) {
                    return (GetLanguage)super.setPrettyPrint(prettyPrint);
                }

                public GetLanguage setQuotaUser(String quotaUser) {
                    return (GetLanguage)super.setQuotaUser(quotaUser);
                }

                public GetLanguage setUserIp(String userIp) {
                    return (GetLanguage)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GetLanguage setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public GetLanguage set(String parameterName, Object value) {
                    return (GetLanguage)super.set(parameterName, value);
                }
            }

            public class GetImap
            extends GmailRequest<ImapSettings> {
                private static final String REST_PATH = "{userId}/settings/imap";
                @Key
                private String userId;

                protected GetImap(String userId) {
                    super(Gmail.this, "GET", REST_PATH, null, ImapSettings.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetImap setAlt(String alt) {
                    return (GetImap)super.setAlt(alt);
                }

                public GetImap setFields(String fields) {
                    return (GetImap)super.setFields(fields);
                }

                public GetImap setKey(String key) {
                    return (GetImap)super.setKey(key);
                }

                public GetImap setOauthToken(String oauthToken) {
                    return (GetImap)super.setOauthToken(oauthToken);
                }

                public GetImap setPrettyPrint(Boolean prettyPrint) {
                    return (GetImap)super.setPrettyPrint(prettyPrint);
                }

                public GetImap setQuotaUser(String quotaUser) {
                    return (GetImap)super.setQuotaUser(quotaUser);
                }

                public GetImap setUserIp(String userIp) {
                    return (GetImap)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GetImap setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public GetImap set(String parameterName, Object value) {
                    return (GetImap)super.set(parameterName, value);
                }
            }

            public class GetAutoForwarding
            extends GmailRequest<AutoForwarding> {
                private static final String REST_PATH = "{userId}/settings/autoForwarding";
                @Key
                private String userId;

                protected GetAutoForwarding(String userId) {
                    super(Gmail.this, "GET", REST_PATH, null, AutoForwarding.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetAutoForwarding setAlt(String alt) {
                    return (GetAutoForwarding)super.setAlt(alt);
                }

                public GetAutoForwarding setFields(String fields) {
                    return (GetAutoForwarding)super.setFields(fields);
                }

                public GetAutoForwarding setKey(String key) {
                    return (GetAutoForwarding)super.setKey(key);
                }

                public GetAutoForwarding setOauthToken(String oauthToken) {
                    return (GetAutoForwarding)super.setOauthToken(oauthToken);
                }

                public GetAutoForwarding setPrettyPrint(Boolean prettyPrint) {
                    return (GetAutoForwarding)super.setPrettyPrint(prettyPrint);
                }

                public GetAutoForwarding setQuotaUser(String quotaUser) {
                    return (GetAutoForwarding)super.setQuotaUser(quotaUser);
                }

                public GetAutoForwarding setUserIp(String userIp) {
                    return (GetAutoForwarding)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GetAutoForwarding setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public GetAutoForwarding set(String parameterName, Object value) {
                    return (GetAutoForwarding)super.set(parameterName, value);
                }
            }
        }

        public class Messages {
            public BatchDelete batchDelete(String userId, BatchDeleteMessagesRequest content) throws IOException {
                BatchDelete result = new BatchDelete(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchModify batchModify(String userId, BatchModifyMessagesRequest content) throws IOException {
                BatchModify result = new BatchModify(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String userId, String id) throws IOException {
                Delete result = new Delete(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String userId, String id) throws IOException {
                Get result = new Get(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GmailImport gmailImport(String userId, Message content) throws IOException {
                GmailImport result = new GmailImport(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GmailImport gmailImport(String userId, Message content, AbstractInputStreamContent mediaContent) throws IOException {
                GmailImport result = new GmailImport(userId, content, mediaContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String userId, Message content) throws IOException {
                Insert result = new Insert(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String userId, Message content, AbstractInputStreamContent mediaContent) throws IOException {
                Insert result = new Insert(userId, content, mediaContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String userId) throws IOException {
                List result = new List(userId);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Modify modify(String userId, String id, ModifyMessageRequest content) throws IOException {
                Modify result = new Modify(userId, id, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Send send(String userId, Message content) throws IOException {
                Send result = new Send(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Send send(String userId, Message content, AbstractInputStreamContent mediaContent) throws IOException {
                Send result = new Send(userId, content, mediaContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Trash trash(String userId, String id) throws IOException {
                Trash result = new Trash(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Untrash untrash(String userId, String id) throws IOException {
                Untrash result = new Untrash(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Attachments attachments() {
                return new Attachments();
            }

            public class Attachments {
                public Get get(String userId, String messageId, String id) throws IOException {
                    Get result = new Get(userId, messageId, id);
                    Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Get
                extends GmailRequest<MessagePartBody> {
                    private static final String REST_PATH = "{userId}/messages/{messageId}/attachments/{id}";
                    @Key
                    private String userId;
                    @Key
                    private String messageId;
                    @Key
                    private String id;

                    protected Get(String userId, String messageId, String id) {
                        super(Gmail.this, "GET", REST_PATH, null, MessagePartBody.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.messageId = (String)Preconditions.checkNotNull((Object)messageId, (Object)"Required parameter messageId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUserIp(String userIp) {
                        return (Get)super.setUserIp(userIp);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getMessageId() {
                        return this.messageId;
                    }

                    public Get setMessageId(String messageId) {
                        this.messageId = messageId;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Get setId(String id) {
                        this.id = id;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class Untrash
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/{id}/untrash";
                @Key
                private String userId;
                @Key
                private String id;

                protected Untrash(String userId, String id) {
                    super(Gmail.this, "POST", REST_PATH, null, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Untrash setAlt(String alt) {
                    return (Untrash)super.setAlt(alt);
                }

                public Untrash setFields(String fields) {
                    return (Untrash)super.setFields(fields);
                }

                public Untrash setKey(String key) {
                    return (Untrash)super.setKey(key);
                }

                public Untrash setOauthToken(String oauthToken) {
                    return (Untrash)super.setOauthToken(oauthToken);
                }

                public Untrash setPrettyPrint(Boolean prettyPrint) {
                    return (Untrash)super.setPrettyPrint(prettyPrint);
                }

                public Untrash setQuotaUser(String quotaUser) {
                    return (Untrash)super.setQuotaUser(quotaUser);
                }

                public Untrash setUserIp(String userIp) {
                    return (Untrash)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Untrash setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Untrash setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Untrash set(String parameterName, Object value) {
                    return (Untrash)super.set(parameterName, value);
                }
            }

            public class Trash
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/{id}/trash";
                @Key
                private String userId;
                @Key
                private String id;

                protected Trash(String userId, String id) {
                    super(Gmail.this, "POST", REST_PATH, null, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Trash setAlt(String alt) {
                    return (Trash)super.setAlt(alt);
                }

                public Trash setFields(String fields) {
                    return (Trash)super.setFields(fields);
                }

                public Trash setKey(String key) {
                    return (Trash)super.setKey(key);
                }

                public Trash setOauthToken(String oauthToken) {
                    return (Trash)super.setOauthToken(oauthToken);
                }

                public Trash setPrettyPrint(Boolean prettyPrint) {
                    return (Trash)super.setPrettyPrint(prettyPrint);
                }

                public Trash setQuotaUser(String quotaUser) {
                    return (Trash)super.setQuotaUser(quotaUser);
                }

                public Trash setUserIp(String userIp) {
                    return (Trash)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Trash setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Trash setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Trash set(String parameterName, Object value) {
                    return (Trash)super.set(parameterName, value);
                }
            }

            public class Send
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/send";
                @Key
                private String userId;

                protected Send(String userId, Message content) {
                    super(Gmail.this, "POST", REST_PATH, (Object)content, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getRaw(), "Message.getRaw()");
                }

                protected Send(String userId, Message content, AbstractInputStreamContent mediaContent) {
                    super(Gmail.this, "POST", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)content, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Send setAlt(String alt) {
                    return (Send)super.setAlt(alt);
                }

                public Send setFields(String fields) {
                    return (Send)super.setFields(fields);
                }

                public Send setKey(String key) {
                    return (Send)super.setKey(key);
                }

                public Send setOauthToken(String oauthToken) {
                    return (Send)super.setOauthToken(oauthToken);
                }

                public Send setPrettyPrint(Boolean prettyPrint) {
                    return (Send)super.setPrettyPrint(prettyPrint);
                }

                public Send setQuotaUser(String quotaUser) {
                    return (Send)super.setQuotaUser(quotaUser);
                }

                public Send setUserIp(String userIp) {
                    return (Send)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Send setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Send set(String parameterName, Object value) {
                    return (Send)super.set(parameterName, value);
                }
            }

            public class Modify
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/{id}/modify";
                @Key
                private String userId;
                @Key
                private String id;

                protected Modify(String userId, String id, ModifyMessageRequest content) {
                    super(Gmail.this, "POST", REST_PATH, (Object)content, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Modify setAlt(String alt) {
                    return (Modify)super.setAlt(alt);
                }

                public Modify setFields(String fields) {
                    return (Modify)super.setFields(fields);
                }

                public Modify setKey(String key) {
                    return (Modify)super.setKey(key);
                }

                public Modify setOauthToken(String oauthToken) {
                    return (Modify)super.setOauthToken(oauthToken);
                }

                public Modify setPrettyPrint(Boolean prettyPrint) {
                    return (Modify)super.setPrettyPrint(prettyPrint);
                }

                public Modify setQuotaUser(String quotaUser) {
                    return (Modify)super.setQuotaUser(quotaUser);
                }

                public Modify setUserIp(String userIp) {
                    return (Modify)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Modify setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Modify setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Modify set(String parameterName, Object value) {
                    return (Modify)super.set(parameterName, value);
                }
            }

            public class List
            extends GmailRequest<ListMessagesResponse> {
                private static final String REST_PATH = "{userId}/messages";
                @Key
                private String userId;
                @Key
                private Boolean includeSpamTrash;
                @Key
                private java.util.List<String> labelIds;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String q;

                protected List(String userId) {
                    super(Gmail.this, "GET", REST_PATH, null, ListMessagesResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public Boolean getIncludeSpamTrash() {
                    return this.includeSpamTrash;
                }

                public List setIncludeSpamTrash(Boolean includeSpamTrash) {
                    this.includeSpamTrash = includeSpamTrash;
                    return this;
                }

                public boolean isIncludeSpamTrash() {
                    if (this.includeSpamTrash == null || this.includeSpamTrash == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.includeSpamTrash;
                }

                public java.util.List<String> getLabelIds() {
                    return this.labelIds;
                }

                public List setLabelIds(java.util.List<String> labelIds) {
                    this.labelIds = labelIds;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getQ() {
                    return this.q;
                }

                public List setQ(String q) {
                    this.q = q;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages";
                @Key
                private String userId;
                @Key
                private Boolean deleted;
                @Key
                private String internalDateSource;

                protected Insert(String userId, Message content) {
                    super(Gmail.this, "POST", REST_PATH, (Object)content, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getRaw(), "Message.getRaw()");
                }

                protected Insert(String userId, Message content, AbstractInputStreamContent mediaContent) {
                    super(Gmail.this, "POST", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)content, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Insert setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public Boolean getDeleted() {
                    return this.deleted;
                }

                public Insert setDeleted(Boolean deleted) {
                    this.deleted = deleted;
                    return this;
                }

                public boolean isDeleted() {
                    if (this.deleted == null || this.deleted == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.deleted;
                }

                public String getInternalDateSource() {
                    return this.internalDateSource;
                }

                public Insert setInternalDateSource(String internalDateSource) {
                    this.internalDateSource = internalDateSource;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class GmailImport
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/import";
                @Key
                private String userId;
                @Key
                private Boolean deleted;
                @Key
                private String internalDateSource;
                @Key
                private Boolean neverMarkSpam;
                @Key
                private Boolean processForCalendar;

                protected GmailImport(String userId, Message content) {
                    super(Gmail.this, "POST", REST_PATH, (Object)content, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                protected GmailImport(String userId, Message content, AbstractInputStreamContent mediaContent) {
                    super(Gmail.this, "POST", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)content, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public GmailImport setAlt(String alt) {
                    return (GmailImport)super.setAlt(alt);
                }

                public GmailImport setFields(String fields) {
                    return (GmailImport)super.setFields(fields);
                }

                public GmailImport setKey(String key) {
                    return (GmailImport)super.setKey(key);
                }

                public GmailImport setOauthToken(String oauthToken) {
                    return (GmailImport)super.setOauthToken(oauthToken);
                }

                public GmailImport setPrettyPrint(Boolean prettyPrint) {
                    return (GmailImport)super.setPrettyPrint(prettyPrint);
                }

                public GmailImport setQuotaUser(String quotaUser) {
                    return (GmailImport)super.setQuotaUser(quotaUser);
                }

                public GmailImport setUserIp(String userIp) {
                    return (GmailImport)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public GmailImport setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public Boolean getDeleted() {
                    return this.deleted;
                }

                public GmailImport setDeleted(Boolean deleted) {
                    this.deleted = deleted;
                    return this;
                }

                public boolean isDeleted() {
                    if (this.deleted == null || this.deleted == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.deleted;
                }

                public String getInternalDateSource() {
                    return this.internalDateSource;
                }

                public GmailImport setInternalDateSource(String internalDateSource) {
                    this.internalDateSource = internalDateSource;
                    return this;
                }

                public Boolean getNeverMarkSpam() {
                    return this.neverMarkSpam;
                }

                public GmailImport setNeverMarkSpam(Boolean neverMarkSpam) {
                    this.neverMarkSpam = neverMarkSpam;
                    return this;
                }

                public boolean isNeverMarkSpam() {
                    if (this.neverMarkSpam == null || this.neverMarkSpam == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.neverMarkSpam;
                }

                public Boolean getProcessForCalendar() {
                    return this.processForCalendar;
                }

                public GmailImport setProcessForCalendar(Boolean processForCalendar) {
                    this.processForCalendar = processForCalendar;
                    return this;
                }

                public boolean isProcessForCalendar() {
                    if (this.processForCalendar == null || this.processForCalendar == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.processForCalendar;
                }

                @Override
                public GmailImport set(String parameterName, Object value) {
                    return (GmailImport)super.set(parameterName, value);
                }
            }

            public class Get
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/messages/{id}";
                @Key
                private String userId;
                @Key
                private String id;
                @Key
                private String format;
                @Key
                private java.util.List<String> metadataHeaders;

                protected Get(String userId, String id) {
                    super(Gmail.this, "GET", REST_PATH, null, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String id) {
                    this.id = id;
                    return this;
                }

                public String getFormat() {
                    return this.format;
                }

                public Get setFormat(String format) {
                    this.format = format;
                    return this;
                }

                public java.util.List<String> getMetadataHeaders() {
                    return this.metadataHeaders;
                }

                public Get setMetadataHeaders(java.util.List<String> metadataHeaders) {
                    this.metadataHeaders = metadataHeaders;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/messages/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Delete(String userId, String id) {
                    super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class BatchModify
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/messages/batchModify";
                @Key
                private String userId;

                protected BatchModify(String userId, BatchModifyMessagesRequest content) {
                    super(Gmail.this, "POST", REST_PATH, (Object)content, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public BatchModify setAlt(String alt) {
                    return (BatchModify)super.setAlt(alt);
                }

                public BatchModify setFields(String fields) {
                    return (BatchModify)super.setFields(fields);
                }

                public BatchModify setKey(String key) {
                    return (BatchModify)super.setKey(key);
                }

                public BatchModify setOauthToken(String oauthToken) {
                    return (BatchModify)super.setOauthToken(oauthToken);
                }

                public BatchModify setPrettyPrint(Boolean prettyPrint) {
                    return (BatchModify)super.setPrettyPrint(prettyPrint);
                }

                public BatchModify setQuotaUser(String quotaUser) {
                    return (BatchModify)super.setQuotaUser(quotaUser);
                }

                public BatchModify setUserIp(String userIp) {
                    return (BatchModify)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public BatchModify setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public BatchModify set(String parameterName, Object value) {
                    return (BatchModify)super.set(parameterName, value);
                }
            }

            public class BatchDelete
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/messages/batchDelete";
                @Key
                private String userId;

                protected BatchDelete(String userId, BatchDeleteMessagesRequest content) {
                    super(Gmail.this, "POST", REST_PATH, (Object)content, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public BatchDelete setAlt(String alt) {
                    return (BatchDelete)super.setAlt(alt);
                }

                public BatchDelete setFields(String fields) {
                    return (BatchDelete)super.setFields(fields);
                }

                public BatchDelete setKey(String key) {
                    return (BatchDelete)super.setKey(key);
                }

                public BatchDelete setOauthToken(String oauthToken) {
                    return (BatchDelete)super.setOauthToken(oauthToken);
                }

                public BatchDelete setPrettyPrint(Boolean prettyPrint) {
                    return (BatchDelete)super.setPrettyPrint(prettyPrint);
                }

                public BatchDelete setQuotaUser(String quotaUser) {
                    return (BatchDelete)super.setQuotaUser(quotaUser);
                }

                public BatchDelete setUserIp(String userIp) {
                    return (BatchDelete)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public BatchDelete setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public BatchDelete set(String parameterName, Object value) {
                    return (BatchDelete)super.set(parameterName, value);
                }
            }
        }

        public class Labels {
            public Create create(String userId, Label content) throws IOException {
                Create result = new Create(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String userId, String id) throws IOException {
                Delete result = new Delete(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String userId, String id) throws IOException {
                Get result = new Get(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String userId) throws IOException {
                List result = new List(userId);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String userId, String id, Label content) throws IOException {
                Patch result = new Patch(userId, id, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String userId, String id, Label content) throws IOException {
                Update result = new Update(userId, id, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends GmailRequest<Label> {
                private static final String REST_PATH = "{userId}/labels/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Update(String userId, String id, Label content) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)content, Label.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getId(), "Label.getId()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getLabelListVisibility(), "Label.getLabelListVisibility()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getMessageListVisibility(), "Label.getMessageListVisibility()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getName(), "Label.getName()");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Update setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Update setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends GmailRequest<Label> {
                private static final String REST_PATH = "{userId}/labels/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Patch(String userId, String id, Label content) {
                    super(Gmail.this, "PATCH", REST_PATH, (Object)content, Label.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Patch setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Patch setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends GmailRequest<ListLabelsResponse> {
                private static final String REST_PATH = "{userId}/labels";
                @Key
                private String userId;

                protected List(String userId) {
                    super(Gmail.this, "GET", REST_PATH, null, ListLabelsResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends GmailRequest<Label> {
                private static final String REST_PATH = "{userId}/labels/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Get(String userId, String id) {
                    super(Gmail.this, "GET", REST_PATH, null, Label.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/labels/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Delete(String userId, String id) {
                    super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends GmailRequest<Label> {
                private static final String REST_PATH = "{userId}/labels";
                @Key
                private String userId;

                protected Create(String userId, Label content) {
                    super(Gmail.this, "POST", REST_PATH, (Object)content, Label.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getLabelListVisibility(), "Label.getLabelListVisibility()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getMessageListVisibility(), "Label.getMessageListVisibility()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getName(), "Label.getName()");
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUserIp(String userIp) {
                    return (Create)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Create setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class History {
            public List list(String userId) throws IOException {
                List result = new List(userId);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends GmailRequest<ListHistoryResponse> {
                private static final String REST_PATH = "{userId}/history";
                @Key
                private String userId;
                @Key
                private java.util.List<String> historyTypes;
                @Key
                private String labelId;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private BigInteger startHistoryId;

                protected List(String userId) {
                    super(Gmail.this, "GET", REST_PATH, null, ListHistoryResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public java.util.List<String> getHistoryTypes() {
                    return this.historyTypes;
                }

                public List setHistoryTypes(java.util.List<String> historyTypes) {
                    this.historyTypes = historyTypes;
                    return this;
                }

                public String getLabelId() {
                    return this.labelId;
                }

                public List setLabelId(String labelId) {
                    this.labelId = labelId;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public BigInteger getStartHistoryId() {
                    return this.startHistoryId;
                }

                public List setStartHistoryId(BigInteger startHistoryId) {
                    this.startHistoryId = startHistoryId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Drafts {
            public Create create(String userId, Draft content) throws IOException {
                Create result = new Create(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String userId, Draft content, AbstractInputStreamContent mediaContent) throws IOException {
                Create result = new Create(userId, content, mediaContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String userId, String id) throws IOException {
                Delete result = new Delete(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String userId, String id) throws IOException {
                Get result = new Get(userId, id);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String userId) throws IOException {
                List result = new List(userId);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Send send(String userId, Draft content) throws IOException {
                Send result = new Send(userId, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Send send(String userId, Draft content, AbstractInputStreamContent mediaContent) throws IOException {
                Send result = new Send(userId, content, mediaContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String userId, String id, Draft content) throws IOException {
                Update result = new Update(userId, id, content);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String userId, String id, Draft content, AbstractInputStreamContent mediaContent) throws IOException {
                Update result = new Update(userId, id, content, mediaContent);
                Gmail.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends GmailRequest<Draft> {
                private static final String REST_PATH = "{userId}/drafts/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Update(String userId, String id, Draft content) {
                    super(Gmail.this, "PUT", REST_PATH, (Object)content, Draft.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                protected Update(String userId, String id, Draft content, AbstractInputStreamContent mediaContent) {
                    super(Gmail.this, "PUT", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)content, Draft.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Update setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Update setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Send
            extends GmailRequest<Message> {
                private static final String REST_PATH = "{userId}/drafts/send";
                @Key
                private String userId;

                protected Send(String userId, Draft content) {
                    super(Gmail.this, "POST", REST_PATH, (Object)content, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                protected Send(String userId, Draft content, AbstractInputStreamContent mediaContent) {
                    super(Gmail.this, "POST", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)content, Message.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Send setAlt(String alt) {
                    return (Send)super.setAlt(alt);
                }

                public Send setFields(String fields) {
                    return (Send)super.setFields(fields);
                }

                public Send setKey(String key) {
                    return (Send)super.setKey(key);
                }

                public Send setOauthToken(String oauthToken) {
                    return (Send)super.setOauthToken(oauthToken);
                }

                public Send setPrettyPrint(Boolean prettyPrint) {
                    return (Send)super.setPrettyPrint(prettyPrint);
                }

                public Send setQuotaUser(String quotaUser) {
                    return (Send)super.setQuotaUser(quotaUser);
                }

                public Send setUserIp(String userIp) {
                    return (Send)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Send setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Send set(String parameterName, Object value) {
                    return (Send)super.set(parameterName, value);
                }
            }

            public class List
            extends GmailRequest<ListDraftsResponse> {
                private static final String REST_PATH = "{userId}/drafts";
                @Key
                private String userId;
                @Key
                private Boolean includeSpamTrash;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String q;

                protected List(String userId) {
                    super(Gmail.this, "GET", REST_PATH, null, ListDraftsResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public Boolean getIncludeSpamTrash() {
                    return this.includeSpamTrash;
                }

                public List setIncludeSpamTrash(Boolean includeSpamTrash) {
                    this.includeSpamTrash = includeSpamTrash;
                    return this;
                }

                public boolean isIncludeSpamTrash() {
                    if (this.includeSpamTrash == null || this.includeSpamTrash == Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.includeSpamTrash;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getQ() {
                    return this.q;
                }

                public List setQ(String q) {
                    this.q = q;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends GmailRequest<Draft> {
                private static final String REST_PATH = "{userId}/drafts/{id}";
                @Key
                private String userId;
                @Key
                private String id;
                @Key
                private String format;

                protected Get(String userId, String id) {
                    super(Gmail.this, "GET", REST_PATH, null, Draft.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Get setId(String id) {
                    this.id = id;
                    return this;
                }

                public String getFormat() {
                    return this.format;
                }

                public Get setFormat(String format) {
                    this.format = format;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends GmailRequest<Void> {
                private static final String REST_PATH = "{userId}/drafts/{id}";
                @Key
                private String userId;
                @Key
                private String id;

                protected Delete(String userId, String id) {
                    super(Gmail.this, "DELETE", REST_PATH, null, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getId() {
                    return this.id;
                }

                public Delete setId(String id) {
                    this.id = id;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends GmailRequest<Draft> {
                private static final String REST_PATH = "{userId}/drafts";
                @Key
                private String userId;

                protected Create(String userId, Draft content) {
                    super(Gmail.this, "POST", REST_PATH, (Object)content, Draft.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                protected Create(String userId, Draft content, AbstractInputStreamContent mediaContent) {
                    super(Gmail.this, "POST", "/upload/" + Gmail.this.getServicePath() + REST_PATH, (Object)content, Draft.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUserIp(String userIp) {
                    return (Create)super.setUserIp(userIp);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Create setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Watch
        extends GmailRequest<WatchResponse> {
            private static final String REST_PATH = "{userId}/watch";
            @Key
            private String userId;

            protected Watch(String userId, WatchRequest content) {
                super(Gmail.this, "POST", REST_PATH, (Object)content, WatchResponse.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public Watch setAlt(String alt) {
                return (Watch)super.setAlt(alt);
            }

            public Watch setFields(String fields) {
                return (Watch)super.setFields(fields);
            }

            public Watch setKey(String key) {
                return (Watch)super.setKey(key);
            }

            public Watch setOauthToken(String oauthToken) {
                return (Watch)super.setOauthToken(oauthToken);
            }

            public Watch setPrettyPrint(Boolean prettyPrint) {
                return (Watch)super.setPrettyPrint(prettyPrint);
            }

            public Watch setQuotaUser(String quotaUser) {
                return (Watch)super.setQuotaUser(quotaUser);
            }

            public Watch setUserIp(String userIp) {
                return (Watch)super.setUserIp(userIp);
            }

            public String getUserId() {
                return this.userId;
            }

            public Watch setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            @Override
            public Watch set(String parameterName, Object value) {
                return (Watch)super.set(parameterName, value);
            }
        }

        public class Stop
        extends GmailRequest<Void> {
            private static final String REST_PATH = "{userId}/stop";
            @Key
            private String userId;

            protected Stop(String userId) {
                super(Gmail.this, "POST", REST_PATH, null, Void.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public Stop setAlt(String alt) {
                return (Stop)super.setAlt(alt);
            }

            public Stop setFields(String fields) {
                return (Stop)super.setFields(fields);
            }

            public Stop setKey(String key) {
                return (Stop)super.setKey(key);
            }

            public Stop setOauthToken(String oauthToken) {
                return (Stop)super.setOauthToken(oauthToken);
            }

            public Stop setPrettyPrint(Boolean prettyPrint) {
                return (Stop)super.setPrettyPrint(prettyPrint);
            }

            public Stop setQuotaUser(String quotaUser) {
                return (Stop)super.setQuotaUser(quotaUser);
            }

            public Stop setUserIp(String userIp) {
                return (Stop)super.setUserIp(userIp);
            }

            public String getUserId() {
                return this.userId;
            }

            public Stop setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            @Override
            public Stop set(String parameterName, Object value) {
                return (Stop)super.set(parameterName, value);
            }
        }

        public class GetProfile
        extends GmailRequest<Profile> {
            private static final String REST_PATH = "{userId}/profile";
            @Key
            private String userId;

            protected GetProfile(String userId) {
                super(Gmail.this, "GET", REST_PATH, null, Profile.class);
                this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetProfile setAlt(String alt) {
                return (GetProfile)super.setAlt(alt);
            }

            public GetProfile setFields(String fields) {
                return (GetProfile)super.setFields(fields);
            }

            public GetProfile setKey(String key) {
                return (GetProfile)super.setKey(key);
            }

            public GetProfile setOauthToken(String oauthToken) {
                return (GetProfile)super.setOauthToken(oauthToken);
            }

            public GetProfile setPrettyPrint(Boolean prettyPrint) {
                return (GetProfile)super.setPrettyPrint(prettyPrint);
            }

            public GetProfile setQuotaUser(String quotaUser) {
                return (GetProfile)super.setQuotaUser(quotaUser);
            }

            public GetProfile setUserIp(String userIp) {
                return (GetProfile)super.setUserIp(userIp);
            }

            public String getUserId() {
                return this.userId;
            }

            public GetProfile setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            @Override
            public GetProfile set(String parameterName, Object value) {
                return (GetProfile)super.set(parameterName, value);
            }
        }
    }
}

