/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-15 at 17:16:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Profile for a Gmail user.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Profile extends com.google.api.client.json.GenericJson {

  /**
   * The user's email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String emailAddress;

  /**
   * The ID of the mailbox's current history record.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger historyId;

  /**
   * The total number of messages in the mailbox.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer messagesTotal;

  /**
   * The total number of threads in the mailbox.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer threadsTotal;

  /**
   * The user's email address.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmailAddress() {
    return emailAddress;
  }

  /**
   * The user's email address.
   * @param emailAddress emailAddress or {@code null} for none
   */
  public Profile setEmailAddress(java.lang.String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * The ID of the mailbox's current history record.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getHistoryId() {
    return historyId;
  }

  /**
   * The ID of the mailbox's current history record.
   * @param historyId historyId or {@code null} for none
   */
  public Profile setHistoryId(java.math.BigInteger historyId) {
    this.historyId = historyId;
    return this;
  }

  /**
   * The total number of messages in the mailbox.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMessagesTotal() {
    return messagesTotal;
  }

  /**
   * The total number of messages in the mailbox.
   * @param messagesTotal messagesTotal or {@code null} for none
   */
  public Profile setMessagesTotal(java.lang.Integer messagesTotal) {
    this.messagesTotal = messagesTotal;
    return this;
  }

  /**
   * The total number of threads in the mailbox.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getThreadsTotal() {
    return threadsTotal;
  }

  /**
   * The total number of threads in the mailbox.
   * @param threadsTotal threadsTotal or {@code null} for none
   */
  public Profile setThreadsTotal(java.lang.Integer threadsTotal) {
    this.threadsTotal = threadsTotal;
    return this;
  }

  @Override
  public Profile set(String fieldName, Object value) {
    return (Profile) super.set(fieldName, value);
  }

  @Override
  public Profile clone() {
    return (Profile) super.clone();
  }

}
