/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-15 at 17:16:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Model definition for ListDraftsResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListDraftsResponse extends com.google.api.client.json.GenericJson {

  /**
   * List of drafts. Note that the Message property in each Draft resource only contains an id and a
   * threadId. The messages.get method can fetch additional message details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Draft> drafts;

  static {
    // hack to force ProGuard to consider Draft used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Draft.class);
  }

  /**
   * Token to retrieve the next page of results in the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Estimated total number of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long resultSizeEstimate;

  /**
   * List of drafts. Note that the Message property in each Draft resource only contains an id and a
   * threadId. The messages.get method can fetch additional message details.
   * @return value or {@code null} for none
   */
  public java.util.List<Draft> getDrafts() {
    return drafts;
  }

  /**
   * List of drafts. Note that the Message property in each Draft resource only contains an id and a
   * threadId. The messages.get method can fetch additional message details.
   * @param drafts drafts or {@code null} for none
   */
  public ListDraftsResponse setDrafts(java.util.List<Draft> drafts) {
    this.drafts = drafts;
    return this;
  }

  /**
   * Token to retrieve the next page of results in the list.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token to retrieve the next page of results in the list.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListDraftsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Estimated total number of results.
   * @return value or {@code null} for none
   */
  public java.lang.Long getResultSizeEstimate() {
    return resultSizeEstimate;
  }

  /**
   * Estimated total number of results.
   * @param resultSizeEstimate resultSizeEstimate or {@code null} for none
   */
  public ListDraftsResponse setResultSizeEstimate(java.lang.Long resultSizeEstimate) {
    this.resultSizeEstimate = resultSizeEstimate;
    return this;
  }

  @Override
  public ListDraftsResponse set(String fieldName, Object value) {
    return (ListDraftsResponse) super.set(fieldName, value);
  }

  @Override
  public ListDraftsResponse clone() {
    return (ListDraftsResponse) super.clone();
  }

}
