/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-15 at 17:16:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.gmail.model;

/**
 * Model definition for BatchModifyMessagesRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Gmail API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchModifyMessagesRequest extends com.google.api.client.json.GenericJson {

  /**
   * A list of label IDs to add to messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> addLabelIds;

  /**
   * The IDs of the messages to modify. There is a limit of 1000 ids per request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> ids;

  /**
   * A list of label IDs to remove from messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> removeLabelIds;

  /**
   * A list of label IDs to add to messages.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAddLabelIds() {
    return addLabelIds;
  }

  /**
   * A list of label IDs to add to messages.
   * @param addLabelIds addLabelIds or {@code null} for none
   */
  public BatchModifyMessagesRequest setAddLabelIds(java.util.List<java.lang.String> addLabelIds) {
    this.addLabelIds = addLabelIds;
    return this;
  }

  /**
   * The IDs of the messages to modify. There is a limit of 1000 ids per request.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIds() {
    return ids;
  }

  /**
   * The IDs of the messages to modify. There is a limit of 1000 ids per request.
   * @param ids ids or {@code null} for none
   */
  public BatchModifyMessagesRequest setIds(java.util.List<java.lang.String> ids) {
    this.ids = ids;
    return this;
  }

  /**
   * A list of label IDs to remove from messages.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRemoveLabelIds() {
    return removeLabelIds;
  }

  /**
   * A list of label IDs to remove from messages.
   * @param removeLabelIds removeLabelIds or {@code null} for none
   */
  public BatchModifyMessagesRequest setRemoveLabelIds(java.util.List<java.lang.String> removeLabelIds) {
    this.removeLabelIds = removeLabelIds;
    return this;
  }

  @Override
  public BatchModifyMessagesRequest set(String fieldName, Object value) {
    return (BatchModifyMessagesRequest) super.set(fieldName, value);
  }

  @Override
  public BatchModifyMessagesRequest clone() {
    return (BatchModifyMessagesRequest) super.clone();
  }

}
