/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.forms.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.forms.v1.FormsRequest;
import com.google.api.services.forms.v1.FormsRequestInitializer;
import com.google.api.services.forms.v1.model.BatchUpdateFormRequest;
import com.google.api.services.forms.v1.model.BatchUpdateFormResponse;
import com.google.api.services.forms.v1.model.CreateWatchRequest;
import com.google.api.services.forms.v1.model.Empty;
import com.google.api.services.forms.v1.model.Form;
import com.google.api.services.forms.v1.model.FormResponse;
import com.google.api.services.forms.v1.model.ListFormResponsesResponse;
import com.google.api.services.forms.v1.model.ListWatchesResponse;
import com.google.api.services.forms.v1.model.RenewWatchRequest;
import com.google.api.services.forms.v1.model.Watch;
import java.io.IOException;

public class Forms
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://forms.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://forms.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://forms.googleapis.com/";

    public Forms(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Forms(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public FormsOperations forms() {
        return new FormsOperations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Google Forms API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Forms.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://forms.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Forms.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Forms.DEFAULT_BATCH_PATH);
        }

        public Forms build() {
            return new Forms(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setFormsRequestInitializer(FormsRequestInitializer formsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)formsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class FormsOperations {
        public BatchUpdate batchUpdate(String formId, BatchUpdateFormRequest content) throws IOException {
            BatchUpdate result = new BatchUpdate(formId, content);
            Forms.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Form content) throws IOException {
            Create result = new Create(content);
            Forms.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String formId) throws IOException {
            Get result = new Get(formId);
            Forms.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Responses responses() {
            return new Responses();
        }

        public Watches watches() {
            return new Watches();
        }

        public class Watches {
            public Create create(String formId, CreateWatchRequest content) throws IOException {
                Create result = new Create(formId, content);
                Forms.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String formId, String watchId) throws IOException {
                Delete result = new Delete(formId, watchId);
                Forms.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String formId) throws IOException {
                List result = new List(formId);
                Forms.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Renew renew(String formId, String watchId, RenewWatchRequest content) throws IOException {
                Renew result = new Renew(formId, watchId, content);
                Forms.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Renew
            extends FormsRequest<Watch> {
                private static final String REST_PATH = "v1/forms/{formId}/watches/{watchId}:renew";
                @Key
                private String formId;
                @Key
                private String watchId;

                protected Renew(String formId, String watchId, RenewWatchRequest content) {
                    super(Forms.this, "POST", REST_PATH, (Object)content, Watch.class);
                    this.formId = (String)Preconditions.checkNotNull((Object)formId, (Object)"Required parameter formId must be specified.");
                    this.watchId = (String)Preconditions.checkNotNull((Object)watchId, (Object)"Required parameter watchId must be specified.");
                }

                public Renew set$Xgafv(String $Xgafv) {
                    return (Renew)super.set$Xgafv($Xgafv);
                }

                public Renew setAccessToken(String accessToken) {
                    return (Renew)super.setAccessToken(accessToken);
                }

                public Renew setAlt(String alt) {
                    return (Renew)super.setAlt(alt);
                }

                public Renew setCallback(String callback) {
                    return (Renew)super.setCallback(callback);
                }

                public Renew setFields(String fields) {
                    return (Renew)super.setFields(fields);
                }

                public Renew setKey(String key) {
                    return (Renew)super.setKey(key);
                }

                public Renew setOauthToken(String oauthToken) {
                    return (Renew)super.setOauthToken(oauthToken);
                }

                public Renew setPrettyPrint(Boolean prettyPrint) {
                    return (Renew)super.setPrettyPrint(prettyPrint);
                }

                public Renew setQuotaUser(String quotaUser) {
                    return (Renew)super.setQuotaUser(quotaUser);
                }

                public Renew setUploadType(String uploadType) {
                    return (Renew)super.setUploadType(uploadType);
                }

                public Renew setUploadProtocol(String uploadProtocol) {
                    return (Renew)super.setUploadProtocol(uploadProtocol);
                }

                public String getFormId() {
                    return this.formId;
                }

                public Renew setFormId(String formId) {
                    this.formId = formId;
                    return this;
                }

                public String getWatchId() {
                    return this.watchId;
                }

                public Renew setWatchId(String watchId) {
                    this.watchId = watchId;
                    return this;
                }

                @Override
                public Renew set(String parameterName, Object value) {
                    return (Renew)super.set(parameterName, value);
                }
            }

            public class List
            extends FormsRequest<ListWatchesResponse> {
                private static final String REST_PATH = "v1/forms/{formId}/watches";
                @Key
                private String formId;

                protected List(String formId) {
                    super(Forms.this, "GET", REST_PATH, null, ListWatchesResponse.class);
                    this.formId = (String)Preconditions.checkNotNull((Object)formId, (Object)"Required parameter formId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getFormId() {
                    return this.formId;
                }

                public List setFormId(String formId) {
                    this.formId = formId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends FormsRequest<Empty> {
                private static final String REST_PATH = "v1/forms/{formId}/watches/{watchId}";
                @Key
                private String formId;
                @Key
                private String watchId;

                protected Delete(String formId, String watchId) {
                    super(Forms.this, "DELETE", REST_PATH, null, Empty.class);
                    this.formId = (String)Preconditions.checkNotNull((Object)formId, (Object)"Required parameter formId must be specified.");
                    this.watchId = (String)Preconditions.checkNotNull((Object)watchId, (Object)"Required parameter watchId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getFormId() {
                    return this.formId;
                }

                public Delete setFormId(String formId) {
                    this.formId = formId;
                    return this;
                }

                public String getWatchId() {
                    return this.watchId;
                }

                public Delete setWatchId(String watchId) {
                    this.watchId = watchId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends FormsRequest<Watch> {
                private static final String REST_PATH = "v1/forms/{formId}/watches";
                @Key
                private String formId;

                protected Create(String formId, CreateWatchRequest content) {
                    super(Forms.this, "POST", REST_PATH, (Object)content, Watch.class);
                    this.formId = (String)Preconditions.checkNotNull((Object)formId, (Object)"Required parameter formId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getFormId() {
                    return this.formId;
                }

                public Create setFormId(String formId) {
                    this.formId = formId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Responses {
            public Get get(String formId, String responseId) throws IOException {
                Get result = new Get(formId, responseId);
                Forms.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String formId) throws IOException {
                List result = new List(formId);
                Forms.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends FormsRequest<ListFormResponsesResponse> {
                private static final String REST_PATH = "v1/forms/{formId}/responses";
                @Key
                private String formId;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String formId) {
                    super(Forms.this, "GET", REST_PATH, null, ListFormResponsesResponse.class);
                    this.formId = (String)Preconditions.checkNotNull((Object)formId, (Object)"Required parameter formId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getFormId() {
                    return this.formId;
                }

                public List setFormId(String formId) {
                    this.formId = formId;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends FormsRequest<FormResponse> {
                private static final String REST_PATH = "v1/forms/{formId}/responses/{responseId}";
                @Key
                private String formId;
                @Key
                private String responseId;

                protected Get(String formId, String responseId) {
                    super(Forms.this, "GET", REST_PATH, null, FormResponse.class);
                    this.formId = (String)Preconditions.checkNotNull((Object)formId, (Object)"Required parameter formId must be specified.");
                    this.responseId = (String)Preconditions.checkNotNull((Object)responseId, (Object)"Required parameter responseId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getFormId() {
                    return this.formId;
                }

                public Get setFormId(String formId) {
                    this.formId = formId;
                    return this;
                }

                public String getResponseId() {
                    return this.responseId;
                }

                public Get setResponseId(String responseId) {
                    this.responseId = responseId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Get
        extends FormsRequest<Form> {
            private static final String REST_PATH = "v1/forms/{formId}";
            @Key
            private String formId;

            protected Get(String formId) {
                super(Forms.this, "GET", REST_PATH, null, Form.class);
                this.formId = (String)Preconditions.checkNotNull((Object)formId, (Object)"Required parameter formId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getFormId() {
                return this.formId;
            }

            public Get setFormId(String formId) {
                this.formId = formId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Create
        extends FormsRequest<Form> {
            private static final String REST_PATH = "v1/forms";

            protected Create(Form content) {
                super(Forms.this, "POST", REST_PATH, (Object)content, Form.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class BatchUpdate
        extends FormsRequest<BatchUpdateFormResponse> {
            private static final String REST_PATH = "v1/forms/{formId}:batchUpdate";
            @Key
            private String formId;

            protected BatchUpdate(String formId, BatchUpdateFormRequest content) {
                super(Forms.this, "POST", REST_PATH, (Object)content, BatchUpdateFormResponse.class);
                this.formId = (String)Preconditions.checkNotNull((Object)formId, (Object)"Required parameter formId must be specified.");
            }

            public BatchUpdate set$Xgafv(String $Xgafv) {
                return (BatchUpdate)super.set$Xgafv($Xgafv);
            }

            public BatchUpdate setAccessToken(String accessToken) {
                return (BatchUpdate)super.setAccessToken(accessToken);
            }

            public BatchUpdate setAlt(String alt) {
                return (BatchUpdate)super.setAlt(alt);
            }

            public BatchUpdate setCallback(String callback) {
                return (BatchUpdate)super.setCallback(callback);
            }

            public BatchUpdate setFields(String fields) {
                return (BatchUpdate)super.setFields(fields);
            }

            public BatchUpdate setKey(String key) {
                return (BatchUpdate)super.setKey(key);
            }

            public BatchUpdate setOauthToken(String oauthToken) {
                return (BatchUpdate)super.setOauthToken(oauthToken);
            }

            public BatchUpdate setPrettyPrint(Boolean prettyPrint) {
                return (BatchUpdate)super.setPrettyPrint(prettyPrint);
            }

            public BatchUpdate setQuotaUser(String quotaUser) {
                return (BatchUpdate)super.setQuotaUser(quotaUser);
            }

            public BatchUpdate setUploadType(String uploadType) {
                return (BatchUpdate)super.setUploadType(uploadType);
            }

            public BatchUpdate setUploadProtocol(String uploadProtocol) {
                return (BatchUpdate)super.setUploadProtocol(uploadProtocol);
            }

            public String getFormId() {
                return this.formId;
            }

            public BatchUpdate setFormId(String formId) {
                this.formId = formId;
                return this;
            }

            @Override
            public BatchUpdate set(String parameterName, Object value) {
                return (BatchUpdate)super.set(parameterName, value);
            }
        }
    }
}

